# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sql_migration_task_input import SqlMigrationTaskInput


class MigrateSchemaSqlServerSqlDbTaskInput(SqlMigrationTaskInput):
    """Input for task that migrates Schema for SQL Server databases to Azure SQL
    databases.

    All required parameters must be populated in order to send to Azure.

    :param source_connection_info: Required. Information for connecting to
     source
    :type source_connection_info:
     ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param target_connection_info: Required. Information for connecting to
     target
    :type target_connection_info:
     ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param selected_databases: Required. Databases to migrate
    :type selected_databases:
     list[~azure.mgmt.datamigration.models.MigrateSchemaSqlServerSqlDbDatabaseInput]
    """

    _validation = {
        'source_connection_info': {'required': True},
        'target_connection_info': {'required': True},
        'selected_databases': {'required': True},
    }

    _attribute_map = {
        'source_connection_info': {'key': 'sourceConnectionInfo', 'type': 'SqlConnectionInfo'},
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'SqlConnectionInfo'},
        'selected_databases': {'key': 'selectedDatabases', 'type': '[MigrateSchemaSqlServerSqlDbDatabaseInput]'},
    }

    def __init__(self, **kwargs):
        super(MigrateSchemaSqlServerSqlDbTaskInput, self).__init__(**kwargs)
        self.selected_databases = kwargs.get('selected_databases', None)
