# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class Compliance(Resource):
    """Compliance of a scope.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar assessment_timestamp_utc_date: The timestamp when the Compliance
     calculation was conducted.
    :vartype assessment_timestamp_utc_date: datetime
    :ivar resource_count: The resource count of the given subscription for
     which the Compliance calculation was conducted (needed for Management
     Group Compliance calculation).
    :vartype resource_count: int
    :ivar assessment_result: An array of segment, which is the actually the
     compliance assessment.
    :vartype assessment_result:
     list[~azure.mgmt.security.models.ComplianceSegment]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'assessment_timestamp_utc_date': {'readonly': True},
        'resource_count': {'readonly': True},
        'assessment_result': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'assessment_timestamp_utc_date': {'key': 'properties.assessmentTimestampUtcDate', 'type': 'iso-8601'},
        'resource_count': {'key': 'properties.resourceCount', 'type': 'int'},
        'assessment_result': {'key': 'properties.assessmentResult', 'type': '[ComplianceSegment]'},
    }

    def __init__(self, **kwargs):
        super(Compliance, self).__init__(**kwargs)
        self.assessment_timestamp_utc_date = None
        self.resource_count = None
        self.assessment_result = None
