# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_only_resource import ProxyOnlyResource


class ContinuousWebJob(ProxyOnlyResource):
    """Continuous Web Job Information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param status: Job status. Possible values include: 'Initializing',
     'Starting', 'Running', 'PendingRestart', 'Stopped'
    :type status: str or ~azure.mgmt.web.models.ContinuousWebJobStatus
    :param detailed_status: Detailed status.
    :type detailed_status: str
    :param log_url: Log URL.
    :type log_url: str
    :param run_command: Run command.
    :type run_command: str
    :param url: Job URL.
    :type url: str
    :param extra_info_url: Extra Info URL.
    :type extra_info_url: str
    :param web_job_type: Job type. Possible values include: 'Continuous',
     'Triggered'
    :type web_job_type: str or ~azure.mgmt.web.models.WebJobType
    :param error: Error information.
    :type error: str
    :param using_sdk: Using SDK?
    :type using_sdk: bool
    :param settings: Job settings.
    :type settings: dict[str, object]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'ContinuousWebJobStatus'},
        'detailed_status': {'key': 'properties.detailed_status', 'type': 'str'},
        'log_url': {'key': 'properties.log_url', 'type': 'str'},
        'run_command': {'key': 'properties.run_command', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'extra_info_url': {'key': 'properties.extra_info_url', 'type': 'str'},
        'web_job_type': {'key': 'properties.web_job_type', 'type': 'WebJobType'},
        'error': {'key': 'properties.error', 'type': 'str'},
        'using_sdk': {'key': 'properties.using_sdk', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': '{object}'},
    }

    def __init__(self, **kwargs):
        super(ContinuousWebJob, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.detailed_status = kwargs.get('detailed_status', None)
        self.log_url = kwargs.get('log_url', None)
        self.run_command = kwargs.get('run_command', None)
        self.url = kwargs.get('url', None)
        self.extra_info_url = kwargs.get('extra_info_url', None)
        self.web_job_type = kwargs.get('web_job_type', None)
        self.error = kwargs.get('error', None)
        self.using_sdk = kwargs.get('using_sdk', None)
        self.settings = kwargs.get('settings', None)
