# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_only_resource import ProxyOnlyResource


class DeletedAppRestoreRequest(ProxyOnlyResource):
    """Details about restoring a deleted app.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param deleted_site_id: ARM resource ID of the deleted app. Example:
     /subscriptions/{subId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}
    :type deleted_site_id: str
    :param recover_configuration: If true, deleted site configuration, in
     addition to content, will be restored.
    :type recover_configuration: bool
    :param snapshot_time: Point in time to restore the deleted app from,
     formatted as a DateTime string.
     If unspecified, default value is the time that the app was deleted.
    :type snapshot_time: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'deleted_site_id': {'key': 'properties.deletedSiteId', 'type': 'str'},
        'recover_configuration': {'key': 'properties.recoverConfiguration', 'type': 'bool'},
        'snapshot_time': {'key': 'properties.snapshotTime', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DeletedAppRestoreRequest, self).__init__(**kwargs)
        self.deleted_site_id = kwargs.get('deleted_site_id', None)
        self.recover_configuration = kwargs.get('recover_configuration', None)
        self.snapshot_time = kwargs.get('snapshot_time', None)
