# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PackageSharingPolicyInfo(Model):
    """Represents a policy for the package sharing.

    :param shared_package_name: The name of code, configuration or data
     package that should be shared.
    :type shared_package_name: str
    :param package_sharing_scope: Represents the scope for
     PackageSharingPolicy. This is specified during DeployServicePackageToNode
     operation. Possible values include: 'None', 'All', 'Code', 'Config',
     'Data'
    :type package_sharing_scope: str or
     ~azure.servicefabric.models.PackageSharingPolicyScope
    """

    _attribute_map = {
        'shared_package_name': {'key': 'SharedPackageName', 'type': 'str'},
        'package_sharing_scope': {'key': 'PackageSharingScope', 'type': 'str'},
    }

    def __init__(self, *, shared_package_name: str=None, package_sharing_scope=None, **kwargs) -> None:
        super(PackageSharingPolicyInfo, self).__init__(**kwargs)
        self.shared_package_name = shared_package_name
        self.package_sharing_scope = package_sharing_scope
