# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class KnowledgebaseDTO(Model):
    """Response schema for CreateKb operation.

    :param id: Unique id that identifies a knowledgebase.
    :type id: str
    :param host_name: URL host name at which the knowledgebase is hosted.
    :type host_name: str
    :param last_accessed_timestamp: Time stamp at which the knowledgebase was
     last accessed (UTC).
    :type last_accessed_timestamp: str
    :param last_changed_timestamp: Time stamp at which the knowledgebase was
     last modified (UTC).
    :type last_changed_timestamp: str
    :param last_published_timestamp: Time stamp at which the knowledgebase was
     last published (UTC).
    :type last_published_timestamp: str
    :param name: Friendly name of the knowledgebase.
    :type name: str
    :param user_id: User who created / owns the knowledgebase.
    :type user_id: str
    :param urls: URL sources from which Q-A were extracted and added to the
     knowledgebase.
    :type urls: list[str]
    :param sources: Custom sources from which Q-A were extracted or explicitly
     added to the knowledgebase.
    :type sources: list[str]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'last_accessed_timestamp': {'key': 'lastAccessedTimestamp', 'type': 'str'},
        'last_changed_timestamp': {'key': 'lastChangedTimestamp', 'type': 'str'},
        'last_published_timestamp': {'key': 'lastPublishedTimestamp', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'user_id': {'key': 'userId', 'type': 'str'},
        'urls': {'key': 'urls', 'type': '[str]'},
        'sources': {'key': 'sources', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(KnowledgebaseDTO, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.host_name = kwargs.get('host_name', None)
        self.last_accessed_timestamp = kwargs.get('last_accessed_timestamp', None)
        self.last_changed_timestamp = kwargs.get('last_changed_timestamp', None)
        self.last_published_timestamp = kwargs.get('last_published_timestamp', None)
        self.name = kwargs.get('name', None)
        self.user_id = kwargs.get('user_id', None)
        self.urls = kwargs.get('urls', None)
        self.sources = kwargs.get('sources', None)
