# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, Optional, TYPE_CHECKING

from azure.core import AsyncPipelineClient
from azure.core.rest import AsyncHttpResponse, HttpRequest
from msrest import Deserializer, Serializer

from ._configuration import PurviewScanningClientConfiguration
from .operations import ClassificationRulesOperations, DataSourcesOperations, FiltersOperations, KeyVaultConnectionsOperations, ScanResultOperations, ScanRulesetsOperations, ScansOperations, SystemScanRulesetsOperations, TriggersOperations

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Dict

    from azure.core.credentials_async import AsyncTokenCredential

class PurviewScanningClient:
    """Creates a Microsoft.Scanning management client.

    :ivar key_vault_connections: KeyVaultConnectionsOperations operations
    :vartype key_vault_connections:
     azure.purview.scanning.aio.operations.KeyVaultConnectionsOperations
    :ivar classification_rules: ClassificationRulesOperations operations
    :vartype classification_rules:
     azure.purview.scanning.aio.operations.ClassificationRulesOperations
    :ivar data_sources: DataSourcesOperations operations
    :vartype data_sources: azure.purview.scanning.aio.operations.DataSourcesOperations
    :ivar filters: FiltersOperations operations
    :vartype filters: azure.purview.scanning.aio.operations.FiltersOperations
    :ivar scans: ScansOperations operations
    :vartype scans: azure.purview.scanning.aio.operations.ScansOperations
    :ivar scan_result: ScanResultOperations operations
    :vartype scan_result: azure.purview.scanning.aio.operations.ScanResultOperations
    :ivar scan_rulesets: ScanRulesetsOperations operations
    :vartype scan_rulesets: azure.purview.scanning.aio.operations.ScanRulesetsOperations
    :ivar system_scan_rulesets: SystemScanRulesetsOperations operations
    :vartype system_scan_rulesets:
     azure.purview.scanning.aio.operations.SystemScanRulesetsOperations
    :ivar triggers: TriggersOperations operations
    :vartype triggers: azure.purview.scanning.aio.operations.TriggersOperations
    :param endpoint: The scanning endpoint of your purview account. Example:
     https://{accountName}.scan.purview.azure.com.
    :type endpoint: str
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    """

    def __init__(
        self,
        endpoint: str,
        credential: "AsyncTokenCredential",
        **kwargs: Any
    ) -> None:
        _endpoint = '{Endpoint}'
        self._config = PurviewScanningClientConfiguration(endpoint, credential, **kwargs)
        self._client = AsyncPipelineClient(base_url=_endpoint, config=self._config, **kwargs)

        self._serialize = Serializer()
        self._deserialize = Deserializer()
        self._serialize.client_side_validation = False
        self.key_vault_connections = KeyVaultConnectionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.classification_rules = ClassificationRulesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.data_sources = DataSourcesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.filters = FiltersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.scans = ScansOperations(self._client, self._config, self._serialize, self._deserialize)
        self.scan_result = ScanResultOperations(self._client, self._config, self._serialize, self._deserialize)
        self.scan_rulesets = ScanRulesetsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.system_scan_rulesets = SystemScanRulesetsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.triggers = TriggersOperations(self._client, self._config, self._serialize, self._deserialize)


    def send_request(
        self,
        request: HttpRequest,
        **kwargs: Any
    ) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client.send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/python/protocol/quickstart

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }

        request_copy.url = self._client.format_url(request_copy.url, **path_format_arguments)
        return self._client.send_request(request_copy, **kwargs)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "PurviewScanningClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
