# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class Resource(_Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.secretsstoreextension.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.secretsstoreextension.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureKeyVaultSecretProviderClass(TrackedResource):
    """The AzureKeyVaultSecretProviderClass resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.secretsstoreextension.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.secretsstoreextension.models.AzureKeyVaultSecretProviderClassProperties
    :ivar extended_location:
    :vartype extended_location: ~azure.mgmt.secretsstoreextension.models.ExtendedLocation
    """

    properties: Optional["_models.AzureKeyVaultSecretProviderClassProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    extended_location: Optional["_models.ExtendedLocation"] = rest_field(
        name="extendedLocation", visibility=["read", "create"]
    )

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.AzureKeyVaultSecretProviderClassProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureKeyVaultSecretProviderClassProperties(_Model):  # pylint: disable=name-too-long
    """The properties of the AzureKeyVaultSecretProviderClass.

    :ivar keyvault_name: The name of the Azure Key Vault to sync secrets from. Required.
    :vartype keyvault_name: str
    :ivar client_id: The user assigned managed identity client ID that should be used to access the
     Azure Key Vault. Required.
    :vartype client_id: str
    :ivar tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
     requests to the Azure Key Vault. Required.
    :vartype tenant_id: str
    :ivar objects: Objects defines the desired state of synced K8s secret objects.
    :vartype objects: str
    :ivar provisioning_state: Provisioning state of the AzureKeyVaultSecretProviderClass instance.
     Known values are: "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.secretsstoreextension.models.ProvisioningState
    """

    keyvault_name: str = rest_field(name="keyvaultName", visibility=["read", "create", "update", "delete", "query"])
    """The name of the Azure Key Vault to sync secrets from. Required."""
    client_id: str = rest_field(name="clientId", visibility=["read", "create", "update", "delete", "query"])
    """The user assigned managed identity client ID that should be used to access the Azure Key Vault.
     Required."""
    tenant_id: str = rest_field(name="tenantId", visibility=["read", "create", "update", "delete", "query"])
    """The Azure Active Directory tenant ID that should be used for authenticating requests to the
     Azure Key Vault. Required."""
    objects: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Objects defines the desired state of synced K8s secret objects."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the AzureKeyVaultSecretProviderClass instance. Known values are:
     \"Succeeded\", \"Failed\", and \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        keyvault_name: str,
        client_id: str,
        tenant_id: str,
        objects: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureKeyVaultSecretProviderClassUpdate(_Model):
    """The type used for update operations of the AzureKeyVaultSecretProviderClass.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.secretsstoreextension.models.AzureKeyVaultSecretProviderClassUpdateProperties
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.AzureKeyVaultSecretProviderClassUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.AzureKeyVaultSecretProviderClassUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureKeyVaultSecretProviderClassUpdateProperties(_Model):  # pylint: disable=name-too-long
    """The updatable properties of the AzureKeyVaultSecretProviderClass.

    :ivar keyvault_name: The name of the Azure Key Vault to sync secrets from.
    :vartype keyvault_name: str
    :ivar client_id: The user assigned managed identity client ID that should be used to access the
     Azure Key Vault.
    :vartype client_id: str
    :ivar tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
     requests to the Azure Key Vault.
    :vartype tenant_id: str
    :ivar objects: Objects defines the desired state of synced K8s secret objects.
    :vartype objects: str
    """

    keyvault_name: Optional[str] = rest_field(
        name="keyvaultName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the Azure Key Vault to sync secrets from."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read", "create", "update", "delete", "query"])
    """The user assigned managed identity client ID that should be used to access the Azure Key Vault."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read", "create", "update", "delete", "query"])
    """The Azure Active Directory tenant ID that should be used for authenticating requests to the
     Azure Key Vault."""
    objects: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Objects defines the desired state of synced K8s secret objects."""

    @overload
    def __init__(
        self,
        *,
        keyvault_name: Optional[str] = None,
        client_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        objects: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.secretsstoreextension.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.secretsstoreextension.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.secretsstoreextension.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExtendedLocation(_Model):
    """The complex type of the extended location.

    :ivar name: The name of the extended location. Required.
    :vartype name: str
    :ivar type: The type of the extended location. Required. Known values are: "EdgeZone" and
     "CustomLocation".
    :vartype type: str or ~azure.mgmt.secretsstoreextension.models.ExtendedLocationType
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the extended location. Required."""
    type: Union[str, "_models.ExtendedLocationType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the extended location. Required. Known values are: \"EdgeZone\" and
     \"CustomLocation\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "_models.ExtendedLocationType"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KubernetesSecretObjectMapping(_Model):
    """Properties defining the mapping between a cloud secret store object and a Kubernetes Secret.

    :ivar source_path: SourcePath is the identifier for the secret data as defined by the external
     secret provider. This is the key or path to the secret in the provider's system, which gets
     mounted to a specific path in the pod. The value should match the name of the secret as
     specified in the SecretProviderClass's objects array. Required.
    :vartype source_path: str
    :ivar target_key: TargetKey is the key in the Kubernetes secret's data field where the secret
     value will be stored. This key is used to reference the secret data within Kubernetes, and it
     should be unique within the secret. Required.
    :vartype target_key: str
    """

    source_path: str = rest_field(name="sourcePath", visibility=["read", "create", "update", "delete", "query"])
    """SourcePath is the identifier for the secret data as defined by the external secret provider.
     This is the key or path to the secret in the provider's system, which gets mounted to a
     specific path in the pod. The value should match the name of the secret as specified in the
     SecretProviderClass's objects array. Required."""
    target_key: str = rest_field(name="targetKey", visibility=["read", "create", "update", "delete", "query"])
    """TargetKey is the key in the Kubernetes secret's data field where the secret value will be
     stored. This key is used to reference the secret data within Kubernetes, and it should be
     unique within the secret. Required."""

    @overload
    def __init__(
        self,
        *,
        source_path: str,
        target_key: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.secretsstoreextension.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.secretsstoreextension.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.secretsstoreextension.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class SecretSync(TrackedResource):
    """The SecretSync resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.secretsstoreextension.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.secretsstoreextension.models.SecretSyncProperties
    :ivar extended_location:
    :vartype extended_location: ~azure.mgmt.secretsstoreextension.models.ExtendedLocation
    """

    properties: Optional["_models.SecretSyncProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    extended_location: Optional["_models.ExtendedLocation"] = rest_field(
        name="extendedLocation", visibility=["read", "create"]
    )

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.SecretSyncProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecretSyncCondition(_Model):
    """A condition represents the status of the secret create and update processes.

    :ivar last_transition_time: LastTransitionTime is the last time the condition transitioned from
     one status to another. This should be when the underlying condition changed. If that is not
     known, then using the time when the API field changed is acceptable.
    :vartype last_transition_time: ~datetime.datetime
    :ivar message: Message is a human readable message indicating details about the transition.
     This may be an empty string. Required.
    :vartype message: str
    :ivar observed_generation: ObservedGeneration represents the .metadata.generation that the
     condition was set based upon. For instance, if .metadata.generation is currently 12, but the
     .status.conditions[x].observedGeneration is 9, the condition is out of date with respect to the
     current state of the instance.
    :vartype observed_generation: int
    :ivar reason: Reason contains a programmatic identifier indicating the reason for the
     condition's last transition. Producers of specific condition types may define expected values
     and meanings for this field, and whether the values are considered a guaranteed API. The value
     should be a CamelCase string. This field may not be empty. Required.
    :vartype reason: str
    :ivar status: Status of the condition, one of True, False, Unknown. Required. Known values are:
     "True", "False", and "Unknown".
    :vartype status: str or ~azure.mgmt.secretsstoreextension.models.StatusConditionType
    :ivar type: Type of condition in CamelCase or in foo.example.com/CamelCase. Many
     .condition.type values are consistent across resources like Available, but because arbitrary
     conditions can be useful (see .node.status.conditions), the ability to de-conflict is
     important. The regex it matches is (dns1123SubdomainFmt/)?(qualifiedNameFmt). Required.
    :vartype type: str
    """

    last_transition_time: Optional[datetime.datetime] = rest_field(
        name="lastTransitionTime", visibility=["read"], format="rfc3339"
    )
    """LastTransitionTime is the last time the condition transitioned from one status to another. This
     should be when the underlying condition changed. If that is not known, then using the time when
     the API field changed is acceptable."""
    message: str = rest_field(visibility=["read"])
    """Message is a human readable message indicating details about the transition. This may be an
     empty string. Required."""
    observed_generation: Optional[int] = rest_field(name="observedGeneration", visibility=["read"])
    """ObservedGeneration represents the .metadata.generation that the condition was set based upon.
     For instance, if .metadata.generation is currently 12, but the
     .status.conditions[x].observedGeneration is 9, the condition is out of date with respect to the
     current state of the instance."""
    reason: str = rest_field(visibility=["read"])
    """Reason contains a programmatic identifier indicating the reason for the condition's last
     transition. Producers of specific condition types may define expected values and meanings for
     this field, and whether the values are considered a guaranteed API. The value should be a
     CamelCase string. This field may not be empty. Required."""
    status: Union[str, "_models.StatusConditionType"] = rest_field(visibility=["read"])
    """Status of the condition, one of True, False, Unknown. Required. Known values are: \"True\",
     \"False\", and \"Unknown\"."""
    type: str = rest_field(visibility=["read"])
    """Type of condition in CamelCase or in foo.example.com/CamelCase. Many .condition.type values are
     consistent across resources like Available, but because arbitrary conditions can be useful (see
     .node.status.conditions), the ability to de-conflict is important. The regex it matches is
     (dns1123SubdomainFmt/)?(qualifiedNameFmt). Required."""


class SecretSyncProperties(_Model):
    """The properties of the SecretSync instance.

    :ivar secret_provider_class_name: SecretProviderClassName specifies the name of the
     SecretProviderClass resource, which contains the information needed to access the cloud
     provider secret store. Required.
    :vartype secret_provider_class_name: str
    :ivar service_account_name: ServiceAccountName specifies the name of the service account used
     to access the cloud provider secret store. The audience field in the service account token must
     be passed as parameter in the controller configuration. The audience is used when requesting a
     token from the API server for the service account; the supported audiences are defined by each
     provider. Required.
    :vartype service_account_name: str
    :ivar kubernetes_secret_type: Type specifies the type of the Kubernetes secret object, e.g.
     "Opaque" or"kubernetes.io/tls". The controller must have permission to create secrets of the
     specified type. Required. Known values are: "Opaque" and "kubernetes.io/tls".
    :vartype kubernetes_secret_type: str or
     ~azure.mgmt.secretsstoreextension.models.KubernetesSecretType
    :ivar force_synchronization: ForceSynchronization can be used to force the secret
     synchronization. The secret synchronization is triggered by changing the value in this field.
     This field is not used to resolve synchronization conflicts.
    :vartype force_synchronization: str
    :ivar object_secret_mapping: An array of SecretObjectData that maps secret data from the
     external secret provider to the Kubernetes secret. Each entry specifies the source secret in
     the external provider and the corresponding key in the Kubernetes secret. Required.
    :vartype object_secret_mapping:
     list[~azure.mgmt.secretsstoreextension.models.KubernetesSecretObjectMapping]
    :ivar status: SecretSyncStatus defines the observed state of the secret synchronization
     process.
    :vartype status: ~azure.mgmt.secretsstoreextension.models.SecretSyncStatus
    :ivar provisioning_state: Provisioning state of the SecretSync instance. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.secretsstoreextension.models.ProvisioningState
    """

    secret_provider_class_name: str = rest_field(
        name="secretProviderClassName", visibility=["read", "create", "update", "delete", "query"]
    )
    """SecretProviderClassName specifies the name of the SecretProviderClass resource, which contains
     the information needed to access the cloud provider secret store. Required."""
    service_account_name: str = rest_field(
        name="serviceAccountName", visibility=["read", "create", "update", "delete", "query"]
    )
    """ServiceAccountName specifies the name of the service account used to access the cloud provider
     secret store. The audience field in the service account token must be passed as parameter in
     the controller configuration. The audience is used when requesting a token from the API server
     for the service account; the supported audiences are defined by each provider. Required."""
    kubernetes_secret_type: Union[str, "_models.KubernetesSecretType"] = rest_field(
        name="kubernetesSecretType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type specifies the type of the Kubernetes secret object, e.g. \"Opaque\"
     or\"kubernetes.io/tls\". The controller must have permission to create secrets of the specified
     type. Required. Known values are: \"Opaque\" and \"kubernetes.io/tls\"."""
    force_synchronization: Optional[str] = rest_field(
        name="forceSynchronization", visibility=["read", "create", "update", "delete", "query"]
    )
    """ForceSynchronization can be used to force the secret synchronization. The secret
     synchronization is triggered by changing the value in this field. This field is not used to
     resolve synchronization conflicts."""
    object_secret_mapping: List["_models.KubernetesSecretObjectMapping"] = rest_field(
        name="objectSecretMapping", visibility=["read", "create", "update", "delete", "query"]
    )
    """An array of SecretObjectData that maps secret data from the external secret provider to the
     Kubernetes secret. Each entry specifies the source secret in the external provider and the
     corresponding key in the Kubernetes secret. Required."""
    status: Optional["_models.SecretSyncStatus"] = rest_field(visibility=["read"])
    """SecretSyncStatus defines the observed state of the secret synchronization process."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the SecretSync instance. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        secret_provider_class_name: str,
        service_account_name: str,
        kubernetes_secret_type: Union[str, "_models.KubernetesSecretType"],
        object_secret_mapping: List["_models.KubernetesSecretObjectMapping"],
        force_synchronization: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecretSyncStatus(_Model):
    """SecretSyncStatus defines the observed state of the secret synchronization process.

    :ivar last_successful_sync_time: LastSuccessfulSyncTime represents the last time the secret was
     retrieved from the Provider and updated.
    :vartype last_successful_sync_time: ~datetime.datetime
    :ivar conditions: Conditions represent the status of the secret create and update processes.
     The status can be True, False, or Unknown with various reasons and messages explaining the
     state. Examples of reasons include CreateSucceeded, ProviderError,
     InvalidClusterSecretLabelError, InvalidClusterSecretAnnotationError, UnknownError,
     ValidatingAdmissionPolicyCheckFailed, UserInputValidationFailed, ControllerSpcError,
     ControllerInternalError, NoValueChange, and ValueChangeOrForceUpdateDetected.
    :vartype conditions: list[~azure.mgmt.secretsstoreextension.models.SecretSyncCondition]
    """

    last_successful_sync_time: Optional[datetime.datetime] = rest_field(
        name="lastSuccessfulSyncTime", visibility=["read"], format="rfc3339"
    )
    """LastSuccessfulSyncTime represents the last time the secret was retrieved from the Provider and
     updated."""
    conditions: Optional[List["_models.SecretSyncCondition"]] = rest_field(visibility=["read"])
    """Conditions represent the status of the secret create and update processes. The status can be
     True, False, or Unknown with various reasons and messages explaining the state. Examples of
     reasons include CreateSucceeded, ProviderError, InvalidClusterSecretLabelError,
     InvalidClusterSecretAnnotationError, UnknownError, ValidatingAdmissionPolicyCheckFailed,
     UserInputValidationFailed, ControllerSpcError, ControllerInternalError, NoValueChange, and
     ValueChangeOrForceUpdateDetected."""


class SecretSyncUpdate(_Model):
    """The type used for update operations of the SecretSync.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.secretsstoreextension.models.SecretSyncUpdateProperties
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.SecretSyncUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.SecretSyncUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecretSyncUpdateProperties(_Model):
    """The updatable properties of the SecretSync.

    :ivar secret_provider_class_name: SecretProviderClassName specifies the name of the
     SecretProviderClass resource, which contains the information needed to access the cloud
     provider secret store.
    :vartype secret_provider_class_name: str
    :ivar service_account_name: ServiceAccountName specifies the name of the service account used
     to access the cloud provider secret store. The audience field in the service account token must
     be passed as parameter in the controller configuration. The audience is used when requesting a
     token from the API server for the service account; the supported audiences are defined by each
     provider.
    :vartype service_account_name: str
    :ivar kubernetes_secret_type: Type specifies the type of the Kubernetes secret object, e.g.
     "Opaque" or"kubernetes.io/tls". The controller must have permission to create secrets of the
     specified type. Known values are: "Opaque" and "kubernetes.io/tls".
    :vartype kubernetes_secret_type: str or
     ~azure.mgmt.secretsstoreextension.models.KubernetesSecretType
    :ivar force_synchronization: ForceSynchronization can be used to force the secret
     synchronization. The secret synchronization is triggered by changing the value in this field.
     This field is not used to resolve synchronization conflicts.
    :vartype force_synchronization: str
    :ivar object_secret_mapping: An array of SecretObjectData that maps secret data from the
     external secret provider to the Kubernetes secret. Each entry specifies the source secret in
     the external provider and the corresponding key in the Kubernetes secret.
    :vartype object_secret_mapping:
     list[~azure.mgmt.secretsstoreextension.models.KubernetesSecretObjectMapping]
    """

    secret_provider_class_name: Optional[str] = rest_field(
        name="secretProviderClassName", visibility=["read", "create", "update", "delete", "query"]
    )
    """SecretProviderClassName specifies the name of the SecretProviderClass resource, which contains
     the information needed to access the cloud provider secret store."""
    service_account_name: Optional[str] = rest_field(
        name="serviceAccountName", visibility=["read", "create", "update", "delete", "query"]
    )
    """ServiceAccountName specifies the name of the service account used to access the cloud provider
     secret store. The audience field in the service account token must be passed as parameter in
     the controller configuration. The audience is used when requesting a token from the API server
     for the service account; the supported audiences are defined by each provider."""
    kubernetes_secret_type: Optional[Union[str, "_models.KubernetesSecretType"]] = rest_field(
        name="kubernetesSecretType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type specifies the type of the Kubernetes secret object, e.g. \"Opaque\"
     or\"kubernetes.io/tls\". The controller must have permission to create secrets of the specified
     type. Known values are: \"Opaque\" and \"kubernetes.io/tls\"."""
    force_synchronization: Optional[str] = rest_field(
        name="forceSynchronization", visibility=["read", "create", "update", "delete", "query"]
    )
    """ForceSynchronization can be used to force the secret synchronization. The secret
     synchronization is triggered by changing the value in this field. This field is not used to
     resolve synchronization conflicts."""
    object_secret_mapping: Optional[List["_models.KubernetesSecretObjectMapping"]] = rest_field(
        name="objectSecretMapping", visibility=["read", "create", "update", "delete", "query"]
    )
    """An array of SecretObjectData that maps secret data from the external secret provider to the
     Kubernetes secret. Each entry specifies the source secret in the external provider and the
     corresponding key in the Kubernetes secret."""

    @overload
    def __init__(
        self,
        *,
        secret_provider_class_name: Optional[str] = None,
        service_account_name: Optional[str] = None,
        kubernetes_secret_type: Optional[Union[str, "_models.KubernetesSecretType"]] = None,
        force_synchronization: Optional[str] = None,
        object_secret_mapping: Optional[List["_models.KubernetesSecretObjectMapping"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.secretsstoreextension.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.secretsstoreextension.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
