% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launch_shinystan.R
\name{launch_shinystan.brmsfit}
\alias{launch_shinystan.brmsfit}
\alias{launch_shinystan}
\title{Interface to \pkg{shinystan}}
\usage{
\method{launch_shinystan}{brmsfit}(object, rstudio = getOption("shinystan.rstudio"), ...)
}
\arguments{
\item{object}{A fitted model object typically of class \code{brmsfit}.}

\item{rstudio}{Only relevant for RStudio users.
The default (\code{rstudio=FALSE}) is to launch the app
in the default web browser rather than RStudio's pop-up Viewer.
Users can change the default to \code{TRUE}
by setting the global option \cr \code{options(shinystan.rstudio = TRUE)}.}

\item{...}{Optional arguments to pass to \code{\link[shiny:runApp]{runApp}}}
}
\value{
An S4 shinystan object
}
\description{
Provide an interface to \pkg{shinystan} for models fitted with \pkg{brms}
}
\examples{
\dontrun{
fit <- brm(rating ~ treat + period + carry + (1|subject),
           data = inhaler, family = "gaussian")
launch_shinystan(fit)
}

}
\seealso{
\code{\link[shinystan:launch_shinystan]{launch_shinystan}}
}
