% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/untangle.R
\name{shuffle}
\alias{shuffle}
\alias{shuffle.default}
\alias{shuffle.dendrogram}
\alias{shuffle.dendlist}
\alias{shuffle.hclust}
\alias{shuffle.phylo}
\title{Random rotation of trees}
\usage{
shuffle(dend, ...)

\method{shuffle}{default}(dend, ...)

\method{shuffle}{dendrogram}(dend, ...)

\method{shuffle}{dendlist}(dend, which, ...)

\method{shuffle}{hclust}(dend, ...)

\method{shuffle}{phylo}(dend, ...)
}
\arguments{
\item{dend}{a tree object (\link{dendrogram}/\link{hclust}/\link[ape]{phylo})}

\item{...}{Ignored.}

\item{which}{an integer vector for indicating
which of the trees in the dendlist object should be plotted
default is missing, in which case all the dends in dendlist
will be shuffled}
}
\value{
A randomlly rotated tree object
}
\description{
'shuffle' randomilly rotates ("shuffles") a tree, changing its presentation 
while preserving its topolgoy.
'shuffle' is based on \link[dendextend]{rotate} and through its methods can
work for any of the major tree objects in R (\link{dendrogram}/\link{hclust}/\link[ape]{phylo}).

This function is useful in combination with \link{tanglegram} and \link{entanglement}.
}
\details{
'shuffle' is a function that randomilly rotates ("shuffles") a tree.
a dendrogram leaves order (by means of rotation)
}
\examples{
dend <- USArrests \%>\% dist \%>\% hclust \%>\% as.dendrogram
set.seed(234238)
dend2 <- shuffle(dend)

tanglegram(dend, dend2, margin_inner=7)
entanglement(dend, dend2) # 0.3983

# although these ARE the SAME tree:
tanglegram(sort(dend), sort(dend2), margin_inner=7)


}
\seealso{
\code{\link{tanglegram}},  \code{\link{entanglement}}, 
\code{\link[dendextend]{rotate}}
}
