% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mstl.R
\name{mstl}
\alias{mstl}
\title{Multiple seasonal decomposition}
\usage{
mstl(x, lambda = NULL, iterate = 2, s.window = 13, ...)
}
\arguments{
\item{x}{Univariate time series of class \code{msts} or \code{ts}.}

\item{lambda}{Box-Cox transformation parameter. If \code{lambda="auto"},
then a transformation is automatically selected using \code{BoxCox.lambda}.
The transformation is ignored if NULL. Otherwise,
data transformed before model is estimated.}

\item{iterate}{Number of iterations to use to refine the seasonal component.}

\item{s.window}{Seasonal windows to be used in the  decompositions. If scalar,
the same value is used for all seasonal components. Otherwise, it should be a vector
of the same length as the number of seasonal components.}

\item{...}{Other arguments are passed to \code{\link[stats]{stl}}.}
}
\description{
Decompose a time series into seasonal, trend and remainder components.
Seasonal components are estimated iteratively using STL. Multiple seasonal periods are
allowed. The trend component is computed for the last iteration of STL.
Non-seasonal time series are decomposed into trend and remainder only.
In this case, \code{\link[stats]{supsmu}} is used to estimate the trend.
Optionally, the time series may be Box-Cox transformed before decomposition.
Unlike \code{\link[stats]{stl}}, \code{mstl} is completely automated.
}
\examples{
library(ggplot2)
mstl(taylor) \%>\% autoplot()
mstl(AirPassengers, lambda = "auto") \%>\% autoplot()
}
\seealso{
\code{\link[stats]{stl}}, \code{\link[stats]{supsmu}}
}
