% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signature.R
\name{git_signature}
\alias{git_signature}
\alias{git_signature_default}
\alias{git_signature_parse}
\title{Author Signature}
\usage{
git_signature_default(repo = ".")

git_signature(name, email, time = NULL)

git_signature_parse(sig)
}
\arguments{
\item{repo}{The path to the git repository. If the directory is not a
repository, parent directories are considered (see \link{git_find}). To disable
this search, provide the filepath protected with \code{\link[=I]{I()}}. When using this
parameter, always explicitly call by name (i.e. \verb{repo = }) because future
versions of gert may have additional parameters.}

\item{name}{Real name of the committer}

\item{email}{Email address of the committer}

\item{time}{timestamp of class POSIXt or NULL}

\item{sig}{string in proper \code{"First Last <your@email.com>"} format, see details.}
}
\description{
A signature contains the author and timestamp of a commit. Each commit
includes a signature of the author and committer (which can be identical).
}
\details{
A signature string has format \code{"Real Name <email> timestamp tzoffset"}. The
\verb{timestamp tzoffset} piece can be omitted in which case the current local
time is used. If not omitted, \code{timestamp} must contain the number
of seconds since the Unix epoch and \code{tzoffset} is the timezone offset in
\code{hhmm} format (note the lack of a colon separator)
}
\examples{
# Your default user
try(git_signature_default())

# Specify explicit name and email
git_signature("Some committer", "sarah@gmail.com")

# Create signature for an hour ago
(sig <- git_signature("Han", "han@company.com", Sys.time() - 3600))

# Parse a signature
git_signature_parse(sig)
git_signature_parse("Emma <emma@mu.edu>")
}
\seealso{
Other git: 
\code{\link{git_archive}},
\code{\link{git_branch}()},
\code{\link{git_commit}()},
\code{\link{git_config}()},
\code{\link{git_diff}()},
\code{\link{git_fetch}()},
\code{\link{git_merge}()},
\code{\link{git_rebase}()},
\code{\link{git_remote}},
\code{\link{git_repo}},
\code{\link{git_stash}},
\code{\link{git_tag}}
}
\concept{git}
