% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls_means.R
\name{show_tests.ls_means}
\alias{show_tests.ls_means}
\title{Show LS-means Hypothesis Tests and Contrasts}
\usage{
\method{show_tests}{ls_means}(object, fractions = FALSE, names = TRUE,
  ...)
}
\arguments{
\item{object}{an \code{ls_means} object.}

\item{fractions}{display contrasts as fractions rather than decimal numbers?}

\item{names}{include row and column names of the contrasts matrices?}

\item{...}{currently not used.}
}
\value{
a list of contrast matrices; one matrix for each model term.
}
\description{
Extracts the contrasts which defines the LS-mean hypothesis tests.
}
\examples{

data("cake", package="lme4")
model <- lmer(angle ~ recipe * temp + (1|recipe:replicate), cake)

# LS-means:
(lsm <- ls_means(model))

# Contrasts for LS-means estimates and hypothesis tests:
show_tests(lsm)

}
\seealso{
\code{\link[=ls_means.lmerModLmerTest]{ls_means}} for computation of
LS-means and \code{\link[=show_tests.anova]{show_tests}} for \code{anova}
objects.
}
\author{
Rune Haubo B. Christensen
}
