% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tol.R
\name{strip_ott_ids}
\alias{strip_ott_ids}
\title{Strip OTT ids from tip labels}
\usage{
strip_ott_ids(tip_labels, remove_underscores = FALSE)
}
\arguments{
\item{tip_labels}{a character vector containing tip labels (most
likely the \code{tip.label} element from a tree returned by
\code{\link{tol_induced_subtree}}}

\item{remove_underscores}{logical (defaults to FALSE). If set to
TRUE underscores in tip labels are converted to spaces}
}
\value{
A character vector containing the contents of
    \code{tip_labels} with any OTT ids removed.
}
\description{
Strip OTT ids from tip labels
}
\examples{
\dontrun{
genera <- c("Perdix", "Setophaga", "Cinclus", "Struthio")
tr <- tol_induced_subtree(ott_ids=c(102710, 285198, 267845, 292466))
tr$tip.label \%in\% genera
tr$tip.label <- strip_ott_ids(tr$tip.label)
tr$tip.label \%in\% genera
}
}
