% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accounts.R
\name{connectUser}
\alias{connectUser}
\title{Connect User Account}
\usage{
connectUser(
  account = NULL,
  server = NULL,
  quiet = FALSE,
  launch.browser = getOption("rsconnect.launch.browser", interactive())
)
}
\arguments{
\item{account}{A name for the account to connect. Optional.}

\item{server}{The server to connect to. Optional if there is only one server
registered.}

\item{quiet}{Whether or not to show messages and prompts while connecting the
account.}

\item{launch.browser}{If true, the system's default web browser will be
launched automatically after the app is started. Defaults to \code{TRUE} in
interactive sessions only. If a function is passed, it will be called
after the app is started, with the app URL as a paramter.}
}
\description{
Connect a user account to the package so that it can be used to deploy and
manage applications on behalf of the account.
}
\details{
When this function is invoked, a web browser will be opened to a
page on the target server where you will be prompted to enter your
credentials. Upon successful authentication, your local installation of
\pkg{rsconnect} and your server account will be paired, and you'll
be able to deploy and manage applications using the package without further
prompts for credentials.
}
\seealso{
Other Account functions: 
\code{\link{accounts}()},
\code{\link{connectApiUser}()},
\code{\link{setAccountInfo}()}
}
\concept{Account functions}
