% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-transformers.R
\name{geos_combine}
\alias{geos_combine}
\alias{st_union.sftime}
\title{Combine or union feature geometries (including \code{sftime} objects)}
\usage{
\method{st_union}{sftime}(x, y, ..., by_feature = FALSE, is_coverage = FALSE)
}
\arguments{
\item{x}{An object of class \code{sftime}, \code{sf}, \code{sfc} or 
\code{sfg}.}

\item{y}{An object of class \code{sftime}, \code{sf}, \code{sfc} or 
\code{sfg} (optional).}

\item{...}{See \code{\link[sf:geos_combine]{geos_combine}}.}

\item{by_feature}{See \code{\link[sf:geos_combine]{geos_combine}}.}

\item{is_coverage}{See \code{\link[sf:geos_combine]{geos_combine}}.}
}
\value{
If \code{y} is missing, \code{st_union(x)} returns a single geometry 
with resolved boundaries, else the geometries for all unioned pairs of 
\code{x[i]} and \code{y[j]}.
}
\description{
Combine or union feature geometries (including \code{sftime} objects)
}
\details{
See \code{\link[sf:geos_combine]{geos_combine}}.
}
\examples{
# union simple features in an sftime object
g <- st_sfc(st_point(c(1, 2)), st_point(c(1, 3)), st_point(c(2, 3)), 
     st_point(c(2, 1)), st_point(c(3, 1)))
tc <- Sys.time() + 1:5
x <- st_sftime(a = 1:5, g, time = tc)

# only x provided (no y)
plot(st_union(st_buffer(x, dist = 1)))

# with arguments x and y provided
plot(st_union(st_buffer(x, dist = 1), st_buffer(x, dist = 0.5)), "a")

}
