% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Baseline.R
\name{createBaseline}
\alias{createBaseline}
\title{Creates a Baseline object}
\usage{
createBaseline(description = "", db = data.frame(),
  regionDefinition = createRegionDefinition(), testStatistic = "",
  regions = NULL, numbOfSeqs = matrix(), binomK = matrix(),
  binomN = matrix(), binomP = matrix(), pdfs = list(),
  stats = data.frame())
}
\arguments{
\item{description}{\code{character} providing general information regarding the 
sequences, selection analysis and/or object.}

\item{db}{\code{data.frame} containing annotation information about 
the sequences and selection results.}

\item{regionDefinition}{\link{RegionDefinition} object defining the regions
and boundaries of the Ig sequences.}

\item{testStatistic}{\code{character} indicating the statistical framework 
used to test for selection. For example, \code{"local"} or 
\code{"focused"} or \code{"imbalanced"}.}

\item{regions}{\code{character} vector defining the regions the BASELINe 
analysis was carried out on. For \code{"CDR"} and \code{"FWR"} 
or \code{"CDR1"}, \code{"CDR2"}, \code{"CDR3"}, etc. If \code{NULL}
then regions will be determined automatically from \code{regionDefinition}.}

\item{numbOfSeqs}{\code{matrix} of dimensions \code{r x c} containing the number of 
sequences or PDFs in each region, where:\cr
\code{r} = number of rows = number of groups or sequences.\cr
\code{c} = number of columns = number of regions.}

\item{binomK}{\code{matrix} of dimensions \code{r x c} containing the number of 
successes in the binomial trials in each region, where:\cr
\code{r} = number of rows = number of groups or sequences.\cr
\code{c} = number of columns = number of regions.}

\item{binomN}{\code{matrix} of dimensions \code{r x c} containing the total 
number of trials in the binomial in each region, where:\cr
\code{r} = number of rows = number of groups or sequences.\cr
\code{c} = number of columns = number of regions.}

\item{binomP}{\code{matrix} of dimensions \code{r x c} containing the probability 
of success in one binomial trial in each region, where:\cr
\code{r} = number of rows = number of groups or sequences.\cr
\code{c} = number of columns = number of regions.}

\item{pdfs}{\code{list} of matrices containing PDFs with one item for each 
defined region (e.g. "CDR" and "FWR"). Matrices have dimensions
\code{r x c} dementions, where:\cr
\code{r} = number of rows = number of sequences or groups. \cr
\code{c} = number of columns = length of the PDF (default 4001).}

\item{stats}{\code{data.frame} of BASELINe statistics, 
including: mean selection strength (mean Sigma), 95\% confidence 
intervals, and p-values with positive signs for the presence of 
positive selection and/or p-values with negative signs for the
presence of negative selection.}
}
\value{
A \code{Baseline} object.
}
\description{
\code{createBaseline} creates and initialize a \code{Baseline} object.
}
\details{
Create and initialize a \code{Baseline} object. 

The \code{testStatistic} indicates the statistical framework used to test for selection. 
For example,
\itemize{
  \item   \code{local} = CDR_R / (CDR_R + CDR_S).
  \item   \code{focused} = CDR_R / (CDR_R + CDR_S + FWR_S).
  \item   \code{immbalance} = CDR_R + CDR_s / (CDR_R + CDR_S + FWR_S + FWR_R)
}
For \code{focused} the \code{regionDefinition} must only contain two regions. If more 
than two regions are defined, then the \code{local} test statistic will be used.
For further information on the frame of these tests see Uduman et al. (2011).
}
\examples{
# Creates an empty Baseline object
createBaseline()

}
\references{
\enumerate{
  \item  Hershberg U, et al. Improved methods for detecting selection by mutation 
           analysis of Ig V region sequences. 
           Int Immunol. 2008 20(5):683-94.
  \item  Uduman M, et al. Detecting selection in immunoglobulin sequences. 
           Nucleic Acids Res. 2011 39(Web Server issue):W499-504.
  \item  Yaari G, et al. Models of somatic hypermutation targeting and substitution based
           on synonymous mutations from high-throughput immunoglobulin sequencing data.
           Front Immunol. 2013 4(November):358.
 }
}
\seealso{
See \link{Baseline} for the return object.
}
