% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git.R
\name{use_git_config}
\alias{use_git_config}
\title{Configure Git}
\usage{
use_git_config(scope = c("user", "project"), ...)
}
\arguments{
\item{scope}{Edit globally for the current \strong{user}, or locally for the
current \strong{project}}

\item{...}{Name-value pairs, processed as
<\code{\link[rlang:dyn-dots]{dynamic-dots}}>.}
}
\value{
Invisibly, the previous values of the modified components, as a named
list.
}
\description{
Sets Git options, for either the user or the project ("global" or "local", in
Git terminology). Wraps \code{\link[gert:git_config]{gert::git_config_set()}} and
\code{\link[gert:git_config]{gert::git_config_global_set()}}. To inspect Git config, see
\code{\link[gert:git_config]{gert::git_config()}}.
}
\examples{
\dontrun{
# set the user's global user.name and user.email
use_git_config(user.name = "Jane", user.email = "jane@example.org")

# set the user.name and user.email locally, i.e. for current repo/project
use_git_config(
  scope = "project",
  user.name = "Jane",
  user.email = "jane@example.org"
)
}
}
\seealso{
Other git helpers: 
\code{\link{use_git_hook}()},
\code{\link{use_git_ignore}()},
\code{\link{use_git}()}
}
\concept{git helpers}
