% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github-actions.R
\name{use_github_action}
\alias{use_github_action}
\alias{use_github_action_check_release}
\alias{use_github_action_check_standard}
\alias{use_github_action_check_full}
\alias{use_github_action_pr_commands}
\title{Use a specific GitHub Actions workflow}
\usage{
use_github_action(
  name,
  url = NULL,
  save_as = NULL,
  ignore = TRUE,
  open = FALSE
)

use_github_action_check_release(
  save_as = "R-CMD-check.yaml",
  ignore = TRUE,
  open = FALSE
)

use_github_action_check_standard(
  save_as = "R-CMD-check.yaml",
  ignore = TRUE,
  open = FALSE
)

use_github_action_check_full(
  save_as = "R-CMD-check.yaml",
  ignore = TRUE,
  open = FALSE,
  repo_spec = NULL
)

use_github_action_pr_commands(
  save_as = "pr-commands.yaml",
  ignore = TRUE,
  open = FALSE
)
}
\arguments{
\item{name}{Name of the workflow file, with or without a \code{.yaml} extension.}

\item{url}{The full URL to the \code{.yaml} file. By default, the corresponding
workflow in \url{https://github.com/r-lib/actions} will be used.}

\item{save_as}{Name of the workflow file. Defaults to \code{fs::path_file(url)}
for \code{use_github_action()}.}

\item{ignore}{Should the newly created file be added to \code{.Rbuildignore}?}

\item{open}{Open the newly created file for editing? Happens in RStudio, if
applicable, or via \code{\link[utils:file.edit]{utils::file.edit()}} otherwise.}

\item{repo_spec}{Optional GitHub repo specification in this form: \code{owner/repo}. This can usually be inferred from the GitHub remotes of active project.}
}
\description{
Configure an individual, specific \href{https://github.com/features/actions}{GitHub Actions} workflow, either one of the
examples from
\href{https://github.com/r-lib/actions/tree/master/examples}{r-lib/actions/examples}
or a custom workflow given by the \code{url} parameter.
}
\section{\code{use_github_action_check_release()}}{

This workflow installs the latest release of R on macOS and runs \verb{R CMD check} via the \href{https://github.com/r-lib/rcmdcheck}{rcmdcheck} package.
}

\section{\code{use_github_action_check_standard()}}{

This workflow runs \verb{R CMD check} via the
\href{https://github.com/r-lib/rcmdcheck}{rcmdcheck} package on the three major
operating systems (linux, macOS, and Windows) on the latest release of R and
on R-devel. This workflow is appropriate for a package that is (or will
hopefully be) on CRAN or Bioconductor.
}

\section{\code{use_github_action_check_full()}}{

This workflow runs \verb{R CMD check} at least once on each of the three major
operating systems (linux, macOS, and Windows) and on the current release,
devel, and four previous versions of R. This is how the tidyverse team checks
its packages, but it may be overkill for less widely used packages. Consider
using the more streamlined workflows set up by \code{\link[=use_github_actions]{use_github_actions()}} or
\code{use_github_action_check_standard()}.
}

\section{\code{use_github_action_pr_commands()}}{

This workflow enables the use of two R-specific commands in pull request
issue comments:
\itemize{
\item \verb{/document} to run \code{roxygen2::roxygenise()} and update the PR
\item \verb{/style} to run \code{styler::style_pkg()} and update the PR
}
}

\seealso{
\link{github_actions} for generic workflows and badge generation.
}
