% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stub_request.R
\name{stub_request}
\alias{stub_request}
\title{Stub an http request}
\usage{
stub_request(method = "get", uri = NULL, uri_regex = NULL)
}
\arguments{
\item{method}{(character) HTTP method, one of "get", "post", "put", "patch",
"head", "delete", "options" - or the special "any" (for any method)}

\item{uri}{(character) The request uri. Can be a full uri, partial, or a
regular expression to match many incantations of a uri. required.}

\item{uri_regex}{(character) A URI represented as regex. See examples}
}
\value{
an object of class \code{StubbedRequest}, with print method describing
the stub.
}
\description{
Stub an http request
}
\details{
Internally, this calls \link{StubbedRequest} which handles the logic

See \code{\link[=stub_registry]{stub_registry()}} for listing stubs, \code{\link[=stub_registry_clear]{stub_registry_clear()}}
for removing all stubs and \code{\link[=remove_request_stub]{remove_request_stub()}} for removing specific
stubs

If multiple stubs match the same request, we use the first stub. So if you
want to use a stub that was created after an earlier one that matches,
remove the earlier one(s).
}
\examples{
\dontrun{
# basic stubbing
stub_request("get", "https://httpbin.org/get")
stub_request("post", "https://httpbin.org/post")

# any method, use "any"
stub_request("any", "https://httpbin.org/get")

# list stubs
stub_registry()

# request headers
stub_request("get", "https://httpbin.org/get") \%>\%
   wi_th(headers = list('User-Agent' = 'R'))

# request body
stub_request("post", "https://httpbin.org/post") \%>\%
   wi_th(body = list(foo = 'bar'))
stub_registry()
library(crul)
x <- crul::HttpClient$new(url = "https://httpbin.org")
crul::mock()
x$post('post', body = list(foo = 'bar'))

# add expectation with to_return
stub_request("get", "https://httpbin.org/get") \%>\%
  wi_th(
    query = list(hello = "world"),
    headers = list('User-Agent' = 'R')) \%>\%
  to_return(status = 200, body = "stuff", headers = list(a = 5))

# list stubs again
stub_registry()

# regex
stub_request("get", uri_regex = ".+ample\\\\..")

# set stub an expectation to timeout
stub_request("get", "https://httpbin.org/get") \%>\% to_timeout()
x <- crul::HttpClient$new(url = "https://httpbin.org")
res <- x$get('get')

# raise exception
library(fauxpas)
stub_request("get", "https://httpbin.org/get") \%>\% to_raise(HTTPAccepted)
stub_request("get", "https://httpbin.org/get") \%>\% to_raise(HTTPAccepted, HTTPGone)

x <- crul::HttpClient$new(url = "https://httpbin.org")
stub_request("get", "https://httpbin.org/get") \%>\% to_raise(HTTPBadGateway)
crul::mock()
x$get('get')

# pass options to .list to avoid NSE
z <- stub_request("get", "https://httpbin.org/get")
wi_th(z, .list = list(query = list(foo = "bar")))

# clear all stubs
stub_registry()
stub_registry_clear()
}
}
\seealso{
\code{\link[=wi_th]{wi_th()}}, \code{\link[=to_return]{to_return()}}, \code{\link[=to_timeout]{to_timeout()}}, \code{\link[=to_raise]{to_raise()}}
}
