if(NOT TESTU01_ROOT_DIR)
    set(TESTU01_ROOT_DIR "/usr/local")
    FIND_LIBRARY(testu01 NAMES testu01 PATHS ${TESTU01_ROOT_DIR}/lib)
    FIND_LIBRARY(probdist NAMES probdist testu01probdist PATHS ${TESTU01_ROOT_DIR}/lib)
    FIND_LIBRARY(mylib NAMES mylib testu01mylib PATHS ${TESTU01_ROOT_DIR}/lib)
else()
    FIND_LIBRARY(testu01 NAMES testu01 PATHS ${TESTU01_ROOT_DIR}/lib NO_DEFAULT_PATH NO_CMAKE_FIND_ROOT_PATH)
    FIND_LIBRARY(probdist NAMES probdist testu01probdist PATHS ${TESTU01_ROOT_DIR}/lib NO_DEFAULT_PATH NO_CMAKE_FIND_ROOT_PATH)
    FIND_LIBRARY(mylib NAMES mylib testu01mylib PATHS ${TESTU01_ROOT_DIR}/lib NO_DEFAULT_PATH NO_CMAKE_FIND_ROOT_PATH)
endif()
mark_as_advanced(TESTU01_ROOT_DIR)

set(TestU01_ERROR_REASON "")
set(TestU01_FOUND TRUE)

if(NOT testu01)
    set(TestU01_FOUND 0)
    string(APPEND TestU01_ERROR_REASON "TestU01 library not found")
endif()
if(NOT probdist)
    set(TestU01_FOUND 0)
    string(APPEND TestU01_ERROR_REASON "ProbDist library not found")
endif()
if(NOT mylib)
    set(TestU01_FOUND 0)
    string(APPEND TestU01_ERROR_REASON "MyLib library not found")
endif()

find_path(TestU01_INCLUDE_DIRS bbattery.h PATH_SUFFIXES testu01 PATHS ${TESTU01_ROOT_DIR}/include)
if(NOT TestU01_INCLUDE_DIRS)
    set(TestU01_FOUND 0)
    string(APPEND TestU01_ERROR_REASON "TestU01 headers not found")
endif()
set(TestU01_LIBRARY_DIRS ${TESTU01_ROOT_DIR}/lib)

if(TestU01_FOUND)
  set(TestU01_LIBRARIES ${testu01} ${probdist} ${mylib})
  set(TestU01_INCLUDE_DIR ${TestU01_INCLUDE_DIRS})
  if(NOT TestU01_FIND_QUIETLY)
    message(STATUS "Found TestU01: ${TestU01_LIBRARIES}")
  endif()
else()
  if(TestU01_FIND_REQUIRED)
    message(SEND_ERROR "Unable to find the TestU01.\n${TestU01_ERROR_REASON}")
  else()
    if(NOT TestU01_FIND_QUIETLY)
      if(TestU01_DEBUG OR TestU01_DETAILED_FAILURE_MSG)
        message(STATUS "Could NOT find TestU01\n${TestU01_ERROR_REASON}")
      endif()
    endif()
  endif()
endif()
