# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::RecoveryServices
  module Models
    #
    # Certificate details representing the Vault credentials for ACS.
    #
    class ResourceCertificateAndAcsDetails < ResourceCertificateDetails

      include MsRestAzure

      include MsRest::JSONable

      def initialize
        @authType = "AccessControlService"
      end

      attr_accessor :authType

      # @return [String] ACS namespace name - tenant for our service.
      attr_accessor :global_acs_namespace

      # @return [String] Acs mgmt host name to connect to.
      attr_accessor :global_acs_host_name

      # @return [String] Global ACS namespace RP realm.
      attr_accessor :global_acs_rprealm


      #
      # Mapper for ResourceCertificateAndAcsDetails class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'AccessControlService',
          type: {
            name: 'Composite',
            class_name: 'ResourceCertificateAndAcsDetails',
            model_properties: {
              certificate: {
                required: false,
                serialized_name: 'certificate',
                type: {
                  name: 'ByteArray'
                }
              },
              friendly_name: {
                required: false,
                serialized_name: 'friendlyName',
                type: {
                  name: 'String'
                }
              },
              issuer: {
                required: false,
                serialized_name: 'issuer',
                type: {
                  name: 'String'
                }
              },
              resource_id: {
                required: false,
                serialized_name: 'resourceId',
                type: {
                  name: 'Number'
                }
              },
              subject: {
                required: false,
                serialized_name: 'subject',
                type: {
                  name: 'String'
                }
              },
              thumbprint: {
                required: false,
                serialized_name: 'thumbprint',
                type: {
                  name: 'String'
                }
              },
              valid_from: {
                required: false,
                serialized_name: 'validFrom',
                type: {
                  name: 'DateTime'
                }
              },
              valid_to: {
                required: false,
                serialized_name: 'validTo',
                type: {
                  name: 'DateTime'
                }
              },
              authType: {
                required: true,
                serialized_name: 'authType',
                type: {
                  name: 'String'
                }
              },
              global_acs_namespace: {
                required: true,
                serialized_name: 'globalAcsNamespace',
                type: {
                  name: 'String'
                }
              },
              global_acs_host_name: {
                required: true,
                serialized_name: 'globalAcsHostName',
                type: {
                  name: 'String'
                }
              },
              global_acs_rprealm: {
                required: true,
                serialized_name: 'globalAcsRPRealm',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
