# encoding: utf-8
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::RecoveryServicesBackup
  module Models
    #
    # Base class for backup item. Workload-specific backup items are derived
    # from this class.
    #
    class WorkloadProtectableItem

      include MsRestAzure

      include MsRest::JSONable
      @@discriminatorMap = Hash.new
      @@discriminatorMap["Microsoft.ClassicCompute/virtualMachines"] = "AzureIaaSClassicComputeVMProtectableItem"
      @@discriminatorMap["Microsoft.Compute/virtualMachines"] = "AzureIaaSComputeVMProtectableItem"
      @@discriminatorMap["IaaSVMProtectableItem"] = "IaaSVMProtectableItem"

      def initialize
        @protectableItemType = "WorkloadProtectableItem"
      end

      attr_accessor :protectableItemType

      # @return [String] Type of backup managemenent to backup an item.
      attr_accessor :backup_management_type

      # @return [String] Friendly name of the backup item.
      attr_accessor :friendly_name

      # @return [ProtectionStatus] State of the back up item. Possible values
      # include: 'Invalid', 'NotProtected', 'Protecting', 'Protected'
      attr_accessor :protection_state


      #
      # Mapper for WorkloadProtectableItem class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'WorkloadProtectableItem',
          type: {
            name: 'Composite',
            polymorphic_discriminator: 'protectableItemType',
            uber_parent: 'WorkloadProtectableItem',
            class_name: 'WorkloadProtectableItem',
            model_properties: {
              backup_management_type: {
                required: false,
                serialized_name: 'backupManagementType',
                type: {
                  name: 'String'
                }
              },
              friendly_name: {
                required: false,
                serialized_name: 'friendlyName',
                type: {
                  name: 'String'
                }
              },
              protection_state: {
                required: false,
                serialized_name: 'protectionState',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
