# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::ServiceBus
  module Models
    #
    # Description of subscription resource.
    #
    class SBSubscription < MsRestAzure::Resource

      include MsRestAzure

      include MsRest::JSONable
      # @return [Integer] Number of messages.
      attr_accessor :message_count

      # @return [DateTime] Exact time the message was created.
      attr_accessor :created_at

      # @return [DateTime] Last time there was a receive request to this
      # subscription.
      attr_accessor :accessed_at

      # @return [DateTime] The exact time the message was updated.
      attr_accessor :updated_at

      # @return [MessageCountDetails] Message count details
      attr_accessor :count_details

      # @return [Duration] ISO 8061 lock duration timespan for the
      # subscription. The default value is 1 minute.
      attr_accessor :lock_duration

      # @return [Boolean] Value indicating if a subscription supports the
      # concept of sessions.
      attr_accessor :requires_session

      # @return [Duration] ISO 8061 Default message timespan to live value.
      # This is the duration after which the message expires, starting from
      # when the message is sent to Service Bus. This is the default value used
      # when TimeToLive is not set on a message itself.
      attr_accessor :default_message_time_to_live

      # @return [Boolean] Value that indicates whether a subscription has dead
      # letter support when a message expires.
      attr_accessor :dead_lettering_on_message_expiration

      # @return [Duration] ISO 8601 timeSpan structure that defines the
      # duration of the duplicate detection history. The default value is 10
      # minutes.
      attr_accessor :duplicate_detection_history_time_window

      # @return [Integer] Number of maximum deliveries.
      attr_accessor :max_delivery_count

      # @return [EntityStatus] Enumerates the possible values for the status of
      # a messaging entity. Possible values include: 'Active', 'Disabled',
      # 'Restoring', 'SendDisabled', 'ReceiveDisabled', 'Creating', 'Deleting',
      # 'Renaming', 'Unknown'
      attr_accessor :status

      # @return [Boolean] Value that indicates whether server-side batched
      # operations are enabled.
      attr_accessor :enable_batched_operations

      # @return [Duration] ISO 8061 timeSpan idle interval after which the
      # topic is automatically deleted. The minimum duration is 5 minutes.
      attr_accessor :auto_delete_on_idle


      #
      # Mapper for SBSubscription class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'SBSubscription',
          type: {
            name: 'Composite',
            class_name: 'SBSubscription',
            model_properties: {
              id: {
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              message_count: {
                required: false,
                read_only: true,
                serialized_name: 'properties.messageCount',
                type: {
                  name: 'Number'
                }
              },
              created_at: {
                required: false,
                read_only: true,
                serialized_name: 'properties.createdAt',
                type: {
                  name: 'DateTime'
                }
              },
              accessed_at: {
                required: false,
                read_only: true,
                serialized_name: 'properties.accessedAt',
                type: {
                  name: 'DateTime'
                }
              },
              updated_at: {
                required: false,
                read_only: true,
                serialized_name: 'properties.updatedAt',
                type: {
                  name: 'DateTime'
                }
              },
              count_details: {
                required: false,
                read_only: true,
                serialized_name: 'properties.countDetails',
                type: {
                  name: 'Composite',
                  class_name: 'MessageCountDetails'
                }
              },
              lock_duration: {
                required: false,
                serialized_name: 'properties.lockDuration',
                type: {
                  name: 'TimeSpan'
                }
              },
              requires_session: {
                required: false,
                serialized_name: 'properties.requiresSession',
                type: {
                  name: 'Boolean'
                }
              },
              default_message_time_to_live: {
                required: false,
                serialized_name: 'properties.defaultMessageTimeToLive',
                type: {
                  name: 'TimeSpan'
                }
              },
              dead_lettering_on_message_expiration: {
                required: false,
                serialized_name: 'properties.deadLetteringOnMessageExpiration',
                type: {
                  name: 'Boolean'
                }
              },
              duplicate_detection_history_time_window: {
                required: false,
                serialized_name: 'properties.duplicateDetectionHistoryTimeWindow',
                type: {
                  name: 'TimeSpan'
                }
              },
              max_delivery_count: {
                required: false,
                serialized_name: 'properties.maxDeliveryCount',
                type: {
                  name: 'Number'
                }
              },
              status: {
                required: false,
                serialized_name: 'properties.status',
                type: {
                  name: 'Enum',
                  module: 'EntityStatus'
                }
              },
              enable_batched_operations: {
                required: false,
                serialized_name: 'properties.enableBatchedOperations',
                type: {
                  name: 'Boolean'
                }
              },
              auto_delete_on_idle: {
                required: false,
                serialized_name: 'properties.autoDeleteOnIdle',
                type: {
                  name: 'TimeSpan'
                }
              }
            }
          }
        }
      end
    end
  end
end
