# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::StreamAnalytics
  module Models
    #
    # An output object, containing all information associated with the named
    # output. All outputs are contained under a streaming job.
    #
    class Output < MsRestAzure::SubResource

      include MsRestAzure

      include MsRest::JSONable
      # @return [OutputDataSource] Describes the data source that output will
      # be written to. Required on PUT (CreateOrReplace) requests.
      attr_accessor :datasource

      # @return [Serialization] Describes how data from an input is serialized
      # or how data is serialized when written to an output. Required on PUT
      # (CreateOrReplace) requests.
      attr_accessor :serialization

      # @return [Diagnostics] Describes conditions applicable to the Input,
      # Output, or the job overall, that warrant customer attention.
      attr_accessor :diagnostics

      # @return [String] The current entity tag for the output. This is an
      # opaque string. You can use it to detect whether the resource has
      # changed between requests. You can also use it in the If-Match or
      # If-None-Match headers for write operations for optimistic concurrency.
      attr_accessor :etag


      #
      # Mapper for Output class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'Output',
          type: {
            name: 'Composite',
            class_name: 'Output',
            model_properties: {
              id: {
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                required: false,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              datasource: {
                required: false,
                serialized_name: 'properties.datasource',
                type: {
                  name: 'Composite',
                  polymorphic_discriminator: 'type',
                  uber_parent: 'OutputDataSource',
                  class_name: 'OutputDataSource'
                }
              },
              serialization: {
                required: false,
                serialized_name: 'properties.serialization',
                type: {
                  name: 'Composite',
                  polymorphic_discriminator: 'type',
                  uber_parent: 'Serialization',
                  class_name: 'Serialization'
                }
              },
              diagnostics: {
                required: false,
                read_only: true,
                serialized_name: 'properties.diagnostics',
                type: {
                  name: 'Composite',
                  class_name: 'Diagnostics'
                }
              },
              etag: {
                required: false,
                read_only: true,
                serialized_name: 'properties.etag',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
