// Copyright 2020 Contributors to the Parsec project.
// SPDX-License-Identifier: Apache-2.0

//! Specification-defined constants

#![allow(missing_docs)]

use super::types::*;

pub const PSA_ALG_ANY_HASH: psa_algorithm_t = 0x020000ff;
pub const PSA_ALG_CBC_MAC: psa_algorithm_t = 0x03c00100;
pub const PSA_ALG_CBC_NO_PADDING: psa_algorithm_t = 0x04404000;
pub const PSA_ALG_CBC_PKCS7: psa_algorithm_t = 0x04404100;
pub const PSA_ALG_CCM: psa_algorithm_t = 0x05500100;
pub const PSA_ALG_CFB: psa_algorithm_t = 0x04c01100;
pub const PSA_ALG_CHACHA20_POLY1305: psa_algorithm_t = 0x05100500;
pub const PSA_ALG_CMAC: psa_algorithm_t = 0x03c00200;
pub const PSA_ALG_CTR: psa_algorithm_t = 0x04c01000;
pub const PSA_ALG_ECB_NO_PADDING: psa_algorithm_t = 0x04404400;
pub const PSA_ALG_ECDH: psa_algorithm_t = 0x09020000;
pub const PSA_ALG_ECDSA_ANY: psa_algorithm_t = 0x06000600;
pub const PSA_ALG_FFDH: psa_algorithm_t = 0x09010000;
pub const PSA_ALG_GCM: psa_algorithm_t = 0x05500200;
pub const PSA_ALG_MD2: psa_algorithm_t = 0x02000001;
pub const PSA_ALG_MD4: psa_algorithm_t = 0x02000002;
pub const PSA_ALG_MD5: psa_algorithm_t = 0x02000003;
pub const PSA_ALG_NONE: psa_algorithm_t = 0;
pub const PSA_ALG_OFB: psa_algorithm_t = 0x04c01200;
pub const PSA_ALG_RIPEMD160: psa_algorithm_t = 0x02000004;
pub const PSA_ALG_RSA_PKCS1V15_CRYPT: psa_algorithm_t = 0x07000200;
pub const PSA_ALG_RSA_PKCS1V15_SIGN_RAW: psa_algorithm_t = 0x06000200;
pub const PSA_ALG_SHA3_224: psa_algorithm_t = 0x02000010;
pub const PSA_ALG_SHA3_256: psa_algorithm_t = 0x02000011;
pub const PSA_ALG_SHA3_384: psa_algorithm_t = 0x02000012;
pub const PSA_ALG_SHA3_512: psa_algorithm_t = 0x02000013;
pub const PSA_ALG_SHA_1: psa_algorithm_t = 0x02000005;
pub const PSA_ALG_SHA_224: psa_algorithm_t = 0x02000008;
pub const PSA_ALG_SHA_256: psa_algorithm_t = 0x02000009;
pub const PSA_ALG_SHA_384: psa_algorithm_t = 0x0200000a;
pub const PSA_ALG_SHA_512: psa_algorithm_t = 0x0200000b;
pub const PSA_ALG_SHA_512_224: psa_algorithm_t = 0x0200000c;
pub const PSA_ALG_SHA_512_256: psa_algorithm_t = 0x0200000d;
pub const PSA_ALG_SM3: psa_algorithm_t = 0x02000014;
pub const PSA_ALG_STREAM_CIPHER: psa_algorithm_t = 0x04800100;
pub const PSA_ALG_XTS: psa_algorithm_t = 0x0440ff00;
pub const PSA_DH_FAMILY_RFC7919: psa_dh_family_t = 0x03;
pub const PSA_ECC_FAMILY_BRAINPOOL_P_R1: psa_ecc_family_t = 0x30;
pub const PSA_ECC_FAMILY_FRP: psa_ecc_family_t = 0x33;
pub const PSA_ECC_FAMILY_MONTGOMERY: psa_ecc_family_t = 0x41;
pub const PSA_ECC_FAMILY_SECP_K1: psa_ecc_family_t = 0x17;
pub const PSA_ECC_FAMILY_SECP_R1: psa_ecc_family_t = 0x12;
pub const PSA_ECC_FAMILY_SECP_R2: psa_ecc_family_t = 0x1b;
pub const PSA_ECC_FAMILY_SECT_K1: psa_ecc_family_t = 0x27;
pub const PSA_ECC_FAMILY_SECT_R1: psa_ecc_family_t = 0x22;
pub const PSA_ECC_FAMILY_SECT_R2: psa_ecc_family_t = 0x2b;
pub const PSA_ERROR_ALREADY_EXISTS: psa_status_t = -139;
pub const PSA_ERROR_BAD_STATE: psa_status_t = -137;
pub const PSA_ERROR_BUFFER_TOO_SMALL: psa_status_t = -138;
pub const PSA_ERROR_COMMUNICATION_FAILURE: psa_status_t = -145;
pub const PSA_ERROR_CORRUPTION_DETECTED: psa_status_t = -151;
pub const PSA_ERROR_DATA_CORRUPT: psa_status_t = -152;
pub const PSA_ERROR_DATA_INVALID: psa_status_t = -153;
pub const PSA_ERROR_DOES_NOT_EXIST: psa_status_t = -140;
pub const PSA_ERROR_GENERIC_ERROR: psa_status_t = -132;
pub const PSA_ERROR_HARDWARE_FAILURE: psa_status_t = -147;
pub const PSA_ERROR_INSUFFICIENT_DATA: psa_status_t = -143;
pub const PSA_ERROR_INSUFFICIENT_ENTROPY: psa_status_t = -148;
pub const PSA_ERROR_INSUFFICIENT_MEMORY: psa_status_t = -141;
pub const PSA_ERROR_INSUFFICIENT_STORAGE: psa_status_t = -142;
pub const PSA_ERROR_INVALID_ARGUMENT: psa_status_t = -135;
pub const PSA_ERROR_INVALID_HANDLE: psa_status_t = -136;
pub const PSA_ERROR_INVALID_PADDING: psa_status_t = -150;
pub const PSA_ERROR_INVALID_SIGNATURE: psa_status_t = -149;
pub const PSA_ERROR_NOT_PERMITTED: psa_status_t = -133;
pub const PSA_ERROR_NOT_SUPPORTED: psa_status_t = -134;
pub const PSA_ERROR_STORAGE_FAILURE: psa_status_t = -146;
pub const PSA_HASH_SUSPEND_ALGORITHM_FIELD_LENGTH: usize = 4;
pub const PSA_KEY_ID_NULL: psa_key_id_t = 0;
pub const PSA_KEY_ID_USER_MAX: psa_key_id_t = 0x3fffffff;
pub const PSA_KEY_ID_USER_MIN: psa_key_id_t = 0x00000001;
pub const PSA_KEY_ID_VENDOR_MAX: psa_key_id_t = 0x7fffffff;
pub const PSA_KEY_ID_VENDOR_MIN: psa_key_id_t = 0x40000000;
pub const PSA_KEY_LIFETIME_PERSISTENT: psa_key_lifetime_t = 0x00000001;
pub const PSA_KEY_LIFETIME_VOLATILE: psa_key_lifetime_t = 0x00000000;
pub const PSA_KEY_LOCATION_LOCAL_STORAGE: psa_key_location_t = 0x000000;
pub const PSA_KEY_LOCATION_PRIMARY_SECURE_ELEMENT: psa_key_location_t = 0x000001;
pub const PSA_KEY_PERSISTENCE_DEFAULT: psa_key_persistence_t = 0x01;
pub const PSA_KEY_PERSISTENCE_READ_ONLY: psa_key_persistence_t = 0xff;
pub const PSA_KEY_PERSISTENCE_VOLATILE: psa_key_persistence_t = 0x00;
pub const PSA_KEY_TYPE_AES: psa_key_type_t = 0x2400;
pub const PSA_KEY_TYPE_ARC4: psa_key_type_t = 0x2002;
pub const PSA_KEY_TYPE_CAMELLIA: psa_key_type_t = 0x2403;
pub const PSA_KEY_TYPE_CHACHA20: psa_key_type_t = 0x2004;
pub const PSA_KEY_TYPE_DERIVE: psa_key_type_t = 0x1200;
pub const PSA_KEY_TYPE_DES: psa_key_type_t = 0x2301;
pub const PSA_KEY_TYPE_HMAC: psa_key_type_t = 0x1100;
pub const PSA_KEY_TYPE_NONE: psa_key_type_t = 0x0000;
pub const PSA_KEY_TYPE_RAW_DATA: psa_key_type_t = 0x1001;
pub const PSA_KEY_TYPE_RSA_KEY_PAIR: psa_key_type_t = 0x7001;
pub const PSA_KEY_TYPE_RSA_PUBLIC_KEY: psa_key_type_t = 0x4001;
pub const PSA_KEY_TYPE_SM4: psa_key_type_t = 0x2405;
pub const PSA_KEY_USAGE_CACHE: psa_key_usage_t = 0x00000004;
pub const PSA_KEY_USAGE_COPY: psa_key_usage_t = 0x00000002;
pub const PSA_KEY_USAGE_DECRYPT: psa_key_usage_t = 0x00000200;
pub const PSA_KEY_USAGE_DERIVE: psa_key_usage_t = 0x00004000;
pub const PSA_KEY_USAGE_ENCRYPT: psa_key_usage_t = 0x00000100;
pub const PSA_KEY_USAGE_EXPORT: psa_key_usage_t = 0x00000001;
pub const PSA_KEY_USAGE_SIGN_HASH: psa_key_usage_t = 0x00001000;
pub const PSA_KEY_USAGE_SIGN_MESSAGE: psa_key_usage_t = 0x00000400;
pub const PSA_KEY_USAGE_VERIFY_HASH: psa_key_usage_t = 0x00002000;
pub const PSA_KEY_USAGE_VERIFY_MESSAGE: psa_key_usage_t = 0x00000800;
pub const PSA_SUCCESS: psa_status_t = 0;
