// This test confirms an earlier problem was resolved, supporting the MIR graph generated by the
// structure of this test.

#[derive(Clone, Debug, PartialEq, Eq, PartialOrd, Ord)]
pub struct Version {
    major: usize,
    minor: usize,
    patch: usize,
}

impl Version {
    pub fn new(major: usize, minor: usize, patch: usize) -> Self {
        Self {
            major,
            minor,
            patch,
        }
    }
}

fn main() {
    let version_3_2_1 = Version::new(3, 2, 1);
    let version_3_3_0 = Version::new(3, 3, 0);

    println!("{:?} < {:?} = {}", version_3_2_1, version_3_3_0, version_3_2_1 < version_3_3_0);
}

/*

This test verifies a bug was fixed that otherwise generated this error:

thread 'rustc' panicked at 'No counters provided the source_hash for function:
    Instance {
        def: Item(WithOptConstParam {
            did: DefId(0:101 ~ autocfg[c44a]::version::{impl#2}::partial_cmp),
            const_param_did: None
        }),
        substs: []
    }'
The `PartialOrd` derived by `Version` happened to generate a MIR that generated coverage
without a code region associated with any `Counter`. Code regions were associated with at least
one expression, which is allowed, but the `function_source_hash` was only passed to the codegen
(coverage mapgen) phase from a `Counter`s code region. A new method was added to pass the
`function_source_hash` without a code region, if necessary.

*/

// FIXME(richkadel): It may be worth investigating why the coverage report for this test produces
// the following results:

/*

1. Why are their two counts below different characters (first and last) of `PartialOrd`, on line 17?

2. Line 17 is counted twice, but the `::lt` instance shows a line count of 1? Is there a missing
   line count with a different instance? Or was it really only called once?

3. Line 20 shows another line count (of 1) for a line within a `struct` declaration (on only one of
   its 3 fields). I doubt the specific field (`minor`) is relevant, but rather I suspect there's a
   problem computing the file position here, for some reason.

<snip>
   16|       |
   17|      2|#[derive(Clone, Debug, PartialEq, Eq, PartialOrd, Ord)]
                                                    ^1       ^1
------------------
|Unexecuted instantiation: <partial_eq_counter_without_region::Version as core::cmp::PartialOrd>::gt
------------------
|Unexecuted instantiation: <partial_eq_counter_without_region::Version as core::cmp::PartialOrd>::le
------------------
|Unexecuted instantiation: <partial_eq_counter_without_region::Version as core::cmp::PartialOrd>::ge
------------------
|<partial_eq_counter_without_region::Version as core::cmp::PartialOrd>::lt:
|  17|      1|#[derive(Clone, Debug, PartialEq, Eq, PartialOrd, Ord)]
------------------
   18|       |pub struct Version {
   19|       |    major: usize,
   20|      1|    minor: usize,
   21|       |    patch: usize,
   22|       |}
   23|       |
   24|       |impl Version {
   25|       |    pub fn new(major: usize, minor: usize, patch: usize) -> Self {
   26|      2|        Version {
   27|      2|            major,
   28|      2|            minor,
   29|      2|            patch,
   30|      2|        }
   31|      2|    }
   32|       |}
   33|       |
   34|      1|fn main() {
   35|      1|    let version_3_2_1 = Version::new(3, 2, 1);
   36|      1|    let version_3_3_0 = Version::new(3, 3, 0);
   37|      1|
   38|      1|    println!("{:?} < {:?} = {}", version_3_2_1, version_3_3_0, version_3_2_1 < version
_3_3_0);
   39|      1|}
*/
