#![allow(non_snake_case, non_camel_case_types, non_upper_case_globals, clashing_extern_declarations, clippy::all)]
#[link(name = "windows")]
extern "system" {
    pub fn AmsiCloseSession(amsicontext: HAMSICONTEXT, amsisession: HAMSISESSION);
    #[cfg(feature = "Win32_Foundation")]
    pub fn AmsiInitialize(appname: super::super::Foundation::PWSTR, amsicontext: *mut HAMSICONTEXT) -> ::windows_sys::core::HRESULT;
    #[cfg(feature = "Win32_Foundation")]
    pub fn AmsiNotifyOperation(amsicontext: HAMSICONTEXT, buffer: *const ::core::ffi::c_void, length: u32, contentname: super::super::Foundation::PWSTR, result: *mut AMSI_RESULT) -> ::windows_sys::core::HRESULT;
    pub fn AmsiOpenSession(amsicontext: HAMSICONTEXT, amsisession: *mut HAMSISESSION) -> ::windows_sys::core::HRESULT;
    #[cfg(feature = "Win32_Foundation")]
    pub fn AmsiScanBuffer(amsicontext: HAMSICONTEXT, buffer: *const ::core::ffi::c_void, length: u32, contentname: super::super::Foundation::PWSTR, amsisession: HAMSISESSION, result: *mut AMSI_RESULT) -> ::windows_sys::core::HRESULT;
    #[cfg(feature = "Win32_Foundation")]
    pub fn AmsiScanString(amsicontext: HAMSICONTEXT, string: super::super::Foundation::PWSTR, contentname: super::super::Foundation::PWSTR, amsisession: HAMSISESSION, result: *mut AMSI_RESULT) -> ::windows_sys::core::HRESULT;
    pub fn AmsiUninitialize(amsicontext: HAMSICONTEXT);
    #[cfg(feature = "Win32_Foundation")]
    pub fn InstallELAMCertificateInfo(elamfile: super::super::Foundation::HANDLE) -> super::super::Foundation::BOOL;
}
pub type AMSI_ATTRIBUTE = i32;
pub const AMSI_ATTRIBUTE_APP_NAME: AMSI_ATTRIBUTE = 0i32;
pub const AMSI_ATTRIBUTE_CONTENT_NAME: AMSI_ATTRIBUTE = 1i32;
pub const AMSI_ATTRIBUTE_CONTENT_SIZE: AMSI_ATTRIBUTE = 2i32;
pub const AMSI_ATTRIBUTE_CONTENT_ADDRESS: AMSI_ATTRIBUTE = 3i32;
pub const AMSI_ATTRIBUTE_SESSION: AMSI_ATTRIBUTE = 4i32;
pub const AMSI_ATTRIBUTE_REDIRECT_CHAIN_SIZE: AMSI_ATTRIBUTE = 5i32;
pub const AMSI_ATTRIBUTE_REDIRECT_CHAIN_ADDRESS: AMSI_ATTRIBUTE = 6i32;
pub const AMSI_ATTRIBUTE_ALL_SIZE: AMSI_ATTRIBUTE = 7i32;
pub const AMSI_ATTRIBUTE_ALL_ADDRESS: AMSI_ATTRIBUTE = 8i32;
pub const AMSI_ATTRIBUTE_QUIET: AMSI_ATTRIBUTE = 9i32;
pub type AMSI_RESULT = i32;
pub const AMSI_RESULT_CLEAN: AMSI_RESULT = 0i32;
pub const AMSI_RESULT_NOT_DETECTED: AMSI_RESULT = 1i32;
pub const AMSI_RESULT_BLOCKED_BY_ADMIN_START: AMSI_RESULT = 16384i32;
pub const AMSI_RESULT_BLOCKED_BY_ADMIN_END: AMSI_RESULT = 20479i32;
pub const AMSI_RESULT_DETECTED: AMSI_RESULT = 32768i32;
pub type AMSI_UAC_MSI_ACTION = i32;
pub const AMSI_UAC_MSI_ACTION_INSTALL: AMSI_UAC_MSI_ACTION = 0i32;
pub const AMSI_UAC_MSI_ACTION_UNINSTALL: AMSI_UAC_MSI_ACTION = 1i32;
pub const AMSI_UAC_MSI_ACTION_UPDATE: AMSI_UAC_MSI_ACTION = 2i32;
pub const AMSI_UAC_MSI_ACTION_MAINTENANCE: AMSI_UAC_MSI_ACTION = 3i32;
pub const AMSI_UAC_MSI_ACTION_MAX: AMSI_UAC_MSI_ACTION = 4i32;
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct AMSI_UAC_REQUEST_AX_INFO {
    pub ulLength: u32,
    pub lpwszLocalInstallPath: super::super::Foundation::PWSTR,
    pub lpwszSourceURL: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AMSI_UAC_REQUEST_AX_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AMSI_UAC_REQUEST_AX_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct AMSI_UAC_REQUEST_COM_INFO {
    pub ulLength: u32,
    pub lpwszServerBinary: super::super::Foundation::PWSTR,
    pub lpwszRequestor: super::super::Foundation::PWSTR,
    pub Clsid: ::windows_sys::core::GUID,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AMSI_UAC_REQUEST_COM_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AMSI_UAC_REQUEST_COM_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct AMSI_UAC_REQUEST_CONTEXT {
    pub ulLength: u32,
    pub ulRequestorProcessId: u32,
    pub UACTrustState: AMSI_UAC_TRUST_STATE,
    pub Type: AMSI_UAC_REQUEST_TYPE,
    pub RequestType: AMSI_UAC_REQUEST_CONTEXT_0,
    pub bAutoElevateRequest: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AMSI_UAC_REQUEST_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AMSI_UAC_REQUEST_CONTEXT {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union AMSI_UAC_REQUEST_CONTEXT_0 {
    pub ExeInfo: AMSI_UAC_REQUEST_EXE_INFO,
    pub ComInfo: AMSI_UAC_REQUEST_COM_INFO,
    pub MsiInfo: AMSI_UAC_REQUEST_MSI_INFO,
    pub ActiveXInfo: AMSI_UAC_REQUEST_AX_INFO,
    pub PackagedAppInfo: AMSI_UAC_REQUEST_PACKAGED_APP_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AMSI_UAC_REQUEST_CONTEXT_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AMSI_UAC_REQUEST_CONTEXT_0 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct AMSI_UAC_REQUEST_EXE_INFO {
    pub ulLength: u32,
    pub lpwszApplicationName: super::super::Foundation::PWSTR,
    pub lpwszCommandLine: super::super::Foundation::PWSTR,
    pub lpwszDLLParameter: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AMSI_UAC_REQUEST_EXE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AMSI_UAC_REQUEST_EXE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct AMSI_UAC_REQUEST_MSI_INFO {
    pub ulLength: u32,
    pub MsiAction: AMSI_UAC_MSI_ACTION,
    pub lpwszProductName: super::super::Foundation::PWSTR,
    pub lpwszVersion: super::super::Foundation::PWSTR,
    pub lpwszLanguage: super::super::Foundation::PWSTR,
    pub lpwszManufacturer: super::super::Foundation::PWSTR,
    pub lpwszPackagePath: super::super::Foundation::PWSTR,
    pub lpwszPackageSource: super::super::Foundation::PWSTR,
    pub ulUpdates: u32,
    pub ppwszUpdates: *mut super::super::Foundation::PWSTR,
    pub ppwszUpdateSources: *mut super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AMSI_UAC_REQUEST_MSI_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AMSI_UAC_REQUEST_MSI_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    pub ulLength: u32,
    pub lpwszApplicationName: super::super::Foundation::PWSTR,
    pub lpwszCommandLine: super::super::Foundation::PWSTR,
    pub lpPackageFamilyName: super::super::Foundation::PWSTR,
    pub lpApplicationId: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AMSI_UAC_REQUEST_PACKAGED_APP_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
pub type AMSI_UAC_REQUEST_TYPE = i32;
pub const AMSI_UAC_REQUEST_TYPE_EXE: AMSI_UAC_REQUEST_TYPE = 0i32;
pub const AMSI_UAC_REQUEST_TYPE_COM: AMSI_UAC_REQUEST_TYPE = 1i32;
pub const AMSI_UAC_REQUEST_TYPE_MSI: AMSI_UAC_REQUEST_TYPE = 2i32;
pub const AMSI_UAC_REQUEST_TYPE_AX: AMSI_UAC_REQUEST_TYPE = 3i32;
pub const AMSI_UAC_REQUEST_TYPE_PACKAGED_APP: AMSI_UAC_REQUEST_TYPE = 4i32;
pub const AMSI_UAC_REQUEST_TYPE_MAX: AMSI_UAC_REQUEST_TYPE = 5i32;
pub type AMSI_UAC_TRUST_STATE = i32;
pub const AMSI_UAC_TRUST_STATE_TRUSTED: AMSI_UAC_TRUST_STATE = 0i32;
pub const AMSI_UAC_TRUST_STATE_UNTRUSTED: AMSI_UAC_TRUST_STATE = 1i32;
pub const AMSI_UAC_TRUST_STATE_BLOCKED: AMSI_UAC_TRUST_STATE = 2i32;
pub const AMSI_UAC_TRUST_STATE_MAX: AMSI_UAC_TRUST_STATE = 3i32;
pub const CAntimalware: ::windows_sys::core::GUID = ::windows_sys::core::GUID { data1: 4256173650, data2: 41492, data3: 19105, data4: [143, 186, 67, 87, 187, 0, 114, 236] };
pub type HAMSICONTEXT = isize;
pub type HAMSISESSION = isize;
pub type IAmsiStream = *mut ::core::ffi::c_void;
pub type IAntimalware = *mut ::core::ffi::c_void;
pub type IAntimalware2 = *mut ::core::ffi::c_void;
pub type IAntimalwareProvider = *mut ::core::ffi::c_void;
pub type IAntimalwareProvider2 = *mut ::core::ffi::c_void;
pub type IAntimalwareUacProvider = *mut ::core::ffi::c_void;
