/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2010 - DIGITEO - Yann Collette
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */
#include <sci_mysql.h>

int sci_mysql_kill(char * fname)
{
  int * sql_pointer_in = NULL;
  int * pid = NULL;
  MYSQL * mysql_ptr = NULL;
  void * ptr_in = NULL;
  SciErr _SciErr;
  double result, dpid;

  CheckRhs(2,2);
  CheckLhs(0,1);

  _SciErr = getVarAddressFromPosition(pvApiCtx, 1, &sql_pointer_in);
  getPointer(pvApiCtx, sql_pointer_in, &ptr_in);
  mysql_ptr = (MYSQL *)ptr_in;

  if (mysql_ptr==NULL)
    {
      Scierror(999,"%s: problem with the mysql pointer\n", fname);
      return 0;
    }

  _SciErr = getVarAddressFromPosition(pvApiCtx, 2, &pid);
  getScalarDouble(pvApiCtx, pid, &dpid);

  result = (double)mysql_kill(mysql_ptr, (unsigned long)dpid);
  createScalarDouble(pvApiCtx, Rhs+1, result);

  LhsVar(1) = Rhs + 1;

  return 0;
}
