/* Copyright (C) 2001, 2007 United States Government as represented by
   the Administrator of the National Aeronautics and Space Administration.
   All Rights Reserved.
*/
package gov.nasa.worldwind.servers.wms;

import java.sql.Date;
import java.text.DateFormat;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

/**
 *
 * @author brownrigg
 * @version $Id: SysLog.java 3341 2007-10-19 11:36:00Z rick $
 */
public class SysLog {
    
    public static SysLog inst() {
        if (theInst == null) 
            theInst = new SysLog();
        return theInst;
    }
    
    public void error(String msg) {
        logger.severe(format(msg));
    }
    
    public void warning(String msg) {
        logger.warning(format(msg));
    }
    
    public void info(String msg) {
        logger.info(format(msg));
    }

    public void stackTrace(Exception ex) {
        StackTraceElement[] elems = ex.getStackTrace();
        if (elems != null) {
            StringBuilder trace = new StringBuilder();
            for (StackTraceElement e : elems) {
                trace.append("    ").append(e.toString()).append("\n");
            }
            error(trace.toString());
        }
    }
        
    private String format(String msg) {
        long currTime = System.currentTimeMillis();
        Date now = new Date(currTime);
        return dateFormatter.format(now) + ": " + msg;
    }
    
    private SysLog() {
        logger = Logger.getAnonymousLogger();
        logger.setUseParentHandlers(false);
        SysLogFormatter formatter = new SysLogFormatter();
        SysLogHandler handler = new SysLogHandler();
        handler.setFormatter(formatter);
        logger.addHandler(handler);
        dateFormatter = DateFormat.getDateTimeInstance();
    }
    
    private class SysLogFormatter extends Formatter {
        public String format(LogRecord lrec) {
            return lrec.getLevel() + " " + lrec.getMessage();
        }
    }
    
    private class SysLogHandler extends StreamHandler {
        public SysLogHandler() {
            setOutputStream(System.err);
        }
    
        public void publish(LogRecord lrec) {
            System.err.println(getFormatter().format(lrec));
        }
    }
    
    private Logger logger;
    private DateFormat dateFormatter;
    private static SysLog theInst = null;

}
