/* Copyright (C) 2001, 2007 United States Government as represented by
   the Administrator of the National Aeronautics and Space Administration.
   All Rights Reserved.
 */
package gov.nasa.worldwind.servers.wms.generators;

import java.io.File;

/**
 * This class wraps a File object with a finalizer that ensures the file gets deleted 
 * when this object is reclaimed. 
 *
 * @author brownrigg
 * @version $Id$
 */

public class TempFile extends File {
    
    public TempFile(String name) {
        super(name);
    }

    protected void finalize() throws Throwable {
        try {
            if( this.exists() )
                this.delete();
        } catch (Exception ex) { }
    }
}
