#ifndef SCIMBRIDGEAGENTCURSORLOCATIONCHANGEDEVENT_H_
#define SCIMBRIDGEAGENTCURSORLOCATIONCHANGEDEVENT_H_

#include "scim-bridge-agent-client-listener.h"
#include "scim-bridge-agent-event.h"
#include "scim-bridge-imcontext.h"

class ScimBridgeAgentCursorLocationChangedEvent: public ScimBridgeAgentEvent
{

    public:

        ScimBridgeAgentCursorLocationChangedEvent (scim_bridge_imcontext_id_t new_id, int new_x, int new_y, ScimBridgeAgentClientListener *new_client_listener);
        ~ScimBridgeAgentCursorLocationChangedEvent ();

        scim_bridge_imcontext_id_t get_imcontext_id () const;

        int get_cursor_x () const;
        int get_cursor_y () const;

        ScimBridgeAgentClientListener *get_client_listener () const;

    private:

        scim_bridge_imcontext_id_t imcontext_id;

        int cursor_x;
        int cursor_y;

        ScimBridgeAgentClientListener *client_listener;

};
#endif                                            /*SCIMBRIDGEAGENTCURSORLOCATIONCHANGEDEVENT_H_*/
