/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#include "scim-bridge-agent-set-preedit-cursor-position-event.h"

ScimBridgeAgentSetPreeditCursorPositionEvent::ScimBridgeAgentSetPreeditCursorPositionEvent (scim_bridge_imcontext_id_t new_id, size_t new_cursor_pos):
ScimBridgeAgentEvent (SET_PREEDIT_CURSOR_POSITION_EVENT), imcontext_id (new_id), cursor_position (new_cursor_pos)
{
}


ScimBridgeAgentSetPreeditCursorPositionEvent::~ScimBridgeAgentSetPreeditCursorPositionEvent ()
{
}


scim_bridge_imcontext_id_t ScimBridgeAgentSetPreeditCursorPositionEvent::get_imcontext_id () const
{
    return imcontext_id;
}


size_t ScimBridgeAgentSetPreeditCursorPositionEvent::get_cursor_position () const
{
    return cursor_position;
}
