/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#include "scim-bridge-agent-surrounding-text-gotten-event.h"

using namespace scim;

ScimBridgeAgentSurroundingTextGottenEvent::ScimBridgeAgentSurroundingTextGottenEvent (scim_bridge_message_response_id_t new_id, const WideString &new_string, int caret, bool new_ret):
ScimBridgeAgentEvent (SURROUNDING_TEXT_GOTTEN_EVENT), response_id (new_id), surrounding_text (new_string), cursor_position (caret), retval (new_ret)
{
}


ScimBridgeAgentSurroundingTextGottenEvent::~ScimBridgeAgentSurroundingTextGottenEvent ()
{
}


scim_bridge_message_response_id_t ScimBridgeAgentSurroundingTextGottenEvent::get_response_id () const
{
    return response_id;
}


const WideString &ScimBridgeAgentSurroundingTextGottenEvent::get_surrounding_text () const
{
    return surrounding_text;
}


int ScimBridgeAgentSurroundingTextGottenEvent::get_cursor_position () const
{
    return cursor_position;
}


bool ScimBridgeAgentSurroundingTextGottenEvent::get_retval () const
{
    return retval;
}
