/*
 * SCIM Bridge
 *
 * Copyright (c) 2006 Ryo Dairiki <ryo-dairiki@users.sourceforge.net>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.*
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.*
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#ifndef SCIMBRIDGECLIENTIMCONTEXT_H_
#define SCIMBRIDGECLIENTIMCONTEXT_H_

#include "scim-bridge.h"
#include "scim-bridge-attribute.h"
#include "scim-bridge-imcontext.h"
#include "scim-bridge-key-event.h"

typedef struct _ScimBridgeClientIMContext ScimBridgeClientIMContext;

#ifdef __cplusplus
extern "C"
{
#endif

    ScimBridgeClientIMContext *scim_bridge_client_find_imcontext (scim_bridge_imcontext_id_t id);
    void scim_bridge_client_imcontext_set_id (ScimBridgeClientIMContext *imcontext, scim_bridge_imcontext_id_t new_id);
    scim_bridge_imcontext_id_t scim_bridge_client_imcontext_get_id (const ScimBridgeClientIMContext *imcontext);

    void scim_bridge_client_imcontext_set_preedit_string (ScimBridgeClientIMContext *imcontext, const char *preedit_string);
    void scim_bridge_client_imcontext_set_preedit_shown (ScimBridgeClientIMContext *imcontext, boolean preedit_shown);
    void scim_bridge_client_imcontext_set_preedit_cursor_position (ScimBridgeClientIMContext *imcontext, int cursor_position);
    void scim_bridge_client_imcontext_set_preedit_attributes (ScimBridgeClientIMContext *imcontext, ScimBridgeAttribute** const preedit_attributes, int attribute_count);
    void scim_bridge_client_imcontext_update_preedit (const ScimBridgeClientIMContext *imcontext);
    void scim_bridge_client_imcontext_set_commit_string (ScimBridgeClientIMContext *imcontext, const char *commit_string);
    void scim_bridge_client_imcontext_commit (const ScimBridgeClientIMContext *imcontext);
    void scim_bridge_client_imcontext_beep (const ScimBridgeClientIMContext *imcontext);
    void scim_bridge_client_imcontext_forward_key_event (const ScimBridgeClientIMContext *imcontext, const ScimBridgeKeyEvent *key_event);
    boolean scim_bridge_client_imcontext_get_surrounding_text (const ScimBridgeClientIMContext *imcontext, int before_max, int after_max, char **string, int *cursor_position);
    boolean scim_bridge_client_imcontext_delete_surrounding_text (ScimBridgeClientIMContext *imcontext, int offset, int length, boolean *need_reset);

#ifdef __cplusplus
}
#endif
#endif                                            /*SCIMBRIDGECLIENTIMCONTEXT_H_*/
