<?xml version="1.0" encoding="ascii"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template name="replaceEntities">
<xsl:param name="content"/>
<xsl:if test="string-length($content)&gt;0">
<xsl:choose>

<xsl:when test="starts-with($content,' ')"><xsl:value-of select="'\; '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,' ')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8201;&#8202;&#8202;')"><xsl:value-of select="'\; '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8201;&#8202;&#8202;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'#')"><xsl:value-of select="'\# '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'#')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'$')"><xsl:value-of select="'\$ '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'$')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'%')"><xsl:value-of select="'\% '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'%')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&amp;')"><xsl:value-of select="'\&amp; '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&amp;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'*')"><xsl:value-of select="'\ast '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'*')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,':')"><xsl:value-of select="'\colon '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,':')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&lt;')"><xsl:value-of select="'&lt;'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&lt;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&gt;')"><xsl:value-of select="'&gt;'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&gt;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'[')"><xsl:value-of select="'\lbrack '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'[')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'\')"><xsl:value-of select="'\backslash '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'\')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,']')"><xsl:value-of select="'\rbrack '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,']')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'^')"><xsl:value-of select="'\textasciicircum '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'^')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'_')"><xsl:value-of select="'\_ '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'_')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'`')"><xsl:value-of select="'\grave{}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'`')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'{')"><xsl:value-of select="'\lbrace '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'{')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'|')"><xsl:value-of select="'\vert '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'|')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'}')"><xsl:value-of select="'\rbrace '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'}')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'~')"><xsl:value-of select="'\textasciitilde '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'~')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#603;')"><xsl:value-of select="'\varepsilon '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#603;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#729;')"><xsl:value-of select="'\dot{}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#729;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#161;')"><xsl:value-of select="'\textexclamdown '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#161;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#162;')"><xsl:value-of select="'\mbox{\textcent}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#162;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#163;')"><xsl:value-of select="'\pounds '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#163;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#164;')"><xsl:value-of select="'\mbox{\textcurrency}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#164;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#165;')"><xsl:value-of select="'\yen '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#165;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#167;')"><xsl:value-of select="'\S '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#167;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#168;')"><xsl:value-of select="'\ddot{}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#168;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#169;')"><xsl:value-of select="'\copyright '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#169;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#170;')"><xsl:value-of select="'\textordfeminine '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#170;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#171;')"><xsl:value-of select="'\mbox{\guillemotleft}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#171;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#172;')"><xsl:value-of select="'\neg '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#172;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#173;')"><xsl:value-of select="'\- '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#173;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#174;')"><xsl:value-of select="'\circledR '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#174;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#175;')"><xsl:value-of select="'\bar{}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#175;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#176;')"><xsl:value-of select="'\degree '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#176;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#177;')"><xsl:value-of select="'\pm '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#177;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#178;')"><xsl:value-of select="'{^2}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#178;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#179;')"><xsl:value-of select="'{^3}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#179;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#180;')"><xsl:value-of select="'\acute{}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#180;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#181;')"><xsl:value-of select="'\mathrm{\mu}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#181;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#182;')"><xsl:value-of select="'\P '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#182;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#183;')"><xsl:value-of select="'\cdotp '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#183;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#184;')"><xsl:value-of select="'\mbox{\c{}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#184;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#185;')"><xsl:value-of select="'{^1}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#185;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#186;')"><xsl:value-of select="'\textordmasculine '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#186;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#187;')"><xsl:value-of select="'\mbox{\guillemotright}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#187;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#192;')"><xsl:value-of select="'\grave{A}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#192;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#193;')"><xsl:value-of select="'\acute{A}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#193;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#194;')"><xsl:value-of select="'\hat{A}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#194;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#195;')"><xsl:value-of select="'\tilde{A}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#195;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#196;')"><xsl:value-of select="'\ddot{A}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#196;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#197;')"><xsl:value-of select="'\AA '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#197;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#198;')"><xsl:value-of select="'\AE '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#198;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#199;')"><xsl:value-of select="'\mbox{\c{C}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#199;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#200;')"><xsl:value-of select="'\grave{E}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#200;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#201;')"><xsl:value-of select="'\acute{E}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#201;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#202;')"><xsl:value-of select="'\hat{E}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#202;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#203;')"><xsl:value-of select="'\ddot{E}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#203;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#204;')"><xsl:value-of select="'\grave{I}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#204;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#205;')"><xsl:value-of select="'\acute{I}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#205;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#206;')"><xsl:value-of select="'\hat{I}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#206;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#207;')"><xsl:value-of select="'\ddot{I}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#207;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#208;')"><xsl:value-of select="'\DH '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#208;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#209;')"><xsl:value-of select="'\tilde{N}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#209;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#210;')"><xsl:value-of select="'\grave{O}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#210;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#211;')"><xsl:value-of select="'\acute{O}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#211;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#212;')"><xsl:value-of select="'\hat{O}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#212;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#213;')"><xsl:value-of select="'\tilde{O}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#213;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#214;')"><xsl:value-of select="'\ddot{O}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#214;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#215;')"><xsl:value-of select="'\times '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#215;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#216;')"><xsl:value-of select="'\O '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#216;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#217;')"><xsl:value-of select="'\grave{U}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#217;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#218;')"><xsl:value-of select="'\acute{U}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#218;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#219;')"><xsl:value-of select="'\hat{U}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#219;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#220;')"><xsl:value-of select="'\ddot{U}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#220;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#221;')"><xsl:value-of select="'\acute{Y}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#221;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#222;')"><xsl:value-of select="'\TH '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#222;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#223;')"><xsl:value-of select="'\ss '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#223;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#224;')"><xsl:value-of select="'\grave{a}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#224;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#225;')"><xsl:value-of select="'\acute{a}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#225;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#226;')"><xsl:value-of select="'\hat{a}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#226;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#227;')"><xsl:value-of select="'\tilde{a}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#227;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#228;')"><xsl:value-of select="'\ddot{a}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#228;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#229;')"><xsl:value-of select="'\aa '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#229;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#230;')"><xsl:value-of select="'\ae '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#230;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#231;')"><xsl:value-of select="'\mbox{\c{c}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#231;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#232;')"><xsl:value-of select="'\grave{e}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#232;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#233;')"><xsl:value-of select="'\acute{e}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#233;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#234;')"><xsl:value-of select="'\hat{e}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#234;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#235;')"><xsl:value-of select="'\ddot{e}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#235;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#236;')"><xsl:value-of select="'\grave{\imath}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#236;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#237;')"><xsl:value-of select="'\acute{\imath}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#237;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#238;')"><xsl:value-of select="'\hat{\imath}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#238;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#239;')"><xsl:value-of select="'\ddot{\imath}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#239;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#240;')"><xsl:value-of select="'\eth '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#240;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#241;')"><xsl:value-of select="'\tilde{n}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#241;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#242;')"><xsl:value-of select="'\grave{o}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#242;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#243;')"><xsl:value-of select="'\acute{o}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#243;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#244;')"><xsl:value-of select="'\hat{o}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#244;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#245;')"><xsl:value-of select="'\tilde{o}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#245;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#246;')"><xsl:value-of select="'\ddot{o}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#246;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#247;')"><xsl:value-of select="'\div '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#247;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#248;')"><xsl:value-of select="'\o '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#248;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#249;')"><xsl:value-of select="'\grave{u}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#249;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#250;')"><xsl:value-of select="'\acute{u}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#250;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#251;')"><xsl:value-of select="'\hat{u}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#251;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#252;')"><xsl:value-of select="'\ddot{u}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#252;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#253;')"><xsl:value-of select="'\acute{y}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#253;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#254;')"><xsl:value-of select="'\th '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#254;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#255;')"><xsl:value-of select="'\ddot{y}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#255;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#256;')"><xsl:value-of select="'\bar{A}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#256;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#257;')"><xsl:value-of select="'\bar{a}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#257;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#258;')"><xsl:value-of select="'\breve{A}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#258;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#259;')"><xsl:value-of select="'\u{a}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#259;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#262;')"><xsl:value-of select="'\acute{C}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#262;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#263;')"><xsl:value-of select="'\acute{c}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#263;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#264;')"><xsl:value-of select="'\hat{C}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#264;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#265;')"><xsl:value-of select="'\hat{c}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#265;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#266;')"><xsl:value-of select="'\dot{C}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#266;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#267;')"><xsl:value-of select="'\dot{c}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#267;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#268;')"><xsl:value-of select="'\check{C}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#268;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#269;')"><xsl:value-of select="'\check{c}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#269;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#270;')"><xsl:value-of select="'\check{D}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#270;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#271;')"><xsl:value-of select="'\check{d}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#271;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#274;')"><xsl:value-of select="'\bar{E}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#274;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#275;')"><xsl:value-of select="'\bar{e}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#275;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#276;')"><xsl:value-of select="'\breve{E}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#276;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#277;')"><xsl:value-of select="'\breve{e}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#277;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#278;')"><xsl:value-of select="'\dot{E}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#278;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#279;')"><xsl:value-of select="'\dot{e}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#279;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#280;')"><xsl:value-of select="'\k{E}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#280;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#282;')"><xsl:value-of select="'\check{E}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#282;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#283;')"><xsl:value-of select="'\check{e}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#283;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#284;')"><xsl:value-of select="'\hat{G}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#284;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#285;')"><xsl:value-of select="'\hat{g}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#285;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#286;')"><xsl:value-of select="'\breve{G}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#286;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#287;')"><xsl:value-of select="'\breve{g}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#287;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#288;')"><xsl:value-of select="'\dot{G}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#288;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#289;')"><xsl:value-of select="'\dot{g}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#289;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#290;')"><xsl:value-of select="'\mbox{\c{G}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#290;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#291;')"><xsl:value-of select="'\mbox{\c{g}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#291;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#292;')"><xsl:value-of select="'\hat{H}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#292;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#293;')"><xsl:value-of select="'\hat{h}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#293;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#295;')"><xsl:value-of select="'\Elzxh '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#295;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#296;')"><xsl:value-of select="'\tilde{I}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#296;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#297;')"><xsl:value-of select="'\tilde{\imath}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#297;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#298;')"><xsl:value-of select="'\bar{I}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#298;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#299;')"><xsl:value-of select="'\bar{\imath}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#299;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#300;')"><xsl:value-of select="'\breve{I}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#300;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#301;')"><xsl:value-of select="'\breve{\imath}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#301;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#304;')"><xsl:value-of select="'\dot{I}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#304;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#305;')"><xsl:value-of select="'\imath '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#305;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#308;')"><xsl:value-of select="'\hat{J}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#308;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#309;')"><xsl:value-of select="'\hat{\jmath}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#309;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#310;')"><xsl:value-of select="'\mbox{\c{K}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#310;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#311;')"><xsl:value-of select="'\mbox{\c{k}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#311;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#313;')"><xsl:value-of select="'\acute{L}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#313;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#314;')"><xsl:value-of select="'\acute{l}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#314;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#315;')"><xsl:value-of select="'\mbox{\c{L}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#315;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#316;')"><xsl:value-of select="'\mbox{\c{l}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#316;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#317;')"><xsl:value-of select="'\check{L}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#317;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#318;')"><xsl:value-of select="'\check{l}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#318;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#321;')"><xsl:value-of select="'\L '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#321;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#322;')"><xsl:value-of select="'\l '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#322;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#323;')"><xsl:value-of select="'\acute{N}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#323;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#324;')"><xsl:value-of select="'\acute{n}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#324;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#325;')"><xsl:value-of select="'\mbox{\c{N}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#325;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#326;')"><xsl:value-of select="'\mbox{\c{n}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#326;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#327;')"><xsl:value-of select="'\check{N}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#327;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#328;')"><xsl:value-of select="'\check{n}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#328;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#332;')"><xsl:value-of select="'\bar{O}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#332;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#333;')"><xsl:value-of select="'\bar{o}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#333;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#334;')"><xsl:value-of select="'\breve{O}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#334;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#335;')"><xsl:value-of select="'\breve{o}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#335;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#336;')"><xsl:value-of select="'\mbox{\H{O}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#336;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#337;')"><xsl:value-of select="'\mbox{\H{o}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#337;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#338;')"><xsl:value-of select="'\OE '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#338;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#339;')"><xsl:value-of select="'\oe '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#339;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#340;')"><xsl:value-of select="'\acute{R}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#340;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#341;')"><xsl:value-of select="'\acute{r}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#341;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#342;')"><xsl:value-of select="'\mbox{\c{R}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#342;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#343;')"><xsl:value-of select="'\mbox{\c{r}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#343;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#344;')"><xsl:value-of select="'\check{R}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#344;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#345;')"><xsl:value-of select="'\check{r}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#345;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#346;')"><xsl:value-of select="'\acute{S}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#346;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#347;')"><xsl:value-of select="'\acute{s}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#347;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#348;')"><xsl:value-of select="'\hat{S}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#348;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#349;')"><xsl:value-of select="'\hat{s}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#349;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#350;')"><xsl:value-of select="'\mbox{\c{S}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#350;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#351;')"><xsl:value-of select="'\mbox{\c{s}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#351;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#352;')"><xsl:value-of select="'\check{S}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#352;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#353;')"><xsl:value-of select="'\check{s}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#353;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#354;')"><xsl:value-of select="'\mbox{\c{T}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#354;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#355;')"><xsl:value-of select="'\mbox{\c{t}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#355;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#356;')"><xsl:value-of select="'\check{T}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#356;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#357;')"><xsl:value-of select="'\check{t}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#357;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#360;')"><xsl:value-of select="'\tilde{U}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#360;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#361;')"><xsl:value-of select="'\tilde{u}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#361;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#362;')"><xsl:value-of select="'\bar{U}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#362;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#363;')"><xsl:value-of select="'\bar{u}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#363;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#364;')"><xsl:value-of select="'\breve{U}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#364;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#365;')"><xsl:value-of select="'\breve{u}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#365;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#366;')"><xsl:value-of select="'\mathring{U}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#366;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#367;')"><xsl:value-of select="'\mathring{u}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#367;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#368;')"><xsl:value-of select="'\mbox{\H{U}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#368;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#369;')"><xsl:value-of select="'\mbox{\H{u}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#369;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#370;')"><xsl:value-of select="'\k{U}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#370;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#372;')"><xsl:value-of select="'\hat{W}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#372;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#373;')"><xsl:value-of select="'\hat{w}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#373;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#374;')"><xsl:value-of select="'\hat{Y}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#374;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#375;')"><xsl:value-of select="'\hat{y}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#375;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#376;')"><xsl:value-of select="'\ddot{Y}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#376;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#377;')"><xsl:value-of select="'\acute{Z}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#377;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#378;')"><xsl:value-of select="'\acute{z}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#378;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#379;')"><xsl:value-of select="'\dot{Z}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#379;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#380;')"><xsl:value-of select="'\dot{z}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#380;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#381;')"><xsl:value-of select="'\check{Z}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#381;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#382;')"><xsl:value-of select="'\check{z}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#382;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#402;')"><xsl:value-of select="'f'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#402;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#426;')"><xsl:value-of select="'\eth '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#426;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#501;')"><xsl:value-of select="'\acute{g}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#501;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#592;')"><xsl:value-of select="'\Elztrna '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#592;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#594;')"><xsl:value-of select="'\Elztrnsa '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#594;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#596;')"><xsl:value-of select="'\Elzopeno '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#596;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#598;')"><xsl:value-of select="'\Elzrtld '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#598;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#601;')"><xsl:value-of select="'\Elzschwa '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#601;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#603;')"><xsl:value-of select="'\varepsilon '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#603;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#611;')"><xsl:value-of select="'\Elzpgamma '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#611;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#612;')"><xsl:value-of select="'\Elzpbgam '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#612;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#613;')"><xsl:value-of select="'\Elztrnh '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#613;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#620;')"><xsl:value-of select="'\Elzbtdl '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#620;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#621;')"><xsl:value-of select="'\Elzrtll '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#621;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#623;')"><xsl:value-of select="'\Elztrnm '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#623;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#624;')"><xsl:value-of select="'\Elztrnmlr '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#624;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#625;')"><xsl:value-of select="'\Elzltlmr '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#625;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#627;')"><xsl:value-of select="'\Elzrtln '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#627;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#631;')"><xsl:value-of select="'\Elzclomeg '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#631;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#633;')"><xsl:value-of select="'\Elztrnr '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#633;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#634;')"><xsl:value-of select="'\Elztrnrl '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#634;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#635;')"><xsl:value-of select="'\Elzrttrnr '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#635;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#636;')"><xsl:value-of select="'\Elzrl '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#636;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#637;')"><xsl:value-of select="'\Elzrtlr '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#637;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#638;')"><xsl:value-of select="'\Elzfhr '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#638;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#642;')"><xsl:value-of select="'\Elzrtls '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#642;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#643;')"><xsl:value-of select="'\Elzesh '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#643;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#647;')"><xsl:value-of select="'\Elztrnt '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#647;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#648;')"><xsl:value-of select="'\Elzrtlt '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#648;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#650;')"><xsl:value-of select="'\Elzpupsil '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#650;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#651;')"><xsl:value-of select="'\Elzpscrv '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#651;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#652;')"><xsl:value-of select="'\Elzinvv '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#652;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#653;')"><xsl:value-of select="'\Elzinvw '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#653;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#654;')"><xsl:value-of select="'\Elztrny '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#654;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#656;')"><xsl:value-of select="'\Elzrtlz '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#656;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#658;')"><xsl:value-of select="'\Elzyogh '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#658;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#660;')"><xsl:value-of select="'\Elzglst '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#660;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#661;')"><xsl:value-of select="'\Elzreglst '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#661;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#662;')"><xsl:value-of select="'\Elzinglst '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#662;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#676;')"><xsl:value-of select="'\Elzdyogh '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#676;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#679;')"><xsl:value-of select="'\Elztesh '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#679;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#700;')"><xsl:value-of select="'\rasp '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#700;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#712;')"><xsl:value-of select="'\Elzverts '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#712;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#716;')"><xsl:value-of select="'\Elzverti '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#716;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#720;')"><xsl:value-of select="'\Elzlmrk '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#720;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#721;')"><xsl:value-of select="'\Elzhlmrk '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#721;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#722;')"><xsl:value-of select="'\Elzsbrhr '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#722;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#723;')"><xsl:value-of select="'\Elzsblhr '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#723;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#724;')"><xsl:value-of select="'\Elzrais '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#724;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#725;')"><xsl:value-of select="'\Elzlow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#725;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#728;')"><xsl:value-of select="'\u '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#728;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#729;')"><xsl:value-of select="'\dot{}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#729;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#730;')"><xsl:value-of select="'\mathring{}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#730;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#731;')"><xsl:value-of select="'\mbox{\k{}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#731;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#733;')"><xsl:value-of select="'\mbox{\H{}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#733;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#768;')"><xsl:value-of select="'\grave '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#768;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#769;')"><xsl:value-of select="'\acute '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#769;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#770;')"><xsl:value-of select="'\hat '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#770;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#771;')"><xsl:value-of select="'\tilde '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#771;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#772;')"><xsl:value-of select="'\bar '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#772;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#774;')"><xsl:value-of select="'\breve '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#774;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#775;')"><xsl:value-of select="'\dot '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#775;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#776;')"><xsl:value-of select="'\ddot '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#776;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#778;')"><xsl:value-of select="'\ocirc '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#778;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#779;')"><xsl:value-of select="'\H '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#779;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#780;')"><xsl:value-of select="'\check '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#780;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#801;')"><xsl:value-of select="'\Elzpalh '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#801;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#810;')"><xsl:value-of select="'\Elzsbbrg '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#810;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#902;')"><xsl:value-of select="'\acute{A}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#902;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#904;')"><xsl:value-of select="'\acute{E}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#904;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#905;')"><xsl:value-of select="'\grave{H}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#905;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#906;')"><xsl:text>\mathrm{'I}</xsl:text><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#906;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#908;')"><xsl:text>\mathrm{'O}</xsl:text><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#908;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#910;')"><xsl:text>\mathrm{'Y}</xsl:text><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#910;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#911;')"><xsl:text>\mathrm{'\Omega}</xsl:text><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#911;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#912;')"><xsl:value-of select="'\acute{\ddot{\iota}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#912;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#913;')"><xsl:value-of select="'{\rm A}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#913;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#914;')"><xsl:value-of select="'{\rm B}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#914;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#915;')"><xsl:value-of select="'\Gamma '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#915;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#916;')"><xsl:value-of select="'\Delta '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#916;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#917;')"><xsl:value-of select="'{\rm E}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#917;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#918;')"><xsl:value-of select="'{\rm Z}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#918;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#919;')"><xsl:value-of select="'{\rm H}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#919;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#920;')"><xsl:value-of select="'\Theta '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#920;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#921;')"><xsl:value-of select="'{\rm I}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#921;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#922;')"><xsl:value-of select="'{\rm K}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#922;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#923;')"><xsl:value-of select="'\Lambda '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#923;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#924;')"><xsl:value-of select="'M'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#924;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#925;')"><xsl:value-of select="'N'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#925;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#926;')"><xsl:value-of select="'\Xi '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#926;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#927;')"><xsl:value-of select="'O'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#927;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#928;')"><xsl:value-of select="'\Pi '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#928;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#929;')"><xsl:value-of select="'{\rm P}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#929;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#931;')"><xsl:value-of select="'\Sigma '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#931;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#932;')"><xsl:value-of select="'{\rm T}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#932;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#933;')"><xsl:value-of select="'\Upsilon '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#933;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#934;')"><xsl:value-of select="'\Phi '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#934;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#935;')"><xsl:value-of select="'{\rm X}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#935;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#936;')"><xsl:value-of select="'\Psi '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#936;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#937;')"><xsl:value-of select="'\Omega '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#937;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#938;')"><xsl:value-of select="'\mathrm{\ddot{I}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#938;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#939;')"><xsl:value-of select="'\mathrm{\ddot{Y}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#939;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#940;')"><xsl:value-of select="'\acute{\alpha}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#940;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#941;')"><xsl:value-of select="'\acute{\epsilon}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#941;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#942;')"><xsl:value-of select="'\acute{\eta}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#942;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#943;')"><xsl:value-of select="'\acute{\iota}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#943;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#944;')"><xsl:value-of select="'\acute{\ddot{\upsilon}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#944;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#945;')"><xsl:value-of select="'\alpha '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#945;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#946;')"><xsl:value-of select="'\beta '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#946;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#947;')"><xsl:value-of select="'\gamma '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#947;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#948;')"><xsl:value-of select="'\delta '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#948;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#949;')"><xsl:value-of select="'\epsilon '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#949;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#950;')"><xsl:value-of select="'\zeta '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#950;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#951;')"><xsl:value-of select="'\eta '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#951;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#952;')"><xsl:value-of select="'\theta '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#952;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#953;')"><xsl:value-of select="'\iota '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#953;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#954;')"><xsl:value-of select="'\kappa '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#954;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#955;')"><xsl:value-of select="'\lambda '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#955;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#956;')"><xsl:value-of select="'\mu '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#956;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#957;')"><xsl:value-of select="'\nu '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#957;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#958;')"><xsl:value-of select="'\xi '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#958;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#959;')"><xsl:value-of select="'o'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#959;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#960;')"><xsl:value-of select="'\pi '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#960;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#961;')"><xsl:value-of select="'\rho '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#961;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#962;')"><xsl:value-of select="'\varsigma '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#962;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#963;')"><xsl:value-of select="'\sigma '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#963;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#964;')"><xsl:value-of select="'\tau '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#964;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#965;')"><xsl:value-of select="'\upsilon '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#965;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#966;')"><xsl:value-of select="'\phi '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#966;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#967;')"><xsl:value-of select="'\chi '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#967;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#968;')"><xsl:value-of select="'\psi '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#968;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#969;')"><xsl:value-of select="'\omega '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#969;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#970;')"><xsl:value-of select="'\ddot{\iota}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#970;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#971;')"><xsl:value-of select="'\ddot{\upsilon}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#971;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#972;')"><xsl:value-of select="'\acute{o}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#972;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#973;')"><xsl:value-of select="'\acute{\upsilon}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#973;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#974;')"><xsl:value-of select="'\acute{\omega}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#974;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#977;')"><xsl:value-of select="'\vartheta '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#977;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#978;')"><xsl:value-of select="'\Upsilon '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#978;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#981;')"><xsl:value-of select="'\phi '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#981;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#982;')"><xsl:value-of select="'\varpi '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#982;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#986;')"><xsl:value-of select="'\Stigma '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#986;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#988;')"><xsl:value-of select="'\Digamma '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#988;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#989;')"><xsl:value-of select="'\digamma '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#989;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#990;')"><xsl:value-of select="'\Koppa '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#990;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#992;')"><xsl:value-of select="'\Sampi '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#992;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#1008;')"><xsl:value-of select="'\varkappa '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#1008;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#1009;')"><xsl:value-of select="'\varrho '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#1009;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#1013;')"><xsl:value-of select="'\epsilon '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#1013;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#1014;')"><xsl:value-of select="'\backepsilon '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#1014;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8194;')"><xsl:value-of select="'\enspace '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8194;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8195;')"><xsl:value-of select="'\quad '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8195;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8196;')"><xsl:value-of select="'\hspace{0.33em}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8196;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8197;')"><xsl:value-of select="'\thickspace '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8197;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8198;')"><xsl:value-of select="'\hspace{0.166em}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8198;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8199;')"><xsl:value-of select="'\hphantom{0}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8199;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8200;')"><xsl:value-of select="'\hphantom{,}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8200;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8201;')"><xsl:value-of select="'\thinspace '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8201;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8202;')"><xsl:value-of select="'\hspace{1pt}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8202;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8203;')"><xsl:value-of select="''"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8203;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8208;')"><xsl:value-of select="'-'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8208;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8211;')"><xsl:value-of select="'\textendash '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8211;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8212;')"><xsl:value-of select="'\textemdash '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8212;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8214;')"><xsl:value-of select="'\Vert '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8214;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8216;')"><xsl:value-of select="'\lq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8216;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8217;')"><xsl:value-of select="'\rq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8217;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8219;')"><xsl:value-of select="'\Elzreapos '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8219;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8220;')"><xsl:value-of select="'\textquotedblleft '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8220;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8221;')"><xsl:value-of select="'\textquotedblright '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8221;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8224;')"><xsl:value-of select="'\dagger '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8224;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8225;')"><xsl:value-of select="'\ddagger '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8225;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8226;')"><xsl:value-of select="'\bullet '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8226;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8230;')"><xsl:value-of select="'\dots '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8230;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8242;')"><xsl:value-of select="'\prime '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8242;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8243;')"><xsl:text>{''}</xsl:text><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8243;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8244;')"><xsl:text>{'''}</xsl:text><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8244;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8245;')"><xsl:value-of select="'\backprime '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8245;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8257;')"><xsl:value-of select="''"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8257;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8260;')"><xsl:value-of select="''"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8260;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8270;')"><xsl:value-of select="''"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8270;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8279;')"><xsl:text>''''</xsl:text><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8279;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8287;')"><xsl:value-of select="'\mkern4mu '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8287;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8289;')"><xsl:value-of select="''"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8289;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8290;')"><xsl:value-of select="''"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8290;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8291;')"><xsl:value-of select="''"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8291;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8359;')"><xsl:value-of select="'\Elzpes'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8359;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8364;')"><xsl:value-of select="'\mbox{\texteuro}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8364;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8411;')"><xsl:value-of select="'\dddot '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8411;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8412;')"><xsl:value-of select="'\ddddot '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8412;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8423;')"><xsl:value-of select="''"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8423;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8450;')"><xsl:value-of select="'\mathbb{C}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8450;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8458;')"><xsl:value-of select="'\mathscr{g}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8458;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8459;')"><xsl:value-of select="'\mathscr{H}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8459;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8460;')"><xsl:value-of select="'\mathfrak{H}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8460;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8461;')"><xsl:value-of select="'\mathbb{H}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8461;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8462;')"><xsl:value-of select="''"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8462;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8463;&#65024;')"><xsl:value-of select="'\hbar '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8463;&#65024;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8463;')"><xsl:value-of select="'\hslash '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8463;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8464;')"><xsl:value-of select="'\mathscr{I}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8464;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8465;')"><xsl:value-of select="'\Im '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8465;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8466;')"><xsl:value-of select="'\mathscr{L}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8466;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8467;')"><xsl:value-of select="'\ell '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8467;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8469;')"><xsl:value-of select="'\mathbb{N}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8469;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8470;')"><xsl:value-of select="'\textnumero '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8470;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8472;')"><xsl:value-of select="'\wp '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8472;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8473;')"><xsl:value-of select="'\mathbb{P}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8473;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8474;')"><xsl:value-of select="'\mathbb{Q}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8474;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8475;')"><xsl:value-of select="'\mathscr{R}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8475;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8476;')"><xsl:value-of select="'\Re '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8476;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8477;')"><xsl:value-of select="'\mathbb{R}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8477;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8478;')"><xsl:value-of select="'\Elzxrat '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8478;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8484;')"><xsl:value-of select="'\mathbb{Z}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8484;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8486;')"><xsl:value-of select="'\Omega '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8486;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8487;')"><xsl:value-of select="'\mho '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8487;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8488;')"><xsl:value-of select="'\mathfrak{Z}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8488;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8489;')"><xsl:value-of select="'\ElsevierGlyph{2129}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8489;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8491;')"><xsl:value-of select="'\AA'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8491;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8492;')"><xsl:value-of select="'\mathscr{B}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8492;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8493;')"><xsl:value-of select="'\mathfrak{C}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8493;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8495;')"><xsl:value-of select="'\mathscr{e}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8495;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8496;')"><xsl:value-of select="'\mathscr{E}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8496;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8497;')"><xsl:value-of select="'\mathscr{F}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8497;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8499;')"><xsl:value-of select="'\mathscr{M}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8499;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8500;')"><xsl:value-of select="'\mathscr{o}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8500;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8501;')"><xsl:value-of select="'\aleph '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8501;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8502;')"><xsl:value-of select="'\beth '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8502;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8503;')"><xsl:value-of select="'\gimel '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8503;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8504;')"><xsl:value-of select="'\daleth '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8504;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8511;')"><xsl:value-of select="'\BbbPi '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8511;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8512;')"><xsl:value-of select="'\bbsum '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8512;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8513;')"><xsl:value-of select="'\Game '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8513;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8517;')"><xsl:value-of select="'D'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8517;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8518;')"><xsl:value-of select="'d'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8518;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8519;')"><xsl:value-of select="'e'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8519;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8520;')"><xsl:value-of select="'i'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8520;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8521;')"><xsl:value-of select="'j'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8521;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8531;')"><xsl:value-of select="'\textfrac{1}{3}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8531;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8532;')"><xsl:value-of select="'\textfrac{2}{3}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8532;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8533;')"><xsl:value-of select="'\textfrac{1}{5}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8533;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8534;')"><xsl:value-of select="'\textfrac{2}{5}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8534;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8535;')"><xsl:value-of select="'\textfrac{3}{5}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8535;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8536;')"><xsl:value-of select="'\textfrac{4}{5}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8536;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8537;')"><xsl:value-of select="'\textfrac{1}{6}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8537;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8538;')"><xsl:value-of select="'\textfrac{5}{6}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8538;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8539;')"><xsl:value-of select="'\textfrac{1}{8}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8539;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8540;')"><xsl:value-of select="'\textfrac{3}{8}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8540;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8541;')"><xsl:value-of select="'\textfrac{5}{8}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8541;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8542;')"><xsl:value-of select="'\textfrac{7}{8}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8542;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8592;')"><xsl:value-of select="'\leftarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8592;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8593;')"><xsl:value-of select="'\uparrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8593;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8594;')"><xsl:value-of select="'\rightarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8594;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8595;')"><xsl:value-of select="'\downarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8595;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8596;')"><xsl:value-of select="'\leftrightarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8596;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8597;')"><xsl:value-of select="'\updownarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8597;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8598;')"><xsl:value-of select="'\nwarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8598;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8599;')"><xsl:value-of select="'\nearrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8599;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8600;')"><xsl:value-of select="'\searrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8600;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8601;')"><xsl:value-of select="'\swarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8601;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8602;')"><xsl:value-of select="'\nleftarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8602;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8603;')"><xsl:value-of select="'\nrightarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8603;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8604;')"><xsl:value-of select="'\leftsquigarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8604;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8605;')"><xsl:value-of select="'\rightsquigarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8605;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8606;')"><xsl:value-of select="'\twoheadleftarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8606;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8608;')"><xsl:value-of select="'\twoheadrightarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8608;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8610;')"><xsl:value-of select="'\leftarrowtail '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8610;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8611;')"><xsl:value-of select="'\rightarrowtail '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8611;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8614;')"><xsl:value-of select="'\mapsto '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8614;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8617;')"><xsl:value-of select="'\hookleftarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8617;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8618;')"><xsl:value-of select="'\hookrightarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8618;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8619;')"><xsl:value-of select="'\looparrowleft '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8619;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8620;')"><xsl:value-of select="'\looparrowright '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8620;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8621;')"><xsl:value-of select="'\leftrightsquigarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8621;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8622;')"><xsl:value-of select="'\nleftrightarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8622;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8624;')"><xsl:value-of select="'\Lsh '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8624;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8625;')"><xsl:value-of select="'\Rsh '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8625;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8627;')"><xsl:value-of select="'\ElsevierGlyph{21B3}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8627;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8630;')"><xsl:value-of select="'\curvearrowleft '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8630;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8631;')"><xsl:value-of select="'\curvearrowright '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8631;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8634;')"><xsl:value-of select="'\circlearrowleft '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8634;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8635;')"><xsl:value-of select="'\circlearrowright '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8635;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8636;')"><xsl:value-of select="'\leftharpoonup '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8636;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8637;')"><xsl:value-of select="'\leftharpoondown '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8637;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8638;')"><xsl:value-of select="'\upharpoonright '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8638;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8639;')"><xsl:value-of select="'\upharpoonleft '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8639;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8640;')"><xsl:value-of select="'\rightharpoonup '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8640;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8641;')"><xsl:value-of select="'\rightharpoondown '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8641;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8642;')"><xsl:value-of select="'\downharpoonright '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8642;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8643;')"><xsl:value-of select="'\downharpoonleft '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8643;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8644;')"><xsl:value-of select="'\rightleftarrows '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8644;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8645;')"><xsl:value-of select="'\dblarrowupdown '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8645;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8646;')"><xsl:value-of select="'\leftrightarrows '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8646;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8647;')"><xsl:value-of select="'\leftleftarrows '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8647;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8648;')"><xsl:value-of select="'\upuparrows '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8648;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8649;')"><xsl:value-of select="'\rightrightarrows '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8649;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8650;')"><xsl:value-of select="'\downdownarrows '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8650;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8651;')"><xsl:value-of select="'\leftrightharpoons '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8651;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8652;')"><xsl:value-of select="'\rightleftharpoons '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8652;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8653;')"><xsl:value-of select="'\nLeftarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8653;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8654;')"><xsl:value-of select="'\nLeftrightarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8654;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8655;')"><xsl:value-of select="'\nRightarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8655;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8656;')"><xsl:value-of select="'\Leftarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8656;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8657;')"><xsl:value-of select="'\Uparrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8657;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8658;')"><xsl:value-of select="'\Rightarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8658;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8659;')"><xsl:value-of select="'\Downarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8659;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8660;')"><xsl:value-of select="'\Leftrightarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8660;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8660;')"><xsl:value-of select="'\iff '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8660;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8661;')"><xsl:value-of select="'\Updownarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8661;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8666;')"><xsl:value-of select="'\Lleftarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8666;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8667;')"><xsl:value-of select="'\Rrightarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8667;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8669;')"><xsl:value-of select="'\rightsquigarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8669;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8693;')"><xsl:value-of select="'\DownArrowUpArrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8693;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8701;')"><xsl:value-of select="'\leftarrowtriangle '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8701;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8702;')"><xsl:value-of select="'\rightarrowtriangle '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8702;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8703;')"><xsl:value-of select="'\leftrightarrowtria* '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8703;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8704;')"><xsl:value-of select="'\forall '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8704;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8705;')"><xsl:value-of select="'\complement '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8705;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8706;')"><xsl:value-of select="'\partial '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8706;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8707;')"><xsl:value-of select="'\exists '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8707;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8708;')"><xsl:value-of select="'\nexists '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8708;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8709;&#65024;')"><xsl:value-of select="'\emptyset '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8709;&#65024;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8709;')"><xsl:value-of select="'\varnothing '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8709;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8711;')"><xsl:value-of select="'\nabla '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8711;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8712;')"><xsl:value-of select="'\in '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8712;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8713;')"><xsl:value-of select="'\notin '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8713;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8715;')"><xsl:value-of select="'\ni '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8715;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8716;')"><xsl:value-of select="'\not\ni '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8716;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8719;')"><xsl:value-of select="'\prod '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8719;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8720;')"><xsl:value-of select="'\coprod '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8720;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8721;')"><xsl:value-of select="'\sum '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8721;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8722;')"><xsl:value-of select="'-'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8722;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8723;')"><xsl:value-of select="'\mp '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8723;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8724;')"><xsl:value-of select="'\dotplus '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8724;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8726;')"><xsl:value-of select="'\setminus '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8726;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8727;')"><xsl:value-of select="'\ast '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8727;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8728;')"><xsl:value-of select="'\circ '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8728;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8729;')"><xsl:value-of select="'\bullet '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8729;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8730;')"><xsl:value-of select="'\surd '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8730;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8733;')"><xsl:value-of select="'\propto '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8733;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8734;')"><xsl:value-of select="'\infty '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8734;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8735;')"><xsl:value-of select="'\rightangle '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8735;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8736;')"><xsl:value-of select="'\angle '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8736;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8737;')"><xsl:value-of select="'\measuredangle '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8737;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8738;')"><xsl:value-of select="'\sphericalangle '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8738;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8739;')"><xsl:value-of select="'\mid '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8739;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8740;&#65024;')"><xsl:value-of select="'\nshortmid '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8740;&#65024;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8740;')"><xsl:value-of select="'\nmid '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8740;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8741;')"><xsl:value-of select="'\parallel '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8741;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8742;&#65024;')"><xsl:value-of select="'\nshortparallel '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8742;&#65024;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8742;')"><xsl:value-of select="'\nparallel '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8742;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8743;')"><xsl:value-of select="'\wedge '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8743;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8744;')"><xsl:value-of select="'\vee '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8744;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8745;')"><xsl:value-of select="'\cap '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8745;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8746;')"><xsl:value-of select="'\cup '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8746;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8747;')"><xsl:value-of select="'\int '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8747;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8748;')"><xsl:value-of select="'\iint '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8748;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8749;')"><xsl:value-of select="'\iiint '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8749;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8750;')"><xsl:value-of select="'\oint '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8750;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8751;')"><xsl:value-of select="'\oiint '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8751;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8752;')"><xsl:value-of select="'\oiiint '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8752;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8753;')"><xsl:value-of select="'\clwintegral '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8753;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8754;')"><xsl:value-of select="'\ElsevierGlyph{2232}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8754;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8755;')"><xsl:value-of select="'\ElsevierGlyph{2233}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8755;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8756;')"><xsl:value-of select="'\therefore '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8756;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8757;')"><xsl:value-of select="'\because '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8757;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8758;')"><xsl:value-of select="':'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8758;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8759;')"><xsl:value-of select="'::'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8759;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8760;')"><xsl:value-of select="'\dotminus '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8760;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8761;')"><xsl:value-of select="' '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8761;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8762;')"><xsl:value-of select="'\mathbin{{:}\!\!{-}\!\!{:}}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8762;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8763;')"><xsl:value-of select="'\kernelcontraction '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8763;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8764;')"><xsl:value-of select="'\sim '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8764;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8765;')"><xsl:value-of select="'\backsim '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8765;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8766;')"><xsl:value-of select="'\lazysinv '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8766;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8767;')"><xsl:value-of select="' '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8767;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8768;')"><xsl:value-of select="'\wr '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8768;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8769;')"><xsl:value-of select="'\nsim '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8769;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8770;&#824;')"><xsl:value-of select="'\neqsim '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8770;&#824;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8770;')"><xsl:value-of select="'\eqsim '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8770;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8771;')"><xsl:value-of select="'\simeq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8771;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8772;')"><xsl:value-of select="'\nsime '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8772;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8773;')"><xsl:value-of select="'\cong '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8773;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8774;')"><xsl:value-of select="'\approxnotequal '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8774;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8775;')"><xsl:value-of select="'\ncong '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8775;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8776;')"><xsl:value-of select="'\approx '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8776;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8777;&#824;')"><xsl:value-of select="' '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8777;&#824;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8777;')"><xsl:value-of select="'\not\approx '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8777;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8778;')"><xsl:value-of select="'\approxeq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8778;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8779;&#824;')"><xsl:value-of select="'\not\apid '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8779;&#824;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8779;')"><xsl:value-of select="'\tildetrpl '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8779;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8780;')"><xsl:value-of select="'\allequal '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8780;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8781;')"><xsl:value-of select="'\asymp '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8781;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8782;&#824;')"><xsl:value-of select="'\not\Bumpeq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8782;&#824;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8782;')"><xsl:value-of select="'\Bumpeq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8782;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8783;&#824;')"><xsl:value-of select="'\not\bumpeq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8783;&#824;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8783;')"><xsl:value-of select="'\bumpeq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8783;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8784;&#824;')"><xsl:value-of select="'\not\doteq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8784;&#824;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8784;')"><xsl:value-of select="'\doteq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8784;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8785;')"><xsl:value-of select="'\Doteq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8785;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8786;')"><xsl:value-of select="'\fallingdotseq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8786;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8787;')"><xsl:value-of select="'\risingdotseq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8787;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8788;')"><xsl:value-of select="'\coloneq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8788;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8789;')"><xsl:value-of select="'\eqcolon '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8789;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8790;')"><xsl:value-of select="'\eqcirc '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8790;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8791;')"><xsl:value-of select="'\circeq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8791;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8792;')"><xsl:value-of select="'\stackrel{\frown}{=}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8792;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8793;')"><xsl:value-of select="'\stackrel{\wedge}{=}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8793;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8794;')"><xsl:value-of select="'\stackrel{\vee}{=}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8794;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8795;')"><xsl:value-of select="'\stackrel{\star}{=}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8795;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8796;')"><xsl:value-of select="'\triangleq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8796;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8797;')"><xsl:value-of select="'\stackrel{\scriptscriptstyle\mathrm{def}}{=}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8797;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8798;')"><xsl:value-of select="'\stackrel{\scriptscriptstyle\mathrm{m}}{=}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8798;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8799;')"><xsl:value-of select="'\stackrel{?}{=}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8799;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8800;&#65024;')"><xsl:value-of select="' '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8800;&#65024;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8800;')"><xsl:value-of select="'\ne '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8800;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8801;&#8421;')"><xsl:value-of select="' '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8801;&#8421;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8801;')"><xsl:value-of select="'\equiv '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8801;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8802;')"><xsl:value-of select="'\not\equiv '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8802;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8803;')"><xsl:value-of select="' '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8803;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8804;')"><xsl:value-of select="'\le '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8804;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8805;')"><xsl:value-of select="'\ge '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8805;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8806;')"><xsl:value-of select="'\leqq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8806;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8807;')"><xsl:value-of select="'\geqq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8807;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8808;&#65024;')"><xsl:value-of select="'\lvertneqq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8808;&#65024;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8808;')"><xsl:value-of select="'\lneqq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8808;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8809;&#65024;')"><xsl:value-of select="'\gvertneqq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8809;&#65024;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8809;')"><xsl:value-of select="'\gneqq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8809;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8810;&#824;&#65024;')"><xsl:value-of select="' '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8810;&#824;&#65024;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8810;&#824;')"><xsl:value-of select="'\NotLessLess '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8810;&#824;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8810;')"><xsl:value-of select="'\ll '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8810;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8811;&#824;&#65024;')"><xsl:value-of select="' '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8811;&#824;&#65024;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8811;&#824;')"><xsl:value-of select="'\NotGreaterGreater '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8811;&#824;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8811;')"><xsl:value-of select="'\gg '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8811;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8812;')"><xsl:value-of select="'\between '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8812;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8813;')"><xsl:value-of select="'\not\kern-0.3em\times '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8813;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8814;')"><xsl:value-of select="'\nless '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8814;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8815;')"><xsl:value-of select="'\ngtr '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8815;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8816;&#8421;')"><xsl:value-of select="'\nleq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8816;&#8421;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8816;')"><xsl:value-of select="'\nleq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8816;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8817;&#8421;')"><xsl:value-of select="'\ngeq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8817;&#8421;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8817;')"><xsl:value-of select="'\ngeq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8817;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8818;')"><xsl:value-of select="'\lesssim '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8818;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8819;')"><xsl:value-of select="'\gtrsim '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8819;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8820;')"><xsl:value-of select="'\ElsevierGlyph{2274} '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8820;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8821;')"><xsl:value-of select="'\ElsevierGlyph{2275} '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8821;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8822;')"><xsl:value-of select="'\lessgtr '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8822;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8823;')"><xsl:value-of select="'\gtrless '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8823;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8824;')"><xsl:value-of select="'\notlessgreater '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8824;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8825;')"><xsl:value-of select="'\notgreaterless '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8825;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8826;')"><xsl:value-of select="'\prec '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8826;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8827;')"><xsl:value-of select="'\succ '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8827;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8828;')"><xsl:value-of select="'\preccurlyeq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8828;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8829;')"><xsl:value-of select="'\succcurlyeq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8829;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8830;&#824;')"><xsl:value-of select="'\not\precsim '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8830;&#824;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8830;')"><xsl:value-of select="'\precsim '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8830;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8831;&#824;')"><xsl:value-of select="'\not\succsim '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8831;&#824;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8831;')"><xsl:value-of select="'\succsim '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8831;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8832;')"><xsl:value-of select="'\nprec '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8832;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8833;')"><xsl:value-of select="'\nsucc '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8833;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8834;')"><xsl:value-of select="'\subset '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8834;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8835;')"><xsl:value-of select="'\supset '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8835;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8836;')"><xsl:value-of select="'\not\subset '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8836;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8837;')"><xsl:value-of select="'\not\supset '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8837;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8838;')"><xsl:value-of select="'\subseteq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8838;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8839;')"><xsl:value-of select="'\supseteq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8839;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8840;')"><xsl:value-of select="'\nsubseteq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8840;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8841;')"><xsl:value-of select="'\nsupseteq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8841;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8842;&#65024;')"><xsl:value-of select="'\varsubsetneqq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8842;&#65024;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8842;')"><xsl:value-of select="'\subsetneq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8842;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8843;&#65024;')"><xsl:value-of select="'\varsupsetneq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8843;&#65024;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8843;')"><xsl:value-of select="'\supsetneq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8843;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8845;')"><xsl:value-of select="'\cupdot '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8845;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8846;')"><xsl:value-of select="'\uplus '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8846;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8847;&#824;')"><xsl:value-of select="'\NotSquareSubset '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8847;&#824;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8847;')"><xsl:value-of select="'\sqsubset '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8847;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8848;&#824;')"><xsl:value-of select="'\NotSquareSuperset '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8848;&#824;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8848;')"><xsl:value-of select="'\sqsupset '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8848;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8849;')"><xsl:value-of select="'\sqsubseteq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8849;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8850;')"><xsl:value-of select="'\sqsupseteq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8850;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8851;')"><xsl:value-of select="'\sqcap '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8851;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8852;')"><xsl:value-of select="'\sqcup '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8852;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8853;')"><xsl:value-of select="'\oplus '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8853;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8854;')"><xsl:value-of select="'\ominus '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8854;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8855;')"><xsl:value-of select="'\otimes '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8855;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8856;')"><xsl:value-of select="'\oslash '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8856;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8857;')"><xsl:value-of select="'\odot '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8857;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8858;')"><xsl:value-of select="'\circledcirc '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8858;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8859;')"><xsl:value-of select="'\circledast '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8859;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8861;')"><xsl:value-of select="'\circleddash '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8861;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8862;')"><xsl:value-of select="'\boxplus '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8862;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8863;')"><xsl:value-of select="'\boxminus '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8863;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8864;')"><xsl:value-of select="'\boxtimes '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8864;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8865;')"><xsl:value-of select="'\boxdot '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8865;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8866;')"><xsl:value-of select="'\vdash '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8866;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8867;')"><xsl:value-of select="'\dashv '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8867;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8868;')"><xsl:value-of select="'\top '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8868;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8869;')"><xsl:value-of select="'\perp '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8869;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8870;')"><xsl:value-of select="'\vdash '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8870;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8871;')"><xsl:value-of select="'\models '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8871;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8872;')"><xsl:value-of select="'\vDash '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8872;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8873;')"><xsl:value-of select="'\Vdash '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8873;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8874;')"><xsl:value-of select="'\Vvdash '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8874;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8875;')"><xsl:value-of select="'\VDash '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8875;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8876;')"><xsl:value-of select="'\nvdash '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8876;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8877;')"><xsl:value-of select="'\nvDash '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8877;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8878;')"><xsl:value-of select="'\nVdash '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8878;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8879;')"><xsl:value-of select="'\nVDash '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8879;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8882;')"><xsl:value-of select="'\vartriangleleft '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8882;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8883;')"><xsl:value-of select="'\vartriangleright '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8883;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8884;')"><xsl:value-of select="'\trianglelefteq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8884;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8885;')"><xsl:value-of select="'\trianglerighteq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8885;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8886;')"><xsl:value-of select="'\original '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8886;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8887;')"><xsl:value-of select="'\image '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8887;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8888;')"><xsl:value-of select="'\multimap '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8888;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8889;')"><xsl:value-of select="'\hermitconjmatrix '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8889;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8890;')"><xsl:value-of select="'\intercal '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8890;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8891;')"><xsl:value-of select="'\veebar '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8891;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8894;')"><xsl:value-of select="'\rightanglearc '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8894;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8896;')"><xsl:value-of select="'\bigwedge '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8896;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8897;')"><xsl:value-of select="'\bigvee '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8897;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8898;')"><xsl:value-of select="'\bigcap '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8898;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8899;')"><xsl:value-of select="'\bigcup '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8899;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8900;')"><xsl:value-of select="'\diamond '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8900;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8901;')"><xsl:value-of select="'\cdot '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8901;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8902;')"><xsl:value-of select="'\star '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8902;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8903;')"><xsl:value-of select="'\divideontimes '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8903;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8904;')"><xsl:value-of select="'\bowtie '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8904;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8905;')"><xsl:value-of select="'\ltimes '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8905;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8906;')"><xsl:value-of select="'\rtimes '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8906;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8907;')"><xsl:value-of select="'\leftthreetimes '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8907;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8908;')"><xsl:value-of select="'\rightthreetimes '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8908;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8909;')"><xsl:value-of select="'\backsimeq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8909;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8910;')"><xsl:value-of select="'\curlyvee '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8910;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8911;')"><xsl:value-of select="'\curlywedge '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8911;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8912;')"><xsl:value-of select="'\Subset '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8912;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8913;')"><xsl:value-of select="'\Supset '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8913;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8914;')"><xsl:value-of select="'\Cap '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8914;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8915;')"><xsl:value-of select="'\Cup '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8915;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8916;')"><xsl:value-of select="'\pitchfork '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8916;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8918;')"><xsl:value-of select="'\lessdot '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8918;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8919;')"><xsl:value-of select="'\gtrdot '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8919;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8920;')"><xsl:value-of select="'\llless '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8920;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8921;')"><xsl:value-of select="'\ggg '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8921;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8922;')"><xsl:value-of select="'\lesseqgtr '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8922;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8923;')"><xsl:value-of select="'\gtreqless '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8923;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8926;')"><xsl:value-of select="'\curlyeqprec '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8926;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8927;')"><xsl:value-of select="'\curlyeqsucc '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8927;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8930;')"><xsl:value-of select="'\not\sqsubseteq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8930;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8931;')"><xsl:value-of select="'\not\sqsupseteq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8931;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8933;')"><xsl:value-of select="'\Elzsqspne '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8933;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8934;')"><xsl:value-of select="'\lnsim '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8934;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8935;')"><xsl:value-of select="'\gnsim '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8935;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8936;')"><xsl:value-of select="'\precnsim '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8936;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8937;')"><xsl:value-of select="'\succnsim '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8937;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8938;')"><xsl:value-of select="'\ntriangleleft '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8938;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8939;')"><xsl:value-of select="'\ntriangleright '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8939;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8940;')"><xsl:value-of select="'\ntrianglelefteq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8940;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8941;')"><xsl:value-of select="'\ntrianglerighteq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8941;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8942;')"><xsl:value-of select="'\vdots '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8942;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8943;')"><xsl:value-of select="'\cdots '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8943;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8944;')"><xsl:value-of select="'\adots '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8944;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8945;')"><xsl:value-of select="'\ddots '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8945;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8968;')"><xsl:value-of select="'\lceil '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8968;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8969;')"><xsl:value-of select="'\rceil '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8969;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8970;')"><xsl:value-of select="'\lfloor '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8970;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8971;')"><xsl:value-of select="'\rfloor '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#8971;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#9001;')"><xsl:value-of select="'\langle '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#9001;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#9002;')"><xsl:value-of select="'\rangle '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#9002;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#9633;')"><xsl:value-of select="'\square '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#9633;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#9642;')"><xsl:value-of select="'\blacksquare '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#9642;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10229;')"><xsl:value-of select="'\longleftarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10229;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10230;')"><xsl:value-of select="'\longrightarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10230;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10231;')"><xsl:value-of select="'\longleftrightarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10231;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10232;')"><xsl:value-of select="'\Longleftarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10232;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10233;')"><xsl:value-of select="'\Longrightarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10233;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10234;')"><xsl:value-of select="'\Longleftrightarrow '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10234;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10236;')"><xsl:value-of select="'\longmapsto '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10236;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10239;')"><xsl:value-of select="'\sim\joinrel\leadsto '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10239;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10643;')"><xsl:value-of select="'&lt;\kern-0.58em( '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10643;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10731;')"><xsl:value-of select="'\blacklozenge '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10731;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10815;')"><xsl:value-of select="'\amalg '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10815;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10862;')"><xsl:value-of select="'\stackrel{*}{=} '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10862;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10877;8')"><xsl:value-of select="'\nleqslant '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10877;8')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10877;')"><xsl:value-of select="'\leqslant '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10877;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10878;8')"><xsl:value-of select="'\ngeqslant '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10878;8')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10878;')"><xsl:value-of select="'\geqslant '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10878;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10885;')"><xsl:value-of select="'\lessapprox '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10885;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10886;')"><xsl:value-of select="'\gtrapprox '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10886;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10887;')"><xsl:value-of select="'\lneq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10887;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10888;')"><xsl:value-of select="'\gneq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10888;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10889;')"><xsl:value-of select="'\lnapprox '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10889;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10890;')"><xsl:value-of select="'\gnapprox '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10890;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10891;')"><xsl:value-of select="'\lesseqqgtr '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10891;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10892;')"><xsl:value-of select="'\gtreqqless '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10892;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10901;')"><xsl:value-of select="'\eqslantless '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10901;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10902;')"><xsl:value-of select="'\eqslantgtr '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10902;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10909;')"><xsl:value-of select="'\Pisymbol{ppi020}{117}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10909;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10910;')"><xsl:value-of select="'\Pisymbol{ppi020}{105}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10910;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10927;8')"><xsl:value-of select="'\not\preceq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10927;8')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10927;')"><xsl:value-of select="'\preceq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10927;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10928;8')"><xsl:value-of select="'\not\succeq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10928;8')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10928;')"><xsl:value-of select="'\succeq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10928;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10933;')"><xsl:value-of select="'\precneqq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10933;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10934;')"><xsl:value-of select="'\succneqq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10934;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10935;')"><xsl:value-of select="'\precapprox '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10935;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10936;')"><xsl:value-of select="'\succapprox '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10936;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10937;')"><xsl:value-of select="'\precnapprox '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10937;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10938;')"><xsl:value-of select="'\succnapprox '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10938;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10949;8')"><xsl:value-of select="'\nsubseteqq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10949;8')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10949;')"><xsl:value-of select="'\subseteqq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10949;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10950;8')"><xsl:value-of select="'\nsupseteqq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10950;8')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10950;')"><xsl:value-of select="'\supseteqq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10950;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10955;')"><xsl:value-of select="'\subsetneqq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10955;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#10956;')"><xsl:value-of select="'\supsetneqq '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#10956;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#11005;&#8421;')"><xsl:value-of select="'{\rlap{\textbackslash}{{/}\!\!{/}}} '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#11005;&#8421;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#11005;')"><xsl:value-of select="'{{/}\!\!{/}} '"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'&#11005;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,&quot;'&quot;)"><xsl:text>\text{'}</xsl:text><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,&quot;'&quot;)"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'{')"><xsl:value-of select="'\{'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'{')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'}')"><xsl:value-of select="'\}'"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content,'}')"/></xsl:call-template></xsl:when>
<xsl:otherwise><xsl:value-of select="substring($content,1,1)"/><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring($content,2)"/></xsl:call-template></xsl:otherwise></xsl:choose></xsl:if></xsl:template>

<xsl:template name="replaceMtextEntities">
<xsl:param name="content"/>
<xsl:if test="string-length($content)&gt;0">
<xsl:choose>

<xsl:when test="starts-with($content,'&#192;')"><xsl:value-of select="'\`{A}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#192;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#193;')"><xsl:text>\'{A}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#193;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#194;')"><xsl:value-of select="'\^{A}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#194;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#195;')"><xsl:value-of select="'\~{A}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#195;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#196;')"><xsl:value-of select="'\&quot;{A}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#196;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#197;')"><xsl:value-of select="'\AA '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#197;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#198;')"><xsl:value-of select="'\AE '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#198;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#199;')"><xsl:value-of select="'\c{C}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#199;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#200;')"><xsl:value-of select="'\`{E}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#200;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#201;')"><xsl:text>\'{E}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#201;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#202;')"><xsl:value-of select="'\^{E}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#202;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#203;')"><xsl:value-of select="'\&quot;{E}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#203;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#204;')"><xsl:value-of select="'\`{I}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#204;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#205;')"><xsl:text>\'{I}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#205;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#206;')"><xsl:value-of select="'\^{I}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#206;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#207;')"><xsl:value-of select="'\&quot;{I}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#207;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#208;')"><xsl:value-of select="'\DH '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#208;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#209;')"><xsl:value-of select="'\~{N}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#209;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#210;')"><xsl:value-of select="'\`{O}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#210;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#211;')"><xsl:text>\'{O}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#211;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#212;')"><xsl:value-of select="'\^{O}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#212;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#213;')"><xsl:value-of select="'\~{O}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#213;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#214;')"><xsl:value-of select="'\&quot;{O}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#214;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#215;')"><xsl:value-of select="'$\times$'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#215;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#216;')"><xsl:value-of select="'\O '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#216;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#217;')"><xsl:value-of select="'\`{U}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#217;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#218;')"><xsl:text>\'{U}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#218;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#219;')"><xsl:value-of select="'\^{U}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#219;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#220;')"><xsl:value-of select="'\&quot;{U}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#220;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#221;')"><xsl:text>\'{Y}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#221;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#222;')"><xsl:value-of select="'\TH '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#222;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#223;')"><xsl:value-of select="'\ss '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#223;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#224;')"><xsl:value-of select="'\`{a}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#224;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#225;')"><xsl:text>\'{a}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#225;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#226;')"><xsl:value-of select="'\^{a}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#226;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#227;')"><xsl:value-of select="'\~{a}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#227;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#228;')"><xsl:value-of select="'\&quot;{a}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#228;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#229;')"><xsl:value-of select="'\aa '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#229;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#230;')"><xsl:value-of select="'\ae '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#230;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#231;')"><xsl:value-of select="'\c{c}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#231;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#232;')"><xsl:value-of select="'\`{e}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#232;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#233;')"><xsl:text>\'{e}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#233;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#234;')"><xsl:value-of select="'\^{e}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#234;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#235;')"><xsl:value-of select="'\&quot;{e}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#235;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#236;')"><xsl:value-of select="'\`{\i}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#236;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#237;')"><xsl:text>\'{\i}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#237;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#238;')"><xsl:value-of select="'\^{\i}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#238;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#239;')"><xsl:value-of select="'\&quot;{\i}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#239;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#240;')"><xsl:value-of select="'\dh '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#240;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#241;')"><xsl:value-of select="'\~{n}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#241;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#242;')"><xsl:value-of select="'\`{o}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#242;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#243;')"><xsl:text>\'{o}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#243;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#244;')"><xsl:value-of select="'\^{o}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#244;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#245;')"><xsl:value-of select="'\~{o}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#245;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#246;')"><xsl:value-of select="'\&quot;{o}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#246;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#247;')"><xsl:value-of select="'$\div$'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#247;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#248;')"><xsl:value-of select="'\o '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#248;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#249;')"><xsl:value-of select="'\`{u}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#249;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#250;')"><xsl:text>\'{u}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#250;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#251;')"><xsl:value-of select="'\^{u}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#251;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#252;')"><xsl:value-of select="'\&quot;{u}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#252;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#253;')"><xsl:text>\'{y}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#253;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#254;')"><xsl:value-of select="'\th '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#254;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#255;')"><xsl:value-of select="'\&quot;{y}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#255;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#256;')"><xsl:value-of select="'\={A}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#256;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#257;')"><xsl:value-of select="'\={a}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#257;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#258;')"><xsl:value-of select="'\u{A}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#258;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#259;')"><xsl:value-of select="'\u{a}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#259;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#260;')"><xsl:value-of select="'\k{A}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#260;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#261;')"><xsl:value-of select="'\k{a}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#261;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#262;')"><xsl:text>\'{C}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#262;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#263;')"><xsl:text>\'{c}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#263;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#264;')"><xsl:value-of select="'\^{C}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#264;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#265;')"><xsl:value-of select="'\^{c}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#265;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#266;')"><xsl:value-of select="'\.{C}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#266;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#267;')"><xsl:value-of select="'\.{c}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#267;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#268;')"><xsl:value-of select="'\v{C}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#268;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#269;')"><xsl:value-of select="'\v{c}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#269;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#270;')"><xsl:value-of select="'\v{D}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#270;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#271;')"><xsl:value-of select="'\v{d}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#271;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#272;')"><xsl:value-of select="'\DJ '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#272;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#273;')"><xsl:value-of select="'\dj '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#273;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#274;')"><xsl:value-of select="'\={E}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#274;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#275;')"><xsl:value-of select="'\={e}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#275;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#276;')"><xsl:value-of select="'\u{E}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#276;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#277;')"><xsl:value-of select="'\u{e}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#277;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#278;')"><xsl:value-of select="'\.{E}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#278;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#279;')"><xsl:value-of select="'\.{e}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#279;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#280;')"><xsl:value-of select="'\k{E}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#280;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#281;')"><xsl:value-of select="'\k{e}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#281;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#282;')"><xsl:value-of select="'\v{E}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#282;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#283;')"><xsl:value-of select="'\v{e}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#283;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#284;')"><xsl:value-of select="'\^{G}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#284;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#285;')"><xsl:value-of select="'\^{g}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#285;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#286;')"><xsl:value-of select="'\u{G}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#286;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#287;')"><xsl:value-of select="'\u{g}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#287;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#288;')"><xsl:value-of select="'\.{G}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#288;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#289;')"><xsl:value-of select="'\.{g}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#289;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#290;')"><xsl:value-of select="'\c{G}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#290;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#291;')"><xsl:value-of select="'\c{g}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#291;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#292;')"><xsl:value-of select="'\^{H}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#292;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#293;')"><xsl:value-of select="'\^{h}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#293;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#296;')"><xsl:value-of select="'\~{I}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#296;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#297;')"><xsl:value-of select="'\~{\i}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#297;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#298;')"><xsl:value-of select="'\={I}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#298;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#299;')"><xsl:value-of select="'\={\i}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#299;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#300;')"><xsl:value-of select="'\u{I}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#300;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#301;')"><xsl:value-of select="'\u{\i}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#301;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#302;')"><xsl:value-of select="'\k{I}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#302;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#303;')"><xsl:value-of select="'\k{i}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#303;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#304;')"><xsl:value-of select="'\.{I}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#304;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#305;')"><xsl:value-of select="'\i '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#305;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#306;')"><xsl:value-of select="'IJ '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#306;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#307;')"><xsl:value-of select="'ij '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#307;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#308;')"><xsl:value-of select="'\^{J}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#308;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#309;')"><xsl:value-of select="'\^{\j}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#309;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#310;')"><xsl:value-of select="'\c{K}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#310;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#311;')"><xsl:value-of select="'\c{k}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#311;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#313;')"><xsl:text>\'{L}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#313;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#314;')"><xsl:text>\'{l}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#314;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#315;')"><xsl:value-of select="'\c{L}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#315;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#316;')"><xsl:value-of select="'\c{l}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#316;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#317;')"><xsl:value-of select="'\v{L}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#317;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#318;')"><xsl:value-of select="'\v{l}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#318;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#321;')"><xsl:value-of select="'\L '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#321;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#322;')"><xsl:value-of select="'\l '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#322;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#323;')"><xsl:text>\'{N}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#323;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#324;')"><xsl:text>\'{n}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#324;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#325;')"><xsl:value-of select="'\c{N}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#325;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#326;')"><xsl:value-of select="'\c{n}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#326;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#327;')"><xsl:value-of select="'\v{N}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#327;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#328;')"><xsl:value-of select="'\v{n}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#328;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#329;')"><xsl:text>'n</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#329;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#330;')"><xsl:value-of select="'\NG '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#330;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#331;')"><xsl:value-of select="'\ng '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#331;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#332;')"><xsl:value-of select="'\={O}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#332;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#333;')"><xsl:value-of select="'\={o}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#333;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#334;')"><xsl:value-of select="'\u{O}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#334;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#335;')"><xsl:value-of select="'\u{o}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#335;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#336;')"><xsl:value-of select="'\H{O}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#336;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#337;')"><xsl:value-of select="'\H{o}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#337;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#338;')"><xsl:value-of select="'\OE '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#338;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#339;')"><xsl:value-of select="'\oe '"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#339;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#340;')"><xsl:text>\'{R}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#340;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#341;')"><xsl:text>\'{r}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#341;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#342;')"><xsl:value-of select="'\c{R}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#342;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#343;')"><xsl:value-of select="'\c{r}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#343;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#344;')"><xsl:value-of select="'\v{R}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#344;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#345;')"><xsl:value-of select="'\v{r}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#345;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#346;')"><xsl:text>\'{S}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#346;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#347;')"><xsl:text>\'{s}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#347;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#348;')"><xsl:value-of select="'\^{S}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#348;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#349;')"><xsl:value-of select="'\^{s}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#349;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#350;')"><xsl:value-of select="'\c{S}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#350;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#351;')"><xsl:value-of select="'\c{s}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#351;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#352;')"><xsl:value-of select="'\v{S}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#352;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#353;')"><xsl:value-of select="'\v{s}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#353;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#354;')"><xsl:value-of select="'\c{T}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#354;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#355;')"><xsl:value-of select="'\c{t}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#355;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#356;')"><xsl:value-of select="'\v{T}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#356;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#357;')"><xsl:value-of select="'\v{t}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#357;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#360;')"><xsl:value-of select="'\~{U}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#360;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#361;')"><xsl:value-of select="'\~{u}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#361;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#362;')"><xsl:value-of select="'\={U}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#362;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#363;')"><xsl:value-of select="'\={u}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#363;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#364;')"><xsl:value-of select="'\u{U}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#364;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#365;')"><xsl:value-of select="'\u{u}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#365;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#366;')"><xsl:value-of select="'\r{U}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#366;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#367;')"><xsl:value-of select="'\r{u}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#367;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#368;')"><xsl:value-of select="'\H{U}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#368;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#369;')"><xsl:value-of select="'\H{u}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#369;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#370;')"><xsl:value-of select="'\k{U}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#370;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#371;')"><xsl:value-of select="'\k{u}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#371;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#372;')"><xsl:value-of select="'\^{W}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#372;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#373;')"><xsl:value-of select="'\^{w}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#373;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#374;')"><xsl:value-of select="'\^{Y}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#374;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#375;')"><xsl:value-of select="'\^{y}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#375;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#376;')"><xsl:value-of select="'\&quot;{Y}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#376;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#377;')"><xsl:text>\'{Z}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#377;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#378;')"><xsl:text>\'{z}</xsl:text><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#378;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#379;')"><xsl:value-of select="'\.{Z}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#379;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#380;')"><xsl:value-of select="'\.{z}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#380;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#381;')"><xsl:value-of select="'\v{Z}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#381;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#382;')"><xsl:value-of select="'\v{z}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#382;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8201;&#8202;&#8202;')"><xsl:value-of select="'\hspace{0.28em}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#8201;&#8202;&#8202;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8194;')"><xsl:value-of select="'\hspace{0.5em}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#8194;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8195;')"><xsl:value-of select="'\hspace{1em}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#8195;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8196;')"><xsl:value-of select="'\hspace{0.33em}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#8196;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8197;')"><xsl:value-of select="'\hspace{0.25em}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#8197;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8201;')"><xsl:value-of select="'\hspace{0.17em}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#8201;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8202;')"><xsl:value-of select="'\hspace{0.05em}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#8202;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8203;')"><xsl:value-of select="''"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#8203;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#8287;')"><xsl:value-of select="'\hspace{0.22em}'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&#8287;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'$')"><xsl:value-of select="'\$'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'$')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'#')"><xsl:value-of select="'\#'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'#')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&amp;')"><xsl:value-of select="'\&amp;'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'&amp;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'%')"><xsl:value-of select="'\%'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'%')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'_')"><xsl:value-of select="'\_'"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'_')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'\')"><xsl:value-of select="''"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content,'\')"/></xsl:call-template></xsl:when>
<xsl:otherwise><xsl:value-of select="substring($content,1,1)"/><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring($content,2)"/></xsl:call-template></xsl:otherwise></xsl:choose></xsl:if></xsl:template>
</xsl:stylesheet>
