/* SPDX-License-Identifier: GPL-2.0 */
/* Copyright (c) 2018-2022, NVIDIA CORPORATION. All rights reserved. */

#ifndef DT_BINDINGS_RESET_TEGRA234_RESET_H
#define DT_BINDINGS_RESET_TEGRA234_RESET_H

/**
 * @file
 * @defgroup bpmp_reset_ids Reset ID's
 * @brief Identifiers for Resets controllable by firmware
 * @{
 */
#define TEGRA234_RESET_PEX1_CORE_6		11U
#define TEGRA234_RESET_PEX1_CORE_6_APB		12U
#define TEGRA234_RESET_PEX1_COMMON_APB		13U
#define TEGRA234_RESET_PEX2_CORE_7		14U
#define TEGRA234_RESET_PEX2_CORE_7_APB		15U
#define TEGRA234_RESET_HDA			20U
#define TEGRA234_RESET_HDACODEC			21U
#define TEGRA234_RESET_I2C1			24U
#define TEGRA234_RESET_PEX2_CORE_8		25U
#define TEGRA234_RESET_PEX2_CORE_8_APB		26U
#define TEGRA234_RESET_PEX2_CORE_9		27U
#define TEGRA234_RESET_PEX2_CORE_9_APB		28U
#define TEGRA234_RESET_I2C2			29U
#define TEGRA234_RESET_I2C3			30U
#define TEGRA234_RESET_I2C4			31U
#define TEGRA234_RESET_I2C6			32U
#define TEGRA234_RESET_I2C7			33U
#define TEGRA234_RESET_I2C8			34U
#define TEGRA234_RESET_I2C9			35U
#define TEGRA234_RESET_PEX2_CORE_10		56U
#define TEGRA234_RESET_PEX2_CORE_10_APB		57U
#define TEGRA234_RESET_PEX2_COMMON_APB		58U
#define TEGRA234_RESET_PWM1			68U
#define TEGRA234_RESET_PWM2			69U
#define TEGRA234_RESET_PWM3			70U
#define TEGRA234_RESET_PWM4			71U
#define TEGRA234_RESET_PWM5			72U
#define TEGRA234_RESET_PWM6			73U
#define TEGRA234_RESET_PWM7			74U
#define TEGRA234_RESET_PWM8			75U
#define TEGRA234_RESET_QSPI0			76U
#define TEGRA234_RESET_QSPI1			77U
#define TEGRA234_RESET_SDMMC4			85U
#define TEGRA234_RESET_UARTA			100U
#define TEGRA234_RESET_PEX0_CORE_0		116U
#define TEGRA234_RESET_PEX0_CORE_1		117U
#define TEGRA234_RESET_PEX0_CORE_2		118U
#define TEGRA234_RESET_PEX0_CORE_3		119U
#define TEGRA234_RESET_PEX0_CORE_4		120U
#define TEGRA234_RESET_PEX0_CORE_0_APB		121U
#define TEGRA234_RESET_PEX0_CORE_1_APB		122U
#define TEGRA234_RESET_PEX0_CORE_2_APB		123U
#define TEGRA234_RESET_PEX0_CORE_3_APB		124U
#define TEGRA234_RESET_PEX0_CORE_4_APB		125U
#define TEGRA234_RESET_PEX0_COMMON_APB		126U
#define TEGRA234_RESET_PEX1_CORE_5		129U
#define TEGRA234_RESET_PEX1_CORE_5_APB		130U

/** @} */

#endif
