/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef LRFMETADATAPARSER_H_INCLUDED
#define LRFMETADATAPARSER_H_INCLUDED

#include "LRFTypes.h"

class WPXInputStream;

namespace libebook
{

class LRFMetadataParser
{
  // Weffc++
  LRFMetadataParser(const LRFMetadataParser &other);
  LRFMetadataParser &operator=(const LRFMetadataParser &other);

public:
  explicit LRFMetadataParser(WPXInputStream *input);

  void parse();

  const LRFMetadata &getMetadata() const;

private:
  LRFMetadata m_metadata;
  WPXInputStream *const m_input;
};

}

#endif // LRFMETADATAPARSER_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
