RabbitMQ `3.9.4` is a maintenance release in the `3.9.x` release series.

Please refer to the **Upgrading to 3.9** section from [v3.9.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.9.0) if upgrading from a version prior to 3.9.0.

This release requires at least Erlang 23.2, and supports the latest Erlang 24 version, 24.0.5 at the time of release. [RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on Erlang version requirements for RabbitMQ.


## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.9.x/release-notes).
Contributors are encouraged to update them together with their changes.  This helps with release automation and more
consistent release schedule.

### Core Server

#### Enhancements

 * New Prometheus metrics for alarms:
   * `rabbitmq_alarms_file_descriptor_limit` 1|0
   * `rabbitmq_alarms_free_disk_space_watermark` 1|0
   * `rabbitmq_alarms_memory_used_watermark` 1|0
   
   While some of the alarms have cluster-wide effect, these metrics are node-local.

   GitHub issue: [#2653](https://github.com/rabbitmq/rabbitmq-server/pull/2653)

 * Nodes will now use four more environment variables, if set: `RABBITMQ_DEFAULT_USER` (overrides `default_user` in `rabbitmq.conf`), `RABBITMQ_DEFAULT_PASS` (overrides `default_pass`), `RABBITMQ_DEFAULT_VHOST` (overrides `default_vhost`) and `RABBITMQ_ERLANG_COOKIE` (sets [shared authentication secret value](https://www.rabbitmq.com/clustering.html#erlang-cookie)).
   These variables **are not recommended to be used in production** but can be the only realistic option in some environment, such as service containers, ECS, and so on.
   Most users should continue using `rabbitmq.conf` and a securely generated local cookie file.

   GitHub issue: [#3299](https://github.com/rabbitmq/rabbitmq-server/pull/3299)

 * Definitions now can be imported from different sources, including those provided by plugins. Original local filesystem source is still supported in a backwards-compatible way.

   The following `rabbitmq.conf` example uses a local file as the source:
   
   ``` ini
   # equivalent to the classic load_definitions configuration key   
   definitions.import_backend = local_filesystem

   definitions.local.path = /path/to/definitions.json
   ```
   
   This `rabbitmq.conf` example uses a local directory with definition files:
   
   ``` ini
   # equivalent to the classic load_definitions configuration key   
   definitions.import_backend = local_filesystem

   definitions.local.path = /path/to/rabbitmq/definitions.d
   ```

   In this example config file, definitions are loaded from a URL accessible over HTTPS:
   
   ``` ini
   # downloads definitions over HTTPS
   definitions.import_backend = https

   definitions.https.url = https://rabbitmq.eng.megacorp.local/env-1/definitions.json

   # client-side TLS options for definition import   
   definitions.tls.versions.1 = tlsv1.2
   definitions.tls.log_level  = error
   ```

   GitHub issue: [#3249](https://github.com/rabbitmq/rabbitmq-server/issues/3249)

## Dependency Upgrades

No dependency changes in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.9.4.tar.xz` instead of the source tarball produced by GitHub.
