/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.layout.client.Layout;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;

public class LayoutCommand
implements Scheduler.ScheduledCommand {
    private boolean scheduled;
    private boolean canceled;
    private int duration;
    private Layout.AnimationCallback callback;
    private final Layout layout;

    public LayoutCommand(Layout layout) {
        this.layout = layout;
    }

    public void cancel() {
        this.canceled = true;
    }

    public final void execute() {
        this.scheduled = false;
        if (this.canceled) {
            return;
        }
        this.doBeforeLayout();
        this.layout.layout(this.duration, new Layout.AnimationCallback(){

            public void onAnimationComplete() {
                if (LayoutCommand.this.callback != null) {
                    LayoutCommand.this.callback.onAnimationComplete();
                }
            }

            public void onLayout(Layout.Layer layer, double progress) {
                Widget child = (Widget)layer.getUserObject();
                if (child instanceof RequiresResize) {
                    ((RequiresResize)((Object)child)).onResize();
                }
                if (LayoutCommand.this.callback != null) {
                    LayoutCommand.this.callback.onLayout(layer, progress);
                }
            }
        });
    }

    public void schedule(int duration, Layout.AnimationCallback callback) {
        this.duration = duration;
        this.callback = callback;
        this.canceled = false;
        if (!this.scheduled) {
            this.scheduled = true;
            Scheduler.get().scheduleFinally(this);
        }
    }

    protected void doBeforeLayout() {
    }
}

