#!/bin/bash

################################################################################
# Linux Management Providers (LMP), System Memory provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_MemoryConformsToProfile.mof
	cimmof -aE -n $4 $6/mof/OpenDRIM_MemoryConformsToProfile.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_MemoryConformsToProfile provider module";
Name = "SystemMemory_OpenDRIM_MemoryConformsToProfileModule";
Location = "cmpiSystemMemory_OpenDRIM_MemoryConformsToProfileProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_MemoryConformsToProfile provider";
Name = "SystemMemory_OpenDRIM_MemoryConformsToProfileProvider";
ProviderModuleName = "SystemMemory_OpenDRIM_MemoryConformsToProfileModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_MemoryConformsToProfile provider capabilities";
ProviderModuleName = "SystemMemory_OpenDRIM_MemoryConformsToProfileModule";
ProviderName = "SystemMemory_OpenDRIM_MemoryConformsToProfileProvider";
ClassName = "OpenDRIM_MemoryConformsToProfile";
ProviderType = {2, 3};
Namespaces = {"$1", "$4"};
SupportedProperties = {"ConformantStandard", "ManagedElement"};
CapabilityID = "SystemMemory_OpenDRIM_MemoryConformsToProfile";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_MemoryConformsToProfile.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_MemoryConformsToProfile]   
   provider: SystemMemory_OpenDRIM_MemoryConformsToProfileProvider
   location: cmpiSystemMemory_OpenDRIM_MemoryConformsToProfileProvider
   type: instance association
   namespace: $1 $4
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_MemoryConformsToProfile.mof
	sfcbstage -r $OUTFILE -n $4 $6/mof/OpenDRIM_MemoryConformsToProfile.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_MemoryConformsToProfile-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_MemoryConformsToProfile.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	owmofc -u http://localhost/$4 $OUTFILE
	
	rm -f $OUTFILE
	
fi
