/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package dexfuzz.rawdex;

public enum Opcode {
  NOP,
  MOVE,
  MOVE_FROM16,
  MOVE_16,
  MOVE_WIDE,
  MOVE_WIDE_FROM16,
  MOVE_WIDE_16,
  MOVE_OBJECT,
  MOVE_OBJECT_FROM16,
  MOVE_OBJECT_16,
  MOVE_RESULT,
  MOVE_RESULT_WIDE,
  MOVE_RESULT_OBJECT,
  MOVE_EXCEPTION,
  RETURN_VOID,
  RETURN,
  RETURN_WIDE,
  RETURN_OBJECT,
  CONST_4,
  CONST_16,
  CONST,
  CONST_HIGH16,
  CONST_WIDE_16,
  CONST_WIDE_32,
  CONST_WIDE,
  CONST_WIDE_HIGH16,
  CONST_STRING,
  CONST_STRING_JUMBO,
  CONST_CLASS,
  MONITOR_ENTER,
  MONITOR_EXIT,
  CHECK_CAST,
  INSTANCE_OF,
  ARRAY_LENGTH,
  NEW_INSTANCE,
  NEW_ARRAY,
  FILLED_NEW_ARRAY,
  FILLED_NEW_ARRAY_RANGE,
  FILL_ARRAY_DATA,
  THROW,
  GOTO,
  GOTO_16,
  GOTO_32,
  PACKED_SWITCH,
  SPARSE_SWITCH,
  CMPL_FLOAT,
  CMPG_FLOAT,
  CMPL_DOUBLE,
  CMPG_DOUBLE,
  CMP_LONG,
  IF_EQ,
  IF_NE,
  IF_LT,
  IF_GE,
  IF_GT,
  IF_LE,
  IF_EQZ,
  IF_NEZ,
  IF_LTZ,
  IF_GEZ,
  IF_GTZ,
  IF_LEZ,
  UNUSED_3E,
  UNUSED_3F,
  UNUSED_40,
  UNUSED_41,
  UNUSED_42,
  UNUSED_43,
  AGET,
  AGET_WIDE,
  AGET_OBJECT,
  AGET_BOOLEAN,
  AGET_BYTE,
  AGET_CHAR,
  AGET_SHORT,
  APUT,
  APUT_WIDE,
  APUT_OBJECT,
  APUT_BOOLEAN,
  APUT_BYTE,
  APUT_CHAR,
  APUT_SHORT,
  IGET,
  IGET_WIDE,
  IGET_OBJECT,
  IGET_BOOLEAN,
  IGET_BYTE,
  IGET_CHAR,
  IGET_SHORT,
  IPUT,
  IPUT_WIDE,
  IPUT_OBJECT,
  IPUT_BOOLEAN,
  IPUT_BYTE,
  IPUT_CHAR,
  IPUT_SHORT,
  SGET,
  SGET_WIDE,
  SGET_OBJECT,
  SGET_BOOLEAN,
  SGET_BYTE,
  SGET_CHAR,
  SGET_SHORT,
  SPUT,
  SPUT_WIDE,
  SPUT_OBJECT,
  SPUT_BOOLEAN,
  SPUT_BYTE,
  SPUT_CHAR,
  SPUT_SHORT,
  INVOKE_VIRTUAL,
  INVOKE_SUPER,
  INVOKE_DIRECT,
  INVOKE_STATIC,
  INVOKE_INTERFACE,
  RETURN_VOID_NO_BARRIER,
  INVOKE_VIRTUAL_RANGE,
  INVOKE_SUPER_RANGE,
  INVOKE_DIRECT_RANGE,
  INVOKE_STATIC_RANGE,
  INVOKE_INTERFACE_RANGE,
  UNUSED_79,
  UNUSED_7A,
  NEG_INT,
  NOT_INT,
  NEG_LONG,
  NOT_LONG,
  NEG_FLOAT,
  NEG_DOUBLE,
  INT_TO_LONG,
  INT_TO_FLOAT,
  INT_TO_DOUBLE,
  LONG_TO_INT,
  LONG_TO_FLOAT,
  LONG_TO_DOUBLE,
  FLOAT_TO_INT,
  FLOAT_TO_LONG,
  FLOAT_TO_DOUBLE,
  DOUBLE_TO_INT,
  DOUBLE_TO_LONG,
  DOUBLE_TO_FLOAT,
  INT_TO_BYTE,
  INT_TO_CHAR,
  INT_TO_SHORT,
  ADD_INT,
  SUB_INT,
  MUL_INT,
  DIV_INT,
  REM_INT,
  AND_INT,
  OR_INT,
  XOR_INT,
  SHL_INT,
  SHR_INT,
  USHR_INT,
  ADD_LONG,
  SUB_LONG,
  MUL_LONG,
  DIV_LONG,
  REM_LONG,
  AND_LONG,
  OR_LONG,
  XOR_LONG,
  SHL_LONG,
  SHR_LONG,
  USHR_LONG,
  ADD_FLOAT,
  SUB_FLOAT,
  MUL_FLOAT,
  DIV_FLOAT,
  REM_FLOAT,
  ADD_DOUBLE,
  SUB_DOUBLE,
  MUL_DOUBLE,
  DIV_DOUBLE,
  REM_DOUBLE,
  ADD_INT_2ADDR,
  SUB_INT_2ADDR,
  MUL_INT_2ADDR,
  DIV_INT_2ADDR,
  REM_INT_2ADDR,
  AND_INT_2ADDR,
  OR_INT_2ADDR,
  XOR_INT_2ADDR,
  SHL_INT_2ADDR,
  SHR_INT_2ADDR,
  USHR_INT_2ADDR,
  ADD_LONG_2ADDR,
  SUB_LONG_2ADDR,
  MUL_LONG_2ADDR,
  DIV_LONG_2ADDR,
  REM_LONG_2ADDR,
  AND_LONG_2ADDR,
  OR_LONG_2ADDR,
  XOR_LONG_2ADDR,
  SHL_LONG_2ADDR,
  SHR_LONG_2ADDR,
  USHR_LONG_2ADDR,
  ADD_FLOAT_2ADDR,
  SUB_FLOAT_2ADDR,
  MUL_FLOAT_2ADDR,
  DIV_FLOAT_2ADDR,
  REM_FLOAT_2ADDR,
  ADD_DOUBLE_2ADDR,
  SUB_DOUBLE_2ADDR,
  MUL_DOUBLE_2ADDR,
  DIV_DOUBLE_2ADDR,
  REM_DOUBLE_2ADDR,
  ADD_INT_LIT16,
  RSUB_INT,
  MUL_INT_LIT16,
  DIV_INT_LIT16,
  REM_INT_LIT16,
  AND_INT_LIT16,
  OR_INT_LIT16,
  XOR_INT_LIT16,
  ADD_INT_LIT8,
  RSUB_INT_LIT8,
  MUL_INT_LIT8,
  DIV_INT_LIT8,
  REM_INT_LIT8,
  AND_INT_LIT8,
  OR_INT_LIT8,
  XOR_INT_LIT8,
  SHL_INT_LIT8,
  SHR_INT_LIT8,
  USHR_INT_LIT8,
  IGET_QUICK,
  IGET_WIDE_QUICK,
  IGET_OBJECT_QUICK,
  IPUT_QUICK,
  IPUT_WIDE_QUICK,
  IPUT_OBJECT_QUICK,
  INVOKE_VIRTUAL_QUICK,
  INVOKE_VIRTUAL_QUICK_RANGE,
  IPUT_BOOLEAN_QUICK,
  IPUT_BYTE_QUICK,
  IPUT_CHAR_QUICK,
  IPUT_SHORT_QUICK,
  UNUSED_EF,
  UNUSED_F0,
  UNUSED_F1,
  UNUSED_F2,
  UNUSED_F3,
  UNUSED_F4,
  UNUSED_F5,
  UNUSED_F6,
  UNUSED_F7,
  UNUSED_F8,
  UNUSED_F9,
  UNUSED_FA,
  UNUSED_FB,
  UNUSED_FC,
  UNUSED_FD,
  UNUSED_FE,
  UNUSED_FF;

  public static boolean isBetween(Opcode opcode, Opcode opcode1, Opcode opcode2) {
    return (opcode.ordinal() >= opcode1.ordinal() && opcode.ordinal() <= opcode2.ordinal());
  }
}
