### ocaml.lib.mk -- Building OCaml libraries

# Author: Michael Grünewald
# Date: Tue Apr  5 12:31:04 CEST 2005

# BSD Owl Scripts (https://bitbucket.org/michipili/bsdowl)
# This file is part of BSD Owl Scripts
#
# Copyright © 2005–2014 Michael Grünewald
#
# This file must be used under the terms of the CeCILL-B.
# This source file is licensed as described in the file COPYING, which
# you should have received as part of this distribution. The terms
# are also available at
# http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.txt


### SYNOPSIS

# LIBRARY=	newton
# SRCS+=	newton.ml
#
# .include "ocaml.lib.mk"


### DESCRIPTION

# Build an ocaml library, compiling each of the module listed in SRCS
# and creating a library named as LIBRARY.
#
# It supports building bytecode and native libraries, ocamlfind,
# lexers and parsers generated by ocamllex and ocamlyacc and
# debugging, profiling as well.

# Variables:
#
#
#  LIBRARY
#   The name of the library
#
#
#  SRCS
#   Files to put in the library
#
#   It can list implementation files, lexer and parser definitions.
#
#
#  LIBOWN, LIBGRP, LIBMODE, LIBDIR, LIBNAME
#   Paramters of the library installation
#
#   See `bps.own.mk` for a closer description of these variables. If
#   the PACKAGE library is set, then LIBDIR will appropriately be
#   initialised to ${PREFIX}/lib/ocaml/site-lib${PACKAGEDIR}
#   instead of {PREFIX}/lib/ocaml.


### IMPLEMENTATION

.include "bps.init.mk"
.include "ocaml.init.mk"

# We do not support the LIB short name, because it clashes with a file
# installation group.
#
# .if defined(LIB)&&!empty(LIB)
# LIBRARY?= ${LIB}
# .endif

.if !defined(LIBRARY)||empty(LIBRARY)
.error The ocaml.lib.mk expects you to set the LIBRARY variable to a sensible value.
.endif

_OCAML_SRCS?=
_OCAML_CMA?=
_OCAML_CMXA?=
_OCAML_A?=

_OCAML_LIB:=${LIBRARY}

.for lib in ${_OCAML_LIB}
SRCS.${lib:T}?=${SRCS}
.if defined(_OCAML_COMPILE_NATIVE)
SRCS.${lib:T}.cmxa?=${SRCS.${lib:T}}
_OCAML_SRCS+=SRCS.${lib}.cmxa
_OCAML_CMXA+=${lib:T}.cmxa
_OCAML_A+=${lib:T}.a
.endif
.if defined(_OCAML_COMPILE_BYTE)
SRCS.${lib:T}.cma?=${SRCS.${lib:T}}
_OCAML_SRCS+=SRCS.${lib}.cma
_OCAML_CMA+=${lib:T}.cma
.endif
.endfor


.include "ocaml.main.mk"


.for lib in ${_OCAML_LIB}
.if defined(_OCAML_COMPILE_NATIVE)
LIB+= ${lib}.cmxa ${lib}.a
_OCAML_SRCS.${lib}.cmxa=${.ALLSRC}
${lib}.cmxa: ${SRCS.${lib}.cmxa:C/\.ml[ly]/.ml/:M*.ml:.ml=.cmx}
.endif
.if defined(_OCAML_COMPILE_BYTE)
LIB+= ${lib}.cma
_OCAML_SRCS.${lib:T}.cma=${.ALLSRC}
${lib}.cma: ${SRCS.${lib:T}.cma:C/\.ml[ly]/.ml/:M*.ml:.ml=.cmo}
.endif
.if !empty(SRCS.${lib:T}:C/\.ml[ly]/.ml/:M*.ml)
LIB+= ${SRCS.${lib:T}:C/\.ml[ly]/.ml/:M*.ml:.ml=.cmi}
.endif
.endfor

.include "bps.clean.mk"
.include "bps.files.mk"
.include "bps.usertarget.mk"

### End of file `ocaml.lib.mk'
