/*------------------------ MIT License HEADER ------------------------------------
    Copyright ANSSI (2013-2015)
    Contributors : Ryad BENADJILA [ryad.benadjila@ssi.gouv.fr],
    Thomas CALDERON [thomas.calderon@ssi.gouv.fr]
    Marion DAUBIGNARD [marion.daubignard@ssi.gouv.fr]

    This software is a computer program whose purpose is to implement
    a PKCS#11 proxy as well as a PKCS#11 filter with security features
    in mind. The project source tree is subdivided in six parts.
    There are five main parts:
      1] OCaml/C PKCS#11 bindings (using OCaml IDL).
      2] XDR RPC generators (to be used with ocamlrpcgen and/or rpcgen).
      3] A PKCS#11 RPC server (daemon) in OCaml using a Netplex RPC basis.
      4] A PKCS#11 filtering module used as a backend to the RPC server.
      5] A PKCS#11 client module that comes as a dynamic library offering
         the PKCS#11 API to the software.
    There is one "optional" part:
      6] Tests in C and OCaml to be used with client module 5] or with the
         bindings 1]

    Here is a big picture of how the PKCS#11 proxy works:

 ----------------------   --------  socket (TCP or Unix)  --------------------
| 3] PKCS#11 RPC server|-|2] RPC  |<+++++++++++++++++++> | 5] Client library  |
 ----------------------  |  Layer | [SSL/TLS optional]   |  --------          |
           |              --------                       | |2] RPC  | PKCS#11 |
 ----------------------                                  | |  Layer |functions|
| 4] PKCS#11 filter    |                                 |  --------          |
 ----------------------                                   --------------------
           |                                                        |
 ----------------------                                             |
| 1] PKCS#11 OCaml     |                                  { PKCS#11 INTERFACE }
|       bindings       |                                            |
 ----------------------                                       APPLICATION
           |
           |
 { PKCS#11 INTERFACE }
           |
 REAL PKCS#11 MIDDLEWARE
    (shared library)

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.

    Except as contained in this notice, the name(s) of the above copyright holders
    shall not be used in advertising or otherwise to promote the sale, use or other
    dealings in this Software without prior written authorization.

    The current source code is part of the client library 5] source tree:
                                                          --------------------
                                                         | 5] Client library  |
                                                         |  --------          |
                                                         | |        | PKCS#11 |
                                                         | |        |functions|
                                                         |  --------          |
                                                          --------------------
                                                                    |
                                                                    |
                                                          { PKCS#11 INTERFACE }
                                                                    |
                                                              APPLICATION

    Project: PKCS#11 Filtering Proxy
    File:    src/client-lib/pkcs11_rpc.h

-------------------------- MIT License HEADER ----------------------------------*/
/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _PKCS11_RPC_H_RPCGEN
#define _PKCS11_RPC_H_RPCGEN

#include <rpc/rpc.h>

#include <pthread.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifdef WIN32
#include <stdint.h>
#define quad_t int64_t
#endif
  extern CLIENT *cl;

  typedef quad_t pkcs11_int;

  typedef pkcs11_int rpc_ck_rv_t;

  typedef pkcs11_int rpc_ck_slot_id_t;

  typedef pkcs11_int rpc_ck_mechanism_type_t;

  typedef pkcs11_int rpc_ck_session_handle_t;

  typedef pkcs11_int rpc_ck_user_type_t;

  typedef pkcs11_int rpc_ck_state_t;

  typedef pkcs11_int rpc_ck_object_handle_t;

  typedef pkcs11_int rpc_ck_object_class_t;

  typedef pkcs11_int rpc_ck_hw_feature_type_t;

  typedef pkcs11_int rpc_ck_key_type_t;

  typedef pkcs11_int rpc_ck_certificate_type_t;

  typedef pkcs11_int rpc_ck_attribute_type_t;

  typedef pkcs11_int rpc_ck_flags_t;

  typedef pkcs11_int rpc_ck_notification_t;

  typedef struct {
    u_int opaque_data_len;
    char *opaque_data_val;
  } opaque_data;

  struct rpc_ck_version {
    struct {
      u_int major_len;
      char *major_val;
    } major;
    struct {
      u_int minor_len;
      char *minor_val;
    } minor;
  };
  typedef struct rpc_ck_version rpc_ck_version;

  struct rpc_ck_info {
    rpc_ck_version rpc_ck_info_cryptoki_version;
    struct {
      u_int rpc_ck_info_manufacturer_id_len;
      char *rpc_ck_info_manufacturer_id_val;
    } rpc_ck_info_manufacturer_id;
    rpc_ck_flags_t rpc_ck_info_flags;
    struct {
      u_int rpc_ck_info_library_description_len;
      char *rpc_ck_info_library_description_val;
    } rpc_ck_info_library_description;
    rpc_ck_version rpc_ck_info_library_version;
  };
  typedef struct rpc_ck_info rpc_ck_info;

  struct rpc_ck_slot_info {
    struct {
      u_int rpc_ck_slot_info_slot_description_len;
      char *rpc_ck_slot_info_slot_description_val;
    } rpc_ck_slot_info_slot_description;
    struct {
      u_int rpc_ck_slot_info_manufacturer_id_len;
      char *rpc_ck_slot_info_manufacturer_id_val;
    } rpc_ck_slot_info_manufacturer_id;
    rpc_ck_flags_t rpc_ck_slot_info_flags;
    rpc_ck_version rpc_ck_slot_info_hardware_version;
    rpc_ck_version rpc_ck_slot_info_firmware_version;
  };
  typedef struct rpc_ck_slot_info rpc_ck_slot_info;

  struct rpc_ck_token_info {
    struct {
      u_int rpc_ck_token_info_label_len;
      char *rpc_ck_token_info_label_val;
    } rpc_ck_token_info_label;
    struct {
      u_int rpc_ck_token_info_manufacturer_id_len;
      char *rpc_ck_token_info_manufacturer_id_val;
    } rpc_ck_token_info_manufacturer_id;
    struct {
      u_int rpc_ck_token_info_model_len;
      char *rpc_ck_token_info_model_val;
    } rpc_ck_token_info_model;
    struct {
      u_int rpc_ck_token_info_serial_number_len;
      char *rpc_ck_token_info_serial_number_val;
    } rpc_ck_token_info_serial_number;
    rpc_ck_flags_t rpc_ck_token_info_flags;
    pkcs11_int rpc_ck_token_info_max_session_count;
    pkcs11_int rpc_ck_token_info_session_count;
    pkcs11_int rpc_ck_token_info_max_rw_session_count;
    pkcs11_int rpc_ck_token_info_rw_session_count;
    pkcs11_int rpc_ck_token_info_max_pin_len;
    pkcs11_int rpc_ck_token_info_min_pin_len;
    pkcs11_int rpc_ck_token_info_total_public_memory;
    pkcs11_int rpc_ck_token_info_free_public_memory;
    pkcs11_int rpc_ck_token_info_total_private_memory;
    pkcs11_int rpc_ck_token_info_free_private_memory;
    rpc_ck_version rpc_ck_token_info_hardware_version;
    rpc_ck_version rpc_ck_token_info_firmware_version;
    struct {
      u_int rpc_ck_token_info_utc_time_len;
      char *rpc_ck_token_info_utc_time_val;
    } rpc_ck_token_info_utc_time;
  };
  typedef struct rpc_ck_token_info rpc_ck_token_info;

  struct rpc_ck_mechanism {
    rpc_ck_mechanism_type_t rpc_ck_mechanism_mechanism;
    struct {
      u_int rpc_ck_mechanism_parameter_len;
      char *rpc_ck_mechanism_parameter_val;
    } rpc_ck_mechanism_parameter;
  };
  typedef struct rpc_ck_mechanism rpc_ck_mechanism;

  struct rpc_ck_session_info {
    rpc_ck_slot_id_t rpc_ck_session_info_slot_id;
    rpc_ck_state_t rpc_ck_session_info_state;
    rpc_ck_flags_t rpc_ck_session_info_flags;
    pkcs11_int rpc_ck_session_info_device_error;
  };
  typedef struct rpc_ck_session_info rpc_ck_session_info;

  struct rpc_ck_mechanism_info {
    pkcs11_int rpc_ck_mechanism_info_min_key_size;
    pkcs11_int rpc_ck_mechanism_info_max_key_size;
    rpc_ck_flags_t rpc_ck_mechanism_info_flags;
  };
  typedef struct rpc_ck_mechanism_info rpc_ck_mechanism_info;

  struct rpc_ck_attribute {
    rpc_ck_attribute_type_t rpc_ck_attribute_type;
    struct {
      u_int rpc_ck_attribute_value_len;
      char *rpc_ck_attribute_value_val;
    } rpc_ck_attribute_value;
    pkcs11_int rpc_ck_attribute_value_len;
  };
  typedef struct rpc_ck_attribute rpc_ck_attribute;

  typedef struct {
    u_int rpc_ck_attribute_array_len;
    rpc_ck_attribute *rpc_ck_attribute_array_val;
  } rpc_ck_attribute_array;

  struct rpc_ck_date {
    struct {
      u_int rpc_ck_date_year_len;
      char *rpc_ck_date_year_val;
    } rpc_ck_date_year;
    struct {
      u_int rpc_ck_date_month_len;
      char *rpc_ck_date_month_val;
    } rpc_ck_date_month;
    struct {
      u_int rpc_ck_date_day_len;
      char *rpc_ck_date_day_val;
    } rpc_ck_date_day;
  };
  typedef struct rpc_ck_date rpc_ck_date;

  struct ck_rv_c_GetSlotList {
    rpc_ck_rv_t c_GetSlotList_rv;
    struct {
      u_int c_GetSlotList_slot_list_len;
      rpc_ck_slot_id_t *c_GetSlotList_slot_list_val;
    } c_GetSlotList_slot_list;
    pkcs11_int c_GetSlotList_count;
  };
  typedef struct ck_rv_c_GetSlotList ck_rv_c_GetSlotList;

  struct ck_rv_c_GetSlotInfo {
    rpc_ck_rv_t c_GetSlotInfo_rv;
    rpc_ck_slot_info c_GetSlotInfo_slot_info;
  };
  typedef struct ck_rv_c_GetSlotInfo ck_rv_c_GetSlotInfo;

  struct ck_rv_c_GetTokenInfo {
    rpc_ck_rv_t c_GetTokenInfo_rv;
    rpc_ck_token_info c_GetTokenInfo_token_info;
  };
  typedef struct ck_rv_c_GetTokenInfo ck_rv_c_GetTokenInfo;

  struct ck_rv_c_GetInfo {
    rpc_ck_rv_t c_GetInfo_rv;
    rpc_ck_info c_GetInfo_info;
  };
  typedef struct ck_rv_c_GetInfo ck_rv_c_GetInfo;

  struct ck_rv_c_WaitForSlotEvent {
    rpc_ck_rv_t c_WaitForSlotEvent_rv;
    rpc_ck_slot_id_t c_WaitForSlotEvent_count;
  };
  typedef struct ck_rv_c_WaitForSlotEvent ck_rv_c_WaitForSlotEvent;

  struct ck_rv_c_OpenSession {
    rpc_ck_rv_t c_OpenSession_rv;
    rpc_ck_session_handle_t c_OpenSession_handle;
  };
  typedef struct ck_rv_c_OpenSession ck_rv_c_OpenSession;

  struct ck_rv_c_GetMechanismList {
    rpc_ck_rv_t c_GetMechanismList_rv;
    struct {
      u_int c_GetMechanismList_list_len;
      rpc_ck_mechanism_type_t *c_GetMechanismList_list_val;
    } c_GetMechanismList_list;
    pkcs11_int c_GetMechanismList_count;
  };
  typedef struct ck_rv_c_GetMechanismList ck_rv_c_GetMechanismList;

  struct ck_rv_c_GetSessionInfo {
    rpc_ck_rv_t c_GetSessionInfo_rv;
    rpc_ck_session_info c_GetSessionInfo_info;
  };
  typedef struct ck_rv_c_GetSessionInfo ck_rv_c_GetSessionInfo;

  struct ck_rv_c_GetMechanismInfo {
    rpc_ck_rv_t c_GetMechanismInfo_rv;
    rpc_ck_mechanism_info c_GetMechanismInfo_info;
  };
  typedef struct ck_rv_c_GetMechanismInfo ck_rv_c_GetMechanismInfo;

  struct ck_rv_c_GenerateRandom {
    rpc_ck_rv_t c_GenerateRandom_rv;
    struct {
      u_int c_GenerateRandom_data_len;
      char *c_GenerateRandom_data_val;
    } c_GenerateRandom_data;
  };
  typedef struct ck_rv_c_GenerateRandom ck_rv_c_GenerateRandom;

  struct ck_rv_c_FindObjects {
    rpc_ck_rv_t c_FindObjects_rv;
    struct {
      u_int c_FindObjects_objects_len;
      rpc_ck_object_handle_t *c_FindObjects_objects_val;
    } c_FindObjects_objects;
    pkcs11_int c_FindObjects_count;
  };
  typedef struct ck_rv_c_FindObjects ck_rv_c_FindObjects;

  struct ck_rv_c_GenerateKey {
    rpc_ck_rv_t c_GenerateKey_rv;
    rpc_ck_object_handle_t c_GenerateKey_handle;
  };
  typedef struct ck_rv_c_GenerateKey ck_rv_c_GenerateKey;

  struct ck_rv_c_GenerateKeyPair {
    rpc_ck_rv_t c_GenerateKeyPair_rv;
    rpc_ck_object_handle_t c_GenerateKeyPair_pubhandle;
    rpc_ck_object_handle_t c_GenerateKeyPair_privhandle;
  };
  typedef struct ck_rv_c_GenerateKeyPair ck_rv_c_GenerateKeyPair;

  struct ck_rv_c_CreateObject {
    rpc_ck_rv_t c_CreateObject_rv;
    rpc_ck_object_handle_t c_CreateObject_handle;
  };
  typedef struct ck_rv_c_CreateObject ck_rv_c_CreateObject;

  struct ck_rv_c_CopyObject {
    rpc_ck_rv_t c_CopyObject_rv;
    rpc_ck_object_handle_t c_CopyObject_handle;
  };
  typedef struct ck_rv_c_CopyObject ck_rv_c_CopyObject;

  struct ck_rv_c_GetAttributeValue {
    rpc_ck_rv_t c_GetAttributeValue_rv;
    rpc_ck_attribute_array c_GetAttributeValue_value;
  };
  typedef struct ck_rv_c_GetAttributeValue ck_rv_c_GetAttributeValue;

  struct ck_rv_c_GetObjectSize {
    rpc_ck_rv_t c_GetObjectSize_rv;
    pkcs11_int c_GetObjectSize_size;
  };
  typedef struct ck_rv_c_GetObjectSize ck_rv_c_GetObjectSize;

  struct ck_rv_c_WrapKey {
    rpc_ck_rv_t c_WrapKey_rv;
    struct {
      u_int c_WrapKey_value_len;
      char *c_WrapKey_value_val;
    } c_WrapKey_value;
  };
  typedef struct ck_rv_c_WrapKey ck_rv_c_WrapKey;

  struct ck_rv_c_UnwrapKey {
    rpc_ck_rv_t c_UnwrapKey_rv;
    rpc_ck_object_handle_t c_UnwrapKey_handle;
  };
  typedef struct ck_rv_c_UnwrapKey ck_rv_c_UnwrapKey;

  struct ck_rv_c_DeriveKey {
    rpc_ck_rv_t c_DeriveKey_rv;
    rpc_ck_object_handle_t c_DeriveKey_handle;
  };
  typedef struct ck_rv_c_DeriveKey ck_rv_c_DeriveKey;

  struct ck_rv_c_Digest {
    rpc_ck_rv_t c_Digest_rv;
    struct {
      u_int c_Digest_value_len;
      char *c_Digest_value_val;
    } c_Digest_value;
  };
  typedef struct ck_rv_c_Digest ck_rv_c_Digest;

  struct ck_rv_c_DigestFinal {
    rpc_ck_rv_t c_DigestFinal_rv;
    struct {
      u_int c_DigestFinal_value_len;
      char *c_DigestFinal_value_val;
    } c_DigestFinal_value;
  };
  typedef struct ck_rv_c_DigestFinal ck_rv_c_DigestFinal;

  struct ck_rv_c_Sign {
    rpc_ck_rv_t c_Sign_rv;
    struct {
      u_int c_Sign_value_len;
      char *c_Sign_value_val;
    } c_Sign_value;
  };
  typedef struct ck_rv_c_Sign ck_rv_c_Sign;

  struct ck_rv_c_SignFinal {
    rpc_ck_rv_t c_SignFinal_rv;
    struct {
      u_int c_SignFinal_value_len;
      char *c_SignFinal_value_val;
    } c_SignFinal_value;
  };
  typedef struct ck_rv_c_SignFinal ck_rv_c_SignFinal;

  struct ck_rv_c_Encrypt {
    rpc_ck_rv_t c_Encrypt_rv;
    struct {
      u_int c_Encrypt_value_len;
      char *c_Encrypt_value_val;
    } c_Encrypt_value;
  };
  typedef struct ck_rv_c_Encrypt ck_rv_c_Encrypt;

  struct ck_rv_c_EncryptUpdate {
    rpc_ck_rv_t c_EncryptUpdate_rv;
    struct {
      u_int c_EncryptUpdate_value_len;
      char *c_EncryptUpdate_value_val;
    } c_EncryptUpdate_value;
  };
  typedef struct ck_rv_c_EncryptUpdate ck_rv_c_EncryptUpdate;

  struct ck_rv_c_EncryptFinal {
    rpc_ck_rv_t c_EncryptFinal_rv;
    struct {
      u_int c_EncryptFinal_value_len;
      char *c_EncryptFinal_value_val;
    } c_EncryptFinal_value;
  };
  typedef struct ck_rv_c_EncryptFinal ck_rv_c_EncryptFinal;

  struct ck_rv_c_Decrypt {
    rpc_ck_rv_t c_Decrypt_rv;
    struct {
      u_int c_Decrypt_value_len;
      char *c_Decrypt_value_val;
    } c_Decrypt_value;
  };
  typedef struct ck_rv_c_Decrypt ck_rv_c_Decrypt;

  struct ck_rv_c_DecryptUpdate {
    rpc_ck_rv_t c_DecryptUpdate_rv;
    struct {
      u_int c_DecryptUpdate_value_len;
      char *c_DecryptUpdate_value_val;
    } c_DecryptUpdate_value;
  };
  typedef struct ck_rv_c_DecryptUpdate ck_rv_c_DecryptUpdate;

  struct ck_rv_c_DecryptFinal {
    rpc_ck_rv_t c_DecryptFinal_rv;
    struct {
      u_int c_DecryptFinal_value_len;
      char *c_DecryptFinal_value_val;
    } c_DecryptFinal_value;
  };
  typedef struct ck_rv_c_DecryptFinal ck_rv_c_DecryptFinal;

  struct ck_rv_c_SignRecover {
    rpc_ck_rv_t c_SignRecover_rv;
    struct {
      u_int c_SignRecover_value_len;
      char *c_SignRecover_value_val;
    } c_SignRecover_value;
  };
  typedef struct ck_rv_c_SignRecover ck_rv_c_SignRecover;

  struct ck_rv_c_VerifyRecover {
    rpc_ck_rv_t c_VerifyRecover_rv;
    struct {
      u_int c_VerifyRecover_value_len;
      char *c_VerifyRecover_value_val;
    } c_VerifyRecover_value;
  };
  typedef struct ck_rv_c_VerifyRecover ck_rv_c_VerifyRecover;

  struct ck_rv_c_DigestEncryptUpdate {
    rpc_ck_rv_t c_DigestEncryptUpdate_rv;
    struct {
      u_int c_DigestEncryptUpdate_value_len;
      char *c_DigestEncryptUpdate_value_val;
    } c_DigestEncryptUpdate_value;
  };
  typedef struct ck_rv_c_DigestEncryptUpdate ck_rv_c_DigestEncryptUpdate;

  struct ck_rv_c_DecryptDigestUpdate {
    rpc_ck_rv_t c_DecryptDigestUpdate_rv;
    struct {
      u_int c_DecryptDigestUpdate_value_len;
      char *c_DecryptDigestUpdate_value_val;
    } c_DecryptDigestUpdate_value;
  };
  typedef struct ck_rv_c_DecryptDigestUpdate ck_rv_c_DecryptDigestUpdate;

  struct ck_rv_c_SignEncryptUpdate {
    rpc_ck_rv_t c_SignEncryptUpdate_rv;
    struct {
      u_int c_SignEncryptUpdate_value_len;
      char *c_SignEncryptUpdate_value_val;
    } c_SignEncryptUpdate_value;
  };
  typedef struct ck_rv_c_SignEncryptUpdate ck_rv_c_SignEncryptUpdate;

  struct ck_rv_c_DecryptVerifyUpdate {
    rpc_ck_rv_t c_DecryptVerifyUpdate_rv;
    struct {
      u_int c_DecryptVerifyUpdate_value_len;
      char *c_DecryptVerifyUpdate_value_val;
    } c_DecryptVerifyUpdate_value;
  };
  typedef struct ck_rv_c_DecryptVerifyUpdate ck_rv_c_DecryptVerifyUpdate;

  struct ck_rv_c_GetOperationState {
    rpc_ck_rv_t c_GetOperationState_rv;
    struct {
      u_int c_GetOperationState_value_len;
      char *c_GetOperationState_value_val;
    } c_GetOperationState_value;
  };
  typedef struct ck_rv_c_GetOperationState ck_rv_c_GetOperationState;

  struct c_getslotlist_3_argument {
    pkcs11_int arg1;
    pkcs11_int arg2;
  };
  typedef struct c_getslotlist_3_argument c_getslotlist_3_argument;

  struct c_login_3_argument {
    rpc_ck_session_handle_t arg1;
    rpc_ck_user_type_t arg2;
    opaque_data arg3;
  };
  typedef struct c_login_3_argument c_login_3_argument;

  struct c_opensession_3_argument {
    rpc_ck_slot_id_t arg1;
    rpc_ck_flags_t arg2;
  };
  typedef struct c_opensession_3_argument c_opensession_3_argument;

  struct c_getmechanismlist_3_argument {
    rpc_ck_slot_id_t arg1;
    pkcs11_int arg2;
  };
  typedef struct c_getmechanismlist_3_argument c_getmechanismlist_3_argument;

  struct c_getmechanisminfo_3_argument {
    rpc_ck_slot_id_t arg1;
    rpc_ck_mechanism_type_t arg2;
  };
  typedef struct c_getmechanisminfo_3_argument c_getmechanisminfo_3_argument;

  struct c_initpin_3_argument {
    rpc_ck_session_handle_t arg1;
    opaque_data arg2;
  };
  typedef struct c_initpin_3_argument c_initpin_3_argument;

  struct c_setpin_3_argument {
    rpc_ck_session_handle_t arg1;
    opaque_data arg2;
    opaque_data arg3;
  };
  typedef struct c_setpin_3_argument c_setpin_3_argument;

  struct c_seedrandom_3_argument {
    rpc_ck_session_handle_t arg1;
    opaque_data arg2;
  };
  typedef struct c_seedrandom_3_argument c_seedrandom_3_argument;

  struct c_inittoken_3_argument {
    rpc_ck_slot_id_t arg1;
    opaque_data arg2;
    opaque_data arg3;
  };
  typedef struct c_inittoken_3_argument c_inittoken_3_argument;

  struct c_generaterandom_3_argument {
    rpc_ck_session_handle_t arg1;
    pkcs11_int arg2;
  };
  typedef struct c_generaterandom_3_argument c_generaterandom_3_argument;

  struct c_findobjectsinit_3_argument {
    rpc_ck_session_handle_t arg1;
    rpc_ck_attribute_array arg2;
  };
  typedef struct c_findobjectsinit_3_argument c_findobjectsinit_3_argument;

  struct c_findobjects_3_argument {
    rpc_ck_session_handle_t arg1;
    pkcs11_int arg2;
  };
  typedef struct c_findobjects_3_argument c_findobjects_3_argument;

  struct c_generatekey_3_argument {
    rpc_ck_session_handle_t arg1;
    rpc_ck_mechanism arg2;
    rpc_ck_attribute_array arg3;
  };
  typedef struct c_generatekey_3_argument c_generatekey_3_argument;

  struct c_generatekeypair_3_argument {
    rpc_ck_session_handle_t arg1;
    rpc_ck_mechanism arg2;
    rpc_ck_attribute_array arg3;
    rpc_ck_attribute_array arg4;
  };
  typedef struct c_generatekeypair_3_argument c_generatekeypair_3_argument;

  struct c_createobject_3_argument {
    rpc_ck_session_handle_t arg1;
    rpc_ck_attribute_array arg2;
  };
  typedef struct c_createobject_3_argument c_createobject_3_argument;

  struct c_copyobject_3_argument {
    rpc_ck_session_handle_t arg1;
    rpc_ck_object_handle_t arg2;
    rpc_ck_attribute_array arg3;
  };
  typedef struct c_copyobject_3_argument c_copyobject_3_argument;

  struct c_destroyobject_3_argument {
    rpc_ck_session_handle_t arg1;
    rpc_ck_object_handle_t arg2;
  };
  typedef struct c_destroyobject_3_argument c_destroyobject_3_argument;

  struct c_getattributevalue_3_argument {
    rpc_ck_session_handle_t arg1;
    rpc_ck_object_handle_t arg2;
    rpc_ck_attribute_array arg3;
  };
  typedef struct c_getattributevalue_3_argument c_getattributevalue_3_argument;

  struct c_setattributevalue_3_argument {
    rpc_ck_session_handle_t arg1;
    rpc_ck_object_handle_t arg2;
    rpc_ck_attribute_array arg3;
  };
  typedef struct c_setattributevalue_3_argument c_setattributevalue_3_argument;

  struct c_getobjectsize_3_argument {
    rpc_ck_session_handle_t arg1;
    rpc_ck_object_handle_t arg2;
  };
  typedef struct c_getobjectsize_3_argument c_getobjectsize_3_argument;

  struct c_wrapkey_3_argument {
    rpc_ck_session_handle_t arg1;
    rpc_ck_mechanism arg2;
    rpc_ck_object_handle_t arg3;
    rpc_ck_object_handle_t arg4;
  };
  typedef struct c_wrapkey_3_argument c_wrapkey_3_argument;

  struct c_unwrapkey_3_argument {
    rpc_ck_session_handle_t arg1;
    rpc_ck_mechanism arg2;
    rpc_ck_object_handle_t arg3;
    opaque_data arg4;
    rpc_ck_attribute_array arg5;
  };
  typedef struct c_unwrapkey_3_argument c_unwrapkey_3_argument;

  struct c_derivekey_3_argument {
    rpc_ck_session_handle_t arg1;
    rpc_ck_mechanism arg2;
    rpc_ck_object_handle_t arg3;
    rpc_ck_attribute_array arg4;
  };
  typedef struct c_derivekey_3_argument c_derivekey_3_argument;

  struct c_digestinit_3_argument {
    rpc_ck_session_handle_t arg1;
    rpc_ck_mechanism arg2;
  };
  typedef struct c_digestinit_3_argument c_digestinit_3_argument;

  struct c_digest_3_argument {
    rpc_ck_session_handle_t arg1;
    opaque_data arg2;
  };
  typedef struct c_digest_3_argument c_digest_3_argument;

  struct c_digestupdate_3_argument {
    rpc_ck_session_handle_t arg1;
    opaque_data arg2;
  };
  typedef struct c_digestupdate_3_argument c_digestupdate_3_argument;

  struct c_digestkey_3_argument {
    rpc_ck_session_handle_t arg1;
    rpc_ck_object_handle_t arg2;
  };
  typedef struct c_digestkey_3_argument c_digestkey_3_argument;

  struct c_signinit_3_argument {
    rpc_ck_session_handle_t arg1;
    rpc_ck_mechanism arg2;
    rpc_ck_object_handle_t arg3;
  };
  typedef struct c_signinit_3_argument c_signinit_3_argument;

  struct c_sign_3_argument {
    rpc_ck_session_handle_t arg1;
    opaque_data arg2;
  };
  typedef struct c_sign_3_argument c_sign_3_argument;

  struct c_signupdate_3_argument {
    rpc_ck_session_handle_t arg1;
    opaque_data arg2;
  };
  typedef struct c_signupdate_3_argument c_signupdate_3_argument;

  struct c_verifyinit_3_argument {
    rpc_ck_session_handle_t arg1;
    rpc_ck_mechanism arg2;
    rpc_ck_object_handle_t arg3;
  };
  typedef struct c_verifyinit_3_argument c_verifyinit_3_argument;

  struct c_verify_3_argument {
    rpc_ck_session_handle_t arg1;
    opaque_data arg2;
    opaque_data arg3;
  };
  typedef struct c_verify_3_argument c_verify_3_argument;

  struct c_verifyupdate_3_argument {
    rpc_ck_session_handle_t arg1;
    opaque_data arg2;
  };
  typedef struct c_verifyupdate_3_argument c_verifyupdate_3_argument;

  struct c_verifyfinal_3_argument {
    rpc_ck_session_handle_t arg1;
    opaque_data arg2;
  };
  typedef struct c_verifyfinal_3_argument c_verifyfinal_3_argument;

  struct c_encryptinit_3_argument {
    rpc_ck_session_handle_t arg1;
    rpc_ck_mechanism arg2;
    rpc_ck_object_handle_t arg3;
  };
  typedef struct c_encryptinit_3_argument c_encryptinit_3_argument;

  struct c_encrypt_3_argument {
    rpc_ck_session_handle_t arg1;
    opaque_data arg2;
  };
  typedef struct c_encrypt_3_argument c_encrypt_3_argument;

  struct c_encryptupdate_3_argument {
    rpc_ck_session_handle_t arg1;
    opaque_data arg2;
  };
  typedef struct c_encryptupdate_3_argument c_encryptupdate_3_argument;

  struct c_decryptinit_3_argument {
    rpc_ck_session_handle_t arg1;
    rpc_ck_mechanism arg2;
    rpc_ck_object_handle_t arg3;
  };
  typedef struct c_decryptinit_3_argument c_decryptinit_3_argument;

  struct c_decrypt_3_argument {
    rpc_ck_session_handle_t arg1;
    opaque_data arg2;
  };
  typedef struct c_decrypt_3_argument c_decrypt_3_argument;

  struct c_decryptupdate_3_argument {
    rpc_ck_session_handle_t arg1;
    opaque_data arg2;
  };
  typedef struct c_decryptupdate_3_argument c_decryptupdate_3_argument;

  struct c_signrecoverinit_3_argument {
    rpc_ck_session_handle_t arg1;
    rpc_ck_mechanism arg2;
    rpc_ck_object_handle_t arg3;
  };
  typedef struct c_signrecoverinit_3_argument c_signrecoverinit_3_argument;

  struct c_signrecover_3_argument {
    rpc_ck_session_handle_t arg1;
    opaque_data arg2;
  };
  typedef struct c_signrecover_3_argument c_signrecover_3_argument;

  struct c_verifyrecoverinit_3_argument {
    rpc_ck_session_handle_t arg1;
    rpc_ck_mechanism arg2;
    rpc_ck_object_handle_t arg3;
  };
  typedef struct c_verifyrecoverinit_3_argument c_verifyrecoverinit_3_argument;

  struct c_verifyrecover_3_argument {
    rpc_ck_session_handle_t arg1;
    opaque_data arg2;
  };
  typedef struct c_verifyrecover_3_argument c_verifyrecover_3_argument;

  struct c_digestencryptupdate_3_argument {
    rpc_ck_session_handle_t arg1;
    opaque_data arg2;
  };
  typedef struct c_digestencryptupdate_3_argument
   c_digestencryptupdate_3_argument;

  struct c_signencryptupdate_3_argument {
    rpc_ck_session_handle_t arg1;
    opaque_data arg2;
  };
  typedef struct c_signencryptupdate_3_argument c_signencryptupdate_3_argument;

  struct c_decryptdigestupdate_3_argument {
    rpc_ck_session_handle_t arg1;
    opaque_data arg2;
  };
  typedef struct c_decryptdigestupdate_3_argument
   c_decryptdigestupdate_3_argument;

  struct c_decryptverifyupdate_3_argument {
    rpc_ck_session_handle_t arg1;
    opaque_data arg2;
  };
  typedef struct c_decryptverifyupdate_3_argument
   c_decryptverifyupdate_3_argument;

  struct c_setoperationstate_3_argument {
    rpc_ck_session_handle_t arg1;
    opaque_data arg2;
    rpc_ck_object_handle_t arg3;
    rpc_ck_object_handle_t arg4;
  };
  typedef struct c_setoperationstate_3_argument c_setoperationstate_3_argument;

#define P 4
#define V 3

#if defined(__STDC__) || defined(__cplusplus)
#define c_SetupArch 2
  extern enum clnt_stat c_setuparch_3(pkcs11_int, rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_setuparch_3_svc(pkcs11_int, rpc_ck_rv_t *, struct svc_req *);
#define c_Initialize 3
  extern enum clnt_stat c_initialize_3(rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_initialize_3_svc(rpc_ck_rv_t *, struct svc_req *);
#define c_GetSlotList 4
  extern enum clnt_stat c_getslotlist_3(pkcs11_int, pkcs11_int,
					ck_rv_c_GetSlotList *, CLIENT *);
  extern bool_t c_getslotlist_3_svc(pkcs11_int, pkcs11_int,
				    ck_rv_c_GetSlotList *, struct svc_req *);
#define c_GetInfo 5
  extern enum clnt_stat c_getinfo_3(ck_rv_c_GetInfo *, CLIENT *);
  extern bool_t c_getinfo_3_svc(ck_rv_c_GetInfo *, struct svc_req *);
#define c_WaitForSlotEvent 6
  extern enum clnt_stat c_waitforslotevent_3(rpc_ck_flags_t,
					     ck_rv_c_WaitForSlotEvent *,
					     CLIENT *);
  extern bool_t c_waitforslotevent_3_svc(rpc_ck_flags_t,
					 ck_rv_c_WaitForSlotEvent *,
					 struct svc_req *);
#define c_GetSlotInfo 7
  extern enum clnt_stat c_getslotinfo_3(rpc_ck_slot_id_t, ck_rv_c_GetSlotInfo *,
					CLIENT *);
  extern bool_t c_getslotinfo_3_svc(rpc_ck_slot_id_t, ck_rv_c_GetSlotInfo *,
				    struct svc_req *);
#define c_GetTokenInfo 8
  extern enum clnt_stat c_gettokeninfo_3(rpc_ck_slot_id_t,
					 ck_rv_c_GetTokenInfo *, CLIENT *);
  extern bool_t c_gettokeninfo_3_svc(rpc_ck_slot_id_t, ck_rv_c_GetTokenInfo *,
				     struct svc_req *);
#define c_Login 9
  extern enum clnt_stat c_login_3(rpc_ck_session_handle_t, rpc_ck_user_type_t,
				  opaque_data, rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_login_3_svc(rpc_ck_session_handle_t, rpc_ck_user_type_t,
			      opaque_data, rpc_ck_rv_t *, struct svc_req *);
#define c_Logout 10
  extern enum clnt_stat c_logout_3(rpc_ck_session_handle_t, rpc_ck_rv_t *,
				   CLIENT *);
  extern bool_t c_logout_3_svc(rpc_ck_session_handle_t, rpc_ck_rv_t *,
			       struct svc_req *);
#define c_OpenSession 11
  extern enum clnt_stat c_opensession_3(rpc_ck_slot_id_t, rpc_ck_flags_t,
					ck_rv_c_OpenSession *, CLIENT *);
  extern bool_t c_opensession_3_svc(rpc_ck_slot_id_t, rpc_ck_flags_t,
				    ck_rv_c_OpenSession *, struct svc_req *);
#define c_CloseSession 12
  extern enum clnt_stat c_closesession_3(rpc_ck_session_handle_t, rpc_ck_rv_t *,
					 CLIENT *);
  extern bool_t c_closesession_3_svc(rpc_ck_session_handle_t, rpc_ck_rv_t *,
				     struct svc_req *);
#define c_Finalize 13
  extern enum clnt_stat c_finalize_3(rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_finalize_3_svc(rpc_ck_rv_t *, struct svc_req *);
#define c_GetMechanismList 14
  extern enum clnt_stat c_getmechanismlist_3(rpc_ck_slot_id_t, pkcs11_int,
					     ck_rv_c_GetMechanismList *,
					     CLIENT *);
  extern bool_t c_getmechanismlist_3_svc(rpc_ck_slot_id_t, pkcs11_int,
					 ck_rv_c_GetMechanismList *,
					 struct svc_req *);
#define c_CloseAllSessions 15
  extern enum clnt_stat c_closeallsessions_3(rpc_ck_slot_id_t, rpc_ck_rv_t *,
					     CLIENT *);
  extern bool_t c_closeallsessions_3_svc(rpc_ck_slot_id_t, rpc_ck_rv_t *,
					 struct svc_req *);
#define c_GetSessionInfo 16
  extern enum clnt_stat c_getsessioninfo_3(rpc_ck_session_handle_t,
					   ck_rv_c_GetSessionInfo *, CLIENT *);
  extern bool_t c_getsessioninfo_3_svc(rpc_ck_session_handle_t,
				       ck_rv_c_GetSessionInfo *,
				       struct svc_req *);
#define c_GetMechanismInfo 17
  extern enum clnt_stat c_getmechanisminfo_3(rpc_ck_slot_id_t,
					     rpc_ck_mechanism_type_t,
					     ck_rv_c_GetMechanismInfo *,
					     CLIENT *);
  extern bool_t c_getmechanisminfo_3_svc(rpc_ck_slot_id_t,
					 rpc_ck_mechanism_type_t,
					 ck_rv_c_GetMechanismInfo *,
					 struct svc_req *);
#define c_InitPIN 18
  extern enum clnt_stat c_initpin_3(rpc_ck_session_handle_t, opaque_data,
				    rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_initpin_3_svc(rpc_ck_session_handle_t, opaque_data,
				rpc_ck_rv_t *, struct svc_req *);
#define c_SetPIN 19
  extern enum clnt_stat c_setpin_3(rpc_ck_session_handle_t, opaque_data,
				   opaque_data, rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_setpin_3_svc(rpc_ck_session_handle_t, opaque_data,
			       opaque_data, rpc_ck_rv_t *, struct svc_req *);
#define c_SeedRandom 20
  extern enum clnt_stat c_seedrandom_3(rpc_ck_session_handle_t, opaque_data,
				       rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_seedrandom_3_svc(rpc_ck_session_handle_t, opaque_data,
				   rpc_ck_rv_t *, struct svc_req *);
#define c_InitToken 21
  extern enum clnt_stat c_inittoken_3(rpc_ck_slot_id_t, opaque_data,
				      opaque_data, rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_inittoken_3_svc(rpc_ck_slot_id_t, opaque_data, opaque_data,
				  rpc_ck_rv_t *, struct svc_req *);
#define c_GenerateRandom 22
  extern enum clnt_stat c_generaterandom_3(rpc_ck_session_handle_t, pkcs11_int,
					   ck_rv_c_GenerateRandom *, CLIENT *);
  extern bool_t c_generaterandom_3_svc(rpc_ck_session_handle_t, pkcs11_int,
				       ck_rv_c_GenerateRandom *,
				       struct svc_req *);
#define c_FindObjectsInit 23
  extern enum clnt_stat c_findobjectsinit_3(rpc_ck_session_handle_t,
					    rpc_ck_attribute_array,
					    rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_findobjectsinit_3_svc(rpc_ck_session_handle_t,
					rpc_ck_attribute_array, rpc_ck_rv_t *,
					struct svc_req *);
#define c_FindObjects 24
  extern enum clnt_stat c_findobjects_3(rpc_ck_session_handle_t, pkcs11_int,
					ck_rv_c_FindObjects *, CLIENT *);
  extern bool_t c_findobjects_3_svc(rpc_ck_session_handle_t, pkcs11_int,
				    ck_rv_c_FindObjects *, struct svc_req *);
#define c_FindObjectsFinal 25
  extern enum clnt_stat c_findobjectsfinal_3(rpc_ck_session_handle_t,
					     rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_findobjectsfinal_3_svc(rpc_ck_session_handle_t, rpc_ck_rv_t *,
					 struct svc_req *);
#define c_GenerateKey 26
  extern enum clnt_stat c_generatekey_3(rpc_ck_session_handle_t,
					rpc_ck_mechanism,
					rpc_ck_attribute_array,
					ck_rv_c_GenerateKey *, CLIENT *);
  extern bool_t c_generatekey_3_svc(rpc_ck_session_handle_t, rpc_ck_mechanism,
				    rpc_ck_attribute_array,
				    ck_rv_c_GenerateKey *, struct svc_req *);
#define c_GenerateKeyPair 27
  extern enum clnt_stat c_generatekeypair_3(rpc_ck_session_handle_t,
					    rpc_ck_mechanism,
					    rpc_ck_attribute_array,
					    rpc_ck_attribute_array,
					    ck_rv_c_GenerateKeyPair *,
					    CLIENT *);
  extern bool_t c_generatekeypair_3_svc(rpc_ck_session_handle_t,
					rpc_ck_mechanism,
					rpc_ck_attribute_array,
					rpc_ck_attribute_array,
					ck_rv_c_GenerateKeyPair *,
					struct svc_req *);
#define c_CreateObject 28
  extern enum clnt_stat c_createobject_3(rpc_ck_session_handle_t,
					 rpc_ck_attribute_array,
					 ck_rv_c_CreateObject *, CLIENT *);
  extern bool_t c_createobject_3_svc(rpc_ck_session_handle_t,
				     rpc_ck_attribute_array,
				     ck_rv_c_CreateObject *, struct svc_req *);
#define c_CopyObject 29
  extern enum clnt_stat c_copyobject_3(rpc_ck_session_handle_t,
				       rpc_ck_object_handle_t,
				       rpc_ck_attribute_array,
				       ck_rv_c_CopyObject *, CLIENT *);
  extern bool_t c_copyobject_3_svc(rpc_ck_session_handle_t,
				   rpc_ck_object_handle_t,
				   rpc_ck_attribute_array, ck_rv_c_CopyObject *,
				   struct svc_req *);
#define c_DestroyObject 30
  extern enum clnt_stat c_destroyobject_3(rpc_ck_session_handle_t,
					  rpc_ck_object_handle_t, rpc_ck_rv_t *,
					  CLIENT *);
  extern bool_t c_destroyobject_3_svc(rpc_ck_session_handle_t,
				      rpc_ck_object_handle_t, rpc_ck_rv_t *,
				      struct svc_req *);
#define c_GetAttributeValue 31
  extern enum clnt_stat c_getattributevalue_3(rpc_ck_session_handle_t,
					      rpc_ck_object_handle_t,
					      rpc_ck_attribute_array,
					      ck_rv_c_GetAttributeValue *,
					      CLIENT *);
  extern bool_t c_getattributevalue_3_svc(rpc_ck_session_handle_t,
					  rpc_ck_object_handle_t,
					  rpc_ck_attribute_array,
					  ck_rv_c_GetAttributeValue *,
					  struct svc_req *);
#define c_SetAttributeValue 32
  extern enum clnt_stat c_setattributevalue_3(rpc_ck_session_handle_t,
					      rpc_ck_object_handle_t,
					      rpc_ck_attribute_array,
					      rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_setattributevalue_3_svc(rpc_ck_session_handle_t,
					  rpc_ck_object_handle_t,
					  rpc_ck_attribute_array, rpc_ck_rv_t *,
					  struct svc_req *);
#define c_GetObjectSize 33
  extern enum clnt_stat c_getobjectsize_3(rpc_ck_session_handle_t,
					  rpc_ck_object_handle_t,
					  ck_rv_c_GetObjectSize *, CLIENT *);
  extern bool_t c_getobjectsize_3_svc(rpc_ck_session_handle_t,
				      rpc_ck_object_handle_t,
				      ck_rv_c_GetObjectSize *,
				      struct svc_req *);
#define c_WrapKey 34
  extern enum clnt_stat c_wrapkey_3(rpc_ck_session_handle_t, rpc_ck_mechanism,
				    rpc_ck_object_handle_t,
				    rpc_ck_object_handle_t, ck_rv_c_WrapKey *,
				    CLIENT *);
  extern bool_t c_wrapkey_3_svc(rpc_ck_session_handle_t, rpc_ck_mechanism,
				rpc_ck_object_handle_t, rpc_ck_object_handle_t,
				ck_rv_c_WrapKey *, struct svc_req *);
#define c_UnwrapKey 35
  extern enum clnt_stat c_unwrapkey_3(rpc_ck_session_handle_t, rpc_ck_mechanism,
				      rpc_ck_object_handle_t, opaque_data,
				      rpc_ck_attribute_array,
				      ck_rv_c_UnwrapKey *, CLIENT *);
  extern bool_t c_unwrapkey_3_svc(rpc_ck_session_handle_t, rpc_ck_mechanism,
				  rpc_ck_object_handle_t, opaque_data,
				  rpc_ck_attribute_array, ck_rv_c_UnwrapKey *,
				  struct svc_req *);
#define c_DeriveKey 36
  extern enum clnt_stat c_derivekey_3(rpc_ck_session_handle_t, rpc_ck_mechanism,
				      rpc_ck_object_handle_t,
				      rpc_ck_attribute_array,
				      ck_rv_c_DeriveKey *, CLIENT *);
  extern bool_t c_derivekey_3_svc(rpc_ck_session_handle_t, rpc_ck_mechanism,
				  rpc_ck_object_handle_t,
				  rpc_ck_attribute_array, ck_rv_c_DeriveKey *,
				  struct svc_req *);
#define c_DigestInit 37
  extern enum clnt_stat c_digestinit_3(rpc_ck_session_handle_t,
				       rpc_ck_mechanism, rpc_ck_rv_t *,
				       CLIENT *);
  extern bool_t c_digestinit_3_svc(rpc_ck_session_handle_t, rpc_ck_mechanism,
				   rpc_ck_rv_t *, struct svc_req *);
#define c_Digest 38
  extern enum clnt_stat c_digest_3(rpc_ck_session_handle_t, opaque_data,
				   ck_rv_c_Digest *, CLIENT *);
  extern bool_t c_digest_3_svc(rpc_ck_session_handle_t, opaque_data,
			       ck_rv_c_Digest *, struct svc_req *);
#define c_DigestUpdate 39
  extern enum clnt_stat c_digestupdate_3(rpc_ck_session_handle_t, opaque_data,
					 rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_digestupdate_3_svc(rpc_ck_session_handle_t, opaque_data,
				     rpc_ck_rv_t *, struct svc_req *);
#define c_DigestFinal 40
  extern enum clnt_stat c_digestfinal_3(rpc_ck_session_handle_t,
					ck_rv_c_DigestFinal *, CLIENT *);
  extern bool_t c_digestfinal_3_svc(rpc_ck_session_handle_t,
				    ck_rv_c_DigestFinal *, struct svc_req *);
#define c_DigestKey 41
  extern enum clnt_stat c_digestkey_3(rpc_ck_session_handle_t,
				      rpc_ck_object_handle_t, rpc_ck_rv_t *,
				      CLIENT *);
  extern bool_t c_digestkey_3_svc(rpc_ck_session_handle_t,
				  rpc_ck_object_handle_t, rpc_ck_rv_t *,
				  struct svc_req *);
#define c_SignInit 42
  extern enum clnt_stat c_signinit_3(rpc_ck_session_handle_t, rpc_ck_mechanism,
				     rpc_ck_object_handle_t, rpc_ck_rv_t *,
				     CLIENT *);
  extern bool_t c_signinit_3_svc(rpc_ck_session_handle_t, rpc_ck_mechanism,
				 rpc_ck_object_handle_t, rpc_ck_rv_t *,
				 struct svc_req *);
#define c_Sign 43
  extern enum clnt_stat c_sign_3(rpc_ck_session_handle_t, opaque_data,
				 ck_rv_c_Sign *, CLIENT *);
  extern bool_t c_sign_3_svc(rpc_ck_session_handle_t, opaque_data,
			     ck_rv_c_Sign *, struct svc_req *);
#define c_SignUpdate 44
  extern enum clnt_stat c_signupdate_3(rpc_ck_session_handle_t, opaque_data,
				       rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_signupdate_3_svc(rpc_ck_session_handle_t, opaque_data,
				   rpc_ck_rv_t *, struct svc_req *);
#define c_SignFinal 45
  extern enum clnt_stat c_signfinal_3(rpc_ck_session_handle_t,
				      ck_rv_c_SignFinal *, CLIENT *);
  extern bool_t c_signfinal_3_svc(rpc_ck_session_handle_t, ck_rv_c_SignFinal *,
				  struct svc_req *);
#define c_VerifyInit 46
  extern enum clnt_stat c_verifyinit_3(rpc_ck_session_handle_t,
				       rpc_ck_mechanism, rpc_ck_object_handle_t,
				       rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_verifyinit_3_svc(rpc_ck_session_handle_t, rpc_ck_mechanism,
				   rpc_ck_object_handle_t, rpc_ck_rv_t *,
				   struct svc_req *);
#define c_Verify 47
  extern enum clnt_stat c_verify_3(rpc_ck_session_handle_t, opaque_data,
				   opaque_data, rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_verify_3_svc(rpc_ck_session_handle_t, opaque_data,
			       opaque_data, rpc_ck_rv_t *, struct svc_req *);
#define c_VerifyUpdate 48
  extern enum clnt_stat c_verifyupdate_3(rpc_ck_session_handle_t, opaque_data,
					 rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_verifyupdate_3_svc(rpc_ck_session_handle_t, opaque_data,
				     rpc_ck_rv_t *, struct svc_req *);
#define c_VerifyFinal 49
  extern enum clnt_stat c_verifyfinal_3(rpc_ck_session_handle_t, opaque_data,
					rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_verifyfinal_3_svc(rpc_ck_session_handle_t, opaque_data,
				    rpc_ck_rv_t *, struct svc_req *);
#define c_EncryptInit 50
  extern enum clnt_stat c_encryptinit_3(rpc_ck_session_handle_t,
					rpc_ck_mechanism,
					rpc_ck_object_handle_t, rpc_ck_rv_t *,
					CLIENT *);
  extern bool_t c_encryptinit_3_svc(rpc_ck_session_handle_t, rpc_ck_mechanism,
				    rpc_ck_object_handle_t, rpc_ck_rv_t *,
				    struct svc_req *);
#define c_Encrypt 51
  extern enum clnt_stat c_encrypt_3(rpc_ck_session_handle_t, opaque_data,
				    ck_rv_c_Encrypt *, CLIENT *);
  extern bool_t c_encrypt_3_svc(rpc_ck_session_handle_t, opaque_data,
				ck_rv_c_Encrypt *, struct svc_req *);
#define c_EncryptUpdate 52
  extern enum clnt_stat c_encryptupdate_3(rpc_ck_session_handle_t, opaque_data,
					  ck_rv_c_EncryptUpdate *, CLIENT *);
  extern bool_t c_encryptupdate_3_svc(rpc_ck_session_handle_t, opaque_data,
				      ck_rv_c_EncryptUpdate *,
				      struct svc_req *);
#define c_EncryptFinal 53
  extern enum clnt_stat c_encryptfinal_3(rpc_ck_session_handle_t,
					 ck_rv_c_EncryptFinal *, CLIENT *);
  extern bool_t c_encryptfinal_3_svc(rpc_ck_session_handle_t,
				     ck_rv_c_EncryptFinal *, struct svc_req *);
#define c_DecryptInit 54
  extern enum clnt_stat c_decryptinit_3(rpc_ck_session_handle_t,
					rpc_ck_mechanism,
					rpc_ck_object_handle_t, rpc_ck_rv_t *,
					CLIENT *);
  extern bool_t c_decryptinit_3_svc(rpc_ck_session_handle_t, rpc_ck_mechanism,
				    rpc_ck_object_handle_t, rpc_ck_rv_t *,
				    struct svc_req *);
#define c_Decrypt 55
  extern enum clnt_stat c_decrypt_3(rpc_ck_session_handle_t, opaque_data,
				    ck_rv_c_Decrypt *, CLIENT *);
  extern bool_t c_decrypt_3_svc(rpc_ck_session_handle_t, opaque_data,
				ck_rv_c_Decrypt *, struct svc_req *);
#define c_DecryptUpdate 56
  extern enum clnt_stat c_decryptupdate_3(rpc_ck_session_handle_t, opaque_data,
					  ck_rv_c_DecryptUpdate *, CLIENT *);
  extern bool_t c_decryptupdate_3_svc(rpc_ck_session_handle_t, opaque_data,
				      ck_rv_c_DecryptUpdate *,
				      struct svc_req *);
#define c_DecryptFinal 57
  extern enum clnt_stat c_decryptfinal_3(rpc_ck_session_handle_t,
					 ck_rv_c_DecryptFinal *, CLIENT *);
  extern bool_t c_decryptfinal_3_svc(rpc_ck_session_handle_t,
				     ck_rv_c_DecryptFinal *, struct svc_req *);
#define c_SignRecoverInit 58
  extern enum clnt_stat c_signrecoverinit_3(rpc_ck_session_handle_t,
					    rpc_ck_mechanism,
					    rpc_ck_object_handle_t,
					    rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_signrecoverinit_3_svc(rpc_ck_session_handle_t,
					rpc_ck_mechanism,
					rpc_ck_object_handle_t, rpc_ck_rv_t *,
					struct svc_req *);
#define c_SignRecover 59
  extern enum clnt_stat c_signrecover_3(rpc_ck_session_handle_t, opaque_data,
					ck_rv_c_SignRecover *, CLIENT *);
  extern bool_t c_signrecover_3_svc(rpc_ck_session_handle_t, opaque_data,
				    ck_rv_c_SignRecover *, struct svc_req *);
#define c_VerifyRecoverInit 60
  extern enum clnt_stat c_verifyrecoverinit_3(rpc_ck_session_handle_t,
					      rpc_ck_mechanism,
					      rpc_ck_object_handle_t,
					      rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_verifyrecoverinit_3_svc(rpc_ck_session_handle_t,
					  rpc_ck_mechanism,
					  rpc_ck_object_handle_t, rpc_ck_rv_t *,
					  struct svc_req *);
#define c_VerifyRecover 61
  extern enum clnt_stat c_verifyrecover_3(rpc_ck_session_handle_t, opaque_data,
					  ck_rv_c_VerifyRecover *, CLIENT *);
  extern bool_t c_verifyrecover_3_svc(rpc_ck_session_handle_t, opaque_data,
				      ck_rv_c_VerifyRecover *,
				      struct svc_req *);
#define c_DigestEncryptUpdate 62
  extern enum clnt_stat c_digestencryptupdate_3(rpc_ck_session_handle_t,
						opaque_data,
						ck_rv_c_DigestEncryptUpdate *,
						CLIENT *);
  extern bool_t c_digestencryptupdate_3_svc(rpc_ck_session_handle_t,
					    opaque_data,
					    ck_rv_c_DigestEncryptUpdate *,
					    struct svc_req *);
#define c_SignEncryptUpdate 63
  extern enum clnt_stat c_signencryptupdate_3(rpc_ck_session_handle_t,
					      opaque_data,
					      ck_rv_c_SignEncryptUpdate *,
					      CLIENT *);
  extern bool_t c_signencryptupdate_3_svc(rpc_ck_session_handle_t, opaque_data,
					  ck_rv_c_SignEncryptUpdate *,
					  struct svc_req *);
#define c_DecryptDigestUpdate 64
  extern enum clnt_stat c_decryptdigestupdate_3(rpc_ck_session_handle_t,
						opaque_data,
						ck_rv_c_DecryptDigestUpdate *,
						CLIENT *);
  extern bool_t c_decryptdigestupdate_3_svc(rpc_ck_session_handle_t,
					    opaque_data,
					    ck_rv_c_DecryptDigestUpdate *,
					    struct svc_req *);
#define c_DecryptVerifyUpdate 65
  extern enum clnt_stat c_decryptverifyupdate_3(rpc_ck_session_handle_t,
						opaque_data,
						ck_rv_c_DecryptVerifyUpdate *,
						CLIENT *);
  extern bool_t c_decryptverifyupdate_3_svc(rpc_ck_session_handle_t,
					    opaque_data,
					    ck_rv_c_DecryptVerifyUpdate *,
					    struct svc_req *);
#define c_GetOperationState 66
  extern enum clnt_stat c_getoperationstate_3(rpc_ck_session_handle_t,
					      ck_rv_c_GetOperationState *,
					      CLIENT *);
  extern bool_t c_getoperationstate_3_svc(rpc_ck_session_handle_t,
					  ck_rv_c_GetOperationState *,
					  struct svc_req *);
#define c_SetOperationState 67
  extern enum clnt_stat c_setoperationstate_3(rpc_ck_session_handle_t,
					      opaque_data,
					      rpc_ck_object_handle_t,
					      rpc_ck_object_handle_t,
					      rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_setoperationstate_3_svc(rpc_ck_session_handle_t, opaque_data,
					  rpc_ck_object_handle_t,
					  rpc_ck_object_handle_t, rpc_ck_rv_t *,
					  struct svc_req *);
#define c_GetFunctionStatus 68
  extern enum clnt_stat c_getfunctionstatus_3(rpc_ck_session_handle_t,
					      rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_getfunctionstatus_3_svc(rpc_ck_session_handle_t,
					  rpc_ck_rv_t *, struct svc_req *);
#define c_CancelFunction 69
  extern enum clnt_stat c_cancelfunction_3(rpc_ck_session_handle_t,
					   rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_cancelfunction_3_svc(rpc_ck_session_handle_t, rpc_ck_rv_t *,
				       struct svc_req *);
#define c_LoadModule 70
  extern enum clnt_stat c_loadmodule_3(opaque_data, rpc_ck_rv_t *, CLIENT *);
  extern bool_t c_loadmodule_3_svc(opaque_data, rpc_ck_rv_t *,
				   struct svc_req *);
  extern int p_3_freeresult(SVCXPRT *, xdrproc_t, caddr_t);

#else				/* K&R C */
#define c_SetupArch 2
  extern enum clnt_stat c_setuparch_3();
  extern bool_t c_setuparch_3_svc();
#define c_Initialize 3
  extern enum clnt_stat c_initialize_3();
  extern bool_t c_initialize_3_svc();
#define c_GetSlotList 4
  extern enum clnt_stat c_getslotlist_3();
  extern bool_t c_getslotlist_3_svc();
#define c_GetInfo 5
  extern enum clnt_stat c_getinfo_3();
  extern bool_t c_getinfo_3_svc();
#define c_WaitForSlotEvent 6
  extern enum clnt_stat c_waitforslotevent_3();
  extern bool_t c_waitforslotevent_3_svc();
#define c_GetSlotInfo 7
  extern enum clnt_stat c_getslotinfo_3();
  extern bool_t c_getslotinfo_3_svc();
#define c_GetTokenInfo 8
  extern enum clnt_stat c_gettokeninfo_3();
  extern bool_t c_gettokeninfo_3_svc();
#define c_Login 9
  extern enum clnt_stat c_login_3();
  extern bool_t c_login_3_svc();
#define c_Logout 10
  extern enum clnt_stat c_logout_3();
  extern bool_t c_logout_3_svc();
#define c_OpenSession 11
  extern enum clnt_stat c_opensession_3();
  extern bool_t c_opensession_3_svc();
#define c_CloseSession 12
  extern enum clnt_stat c_closesession_3();
  extern bool_t c_closesession_3_svc();
#define c_Finalize 13
  extern enum clnt_stat c_finalize_3();
  extern bool_t c_finalize_3_svc();
#define c_GetMechanismList 14
  extern enum clnt_stat c_getmechanismlist_3();
  extern bool_t c_getmechanismlist_3_svc();
#define c_CloseAllSessions 15
  extern enum clnt_stat c_closeallsessions_3();
  extern bool_t c_closeallsessions_3_svc();
#define c_GetSessionInfo 16
  extern enum clnt_stat c_getsessioninfo_3();
  extern bool_t c_getsessioninfo_3_svc();
#define c_GetMechanismInfo 17
  extern enum clnt_stat c_getmechanisminfo_3();
  extern bool_t c_getmechanisminfo_3_svc();
#define c_InitPIN 18
  extern enum clnt_stat c_initpin_3();
  extern bool_t c_initpin_3_svc();
#define c_SetPIN 19
  extern enum clnt_stat c_setpin_3();
  extern bool_t c_setpin_3_svc();
#define c_SeedRandom 20
  extern enum clnt_stat c_seedrandom_3();
  extern bool_t c_seedrandom_3_svc();
#define c_InitToken 21
  extern enum clnt_stat c_inittoken_3();
  extern bool_t c_inittoken_3_svc();
#define c_GenerateRandom 22
  extern enum clnt_stat c_generaterandom_3();
  extern bool_t c_generaterandom_3_svc();
#define c_FindObjectsInit 23
  extern enum clnt_stat c_findobjectsinit_3();
  extern bool_t c_findobjectsinit_3_svc();
#define c_FindObjects 24
  extern enum clnt_stat c_findobjects_3();
  extern bool_t c_findobjects_3_svc();
#define c_FindObjectsFinal 25
  extern enum clnt_stat c_findobjectsfinal_3();
  extern bool_t c_findobjectsfinal_3_svc();
#define c_GenerateKey 26
  extern enum clnt_stat c_generatekey_3();
  extern bool_t c_generatekey_3_svc();
#define c_GenerateKeyPair 27
  extern enum clnt_stat c_generatekeypair_3();
  extern bool_t c_generatekeypair_3_svc();
#define c_CreateObject 28
  extern enum clnt_stat c_createobject_3();
  extern bool_t c_createobject_3_svc();
#define c_CopyObject 29
  extern enum clnt_stat c_copyobject_3();
  extern bool_t c_copyobject_3_svc();
#define c_DestroyObject 30
  extern enum clnt_stat c_destroyobject_3();
  extern bool_t c_destroyobject_3_svc();
#define c_GetAttributeValue 31
  extern enum clnt_stat c_getattributevalue_3();
  extern bool_t c_getattributevalue_3_svc();
#define c_SetAttributeValue 32
  extern enum clnt_stat c_setattributevalue_3();
  extern bool_t c_setattributevalue_3_svc();
#define c_GetObjectSize 33
  extern enum clnt_stat c_getobjectsize_3();
  extern bool_t c_getobjectsize_3_svc();
#define c_WrapKey 34
  extern enum clnt_stat c_wrapkey_3();
  extern bool_t c_wrapkey_3_svc();
#define c_UnwrapKey 35
  extern enum clnt_stat c_unwrapkey_3();
  extern bool_t c_unwrapkey_3_svc();
#define c_DeriveKey 36
  extern enum clnt_stat c_derivekey_3();
  extern bool_t c_derivekey_3_svc();
#define c_DigestInit 37
  extern enum clnt_stat c_digestinit_3();
  extern bool_t c_digestinit_3_svc();
#define c_Digest 38
  extern enum clnt_stat c_digest_3();
  extern bool_t c_digest_3_svc();
#define c_DigestUpdate 39
  extern enum clnt_stat c_digestupdate_3();
  extern bool_t c_digestupdate_3_svc();
#define c_DigestFinal 40
  extern enum clnt_stat c_digestfinal_3();
  extern bool_t c_digestfinal_3_svc();
#define c_DigestKey 41
  extern enum clnt_stat c_digestkey_3();
  extern bool_t c_digestkey_3_svc();
#define c_SignInit 42
  extern enum clnt_stat c_signinit_3();
  extern bool_t c_signinit_3_svc();
#define c_Sign 43
  extern enum clnt_stat c_sign_3();
  extern bool_t c_sign_3_svc();
#define c_SignUpdate 44
  extern enum clnt_stat c_signupdate_3();
  extern bool_t c_signupdate_3_svc();
#define c_SignFinal 45
  extern enum clnt_stat c_signfinal_3();
  extern bool_t c_signfinal_3_svc();
#define c_VerifyInit 46
  extern enum clnt_stat c_verifyinit_3();
  extern bool_t c_verifyinit_3_svc();
#define c_Verify 47
  extern enum clnt_stat c_verify_3();
  extern bool_t c_verify_3_svc();
#define c_VerifyUpdate 48
  extern enum clnt_stat c_verifyupdate_3();
  extern bool_t c_verifyupdate_3_svc();
#define c_VerifyFinal 49
  extern enum clnt_stat c_verifyfinal_3();
  extern bool_t c_verifyfinal_3_svc();
#define c_EncryptInit 50
  extern enum clnt_stat c_encryptinit_3();
  extern bool_t c_encryptinit_3_svc();
#define c_Encrypt 51
  extern enum clnt_stat c_encrypt_3();
  extern bool_t c_encrypt_3_svc();
#define c_EncryptUpdate 52
  extern enum clnt_stat c_encryptupdate_3();
  extern bool_t c_encryptupdate_3_svc();
#define c_EncryptFinal 53
  extern enum clnt_stat c_encryptfinal_3();
  extern bool_t c_encryptfinal_3_svc();
#define c_DecryptInit 54
  extern enum clnt_stat c_decryptinit_3();
  extern bool_t c_decryptinit_3_svc();
#define c_Decrypt 55
  extern enum clnt_stat c_decrypt_3();
  extern bool_t c_decrypt_3_svc();
#define c_DecryptUpdate 56
  extern enum clnt_stat c_decryptupdate_3();
  extern bool_t c_decryptupdate_3_svc();
#define c_DecryptFinal 57
  extern enum clnt_stat c_decryptfinal_3();
  extern bool_t c_decryptfinal_3_svc();
#define c_SignRecoverInit 58
  extern enum clnt_stat c_signrecoverinit_3();
  extern bool_t c_signrecoverinit_3_svc();
#define c_SignRecover 59
  extern enum clnt_stat c_signrecover_3();
  extern bool_t c_signrecover_3_svc();
#define c_VerifyRecoverInit 60
  extern enum clnt_stat c_verifyrecoverinit_3();
  extern bool_t c_verifyrecoverinit_3_svc();
#define c_VerifyRecover 61
  extern enum clnt_stat c_verifyrecover_3();
  extern bool_t c_verifyrecover_3_svc();
#define c_DigestEncryptUpdate 62
  extern enum clnt_stat c_digestencryptupdate_3();
  extern bool_t c_digestencryptupdate_3_svc();
#define c_SignEncryptUpdate 63
  extern enum clnt_stat c_signencryptupdate_3();
  extern bool_t c_signencryptupdate_3_svc();
#define c_DecryptDigestUpdate 64
  extern enum clnt_stat c_decryptdigestupdate_3();
  extern bool_t c_decryptdigestupdate_3_svc();
#define c_DecryptVerifyUpdate 65
  extern enum clnt_stat c_decryptverifyupdate_3();
  extern bool_t c_decryptverifyupdate_3_svc();
#define c_GetOperationState 66
  extern enum clnt_stat c_getoperationstate_3();
  extern bool_t c_getoperationstate_3_svc();
#define c_SetOperationState 67
  extern enum clnt_stat c_setoperationstate_3();
  extern bool_t c_setoperationstate_3_svc();
#define c_GetFunctionStatus 68
  extern enum clnt_stat c_getfunctionstatus_3();
  extern bool_t c_getfunctionstatus_3_svc();
#define c_CancelFunction 69
  extern enum clnt_stat c_cancelfunction_3();
  extern bool_t c_cancelfunction_3_svc();
#define c_LoadModule 70
  extern enum clnt_stat c_loadmodule_3();
  extern bool_t c_loadmodule_3_svc();
  extern int p_3_freeresult();
#endif				/* K&R C */

/* the xdr functions */

#if defined(__STDC__) || defined(__cplusplus)
  extern bool_t xdr_pkcs11_int(XDR *, pkcs11_int *);
  extern bool_t xdr_rpc_ck_rv_t(XDR *, rpc_ck_rv_t *);
  extern bool_t xdr_rpc_ck_slot_id_t(XDR *, rpc_ck_slot_id_t *);
  extern bool_t xdr_rpc_ck_mechanism_type_t(XDR *, rpc_ck_mechanism_type_t *);
  extern bool_t xdr_rpc_ck_session_handle_t(XDR *, rpc_ck_session_handle_t *);
  extern bool_t xdr_rpc_ck_user_type_t(XDR *, rpc_ck_user_type_t *);
  extern bool_t xdr_rpc_ck_state_t(XDR *, rpc_ck_state_t *);
  extern bool_t xdr_rpc_ck_object_handle_t(XDR *, rpc_ck_object_handle_t *);
  extern bool_t xdr_rpc_ck_object_class_t(XDR *, rpc_ck_object_class_t *);
  extern bool_t xdr_rpc_ck_hw_feature_type_t(XDR *, rpc_ck_hw_feature_type_t *);
  extern bool_t xdr_rpc_ck_key_type_t(XDR *, rpc_ck_key_type_t *);
  extern bool_t xdr_rpc_ck_certificate_type_t(XDR *,
					      rpc_ck_certificate_type_t *);
  extern bool_t xdr_rpc_ck_attribute_type_t(XDR *, rpc_ck_attribute_type_t *);
  extern bool_t xdr_rpc_ck_flags_t(XDR *, rpc_ck_flags_t *);
  extern bool_t xdr_rpc_ck_notification_t(XDR *, rpc_ck_notification_t *);
  extern bool_t xdr_opaque_data(XDR *, opaque_data *);
  extern bool_t xdr_rpc_ck_version(XDR *, rpc_ck_version *);
  extern bool_t xdr_rpc_ck_info(XDR *, rpc_ck_info *);
  extern bool_t xdr_rpc_ck_slot_info(XDR *, rpc_ck_slot_info *);
  extern bool_t xdr_rpc_ck_token_info(XDR *, rpc_ck_token_info *);
  extern bool_t xdr_rpc_ck_mechanism(XDR *, rpc_ck_mechanism *);
  extern bool_t xdr_rpc_ck_session_info(XDR *, rpc_ck_session_info *);
  extern bool_t xdr_rpc_ck_mechanism_info(XDR *, rpc_ck_mechanism_info *);
  extern bool_t xdr_rpc_ck_attribute(XDR *, rpc_ck_attribute *);
  extern bool_t xdr_rpc_ck_attribute_array(XDR *, rpc_ck_attribute_array *);
  extern bool_t xdr_rpc_ck_date(XDR *, rpc_ck_date *);
  extern bool_t xdr_ck_rv_c_GetSlotList(XDR *, ck_rv_c_GetSlotList *);
  extern bool_t xdr_ck_rv_c_GetSlotInfo(XDR *, ck_rv_c_GetSlotInfo *);
  extern bool_t xdr_ck_rv_c_GetTokenInfo(XDR *, ck_rv_c_GetTokenInfo *);
  extern bool_t xdr_ck_rv_c_GetInfo(XDR *, ck_rv_c_GetInfo *);
  extern bool_t xdr_ck_rv_c_WaitForSlotEvent(XDR *, ck_rv_c_WaitForSlotEvent *);
  extern bool_t xdr_ck_rv_c_OpenSession(XDR *, ck_rv_c_OpenSession *);
  extern bool_t xdr_ck_rv_c_GetMechanismList(XDR *, ck_rv_c_GetMechanismList *);
  extern bool_t xdr_ck_rv_c_GetSessionInfo(XDR *, ck_rv_c_GetSessionInfo *);
  extern bool_t xdr_ck_rv_c_GetMechanismInfo(XDR *, ck_rv_c_GetMechanismInfo *);
  extern bool_t xdr_ck_rv_c_GenerateRandom(XDR *, ck_rv_c_GenerateRandom *);
  extern bool_t xdr_ck_rv_c_FindObjects(XDR *, ck_rv_c_FindObjects *);
  extern bool_t xdr_ck_rv_c_GenerateKey(XDR *, ck_rv_c_GenerateKey *);
  extern bool_t xdr_ck_rv_c_GenerateKeyPair(XDR *, ck_rv_c_GenerateKeyPair *);
  extern bool_t xdr_ck_rv_c_CreateObject(XDR *, ck_rv_c_CreateObject *);
  extern bool_t xdr_ck_rv_c_CopyObject(XDR *, ck_rv_c_CopyObject *);
  extern bool_t xdr_ck_rv_c_GetAttributeValue(XDR *,
					      ck_rv_c_GetAttributeValue *);
  extern bool_t xdr_ck_rv_c_GetObjectSize(XDR *, ck_rv_c_GetObjectSize *);
  extern bool_t xdr_ck_rv_c_WrapKey(XDR *, ck_rv_c_WrapKey *);
  extern bool_t xdr_ck_rv_c_UnwrapKey(XDR *, ck_rv_c_UnwrapKey *);
  extern bool_t xdr_ck_rv_c_DeriveKey(XDR *, ck_rv_c_DeriveKey *);
  extern bool_t xdr_ck_rv_c_Digest(XDR *, ck_rv_c_Digest *);
  extern bool_t xdr_ck_rv_c_DigestFinal(XDR *, ck_rv_c_DigestFinal *);
  extern bool_t xdr_ck_rv_c_Sign(XDR *, ck_rv_c_Sign *);
  extern bool_t xdr_ck_rv_c_SignFinal(XDR *, ck_rv_c_SignFinal *);
  extern bool_t xdr_ck_rv_c_Encrypt(XDR *, ck_rv_c_Encrypt *);
  extern bool_t xdr_ck_rv_c_EncryptUpdate(XDR *, ck_rv_c_EncryptUpdate *);
  extern bool_t xdr_ck_rv_c_EncryptFinal(XDR *, ck_rv_c_EncryptFinal *);
  extern bool_t xdr_ck_rv_c_Decrypt(XDR *, ck_rv_c_Decrypt *);
  extern bool_t xdr_ck_rv_c_DecryptUpdate(XDR *, ck_rv_c_DecryptUpdate *);
  extern bool_t xdr_ck_rv_c_DecryptFinal(XDR *, ck_rv_c_DecryptFinal *);
  extern bool_t xdr_ck_rv_c_SignRecover(XDR *, ck_rv_c_SignRecover *);
  extern bool_t xdr_ck_rv_c_VerifyRecover(XDR *, ck_rv_c_VerifyRecover *);
  extern bool_t xdr_ck_rv_c_DigestEncryptUpdate(XDR *,
						ck_rv_c_DigestEncryptUpdate *);
  extern bool_t xdr_ck_rv_c_DecryptDigestUpdate(XDR *,
						ck_rv_c_DecryptDigestUpdate *);
  extern bool_t xdr_ck_rv_c_SignEncryptUpdate(XDR *,
					      ck_rv_c_SignEncryptUpdate *);
  extern bool_t xdr_ck_rv_c_DecryptVerifyUpdate(XDR *,
						ck_rv_c_DecryptVerifyUpdate *);
  extern bool_t xdr_ck_rv_c_GetOperationState(XDR *,
					      ck_rv_c_GetOperationState *);
  extern bool_t xdr_c_getslotlist_3_argument(XDR *, c_getslotlist_3_argument *);
  extern bool_t xdr_c_login_3_argument(XDR *, c_login_3_argument *);
  extern bool_t xdr_c_opensession_3_argument(XDR *, c_opensession_3_argument *);
  extern bool_t xdr_c_getmechanismlist_3_argument(XDR *,
						  c_getmechanismlist_3_argument
						  *);
  extern bool_t xdr_c_getmechanisminfo_3_argument(XDR *,
						  c_getmechanisminfo_3_argument
						  *);
  extern bool_t xdr_c_initpin_3_argument(XDR *, c_initpin_3_argument *);
  extern bool_t xdr_c_setpin_3_argument(XDR *, c_setpin_3_argument *);
  extern bool_t xdr_c_seedrandom_3_argument(XDR *, c_seedrandom_3_argument *);
  extern bool_t xdr_c_inittoken_3_argument(XDR *, c_inittoken_3_argument *);
  extern bool_t xdr_c_generaterandom_3_argument(XDR *,
						c_generaterandom_3_argument *);
  extern bool_t xdr_c_findobjectsinit_3_argument(XDR *,
						 c_findobjectsinit_3_argument
						 *);
  extern bool_t xdr_c_findobjects_3_argument(XDR *, c_findobjects_3_argument *);
  extern bool_t xdr_c_generatekey_3_argument(XDR *, c_generatekey_3_argument *);
  extern bool_t xdr_c_generatekeypair_3_argument(XDR *,
						 c_generatekeypair_3_argument
						 *);
  extern bool_t xdr_c_createobject_3_argument(XDR *,
					      c_createobject_3_argument *);
  extern bool_t xdr_c_copyobject_3_argument(XDR *, c_copyobject_3_argument *);
  extern bool_t xdr_c_destroyobject_3_argument(XDR *,
					       c_destroyobject_3_argument *);
  extern bool_t xdr_c_getattributevalue_3_argument(XDR *,
						   c_getattributevalue_3_argument
						   *);
  extern bool_t xdr_c_setattributevalue_3_argument(XDR *,
						   c_setattributevalue_3_argument
						   *);
  extern bool_t xdr_c_getobjectsize_3_argument(XDR *,
					       c_getobjectsize_3_argument *);
  extern bool_t xdr_c_wrapkey_3_argument(XDR *, c_wrapkey_3_argument *);
  extern bool_t xdr_c_unwrapkey_3_argument(XDR *, c_unwrapkey_3_argument *);
  extern bool_t xdr_c_derivekey_3_argument(XDR *, c_derivekey_3_argument *);
  extern bool_t xdr_c_digestinit_3_argument(XDR *, c_digestinit_3_argument *);
  extern bool_t xdr_c_digest_3_argument(XDR *, c_digest_3_argument *);
  extern bool_t xdr_c_digestupdate_3_argument(XDR *,
					      c_digestupdate_3_argument *);
  extern bool_t xdr_c_digestkey_3_argument(XDR *, c_digestkey_3_argument *);
  extern bool_t xdr_c_signinit_3_argument(XDR *, c_signinit_3_argument *);
  extern bool_t xdr_c_sign_3_argument(XDR *, c_sign_3_argument *);
  extern bool_t xdr_c_signupdate_3_argument(XDR *, c_signupdate_3_argument *);
  extern bool_t xdr_c_verifyinit_3_argument(XDR *, c_verifyinit_3_argument *);
  extern bool_t xdr_c_verify_3_argument(XDR *, c_verify_3_argument *);
  extern bool_t xdr_c_verifyupdate_3_argument(XDR *,
					      c_verifyupdate_3_argument *);
  extern bool_t xdr_c_verifyfinal_3_argument(XDR *, c_verifyfinal_3_argument *);
  extern bool_t xdr_c_encryptinit_3_argument(XDR *, c_encryptinit_3_argument *);
  extern bool_t xdr_c_encrypt_3_argument(XDR *, c_encrypt_3_argument *);
  extern bool_t xdr_c_encryptupdate_3_argument(XDR *,
					       c_encryptupdate_3_argument *);
  extern bool_t xdr_c_decryptinit_3_argument(XDR *, c_decryptinit_3_argument *);
  extern bool_t xdr_c_decrypt_3_argument(XDR *, c_decrypt_3_argument *);
  extern bool_t xdr_c_decryptupdate_3_argument(XDR *,
					       c_decryptupdate_3_argument *);
  extern bool_t xdr_c_signrecoverinit_3_argument(XDR *,
						 c_signrecoverinit_3_argument
						 *);
  extern bool_t xdr_c_signrecover_3_argument(XDR *, c_signrecover_3_argument *);
  extern bool_t xdr_c_verifyrecoverinit_3_argument(XDR *,
						   c_verifyrecoverinit_3_argument
						   *);
  extern bool_t xdr_c_verifyrecover_3_argument(XDR *,
					       c_verifyrecover_3_argument *);
  extern bool_t xdr_c_digestencryptupdate_3_argument(XDR *,
						     c_digestencryptupdate_3_argument
						     *);
  extern bool_t xdr_c_signencryptupdate_3_argument(XDR *,
						   c_signencryptupdate_3_argument
						   *);
  extern bool_t xdr_c_decryptdigestupdate_3_argument(XDR *,
						     c_decryptdigestupdate_3_argument
						     *);
  extern bool_t xdr_c_decryptverifyupdate_3_argument(XDR *,
						     c_decryptverifyupdate_3_argument
						     *);
  extern bool_t xdr_c_setoperationstate_3_argument(XDR *,
						   c_setoperationstate_3_argument
						   *);

#else				/* K&R C */
  extern bool_t xdr_pkcs11_int();
  extern bool_t xdr_rpc_ck_rv_t();
  extern bool_t xdr_rpc_ck_slot_id_t();
  extern bool_t xdr_rpc_ck_mechanism_type_t();
  extern bool_t xdr_rpc_ck_session_handle_t();
  extern bool_t xdr_rpc_ck_user_type_t();
  extern bool_t xdr_rpc_ck_state_t();
  extern bool_t xdr_rpc_ck_object_handle_t();
  extern bool_t xdr_rpc_ck_object_class_t();
  extern bool_t xdr_rpc_ck_hw_feature_type_t();
  extern bool_t xdr_rpc_ck_key_type_t();
  extern bool_t xdr_rpc_ck_certificate_type_t();
  extern bool_t xdr_rpc_ck_attribute_type_t();
  extern bool_t xdr_rpc_ck_flags_t();
  extern bool_t xdr_rpc_ck_notification_t();
  extern bool_t xdr_opaque_data();
  extern bool_t xdr_rpc_ck_version();
  extern bool_t xdr_rpc_ck_info();
  extern bool_t xdr_rpc_ck_slot_info();
  extern bool_t xdr_rpc_ck_token_info();
  extern bool_t xdr_rpc_ck_mechanism();
  extern bool_t xdr_rpc_ck_session_info();
  extern bool_t xdr_rpc_ck_mechanism_info();
  extern bool_t xdr_rpc_ck_attribute();
  extern bool_t xdr_rpc_ck_attribute_array();
  extern bool_t xdr_rpc_ck_date();
  extern bool_t xdr_ck_rv_c_GetSlotList();
  extern bool_t xdr_ck_rv_c_GetSlotInfo();
  extern bool_t xdr_ck_rv_c_GetTokenInfo();
  extern bool_t xdr_ck_rv_c_GetInfo();
  extern bool_t xdr_ck_rv_c_WaitForSlotEvent();
  extern bool_t xdr_ck_rv_c_OpenSession();
  extern bool_t xdr_ck_rv_c_GetMechanismList();
  extern bool_t xdr_ck_rv_c_GetSessionInfo();
  extern bool_t xdr_ck_rv_c_GetMechanismInfo();
  extern bool_t xdr_ck_rv_c_GenerateRandom();
  extern bool_t xdr_ck_rv_c_FindObjects();
  extern bool_t xdr_ck_rv_c_GenerateKey();
  extern bool_t xdr_ck_rv_c_GenerateKeyPair();
  extern bool_t xdr_ck_rv_c_CreateObject();
  extern bool_t xdr_ck_rv_c_CopyObject();
  extern bool_t xdr_ck_rv_c_GetAttributeValue();
  extern bool_t xdr_ck_rv_c_GetObjectSize();
  extern bool_t xdr_ck_rv_c_WrapKey();
  extern bool_t xdr_ck_rv_c_UnwrapKey();
  extern bool_t xdr_ck_rv_c_DeriveKey();
  extern bool_t xdr_ck_rv_c_Digest();
  extern bool_t xdr_ck_rv_c_DigestFinal();
  extern bool_t xdr_ck_rv_c_Sign();
  extern bool_t xdr_ck_rv_c_SignFinal();
  extern bool_t xdr_ck_rv_c_Encrypt();
  extern bool_t xdr_ck_rv_c_EncryptUpdate();
  extern bool_t xdr_ck_rv_c_EncryptFinal();
  extern bool_t xdr_ck_rv_c_Decrypt();
  extern bool_t xdr_ck_rv_c_DecryptUpdate();
  extern bool_t xdr_ck_rv_c_DecryptFinal();
  extern bool_t xdr_ck_rv_c_SignRecover();
  extern bool_t xdr_ck_rv_c_VerifyRecover();
  extern bool_t xdr_ck_rv_c_DigestEncryptUpdate();
  extern bool_t xdr_ck_rv_c_DecryptDigestUpdate();
  extern bool_t xdr_ck_rv_c_SignEncryptUpdate();
  extern bool_t xdr_ck_rv_c_DecryptVerifyUpdate();
  extern bool_t xdr_ck_rv_c_GetOperationState();
  extern bool_t xdr_c_getslotlist_3_argument();
  extern bool_t xdr_c_login_3_argument();
  extern bool_t xdr_c_opensession_3_argument();
  extern bool_t xdr_c_getmechanismlist_3_argument();
  extern bool_t xdr_c_getmechanisminfo_3_argument();
  extern bool_t xdr_c_initpin_3_argument();
  extern bool_t xdr_c_setpin_3_argument();
  extern bool_t xdr_c_seedrandom_3_argument();
  extern bool_t xdr_c_inittoken_3_argument();
  extern bool_t xdr_c_generaterandom_3_argument();
  extern bool_t xdr_c_findobjectsinit_3_argument();
  extern bool_t xdr_c_findobjects_3_argument();
  extern bool_t xdr_c_generatekey_3_argument();
  extern bool_t xdr_c_generatekeypair_3_argument();
  extern bool_t xdr_c_createobject_3_argument();
  extern bool_t xdr_c_copyobject_3_argument();
  extern bool_t xdr_c_destroyobject_3_argument();
  extern bool_t xdr_c_getattributevalue_3_argument();
  extern bool_t xdr_c_setattributevalue_3_argument();
  extern bool_t xdr_c_getobjectsize_3_argument();
  extern bool_t xdr_c_wrapkey_3_argument();
  extern bool_t xdr_c_unwrapkey_3_argument();
  extern bool_t xdr_c_derivekey_3_argument();
  extern bool_t xdr_c_digestinit_3_argument();
  extern bool_t xdr_c_digest_3_argument();
  extern bool_t xdr_c_digestupdate_3_argument();
  extern bool_t xdr_c_digestkey_3_argument();
  extern bool_t xdr_c_signinit_3_argument();
  extern bool_t xdr_c_sign_3_argument();
  extern bool_t xdr_c_signupdate_3_argument();
  extern bool_t xdr_c_verifyinit_3_argument();
  extern bool_t xdr_c_verify_3_argument();
  extern bool_t xdr_c_verifyupdate_3_argument();
  extern bool_t xdr_c_verifyfinal_3_argument();
  extern bool_t xdr_c_encryptinit_3_argument();
  extern bool_t xdr_c_encrypt_3_argument();
  extern bool_t xdr_c_encryptupdate_3_argument();
  extern bool_t xdr_c_decryptinit_3_argument();
  extern bool_t xdr_c_decrypt_3_argument();
  extern bool_t xdr_c_decryptupdate_3_argument();
  extern bool_t xdr_c_signrecoverinit_3_argument();
  extern bool_t xdr_c_signrecover_3_argument();
  extern bool_t xdr_c_verifyrecoverinit_3_argument();
  extern bool_t xdr_c_verifyrecover_3_argument();
  extern bool_t xdr_c_digestencryptupdate_3_argument();
  extern bool_t xdr_c_signencryptupdate_3_argument();
  extern bool_t xdr_c_decryptdigestupdate_3_argument();
  extern bool_t xdr_c_decryptverifyupdate_3_argument();
  extern bool_t xdr_c_setoperationstate_3_argument();

#endif				/* K&R C */

#ifdef __cplusplus
}
#endif
#endif				/* !_PKCS11_RPC_H_RPCGEN */
