﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using Microsoft.CodeAnalysis.CodeFixes;

namespace Microsoft.CodeAnalysis.ExternalAccess.Razor
{
    internal static class RazorPredefinedCodeFixProviderNames
    {
        public static string AddAccessibilityModifiers => PredefinedCodeFixProviderNames.AddOrRemoveAccessibilityModifiers;
        public static string AddAnonymousTypeMemberName => PredefinedCodeFixProviderNames.AddAnonymousTypeMemberName;
        public static string AddAsync => PredefinedCodeFixProviderNames.AddAsync;
        public static string AddBraces => PredefinedCodeFixProviderNames.AddBraces;
        public static string AddDocCommentNodes => PredefinedCodeFixProviderNames.AddDocCommentNodes;
        public static string AddExplicitCast => PredefinedCodeFixProviderNames.AddExplicitCast;
        public static string AddImport => PredefinedCodeFixProviderNames.AddImport;
        public static string AddMissingReference => PredefinedCodeFixProviderNames.AddMissingReference;
        public static string AddNew => PredefinedCodeFixProviderNames.AddNew;
        public static string AddObsoleteAttribute => PredefinedCodeFixProviderNames.AddObsoleteAttribute;
        public static string AddOverloads => PredefinedCodeFixProviderNames.AddOverloads;
        public static string AddPackage => PredefinedCodeFixProviderNames.AddPackage;
        public static string AddParameter => PredefinedCodeFixProviderNames.AddParameter;
        public static string AddParenthesesAroundConditionalExpressionInInterpolatedString => PredefinedCodeFixProviderNames.AddParenthesesAroundConditionalExpressionInInterpolatedString;
        public static string AddRequiredParentheses => PredefinedCodeFixProviderNames.AddRequiredParentheses;
        public static string AliasAmbiguousType => PredefinedCodeFixProviderNames.AliasAmbiguousType;
        public static string ApplyNamingStyle => PredefinedCodeFixProviderNames.ApplyNamingStyle;
        public static string AssignOutParametersAboveReturn => PredefinedCodeFixProviderNames.AssignOutParametersAboveReturn;
        public static string AssignOutParametersAtStart => PredefinedCodeFixProviderNames.AssignOutParametersAtStart;
        public static string ChangeNamespaceToMatchFolder => PredefinedCodeFixProviderNames.ChangeNamespaceToMatchFolder;
        public static string ChangeReturnType => PredefinedCodeFixProviderNames.ChangeReturnType;
        public static string ChangeToYield => PredefinedCodeFixProviderNames.ChangeToYield;
        public static string ConflictMarkerResolution => PredefinedCodeFixProviderNames.ConflictMarkerResolution;
        public static string ConsecutiveBracePlacement => PredefinedCodeFixProviderNames.ConsecutiveBracePlacement;
        public static string ConsecutiveStatementPlacement => PredefinedCodeFixProviderNames.ConsecutiveStatementPlacement;
        public static string ConstructorInitializerPlacement => PredefinedCodeFixProviderNames.ConstructorInitializerPlacement;
        public static string ConvertSwitchStatementToExpression => PredefinedCodeFixProviderNames.ConvertSwitchStatementToExpression;
        public static string ConvertToAsync => PredefinedCodeFixProviderNames.ConvertToAsync;
        public static string ConvertToIterator => PredefinedCodeFixProviderNames.ConvertToIterator;
        public static string ConvertTypeOfToNameOf => PredefinedCodeFixProviderNames.ConvertTypeOfToNameOf;
        public static string CorrectNextControlVariable => PredefinedCodeFixProviderNames.CorrectNextControlVariable;
        public static string DeclareAsNullable => PredefinedCodeFixProviderNames.DeclareAsNullable;
        public static string DisambiguateSameVariable => PredefinedCodeFixProviderNames.DisambiguateSameVariable;
        public static string EmbeddedStatementPlacement => PredefinedCodeFixProviderNames.EmbeddedStatementPlacement;
        public static string FileHeader => PredefinedCodeFixProviderNames.FileHeader;
        public static string FixFormatting => PredefinedCodeFixProviderNames.FixFormatting;
        public static string FixIncorrectExitContinue => PredefinedCodeFixProviderNames.FixIncorrectExitContinue;
        public static string FixIncorrectFunctionReturnType => PredefinedCodeFixProviderNames.FixIncorrectFunctionReturnType;
        public static string FixReturnType => PredefinedCodeFixProviderNames.FixReturnType;
        public static string FullyQualify => PredefinedCodeFixProviderNames.FullyQualify;
        public static string GenerateConstructor => PredefinedCodeFixProviderNames.GenerateConstructor;
        public static string GenerateConversion => PredefinedCodeFixProviderNames.GenerateConversion;
        public static string GenerateDeconstructMethod => PredefinedCodeFixProviderNames.GenerateDeconstructMethod;
        public static string GenerateEndConstruct => PredefinedCodeFixProviderNames.GenerateEndConstruct;
        public static string GenerateEnumMember => PredefinedCodeFixProviderNames.GenerateEnumMember;
        public static string GenerateEvent => PredefinedCodeFixProviderNames.GenerateEvent;
        public static string GenerateMethod => PredefinedCodeFixProviderNames.GenerateMethod;
        public static string GenerateType => PredefinedCodeFixProviderNames.GenerateType;
        public static string GenerateVariable => PredefinedCodeFixProviderNames.GenerateVariable;
        public static string ImplementAbstractClass => PredefinedCodeFixProviderNames.ImplementAbstractClass;
        public static string ImplementInterface => PredefinedCodeFixProviderNames.ImplementInterface;
        public static string InlineDeclaration => PredefinedCodeFixProviderNames.InlineDeclaration;
        public static string InvokeDelegateWithConditionalAccess => PredefinedCodeFixProviderNames.InvokeDelegateWithConditionalAccess;
        public static string MakeFieldReadonly => PredefinedCodeFixProviderNames.MakeFieldReadonly;
        public static string MakeLocalFunctionStatic => PredefinedCodeFixProviderNames.MakeLocalFunctionStatic;
        public static string MakeMemberStatic => PredefinedCodeFixProviderNames.MakeMemberStatic;
        public static string MakeMethodSynchronous => PredefinedCodeFixProviderNames.MakeMethodSynchronous;
        public static string MakeRefStruct => PredefinedCodeFixProviderNames.MakeRefStruct;
        public static string MakeStatementAsynchronous => PredefinedCodeFixProviderNames.MakeStatementAsynchronous;
        public static string MakeStructFieldsWritable => PredefinedCodeFixProviderNames.MakeStructFieldsWritable;
        public static string MakeTypeAbstract => PredefinedCodeFixProviderNames.MakeTypeAbstract;
        public static string MoveMisplacedUsingDirectives => PredefinedCodeFixProviderNames.MoveMisplacedUsingDirectives;
        public static string MoveToTopOfFile => PredefinedCodeFixProviderNames.MoveToTopOfFile;
        public static string OrderModifiers => PredefinedCodeFixProviderNames.OrderModifiers;
        public static string PassInCapturedVariables => PredefinedCodeFixProviderNames.PassInCapturedVariables;
        public static string PopulateSwitch => PredefinedCodeFixProviderNames.PopulateSwitch;
        public static string PopulateSwitchExpression => PredefinedCodeFixProviderNames.PopulateSwitchExpression;
        public static string PreferFrameworkType => PredefinedCodeFixProviderNames.PreferFrameworkType;
        public static string QualifyMemberAccess => PredefinedCodeFixProviderNames.QualifyMemberAccess;
        public static string RemoveAsyncModifier => PredefinedCodeFixProviderNames.RemoveAsyncModifier;
        public static string RemoveBlankLines => PredefinedCodeFixProviderNames.RemoveBlankLines;
        public static string RemoveConfusingSuppression => PredefinedCodeFixProviderNames.RemoveConfusingSuppression;
        public static string RemoveDocCommentNode => PredefinedCodeFixProviderNames.RemoveDocCommentNode;
        public static string RemoveIn => PredefinedCodeFixProviderNames.RemoveIn;
        public static string RemoveNew => PredefinedCodeFixProviderNames.RemoveNew;
        public static string RemoveRedundantEquality => PredefinedCodeFixProviderNames.RemoveRedundantEquality;
        public static string RemoveSharedFromModuleMembers => PredefinedCodeFixProviderNames.RemoveSharedFromModuleMembers;
        public static string RemoveUnnecessaryAttributeSuppressions => PredefinedCodeFixProviderNames.RemoveUnnecessaryAttributeSuppressions;
        public static string RemoveUnnecessaryByVal => PredefinedCodeFixProviderNames.RemoveUnnecessaryByVal;
        public static string RemoveUnnecessaryCast => PredefinedCodeFixProviderNames.RemoveUnnecessaryCast;
        public static string RemoveUnnecessaryDiscardDesignation => PredefinedCodeFixProviderNames.RemoveUnnecessaryDiscardDesignation;
        public static string RemoveUnnecessaryImports => PredefinedCodeFixProviderNames.RemoveUnnecessaryImports;
        public static string RemoveUnnecessaryParentheses => PredefinedCodeFixProviderNames.RemoveUnnecessaryParentheses;
        public static string RemoveUnnecessaryPragmaSuppressions => PredefinedCodeFixProviderNames.RemoveUnnecessaryPragmaSuppressions;
        public static string RemoveUnreachableCode => PredefinedCodeFixProviderNames.RemoveUnreachableCode;
        public static string RemoveUnusedLocalFunction => PredefinedCodeFixProviderNames.RemoveUnusedLocalFunction;
        public static string RemoveUnusedMembers => PredefinedCodeFixProviderNames.RemoveUnusedMembers;
        public static string RemoveUnusedValues => PredefinedCodeFixProviderNames.RemoveUnusedValues;
        public static string RemoveUnusedVariable => PredefinedCodeFixProviderNames.RemoveUnusedVariable;
        public static string ReplaceDefaultLiteral => PredefinedCodeFixProviderNames.ReplaceDefaultLiteral;
        public static string SimplifyConditionalExpression => PredefinedCodeFixProviderNames.SimplifyConditionalExpression;
        public static string SimplifyInterpolation => PredefinedCodeFixProviderNames.SimplifyInterpolation;
        public static string SimplifyLinqExpression => PredefinedCodeFixProviderNames.SimplifyLinqExpression;
        public static string SimplifyNames => PredefinedCodeFixProviderNames.SimplifyNames;
        public static string SimplifyThisOrMe => PredefinedCodeFixProviderNames.SimplifyThisOrMe;
        public static string SpellCheck => PredefinedCodeFixProviderNames.SpellCheck;
        public static string UnsealClass => PredefinedCodeFixProviderNames.UnsealClass;
        public static string UpdateLegacySuppressions => PredefinedCodeFixProviderNames.UpdateLegacySuppressions;
        public static string UpdateProjectToAllowUnsafe => PredefinedCodeFixProviderNames.UpdateProjectToAllowUnsafe;
        public static string UpgradeProject => PredefinedCodeFixProviderNames.UpgradeProject;
        public static string UseAutoProperty => PredefinedCodeFixProviderNames.UseAutoProperty;
        public static string UseCoalesceExpression => PredefinedCodeFixProviderNames.UseCoalesceExpressionForTernaryConditionalCheck;
        public static string UseCoalesceExpressionForNullable => PredefinedCodeFixProviderNames.UseCoalesceExpressionForNullableTernaryConditionalCheck;
        public static string UseCollectionInitializer => PredefinedCodeFixProviderNames.UseCollectionInitializer;
        public static string UseCompoundAssignment => PredefinedCodeFixProviderNames.UseCompoundAssignment;
        public static string UseCompoundCoalesceAssignment => PredefinedCodeFixProviderNames.UseCompoundCoalesceAssignment;
        public static string UseConditionalExpressionForAssignment => PredefinedCodeFixProviderNames.UseConditionalExpressionForAssignment;
        public static string UseConditionalExpressionForReturn => PredefinedCodeFixProviderNames.UseConditionalExpressionForReturn;
        public static string UseDeconstruction => PredefinedCodeFixProviderNames.UseDeconstruction;
        public static string UseDefaultLiteral => PredefinedCodeFixProviderNames.UseDefaultLiteral;
        public static string UseExplicitTupleName => PredefinedCodeFixProviderNames.UseExplicitTupleName;
        public static string UseExplicitType => PredefinedCodeFixProviderNames.UseExplicitType;
        public static string UseExplicitTypeForConst => PredefinedCodeFixProviderNames.UseExplicitTypeForConst;
        public static string UseExpressionBody => PredefinedCodeFixProviderNames.UseExpressionBody;
        public static string UseExpressionBodyForLambda => PredefinedCodeFixProviderNames.UseExpressionBodyForLambda;
        public static string UseImplicitObjectCreation => PredefinedCodeFixProviderNames.UseImplicitObjectCreation;
        public static string UseImplicitType => PredefinedCodeFixProviderNames.UseImplicitType;
        public static string UseIndexOperator => PredefinedCodeFixProviderNames.UseIndexOperator;
        public static string UseInferredMemberName => PredefinedCodeFixProviderNames.UseInferredMemberName;
        public static string UseInterpolatedVerbatimString => PredefinedCodeFixProviderNames.UseInterpolatedVerbatimString;
        public static string UseIsNotExpression => PredefinedCodeFixProviderNames.UseIsNotExpression;
        public static string UseIsNullCheck => PredefinedCodeFixProviderNames.UseIsNullCheck;
        public static string UseIsNullCheckForCastAndEqualityOperator => PredefinedCodeFixProviderNames.UseIsNullCheckForCastAndEqualityOperator;
        public static string UseIsNullCheckForReferenceEquals => PredefinedCodeFixProviderNames.UseIsNullCheckForReferenceEquals;
        public static string UseLocalFunction => PredefinedCodeFixProviderNames.UseLocalFunction;
        public static string UseNotPattern => PredefinedCodeFixProviderNames.UseNotPattern;
        public static string UseNullPropagation => PredefinedCodeFixProviderNames.UseNullPropagation;
        public static string UseObjectInitializer => PredefinedCodeFixProviderNames.UseObjectInitializer;
        public static string UsePatternCombinators => PredefinedCodeFixProviderNames.UsePatternCombinators;
        public static string UsePatternMatchingAsAndNullCheck => PredefinedCodeFixProviderNames.UsePatternMatchingAsAndNullCheck;
        public static string UsePatternMatchingIsAndCastCheck => PredefinedCodeFixProviderNames.UsePatternMatchingIsAndCastCheck;
        public static string UsePatternMatchingIsAndCastCheckWithoutName => PredefinedCodeFixProviderNames.UsePatternMatchingIsAndCastCheckWithoutName;
        public static string UseRangeOperator => PredefinedCodeFixProviderNames.UseRangeOperator;
        public static string UseSimpleUsingStatement => PredefinedCodeFixProviderNames.UseSimpleUsingStatement;
        public static string UseSystemHashCode => PredefinedCodeFixProviderNames.UseSystemHashCode;
        public static string UseThrowExpression => PredefinedCodeFixProviderNames.UseThrowExpression;
    }
}
