// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package sagemakeredgemanageriface provides an interface to enable mocking the Amazon Sagemaker Edge Manager service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package sagemakeredgemanageriface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/sagemakeredgemanager"
)

// SagemakerEdgeManagerAPI provides an interface to enable mocking the
// sagemakeredgemanager.SagemakerEdgeManager service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Sagemaker Edge Manager.
//    func myFunc(svc sagemakeredgemanageriface.SagemakerEdgeManagerAPI) bool {
//        // Make svc.GetDeviceRegistration request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := sagemakeredgemanager.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockSagemakerEdgeManagerClient struct {
//        sagemakeredgemanageriface.SagemakerEdgeManagerAPI
//    }
//    func (m *mockSagemakerEdgeManagerClient) GetDeviceRegistration(input *sagemakeredgemanager.GetDeviceRegistrationInput) (*sagemakeredgemanager.GetDeviceRegistrationOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockSagemakerEdgeManagerClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type SagemakerEdgeManagerAPI interface {
	GetDeviceRegistration(*sagemakeredgemanager.GetDeviceRegistrationInput) (*sagemakeredgemanager.GetDeviceRegistrationOutput, error)
	GetDeviceRegistrationWithContext(aws.Context, *sagemakeredgemanager.GetDeviceRegistrationInput, ...request.Option) (*sagemakeredgemanager.GetDeviceRegistrationOutput, error)
	GetDeviceRegistrationRequest(*sagemakeredgemanager.GetDeviceRegistrationInput) (*request.Request, *sagemakeredgemanager.GetDeviceRegistrationOutput)

	SendHeartbeat(*sagemakeredgemanager.SendHeartbeatInput) (*sagemakeredgemanager.SendHeartbeatOutput, error)
	SendHeartbeatWithContext(aws.Context, *sagemakeredgemanager.SendHeartbeatInput, ...request.Option) (*sagemakeredgemanager.SendHeartbeatOutput, error)
	SendHeartbeatRequest(*sagemakeredgemanager.SendHeartbeatInput) (*request.Request, *sagemakeredgemanager.SendHeartbeatOutput)
}

var _ SagemakerEdgeManagerAPI = (*sagemakeredgemanager.SagemakerEdgeManager)(nil)
