// generated by ../../../../tools/tube_transfer.py
// tube: KT88
// plate current function: pentode2
// mu: 8.8
// kx: 1.35
// kg1: 730
// kg2: 4200
// kp: 32
// kvb: 16
// Uin_min: -5
// Uin_max: 5
// Vp: 250
// Rp: 100000

table1d_imp<2001> tubetable_KT88[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	240.90442332476144,240.88712024320165,240.86971494053603,240.85220676290857,240.83459505251412,
	240.81687914757762,240.79905838233347,240.78113208700472,240.76309958778236,240.74496020680428,
	240.7267132621345,240.708358067742,240.68989393348002,240.67132016506434,240.6526360640527,
	240.63384092782323,240.6149340495532,240.5959147181977,240.57678221846834,240.55753583081167,
	240.5381748313875,240.51869849204772,240.49910608031433,240.47939685935788,240.45957008797592,
	240.4396250205707,240.41956090712804,240.3993769931949,240.3790725198575,240.3586467237196,
	240.33809883688048,240.31742808691234,240.29663369683885,240.27571488511254,240.2546708655928,
	240.2335008475234,240.21220403551047,240.19077962950004,240.16922682475553,240.14754481183556,
	240.12573277657134,240.10378990004418,240.08171535856303,240.0595083236419,240.03716796197725,
	240.01469343542522,239.99208390097925,239.9693385107471,239.94645641192838,239.92343674679154,
	239.90027865265137,239.87698126184583,239.85354370171368,239.82996509457126,239.80624455768975,
	239.78238120327225,239.75837413843098,239.7342224651642,239.7099252803333,239.68548167563983,
	239.6608907376027,239.63615154753498,239.6112631815209,239.58622471039303,239.56103519970915,
	239.53569370972923,239.5101992953924,239.48455100629408,239.45874788666262,239.43278897533688,
	239.40667330574234,239.38039990586898,239.35396779824762,239.32737599992743,239.30062352245247,
	239.27370937183903,239.2466325485526,239.219392047485,239.19198685793117,239.16441596356657,
	239.1366783424242,239.1087729668717,239.08069880358863,239.05245481354345,239.02403995197105,
	238.9954531683498,238.96669340637885,238.93775960395553,238.90865069315277,238.87936560019642,
	238.84990324544282,238.82026254335605,238.79044240248595,238.76044172544522,238.73025940888743,
	238.69989434348466,238.6693454139051,238.6386114987913,238.6076914707377,238.57658419626864,
	238.5452885358166,238.5138033437003,238.4821274681026,238.45025975104912,238.41819902838657,
	238.38594412976084,238.353493878596,238.32084709207246,238.28800258110616,238.25495915032698,
	238.22171559805778,238.1882707162934,238.15462329068004,238.120772100494,238.0867159186214,
	238.05245351153735,238.01798363928583,237.98330505545925,237.94841650717822,237.91331673507136,
	237.8780044732558,237.84247844931716,237.8067373842898,237.7707799926375,237.7346049822341,
	237.6982110543442,237.66159690360428,237.62476121800364,237.58770267886584,237.55041996083014,
	237.5129117318329,237.47517665308976,237.43721337907724,237.3990205575152,237.3605968293489,
	237.32194082873184,237.2830511830083,237.24392651269628,237.20456543147083,237.16496654614696,
	237.12512845666384,237.08504975606803,237.04472903049776,237.00416485916708,236.96335581435025,
	236.92230046136677,236.88099735856574,236.83944505731162,236.79764210196936,236.75558702989017,
	236.7132783713975,236.6707146497731,236.62789438124372,236.5848160749679,236.54147823302273,
	236.49787935039146,236.45401791495104,236.40989240746003,236.36550130154689,236.3208430636984,
	236.27591615324852,236.23071902236768,236.18525011605215,236.13950787211408,236.0934907211712,
	236.04719708663785,236.00062538471533,235.95377402438368,235.90664140739258,235.85922592825378,
	235.81152597423318,235.76353992534345,235.71526615433737,235.66670302670082,235.61784890064706,
	235.5687021271107,235.5192610497424,235.469524004904,235.419489321664,235.36915532179341,
	235.31852031976214,235.26758262273577,235.21634053057275,235.1647923358221,235.11293632372184,
	235.06077077219695,235.00829395185917,234.95550412600613,234.9023995506216,234.84897847437585,
	234.79523913862712,234.7411797774226,234.68679861750107,234.6320938782951,234.57706377193446,
	234.52170650324967,234.4660202697761,234.41000326175916,234.35365366215902,234.29696964665717,
	234.23994938366243,234.18259103431808,234.1248927525098,234.06685268487357,234.00846897080473,
	233.94973974246744,233.89066312480463,233.83123723554903,233.77146018523408,233.71133007720633,
	233.65084500763803,233.5900030655402,233.52880233277693,233.46724088408004,233.405316787064,
	233.34302810224267,233.28037288304537,233.21734917583498,233.15395501992566,233.0901884476018,
	233.02604748413805,232.96153014781927,232.8966344499619,232.83135839493585,232.7656999801871,
	232.69965719626134,232.6332280268279,232.56641044870517,232.49920243188615,232.43160193956513,
	232.36360692816558,232.29521534736764,232.22642514013833,232.1572342427606,232.08764058486474,
	232.01764208945983,231.94723667296657,231.87642224525067,231.8051967096571,231.73355796304546,
	231.66150389582643,231.58903239199827,231.51614132918556,231.44282857867756,231.3690920054686,
	231.29492946829873,231.22033881969557,231.14531790601714,231.06986456749567,230.99397663828265,
	230.91765194649398,230.8408883142573,230.76368355775995,230.68603548729723,230.6079419073227,
	230.5294006164991,230.45040940775013,230.37096606831366,230.29106837979595,230.21071411822655,
	230.1299010541149,230.0486269525075,229.96688957304673,229.8846866700299,229.80201599247076,
	229.71887528416073,229.6352622837322,229.5511747247229,229.46661033564075,229.38156684003087,
	229.2960419565431,229.21003339900057,229.12353887647035,229.0365560933343,228.94908274936162,
	228.8611165397829,228.77265515536442,228.68369628248502,228.59423760321312,228.5042767953854,
	228.41381153268708,228.3228394847326,228.23135831714876,228.1393656916578,228.0468592661632,
	227.95383669483533,227.86029562819976,227.76623371322592,227.67164859341747,227.57653790890404,
	227.48089929653423,227.38473038996983,227.2880288197817,227.19079221354667,227.09301819594612,
	226.99470438886567,226.8958484114965,226.79644788043765,226.69650040980034,226.59600361131317,
	226.49495509442872,226.39335246643222,226.29119333255062,226.18847529606393,226.0851959584177,
	225.98135291933679,225.87694377694078,225.77196612786076,225.66641756735748,225.5602956894413,
	225.45359808699297,225.34632235188664,225.23846607511368,225.13002684690844,225.02100225687514,
	224.91138989411647,224.80118734736376,224.6903922051083,224.57900205573432,224.46701448765353,
	224.35442708944143,224.24123744997425,224.1274431585685,224.01304180512108,223.89803098025152,
	223.78240827544548,223.66617128319993,223.54931759716933,223.43184481231407,223.31375052505018,
	223.19503233339984,223.07568783714484,222.95571463797987,222.83511033966906,222.71387254820235,
	222.59199887195496,222.46948692184696,222.3463343115055,222.22253865742775,222.09809757914596,
	221.97300869939346,221.84726964427261,221.72087804342422,221.59383153019795,221.46612774182512,
	221.3377643195922,221.20873890901623,221.07904916002158,220.94869272711827,220.81766726958165,
	220.6859704516337,220.5535999426259,220.42055341722303,220.28682855558915,220.15242304357471,
	220.01733457290493,219.88156084136963,219.74509955301522,219.60794841833706,219.47010515447386,
	219.33156748540347,219.19233314213986,219.0523998629317,218.9117653934621,218.77042748705009,
	218.628383904853,218.4856324160705,218.34217079815,218.19799683699313,218.053108327164,
	217.90750307209805,217.76117888431318,217.61413358562103,217.46636500734064,217.3178709905125,
	217.1686493861143,217.01869805527792,216.8680148695073,216.71659771089801,216.5644444723575,
	216.41155305782678,216.25792138250344,216.10354737306537,215.94842896789578,215.7925641173097,
	215.63595078378083,215.47858694217024,215.32047057995533,215.1615996974607,215.00197230808908,
	214.84158643855417,214.68044012911375,214.51853143380384,214.35585842067448,214.19241917202515,
	214.02821178464254,213.86323437003801,213.6974850546862,213.5309619802651,213.36366330389583,
	213.19558719838398,213.02673185246147,212.85709547102894,212.68667627539944,212.51547250354162,
	212.3434824103249,212.17070426776422,211.99713636526613,211.82277700987476,211.64762452651874,
	211.47167725825867,211.2949335665346,211.1173918314146,210.93905045184314,210.75990784589015,
	210.57996245100034,210.39921272424328,210.21765714256267,210.03529420302698,209.85212242307995,
	209.66814034079098,209.48334651510604,209.29773952609852,209.1113179752202,208.9240804855524,
	208.7360257020569,208.54715229182705,208.35745894433865,208.16694437170096,207.97560730890754,
	207.78344651408662,207.59046076875168,207.39664887805156,207.2020096710204,207.00654200082707,
	206.8102447450246,206.61311680579894,206.41515711021725,206.216364610476,206.01673828414832,
	205.81627713443092,205.61498019039016,205.4128465072082,205.20987516642745,205.00606527619496,
	204.8014159715063,204.5959264144479,204.38959579443897,204.18242332847257,203.97440826135576,
	203.7655498659486,203.55584744340212,203.34530032339563,203.13390786437256,202.92166945377508,
	202.70858450827794,202.49465247402077,202.2798728268391,202.06424507249437,201.84776874690215,
	201.63044341635918,201.41226867776908,201.19324415886618,200.9733695184383,200.7526444465474,
	200.53106866474914,200.30864192631037,200.08536401642496,199.8612347524279,199.63625398400785,
	199.41042159341728,199.18373749568116,198.95620163880324,198.72781400397113,198.4985746057584,
	198.26848349232515,198.037540745616,197.80574648155695,197.57310085024832,197.33960403615689,
	197.10525625830508,196.87005777045775,196.6340088613067,196.39710985465294,196.15936110958555,
	195.92076302065945,195.68131601806934,195.4410205678215,195.19987717190278,194.957886368447,
	194.71504873189852,194.47136487317297,194.22683543981495,193.9814611161533,193.73524262345273,
	193.48818072006333,193.24027620156613,192.99152990091625,192.74194268858258,192.49151547268457,
	192.24024919912563,191.98814485172306,191.73520345233544,191.48142606098588,191.22681377598224,
	190.97136773403432,190.71508911036668,190.45797911882917,190.20003901200263,189.94127008130252,
	189.68167365707737,189.42125110870495,189.1600038446839,188.8979333127221,188.63504099982117,
	188.3713284323571,188.10679717615736,187.84144883657365,187.57528505855157,187.30830752669544,
	187.04051796533005,186.77191813855785,186.5025098503123,186.23229494440753,185.9612753045832,
	185.68945285454632,185.41682955800766,185.14340741871533,184.86918848048327,184.59417482721588,
	184.31836858292849,184.04177191176336,183.76438701800194,183.48621614607194,183.20726158055098,
	182.9275256461653,182.64701070778472,182.3657191704124,182.0836534791711,181.8008161192842,
	181.51720961605312,181.23283653482957,180.94769948098377,180.66180109986817,180.37514407677642,
	180.08773113689816,179.79956504526902,179.51064860671642,179.2209846658006,178.93057610675103,
	178.6394258533987,178.3475368691033,178.0549121566762,177.7615547582989,177.46746775543656,
	177.17265426874735,176.877117457987,176.58086052190882,176.28388669815914,175.98619926316823,
	175.68780153203642,175.38869685841615,175.0888886343889,174.7883802903376,174.48717529481505,
	174.18527715440706,173.8826894135916,173.579415654593,173.27545949723202,172.97082459877075,
	172.6655146537541,172.3595333938455,172.05288458765926,171.74557204058758,171.43759959462366,
	171.12897112818018,170.8196905559035,170.509761828483,170.19918893245688,169.8879758900128,
	169.5761267587846,169.2636456316444,168.9505366364911,168.6368039360336,168.32245172757078,
	168.00748424276634,167.69190574742044,167.37572054123623,167.05893295758293,166.74154736325448,
	166.42356815822438,166.10499977539632,165.78584668035055,165.46611337108703,165.1458043777639,
	164.8249242624326,164.50347761876873,164.18146907179937,163.85890327762667,163.53578492314745,
	163.2121187257691,162.8879094331224,162.56316182277,162.23788070191182,161.91207090708673,
	161.58573730387084,161.2588847865723,160.93151827792295,160.60364272876643,160.2752631177429,
	159.9463844509709,159.61701176172605,159.28715011011602,158.95680458275322,158.62598029242403,
	158.29468237775518,157.96291600287725,157.63068635708544,157.29799865449738,156.96485813370816,
	156.63127005744323,156.297239712208,155.96277240793523,155.62787347763006,155.29254827701266,
	154.95680218415802,154.62064059913408,154.2840689436374,153.94709266062657,153.60971721395373,
	153.27194808799402,152.9337907872728,152.5952508360919,152.25633377815262,151.91704517617836,
	151.5773906115348,151.2373756838491,150.89700601062665,150.55628722686745,150.21522498468025,
	149.87382495289637,149.5320928166811,149.19003427714503,148.84765505095368,148.50496086993664,
	148.16195748069532,147.81865064421046,147.47504613544814,147.13114974296607,146.78696726851868,
	146.4425045266618,146.09776734435735,145.75276156057708,145.40749302590692,145.06196760215033,
	144.71619116193222,144.37016958830282,144.02390877434152,143.67741462276098,143.33069304551182,
	142.9837499633873,142.63659130562903,142.28922300953295,141.94165102005596,141.59388128942373,
	141.24591977673927,140.89777244759213,140.5494452736694,140.20094423236728,139.85227530640458,
	139.50344448343716,139.15445775567406,138.8053211194954,138.456040575072,138.10662212598683,
	137.75707177885818,137.4073955429657,137.05759942987743,136.70768945308075,136.35767162761414,
	136.00755196970286,135.65733649639628,135.30703122520907,134.95664217376432,134.6061753594406,
	134.25563679902152,133.90503250834934,133.55436850198154,133.20365079285108,132.8528853919309,
	132.50207830790177,132.15123554682444,131.8003631118159,131.44946700273044,131.09855321584453,
	130.74762774354704,130.39669657403368,130.0457656910073,129.6948410733821,129.34392869499493,
	128.99303452432036,128.64216452419257,128.29132465153282,127.94052085708307,127.58975908514569,
	127.23904527332986,126.88838535230467,126.53778524555885,126.187250869168,125.83678813156872,
	125.4864029333407,125.13610116699624,124.78588871677809,124.43577145846523,124.08575525918731,
	123.73584597724816,123.38604946195758,123.03637155347316,122.68681808265124,122.33739487090787,
	121.9881077300899,121.63896246235646,121.28996486007112,120.94112070570534,120.5924357717532,
	120.24391582065759,119.89556660474888,119.54739386619568,119.19940333696876,118.85160073881751,
	118.50399178326062,118.15658217159012,117.80937759489034,117.4623837340709,117.11560625991568,
	116.76905083314674,116.4227231045048,116.07662871484605,115.73077329525607,115.3851624671812,
	115.03980184257821,114.6946970240822,114.34985360519379,114.00527717048622,113.66097329583212,
	113.31694754865185,112.97320548818246,112.6297526657695,112.28659462518105,111.94373690294525,
	111.60118502871188,111.25894452563854,110.9170209108028,110.57541969563962,110.23414638640656,
	109.89320648467626,109.55260548785736,109.21234888974534,108.87244218110244,108.53289085026962,
	108.19370038380971,107.85487626718384,107.516423985461,107.17834902406257,106.84065686954254,
	106.50335301040391,106.1664429379529,105.82993214719166,105.4938261377507,105.1581304148618,
	104.82285049037289,104.48799188380556,104.15356012345677,103.81956074754534,103.4859993054052,
	103.15288135872535,102.8202124828391,102.48799826806251,102.1562443210842,101.82495626640716,
	101.49413974784376,101.16380043006565,100.83394400020967,100.50457616953992,100.17570267516902,
	99.84732928183824,99.51946178375871,99.19210600651364,98.86526780902587,98.53895308558207,
	98.21316776793539,97.88791782746156,97.56320927738867,97.2390481750935,96.91544062446751,
	96.59239277835228,96.26991084104584,95.94800107088055,95.62666978287258,95.30592335144453,
	94.98576821321984,94.66621086989136,94.3472578911623,94.02891591776073,93.71119166452664,
	93.39409192357192,93.07762356751167,92.76179355276685,92.4466089229368,92.1320768122406,
	91.81820444902499,91.50499915933784,91.19246837056451,90.88061961512416,90.56946053422371,
	90.25899888166599,89.94924252770774,89.64019946296412,89.33187780235441,89.02428578908365,
	88.7174317986553,88.41132434290733,88.10597207406614,87.80138378880966,87.4975684323322,
	87.19453510240172,86.89229305340007,86.5908517003356,86.29022062281733,85.99040956897794,
	85.69142845933365,85.39328739056641,85.09599663921408,84.7995666652533,84.5040081155576,
	84.20933182721443,83.91554883068171,83.62267035276443,83.33070781939175,83.03967285817183,
	82.74957730070282,82.46043318461655,82.17225275532985,81.88504846747914,81.5988329860117,
	81.31361918690621,81.02942015749602,80.74624919636561,80.46411981279172,80.18304572570007,
	79.903040862107,79.62411935501676,79.34629554074377,79.06958395563005,78.79399933212771,
	78.51955659421728,78.24627085213261,77.97415739636556,77.70323169092187,77.43350936580461,
	77.16500620869971,76.8977381558428,76.6317212820468,76.36697178987342,76.1035059979336,
	75.84134032830578,75.58049129306377,75.32097547990993,75.06280953691314,74.8060101563557,
	74.55059405769731,74.29657796967014,74.04397861152209,73.79281267343357,73.54309679613525,
	73.29484754976292,73.04808141198875,72.802814745476,72.55906377470843,72.31684456225295,
	72.07617298451832,71.83706470707861,71.59953515963662,71.3635995107052,71.12927264209152,
	70.89656912327169,70.66550318574804,70.4360886974848,70.20833913751983,69.98226757085278,
	69.75788662371194,69.53520845930174,69.31424475413417,69.09500667504535,68.87750485699863,
	68.6617493817713,68.44774975762158,68.2355149000257,68.02505311357336,67.81637207510225,
	67.60947881814783,67.4043797187774,67.20108048287072,66.99958613490138,66.79990100826545,
	66.60202873719605,66.40597225029222,66.2117337656838,66.01931478784327,65.82871610604771,
	65.63993779448433,65.4529792139855,65.26783901536899,65.08451514435278,64.90300484800476,
	64.72330468268096,64.54541052339874,64.36931757458554,64.19502038213767,64.02251284671856,
	63.85178823822224,63.68283921132311,63.51565782203031,63.35023554516328,63.18656329266223,
	63.02463143264731,62.864429809138834,62.70594776235199,62.54917414947916,62.39409736587565,
	62.2407053665647,62.0889856879812,61.93892546987558,61.790511477302275,61.64373012262029,
	61.498567487438,61.35500934443579,61.21304117900702,61.07264821065926,60.93381541412335,
	60.796527540121595,60.66076913575066,60.526524564438645,60.39377802544065,60.26251357284031,
	60.13271513402931,60.004366527640826,59.87745148091579,59.75195364648556,59.627856618556756,
	59.50514394848808,59.38379915975155,59.26380576227367,59.145147266154126,59.027807194762886,
	58.911769097218304,58.797016560250405,58.683533219456834,58.57130276995921,58.46030897646962,
	58.35053568277878,58.241966820678094,58.13458641832868,58.02837860809201,57.92332763383699,
	57.81941785773901,57.7166337665874,57.61495997761729,57.51438124388326,57.41488245919113,
	57.316448662605595,57.21906504255023,57.12271694051715,57.02738985440343,56.93306944149073,
	56.839741521084726,56.7473920768308,56.6560072587216,56.56557338481255,56.47607694265977,
	56.38750459049644,56.29984315816051,56.213079647789264,56.12720123429306,56.04219526562215,
	55.95804926283873,55.8747509200068,55.79228810391093,55.71064885361587,55.62982137987739,
	55.54979406441453,55.4705554590536,55.392094284753,55.3143994305179,55.237459952213456,
	55.16126507128472,55.08580417339091,55.01106680696149,54.93704268168078,54.86372166690836,
	54.79109379004072,54.71914923482066,54.647878339599814,54.577271595559374,54.50731964489464,
	54.4380132789671,54.369343436412954,54.30130120131234,54.2338778011653,54.16706460503104,
	54.10085312156218,54.03523499704844,53.97020201345437,53.90574608645311,53.84185926345903,
	53.77853372166177,53.715761766063856,53.653535827523505,53.59184846080517,53.5306923426392,
	53.47006026979211,53.40994515714921,53.3503400358109,53.291238051203614,53.23263246120702,
	53.17451663429772,53.11688404771146,53.05972828562367,53.0030430373495,52.94682209556437,
	52.89105935454485,52.835748808431056,52.78088454951084,52.726460766525875,52.67247174300047,
	52.6189118555929,52.56577557246999,52.513057451704654,52.46075213969678,52.40885436961773,
	52.35735895987806,52.30626081261896,52.255554912227126,52.20523632387315,52.155300192073284,
	52.105741739274634,52.05655626446363,52.0077391417974,51.9592858192583,51.91119181733126,
	51.863452727703624,51.81606421198748,51.7690220004642,51.72232189085106,51.67595974708939,
	51.6299314981546,51.58423313688707,51.53886071884445,51.493810361174354,51.449078241507884,
	51.404660596873015,51.360553722628204,51.31675397141544,51.27325775213276,51.23006152892581,
	51.18716182019814,51.14455519764008,51.10223828527575,51.060207758528,51.018460343300994,
	50.97699281508002,50.93580199804849,50.89488476422155,50.8542380325963,50.81385876831792,
	50.77374398186212,50.73389072823268,50.69429610617476,50.654957257403034,50.61587136584464,
	50.57703565689677,50.53844739669825,50.50010389141534,50.462002486541095,50.42414056620835,
	50.386515552515654,50.34912490486641,50.311966119320616,50.27503672795906,50.23833429825973,
	50.20185643248616,50.16560076708779,50.12956497211144,50.093746750624426,50.05814383814858,
	50.0227540021051,49.98757504127025,49.95260478524127,49.91784109391253,49.88328185696186,
	49.84892499332925,49.81476845079385,49.780810205378835,49.74704826095166,49.71348064873781,
	49.68010542686305,49.64692067990462,49.61392451845046,49.58111507866731,49.548490521876616,
	49.51604903413864,49.483788825844385,49.451708131315165,49.41980520840978,49.388078338139024,
	49.35652582428748,49.32514599304243,49.29393719262953,49.26289779295558,49.23202618525768,
	49.201320781759165,49.17078001533173,49.140402339163984,49.11018622643604,49.080130170000196,
	49.05023268206751,49.02049229390008,48.990907555509054,48.96147703535823,48.932199320073,
	48.903073014154586,48.874096739699716,48.84526913612516,48.81658885989738,48.78805458426713,
	48.75966499900881,48.73141881016457,48.703314739793036,48.67535152572248,48.64752792130856,
	48.619842695196354,48.59229463108655,48.564882527506086,48.53760519758253,48.51046146882274,
	48.48345018289538,48.45657019541721,48.42982037574331,48.40319960676089,48.37670678468676,
	48.35034081886832,48.32410063158814,48.2979851578719,48.271993345299684,48.24612415382049,
	48.22037655557019,48.194749534692306,48.16924208716225,48.14385322061432,48.11858195417176,
	48.09342731827989,48.068388354541895,48.04346411555746,48.01865366476428,47.99395607628216,
	47.96937043475977,47.944895835224095,47.920531382932325,47.896276193226235,47.87212939138915,
	47.84809011250522,47.824157501321025,47.80033071210953,47.77660890853642,47.75299126352841,
	47.72947695914402,47.70606518644624,47.68275514537759,47.65954604463686,47.636437101558315,
	47.61342754199249,47.59051660018924,47.567703518682414,47.5449875481768,47.52236794743644,
	47.49984398317515,47.47741492994855,47.45508007004808,47.43283869339651,47.41069009744517,
	47.388633587072974,47.36666847448682,47.344794079123886,47.32300972755522,47.301314753390876,
	47.279708497186824,47.25819030635298,47.23675953506293,47.21541554416499,47.19415770109462,
	47.172985379788294,47.15189796059873,47.1308948302113,47.109975381561874,47.08913901375597,
	47.06838513198895,47.0477131474677,47.02712247733337,47.00661254458529,46.98618277800615,
	46.96583261208833,46.94556148696113,46.92536884831941,46.90525414735321,46.88521684067826,
	46.865256390267874,46.84537226338552,46.825563932518705,46.80583087529567,46.78617257449485,
	46.766588517868136,46.74707819815624,46.72764111300707,46.70827676491549,46.688984661163445,
	46.669764313761405,46.65061523939035,46.6315369593448,46.612528999476574,46.59359089013956,
	46.57472216613489,46.555922366657455,46.53719103524278,46.518527719714776,46.49993197213434,
	46.48140334874868,46.46294140994123,46.444545720182404,46.4262158479812,46.407951365837,
	46.389751850192724,46.37161688138813,46.35354604361402,46.33553892486702,46.31759511690507,
	46.29971421520345,46.28189581891146,46.264139530809715,46.24644495726812,46.22881170820421,
	46.21123939704239,46.19372764067339,46.176276059414604,46.1588842769707,46.141551920395074,
	46.12427862005151,46.107064009576625,46.08990772584271,46.072809408921096,46.05576870204606,
	46.038785251579114,46.021858706973944,46.004988720741736,45.98817494841689,45.9714170485234,
	45.95471468254145,45.938067514874696,45.921475212817796,45.904937446524436,45.8884538889759,
	45.87202421594986,45.855648105989715,45.83932524037428,45.82305530308796,45.806837980791144,
	45.790672962791234,45.77455994101382,45.75849860997447,45.74248866675045,45.726529810953586,
	45.71062174470261,45.69476417259649,45.678956801687775,45.66319934145647,45.64749150378416,
	45.631833002928474,45.61622355549792,45.600662880426896,45.58515069895134,45.569686734584295,
	45.55427071309214,45.538902362470786,45.52358141292255,45.50830759683297,45.493080648748176,
	45.47790030535235,45.46276630544564,45.447678389922196,45.43263630174864,45.41763978594265,
	45.4026885895519,45.387782461633336,45.372921153232454,45.35810441736316,45.34333200898764,
	45.32860368499656,45.31391920418959,45.299278327255955,45.284680816755504,45.27012643709974,
	45.25561495453331,45.241146137115564,45.22671975470238,45.212335578928325,45.197993383188745,
	45.1836929426225,45.16943403409446,45.15521643617848,45.141039929140625,45.126904294922284,
	45.11280931712391,45.098754780988585,45.084740473386,45.070766182796525,45.05683169929555,
	45.04293681453789,45.02908132174252,45.01526501567739,45.001487692644446,44.987749150464786,
	44.97404918846416,44.96038760745838,44.946764209739065,44.93317879905958,44.919631180621,
	44.90612116105843,44.89264854842719,44.87921315218955,44.86581478320123,44.85245325369836,
	44.83912837728437,44.825839968901946,44.81258784488306,44.799371822839376,44.786191721716605,
	44.773047361764824,44.75993856452649,44.746865152824405,44.733826950749744,44.72082378365039,
	44.70785547811937,44.69492186198326,44.68202276429092,44.66915801530227,44.656327446477206,
	44.643530890464504,44.630768181091184,44.61803915335159,44.6053436433969,44.59268148852456,
	44.580052527167986,44.567456598886196,44.55489354435379,44.54236320535082,44.52986542475285,
	44.51740004652127,44.50496691569339,44.49256587837302,44.480196781720856,44.46785947394514,
	44.455553804292315,44.44327962303791,44.43103678147735,44.41882513191698,44.40664452766528,
	44.394494823023905,44.38237587327903,44.37028753469282,44.35822966449477,44.34620212087333,
	44.33420476296759,44.322237450859,44.3103000455632,44.29839240902189,44.28651440409498,
	44.274665894552506,44.262846745066916,44.25105682120527,44.239295989421606,44.22756411704932,
	44.2158610722937,44.20418672422449,44.19254094276849,44.18092359870239,44.169334563645485,
	44.15777371005252,44.146240911206746,44.13473604121289,44.123258974990215,44.11180958826579,
	44.10038775756755,44.08899336021778,44.07762627432642,44.06628637878446,44.05497355325751,
	44.04368767817935,44.03242863474559,44.021196304907306,44.009990571364895,43.998811317561845,
	43.98765842767866,43.976531786626786,43.965431280042644,43.95435679428171,43.943308216412596,
	43.93228543421134,43.921288336155555,43.91031681141876,43.899370749864836,43.888450042042294,
	43.87755457917886,43.86668425317597,43.85583895660332,43.845018582671685,43.834223025319794,
	43.823452179062784,43.81270593909062,43.801984201235165,43.79128686196518,43.78061381838125,
	43.769964968210736,43.75934020980288,43.74873944212385,43.738162564751875,43.72760947787244,
	43.717080082273576,43.706574279341055,43.69609197105371,43.68563305997888,43.675197449267735,
	43.66478504265079,43.65439574443337,43.64402945949119,43.63368609326586,43.62336555176059,
	43.61306774153583,43.60279256970496,43.59253994393005,43.58230977241766,43.5721019639146,
	43.56191642770395,43.55175307360076,43.54161181194819,43.53149255361333,43.52139520997637,
	43.51131969295991,43.501265914962694,43.49123378891142,43.48122322841923,43.47123414686305,
	43.46126645922109,43.451320080230126,43.44139492528937,43.43149091030316,43.42160795164421,
	43.41174596616736,43.4019048712025,43.392084584551036,43.38228502448229,43.372506109730196,
	43.36274775948972,43.35300989341355,43.34329243160863,43.33359529463295,43.323918403492115,
	43.314261679636104,43.304625044956055,43.295008421780985,43.2854117328746,43.27583490143216,
	43.26627785107732,43.25674050585908,43.247222790248564,43.23772462913609,43.228245947828135,
	43.2187866720442,43.209346727914046,43.199926041974564,43.19052454116698,43.18114215283382,
	43.17177880471617,43.162434424950774,43.15310894206722,43.1438022849851,43.134514383011336,
	43.125245165864385,43.11599456356952,43.10676250660108,43.097548925788,43.08835375233289,
	43.079176917809654,43.070018354160645,43.06087799369418,43.051755769082,43.04265161335671,
	43.03356545990922,43.024497242486284,43.01544689518805,43.00641435246554,42.99739954911826,
	42.988402420291784,42.97942290147535,42.97046092849949,42.96151643753367,42.952589365083995,
	42.943679647990834,42.93478722342658,42.92591202889334,42.917054002220745,42.90821308156359,
	42.899389205399764,42.890582312527904,42.881792342065374,42.87301923344597,42.864262926417844,
	42.855523361041335,42.84680047768693,42.83809421703307,42.829404520064166,42.820731328068526,
	42.8120745826363,42.803434225657405,42.794810199319635,42.78620244610655,42.77761090879561,
	42.76903553045614,42.760476254447426,42.751933024416786,42.743405784297636,42.73489447830765,
	42.726399050946824,42.717919446995566,42.70945561151309,42.701007489835234,42.692575027572886,
	42.68415817061016,42.675756865102485,42.6673710574749,42.659000694420364,42.6506457228979,
	42.64230609013087,42.63398174360538,42.62567263106838,42.61737870052618,42.60909990024255,
	42.60083617873734,42.5925874847845,42.58435376741073,42.57613497589365,42.567931059760305,
	42.55974196878553,42.551567652990336,42.54340806264042,42.53526314824449,42.52713286055279,
	42.519017150555534,42.510915969481374,42.502829268795956,42.49475700020032,42.48669911562943,
	42.478655567250804,42.47062630746285,42.462611288893584,42.454610464399146,42.446623787062265,
	42.438651210191,42.43069268731717,42.42274817219509,42.414817618800065,42.406900981327105,
	42.39899821418949,42.391109272017445,42.38323410965678,42.37537268216759,42.36752494482286,
	42.359690853107196,42.3518703627155,42.344063429551696,42.336270009727414,42.328490059560714,
	42.320723535574906,42.31297039449706,42.305230593257065,42.29750408898617,42.28979083899989,
	42.282090800859045,42.27440393227726,42.26673019117928,42.259069535685235,42.251421924109394,
	42.24378731495909,42.23616566693347,42.228556938922374,42.22096109000518,42.213378079449626,
	42.20580786671074,42.19825041142969,42.19070567343265,42.183173612729675,42.1756541895137,
	42.16814736415932,42.16065309722183,42.153171349435965,42.14570208171513,42.13824525514998,
	42.13080083100769,42.123368770730714,42.11594903593579,42.10854158841299,42.101146390124555,
	42.093763403204,42.0863925899551,42.07903391285079,42.0716873345323,42.06435281780807,
	42.05703032565283,42.04971982120659,42.04242126777373,42.035134628821986,42.02785986798152,
	42.020596949043984,42.013345835961594,42.006106492846136,41.99887888396815,41.99166297375591,
	41.98445872679458,41.977266107825265,41.970085081744145,41.96291561360157,41.9557576686012,
	41.94861121209907,41.94147620960278,41.9343526267706,41.92724042941057,41.92013958347973,
	41.91305005508323,41.90597181047345,41.898904816049246,41.89184903835502,41.88480444408,
	41.87777100005734,41.87074867326332,41.863737430816606,41.85673723997736,41.8497480681465,
	41.84276988286487,41.83580265181246,41.82884634280768,41.821900923806524,41.81496636290183,
	41.808042628322504,41.801129688432766,41.794227511731364,41.78733606685095,41.78045532255712,
	41.77358524774788,41.766725811452844,41.75987698283244,41.75303873117726,41.74621102590736,
	41.739393836571466,41.73258713284632,41.725790884535996,41.71900506157114,41.712229634008274,
	41.70546457202926,41.698709845940336,41.691965426171706,41.685231283276735,41.678507387931276,
	41.67179371093301,41.665090223200814,41.65839689577412,41.65171369981217,41.64504060659343,
	41.63837758751503,41.631724614091894,41.62508165795633,41.61844869085734,41.61182568465987,
	41.60521261134438,41.59860944300604,41.592016151854246,41.58543271021197,41.57885909051511,
	41.57229526531197,41.56574120726257,41.559196889138136,41.5526622838204,41.54613736430119,
	41.539622103681594,41.53311647517165,41.52662045208959,41.52013400786129,41.51365711601977,
	41.507189750204596,41.50073188416128,41.4942834917408,41.487844546898955,41.48141502369589,
	41.47499489629549,41.46858413896495,41.462182726074055,41.455790632094754,41.449407831600695,
	41.44303429926651,41.43667000986747,41.430314938278876,41.42396905947554,41.41763234853126,
	41.41130478061832,41.40498633100705,41.398676975065214,41.392376688257535,41.38608544614524,
	41.37980322438553,41.373529998731094,41.367265745029584,41.361010439223215,41.354764057348156,
	41.34852657553418,41.3422979700041,41.33607821707333,41.32986729314938,41.32366517473142,
	41.31747183840979,41.31128726086557,41.305111418870105,41.29894428928451,41.292785849059285,
	41.286636075233794,41.280494944935846,41.27436243538129,41.268238523873514,41.26212318780298,
	41.256016404646864,41.249918151968615,41.24382840741747,41.23774714872802,41.23167435371981,
	41.225610000297024,41.21955406644778,41.21350653024402,41.20746736984093,41.20143656347648,
	41.195414089471214,41.189399926227594,41.183394052229794,41.17739644604319,41.171407086313955,
	41.16542595176873,41.15945302121418,41.153488273536595,41.14753168770148,41.14158324275327,
	41.1356429178148,41.129710692087,41.12378654484853,41.11787045545535,41.11196240334035,
	41.10606236801301,41.10017032905896,41.09428626613973,41.088410158992254,41.08254198742849,
	41.07668173133527,41.07082937067364,41.064984885478744,41.059148255859284,41.053319461997354,
	41.047498484147845,41.041685302638356,41.035879897868654,41.030082250310386,41.024292340506776,
	41.018510149072185,41.0127356566919,41.006968844121644,41.0012096921874,40.99545818178492,
	40.989714293879494,40.98397800950561,40.97824930976658,40.97252817583425,40.96681458892952,
	40.9611085303975,40.95540998159551,40.94971892396621,40.94403533901923,40.938359208330745,
	40.93269051354323,40.92702923636513,40.92137535857053,40.91572886199889,40.910089728554695,
	40.90445794020718,40.89883347899002,40.893216327000985,40.887606466401735,40.882003879417425,
	40.87640854833641,40.870820455510085,40.86523958335242,40.85966591433978,40.85409943101056,
	40.84854011596498,40.842987951864714,40.83744292143269,40.831905007452704,40.82637419276927,
	40.82085046028719,40.815333792971394,40.80982417384662,40.80432158599712,40.79882601256642,
	40.793337436757064,40.787855841830236,40.782381211105665,40.77691352796117,40.77145277583258,
	40.765998938213265,40.76055199865406,40.755111940762916,40.74967874820464,40.744252404700624,
	40.738832894028675,40.733420200022614,40.72801430657216,40.72261519762259,40.71722285717453,
	40.711837269283706,40.70645841806065,40.70108628767049,40.695720862332756,40.69036212632097,
	40.68501006396261,40.67966465963873,40.67432589778373,40.66899376288518,40.66366823948357,
	40.65834931217201,40.653036965596044,40.64773118445342,40.64243195349384,40.63713925751871,
	40.63185308138098,40.626573409984836,40.621300228285556,40.61603352128911,40.610773274052235,
	40.60551947168188,40.60027209933523,40.595031142219334,40.58979658559103,40.584568414756525,
	40.57934661507137,40.57413117194014,40.568922070816264,40.56371929720176,40.558522836647086,
	40.553332674750855,40.5481487971597,40.54297118956801,40.537799837717735,40.5326347273982,
	40.52747584444588,40.52232317474418,40.51717670422324,40.51203641885979,40.50690230467688,
	40.50177434774362,40.49665253417517,40.49153685013238,40.48642728182161,40.48132381549463,
	40.47622643744829,40.47113513402445,40.46604989160971,40.460970696635215,40.45589753557653,
	40.45083039495341,40.44576926132954,40.44071412131248,40.4356649615534,40.43062176874689,
	40.425584529630804,40.42055323098606,40.41552785963644,40.41050840244844,40.40549484633109,
	40.40048717823575,40.39548538515588,40.39048945412703,40.38549937222648,40.38051512657313,
	40.37553670432737,40.370564092690806,40.36559727890622,40.36063625025724,40.355680994068344,
	40.35073149770448,40.34578774857113,40.34084973411389,40.33591744181856,40.33099085921074,
	40.326069973855866,40.321154773358856,40.31624524536409,40.311341377555166,40.30644315765483,
	40.30155057342464,40.29666361266499,40.29178226321483,40.28690651295156,40.28203634979087,
	40.27717176168655,40.27231273663033,40.26745926265178,40.262611327818114,40.25776892023397,
	40.252932028041435,40.248100639419704,40.24327474258499,40.23845432579042,40.233639377325886,
	40.22882988551773,40.224025838728835,40.21922722535833,40.21443403384146,40.20964625264943,
	40.20486387028932,40.20008687530389,40.1953152562714,40.19054900180559,40.18578810055536,
	40.18103254120477,40.17628231247286,40.17153740311343,40.16679780191506,40.16206349770081,
	40.157334479328156,40.15261073568883,40.14789225570873,40.14317902834768,40.13847104259945,
	40.13376828749143,40.12907075208463,40.124378425473516,40.11969129678589,40.115009355182664,
	40.11033258985785,40.105660990038366,40.10099454498387,40.09633324398672,40.09167707637179,
	40.087026031496315,40.08238009874981,40.07773926755393,40.07310352736234,40.06847286766055,
	40.06384727796585,40.05922674782717,40.0546112668249,40.050000824570844,40.04539541070804,
	40.04079501491066,40.03619962688388,40.031609236363764,40.027023833117134,40.022443406941456,
	40.01786794766472,40.013297445145305,40.00873188927189,40.00417126996331,39.99961557716843,
	39.99506480086606,39.99051893106484,39.985977957803044,39.98144187114859,39.97691066119882,
	39.97238431808044,39.96786283194938,39.963346192990706,39.95883439141845,39.9543274174756,
	39.94982526143389,39.94532791359372,39.94083536428409,39.93634760386241,39.93186462271442,
	39.92738641125416
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	240.90442332476144,240.88712024320165,240.86971494053603,240.85220676290857,240.83459505251412,
	240.81687914757762,240.79905838233347,240.78113208700472,240.76309958778236,240.74496020680428,
	240.7267132621345,240.708358067742,240.68989393348002,240.67132016506434,240.6526360640527,
	240.63384092782323,240.6149340495532,240.5959147181977,240.57678221846834,240.55753583081162,
	240.5381748313875,240.51869849204772,240.49910608031433,240.47939685935788,240.45957008797592,
	240.43962502057076,240.41956090712807,240.3993769931949,240.3790725198575,240.3586467237196,
	240.33809883688042,240.31742808691234,240.29663369683885,240.2757148851126,240.2546708655928,
	240.2335008475234,240.21220403551044,240.19077962950004,240.16922682475553,240.14754481183556,
	240.12573277657134,240.10378990004418,240.08171535856303,240.05950832364195,240.03716796197725,
	240.01469343542522,239.99208390097925,239.9693385107471,239.94645641192838,239.92343674679154,
	239.90027865265134,239.87698126184583,239.85354370171368,239.82996509457126,239.80624455768975,
	239.78238120327228,239.758374138431,239.7342224651642,239.7099252803333,239.68548167563983,
	239.6608907376027,239.63615154753498,239.6112631815209,239.58622471039305,239.56103519970915,
	239.53569370972926,239.5101992953924,239.4845510062941,239.45874788666265,239.43278897533685,
	239.40667330574234,239.38039990586896,239.35396779824762,239.32737599992743,239.30062352245247,
	239.27370937183906,239.2466325485527,239.21939204748503,239.1919868579312,239.1644159635666,
	239.13667834242423,239.10877296687173,239.08069880358863,239.05245481354348,239.02403995197108,
	238.9954531683498,238.96669340637885,238.93775960395556,238.90865069315277,238.87936560019645,
	238.84990324544282,238.82026254335605,238.790442402486,238.76044172544525,238.73025940888746,
	238.69989434348463,238.66934541390512,238.63861149879136,238.6076914707377,238.57658419626864,
	238.54528853581664,238.51380334370032,238.4821274681026,238.45025975104915,238.41819902838657,
	238.38594412976087,238.353493878596,238.32084709207248,238.28800258110624,238.25495915032698,
	238.22171559805778,238.18827071629346,238.15462329068012,238.12077210049404,238.08671591862145,
	238.0524535115374,238.01798363928592,237.9833050554593,237.94841650717828,237.91331673507142,
	237.87800447325586,237.84247844931724,237.80673738428985,237.77077999263759,237.73460498223415,
	237.6982110543443,237.66159690360436,237.62476121800375,237.58770267886598,237.55041996083023,
	237.51291173183301,237.47517665308985,237.43721337907735,237.3990205575153,237.36059682934902,
	237.32194082873195,237.28305118300844,237.24392651269648,237.2045654314709,237.16496654614713,
	237.12512845666402,237.0850497560682,237.04472903049793,237.00416485916725,236.96335581435045,
	236.92230046136697,236.88099735856593,236.83944505731185,236.7976421019696,236.75558702989045,
	236.71327837139776,236.67071464977334,236.62789438124403,236.5848160749682,236.541478233023,
	236.49787935039177,236.4540179149514,236.4098924074604,236.36550130154728,236.3208430636988,
	236.27591615324891,236.23071902236805,236.1852501160526,236.13950787211454,236.0934907211717,
	236.04719708663833,236.0006253847159,235.9537740243842,235.90664140739312,235.85922592825435,
	235.8115259742338,235.76353992534413,235.71526615433805,235.66670302670155,235.61784890064786,
	235.5687021271115,235.51926104974322,235.46952400490486,235.4194893216649,235.36915532179435,
	235.31852031976314,235.26758262273677,235.2163405305738,235.16479233582325,235.112936323723,
	235.06077077219823,235.00829395186048,234.9555041260075,234.90239955062296,234.84897847437736,
	234.79523913862866,234.7411797774242,234.6867986175028,234.63209387829687,234.57706377193634,
	234.52170650325158,234.46602026977817,234.41000326176126,234.35365366216124,234.29696964665945,
	234.23994938366482,234.18259103432055,234.12489275251244,234.06685268487632,234.00846897080763,
	233.94973974247043,233.8906631248078,233.8312372355523,233.77146018523754,233.71133007720996,
	233.65084500764175,233.59000306554415,233.52880233278105,233.46724088408436,233.40531678706847,
	233.34302810224736,233.28037288305032,233.21734917584013,233.15395501993103,233.09018844760746,
	233.02604748414393,232.9615301478254,232.8966344499683,232.83135839494258,232.76569998019414,
	232.69965719626873,232.63322802683558,232.5664104487132,232.49920243189453,232.43160193957394,
	232.3636069281747,232.29521534737728,232.22642514014842,232.15723424277112,232.08764058487574,
	232.01764208947134,231.9472366729786,231.8764222452632,231.8051967096702,231.73355796305918,
	231.66150389584078,231.58903239201334,231.51614132920125,231.442828578694,231.36909200548575,
	231.29492946831667,231.2203388197143,231.14531790603672,231.06986456751622,230.99397663830405,
	230.91765194651634,230.84088831428073,230.76368355778445,230.68603548732287,230.60794190734947,
	230.52940061652708,230.45040940777935,230.37096606834425,230.2910683798279,230.21071411825994,
	230.12990105414983,230.04862695254405,229.96688957308487,229.88468667006984,229.8020159925125,
	229.71887528420436,229.63526228377782,229.5511747247706,229.4666103356906,229.38156684008302,
	229.29604195659755,229.2100333990575,229.12353887652984,229.0365560933965,228.94908274942674,
	228.86111653985088,228.7726551554355,228.6836962825593,228.59423760329076,228.5042767954666,
	228.41381153277194,228.32283948482137,228.2313583172415,228.1393656917548,228.0468592662645,
	227.95383669494126,227.8602956283105,227.76623371334165,227.67164859353846,227.5765379090305,
	227.48089929666645,227.38473039010802,227.2880288199261,227.19079221369765,227.0930181961039,
	226.99470438903066,226.8958484116689,226.79644788061782,226.69650040998872,226.59600361150999,
	226.49495509463452,226.39335246664731,226.2911933327754,226.1884752962989,226.08519595866326,
	225.98135291959346,225.87694377720905,225.77196612814112,225.6664175676505,225.56029568974756,
	225.45359808731305,225.34632235222114,225.23846607546326,225.13002684727377,225.02100225725698,
	224.9113898945156,224.8011873477809,224.69039220554424,224.5790020561899,224.46701448812965,
	224.35442708993898,224.24123745049425,224.12744315911195,224.01304180568897,223.89803098084502,
	223.78240827606572,223.66617128384806,223.54931759784662,223.4318448130219,223.31375052578986,
	223.1950323341728,223.07568783795256,222.95571463882393,222.83511034055104,222.71387254912403,
	222.59199887291808,222.46948692285338,222.34633431255713,222.22253865852664,222.09809758029425,
	221.97300870059328,221.84726964552638,221.72087804473423,221.5938315315668,221.4661277432554,
	221.33776432108667,221.20873891057778,221.07904916165316,220.94869272882303,220.8176672713628,
	220.68597045349475,220.55359994457035,220.42055341925462,220.2868285577118,220.15242304579243,
	220.01733457522198,219.88156084379045,219.74509955554444,219.60794842097945,219.47010515723454,
	219.33156748828765,219.19233314515304,219.0523998660796,218.91176539675084,218.77042749048584,
	218.62838390844226,218.48563241982018,218.34217080206722,218.1979968410853,218.05310833143898,
	217.90750307656393,217.76117888897835,217.61413359049442,217.46636501243145,217.31787099583042,
	217.1686493916694,217.0186980610807,216.8680148755688,216.7165977172296,216.5644444789712,
	216.41155306473516,216.25792138971957,216.1035473806027,215.9484289757687,215.79256412553303,
	215.6359507923701,215.47858695114158,215.3204705893257,215.16159970724772,215.0019723183112,
	214.84158644923065,214.68044014026455,214.51853144545004,214.35585843283783,214.19241918472864,
	214.02821179790996,213.86323438389422,213.69748506915724,213.530961995378,213.36366331967892,
	213.1955872148668,213.02673186967485,212.8570954890052,212.68667629417206,212.5154725231457,
	212.34348243079697,212.1707042891426,211.99713638759061,211.822777033187,211.64762455086216,
	211.47167728367862,211.29493359307835,211.11739185913154,210.9390504807848,210.75990787611028,
	210.57996248255517,210.3992127571912,210.2176571769649,210.03529423894727,209.85212246058487,
	209.66814037995002,209.48334655599157,209.29773956878626,209.11131801978902,208.92408053208473,
	208.7360257506386,208.5471523425477,208.35745899729184,208.1669444269844,207.97560736662302,
	207.78344657434042,207.59046083165467,207.39664894371938,207.20200973957375,207.00654207239194,
	206.81024481973228,206.6131168837865,206.4151571916277,206.21636469545854,206.01673837285858,
	205.81627722703115,205.61498028704992,205.41284660810396,205.20987527174364,205.00606538612388,
	204.80141608624848,204.5959265342126,204.38959591944433,204.18242345894635,203.9744083975354,
	203.76555000808173,203.55584759174712,203.34530047822201,203.13390802596135,202.92166962241942,
	202.70858468428358,202.49465265770658,202.27987301853773,202.0642452725527,201.84776895568191,
	201.63044363423765,201.41226890513974,201.1932443961394,200.97336976604194,200.75264470492775,
	200.53106893437163,200.30864220766026,200.08536431000832,199.86123505877245,199.63625430366392,
	199.41042192695863,199.18373784370607,198.9562020019357,198.72781438286165,198.4985750010852,
	198.26848390479543,198.03754117596722,197.80574693055786,197.57310131870045,197.33960452489606,
	197.10525676820254,196.87005830242185,196.6340094162845,196.3971104336316,196.1593617135945,
	195.92076365077168,195.6813166754034,195.44102125354337,195.19987788722807,194.95788711464286,
	194.7150495102857,194.4713656851283,194.22683628677368,193.98146199961133,193.73524354496934,
	193.48818168126377,193.24027720414443,192.99153094663805,192.7419437792881,192.49151661029185,
	192.24025038563366,191.9881460892152,191.73520474298297,191.48142740705165,191.22681517982454,
	190.97136919811072,190.7150906372384,190.4579807111651,190.20004067258418,189.9412718130279,
	189.6816754629668,189.4212529919056,189.1600058084751,188.89793536052088,188.63504313518808,
	188.37133065900204,188.1067994979458,187.84145125753324,187.5752875828786,187.30831015876197,
	187.0405207096913,186.77192099995958,186.5025128336989,186.23229805492997,185.96127854760792,
	185.68945623566378,185.41683308304195,185.14341109373345,184.86919231180542,184.5941788214259,
	184.31837274688465,184.04177625260962,183.76439154317987,183.48622086333282,183.2072664979686,
	182.92753077214937,182.64701605109448,182.3657247401712,182.0836592848811,181.80082217084208,
	181.51721592376637,181.23284310943313,180.94770633365778,180.66180824225603,180.37515152100383,
	180.08773889559288,179.79957313158155,179.51065703434116,179.22099344899823,178.93058526037174,
	178.63943539290602,178.3475468105993,178.0549225169277,177.76156555476422,177.46747900629407,
	177.1726659929247,176.8771296751916,176.5808732526596,176.28389996381966,175.98621308598095,
	175.68781593515854,175.38871186595674,175.08890427144738,174.78839658304435,174.48719227037296,
	174.1852948411351,173.88270784097003,173.5794348533106,173.2754794992349,172.9708454373133,
	172.6655363634519,172.35955601073059,172.052908149237,171.74559658589655,171.4376251642974,
	171.12899776451184,170.8197183029123,170.5097907319845,170.19921904013498,169.8880072514951,
	169.5761594257207,169.26367965778735,168.95057207778208,168.63684085068977,168.32249017617684,
	168.00752428836978,167.69194745563027,167.37576398032593,167.05897819859732,166.741594480121,
	166.42361722786825,166.105050877861,165.78589989892265,165.46616879242586,165.14586209203657,
	164.82498436345432,164.50354020414858,164.18153424309182,163.85897114048916,163.53585558750416,
	163.21219230598126,162.88798604816515,162.5632415964162,162.23796376292321,161.91215738941267,
	161.58582734685464,161.25897853516597,160.93161588291002,160.60374434699375,160.27536891236159,
	159.94649459168656,159.61712642505887,159.28726947967115,158.95692884950162,158.62610965499434,
	158.29481704273715,157.96305618513674,157.6308322800921,157.29815055066473,156.96501624474746,
	156.63143463473062,156.29741101716633,155.96295071243074,155.62805906438425,155.29274144003068,
	154.9570032291732,154.62084984407028,154.2842867190889,153.94731931035702,153.60995309541417,
	153.27219357286114,152.93404626200825,152.59551670252299,152.25661045407585,151.91733309598618,
	151.57769022686682,151.2376874642682,150.89733044432163,150.5566248213827,150.2155762676737,
	149.87419047292656,149.53247314402492,149.19043000464688,148.8480667949076,148.505389271002,
	148.16240320484857,147.81911438373268,147.4755286099516,147.13165170045943,146.78748948651383,
	146.44304781332278,146.09833253969384,145.7533495376837,145.40810469224974,145.06260390090324,
	144.71685307336443,144.37085813121936,144.02462500757917,143.67815964674162,143.33146800385475,
	142.98455604458402,142.63742974478123,142.29009509015762,141.94255807595917,141.59482470664605,
	141.2469009955752,140.89879296468695,140.5505066441956,140.2020480722842,139.85342329480392,
	139.50463836497778,139.15569934310943,138.80661229629726,138.4573832981533,138.1080184285285,
	137.75852377324304,137.40890542382334,137.05916947724518,136.70932203568347,136.35936920626915,
	136.00931710085268,135.65917183577582,135.308939531651,134.95862631314787,134.60823830878988,
	134.25778165075798,133.90726247470477,133.5566869195769,133.20606112744812,132.85539124336196,
	132.5046834151851,132.1539437934718,131.80317853133846,131.4523937843521,131.10159571042894,
	130.7507904697462,130.39998422466704,130.04918313967852,129.69839338134398,129.34762111826925,
	128.99687252108396,128.6461537624383,128.29547101701542,127.94483046156071,127.59423827492719,
	127.24370063813956,126.89322373447534,126.5428137495656,126.19247687151433,125.8422192910382,
	125.49204720162678,125.14196679972427,124.79198428493287,124.44210586023914,124.09233773226383,
	123.74268611153548,123.39315721278952,123.04375725529275,122.69449246319441,122.3453690659047,
	121.99639329850187,121.6475714021675,121.29890962465309,120.9504142207764,120.6020914529506,
	120.25394759174573,119.90598891648426,119.55822171587147,119.21065228866205,118.86328694436313,
	118.51613200397591,118.16919380077641,117.82247868113643,117.47599300538619,117.12974314871948,
	116.78373550214316,116.43797647347137,116.09247248836643,115.74722999142737,115.40225544732745,
	115.0575553420022,114.71313618388882,114.36900450521888,114.02516686336529,113.68162984224497,
	113.33840005377921,112.9954841394119,112.65288877168821,112.31062065589484,111.96868653176277,
	111.62709317523459,111.28584740029741,110.94495606088289,110.60442605283605,110.26426431595353,
	109.92447783609347,109.58507364735802,109.24605883434938,108.90744053450135,108.56922594048714,
	108.23142230270442,107.89403693183957,107.55707720151067,107.22055055099187,106.88446448801834,
	106.54882659167411,106.21364451536171,105.87892598985584,105.54467882643979,105.21091092012615,
	104.87763025296093,104.54484489741088,104.21256301983448,103.88079288403486,103.54954285489468,
	103.21882140209097,102.88863710388944,102.55899865101564,102.22991485060143,101.90139463020374,
	101.57344704189371,101.24608126641174,100.9193066173857,100.59313254560735,100.2675686433657,
	99.94262464881514,99.61831045041242,99.29463609136464,98.97161177411843,98.64924786486826,
	98.32755489807735,98.00654358100172,97.68622479820827,97.36660961607463,97.04770928726012,
	96.72953525513456,96.41209915815107,96.09541283414923,95.77948832457179,95.46433787857902,
	95.14997395704297,94.83640923640256,94.52365661235987,94.21172920339642,93.90064035408761,
	93.59040363819196,93.28103286149042,92.97254206435083,92.66494552399091,92.35825775641158,
	92.0524935179726,91.74766780658068,91.44379586245935,91.14089316846965,90.83897544994875,
	90.53805867403487,90.23815904844416,89.93929301966617,89.6414772705445,89.34472871720786,
	89.04906450531809,88.75450200560115,88.46105880862896,88.16875271881838,87.87760174761713,
	87.58762410584656,87.29883819517232,87.01126259867685,86.72491607050934,86.43981752459135,
	86.15598602235899,85.87344075952599,85.59220105185568,85.31228631993316,85.03371607293404,
	84.75650989138987,84.48068740895569,84.20626829319039,83.93327222536598,83.6617188793269,
	83.39162789942797,83.12301887758436,82.8559113294736,82.5903246699367,82.32627818763103,
	82.06379101899434,81.80288212158649,81.54357024688018,81.28587391257936,81.02981137454974,
	80.77540059845002,80.52265923115972,80.27160457210186,80.02225354456468,79.7746226671291,
	79.52872802531203,79.28458524353717,79.0422094575473,78.801615287372,78.56281681096493,
	78.32582753862317,78.09066038830035,77.85732766192142,77.62584102280421,77.39621147428709,
	77.16844933965932,76.94256424348143,76.7185650943788,76.49646006938343,76.2762565998893,
	76.05796135928102,75.84158025228452,75.6271184060787,75.41458016319969,75.20396907625707,
	74.99528790447299,74.78853861204468,74.58372236832172,74.38083954977863,74.17988974375584,
	73.9808717539317,73.78378360748017,73.58862256386207,73.39538512518807,73.20406704808737,
	73.01466335700825,72.82716835887216,72.64157565899775,72.45787817820847,72.27606817103235,
	72.09613724490248,71.91807638026297,71.7418759514853,71.56752574849942,71.3950149990443,
	71.2243323914433,71.05546609781202,70.88840379760722,70.72313270142901,70.55963957499085,
	70.3979107631754,70.23793221409761,70.07968950310095,69.92316785661666,69.76835217581927,
	69.61522706001803,69.46377682972614,69.3139855493563,69.16583704949423,69.01931494870725,
	68.87440267484862,68.73108348582409,68.58934048978982,68.44915666475615,68.31051487757523,
	68.17339790229427,68.03778843785989,67.90366912516275,67.77102256341462,67.63983132585247,
	67.51007797476885,67.38174507586797,67.25481521195123,67.12927099593738,67.0050950832243,
	66.88227018340206,66.76077907132674,66.64060459756894,66.52172969824844,66.40413740427081,
	66.28781084998107,66.17273328124978,66.05888806300985,65.94625868626046,65.8348287745558,
	65.72458208999743,65.61550253874796,65.50757417608455,65.40078121101078,65.2951080104451,
	65.19053910300394,65.08705918239781,64.98465311045807,64.88330591981163,64.78300281622086,
	64.6837291806057,64.58547057076419,64.48821272280722,64.39194155232317,64.29664315528777,
	64.20230380873319,64.10890997119083,64.01644828292139,63.92490556594519,63.83426882388542,
	63.744525241636424,63.65566218486861,63.56766719938115,63.480528010313016,63.39423252122284,
	63.308768813046775,63.22412514292495,63.140289943022715,63.05725181905418,62.974999548926746,
	62.89352208119872,62.81280853348636,62.73284819080528,62.653630503852405,62.57514508723464,
	62.49738171764996,62.42033033202628,62.343981025623236,62.268324050101626,62.193349811565064,
	62.11904886857789,62.045411930163546,61.97242985378688,61.900093643323956,61.82839444702263,
	61.75732355545694,61.68687239947776,61.61703254816303,61.54779570676934,61.47915371468734,
	61.411098543403305,61.34362229446832,61.27671719747741,61.21037560805965,61.14459000588135,
	61.079352992663175,61.01465729021303,60.95049573847507,60.88686129359692,60.82374702601489,
	60.76114611855909,60.69905186457851,60.637457666087016,60.57635703193087,60.51574357597825,
	60.4556110153313,60.39595316856098,60.336763953965274,60.27803738785096,60.219767582838784,
	60.16194874619333,60.10457517817612,60.047641270423625,59.99114150434919,59.93507044956953,
	59.879422762355205,59.824193184105724,59.76937653984865,59.71496773676305,59.66096176272668,
	59.60735368488744,59.55413864825832,59.501311874335975,59.448868659742836,59.396804374892284,
	59.34511446267689,59.29379443717943,59.24283988240626,59.192246451043275,59.142009863233646,
	59.09212590537739,59.042590428952515,58.993399349357176,58.94454864477311,58.896034355049274,
	58.84785258060635,58.799999481360686,58.7524712756688,58.70526423929064,58.65837470437238,
	58.61179905844806,58.565533743459824,58.51957525479628,58.47392014034912,58.42856499958713,
	58.38350648264772,58.338741289445736,58.294266168798636,58.250077917568625,58.20617337982075,
	58.16254944599702,58.1192030521061,58.07613117892847,58.03333085123663,57.99079913703012,
	57.948533146785024,57.9065300327179,57.86478698806356,57.82330124636667,57.78207008078676,
	57.74109080341677,57.70036076461396,57.65987735234427,57.619637991538575,57.57964014346167,
	57.539881305092784,57.50035900851836,57.46107082033598,57.42201434106989,57.38318720459746,
	57.34458707758656,57.30621165894375,57.26805867927271,57.230125900343154,57.192411114569445,
	57.154912144480726,57.11762684229628,57.080553089314726,57.04368879551231,57.00703189904821,
	56.97058036579959,56.93433218890557,56.89828538831946,56.862438010369594,56.82678812732831,
	56.79133383698905,56.756073262251185,56.72100455071272,56.68612587427066,56.651435428728504,
	56.6169314334113,56.58261213078774,56.54847578609912,56.51452068699542,56.48074514317783,
	56.44714748604796,56.41372606836353,56.380479263900284,56.347405467120204,56.31450309284569,
	56.28177057593973,56.24920637099189,56.21680895201001,56.18457681211748,56.15250846325598,
	56.12060243589367,56.08885727873866,56.05727155845734,56.025843859398286,55.994572783320656,
	55.963456949127725,55.932494992605,55.90168556616319,55.87102733858559,55.84051899477996,
	55.81015923553502,55.779946777280905,55.74988035185407,55.719958706266425,55.690180602478165,
	55.66054481717502,55.63105014154907,55.601695381083566,55.57247935534145,55.54340089775748,
	55.51445885543421,55.485652088941094,55.45697947211745,55.42843989187865,55.40003224802556,
	55.3717554530575,55.34360843198809,55.31559012216454,55.28769947308986,55.25993544624804,
	55.232297014932406,55.204783164076666,55.17739289008897,55.15012520068861,55.12297911474569,
	55.09595366212327,55.06904788352221,55.04226083032873,55.01559156446435,54.9890391582385,
	54.96260269420322,54.936281265010834,54.910073973273434,54.88397993142499,54.85799826158564,
	54.83212809542822,54.80636857404682,54.78071884782794,54.755178076323105,54.72974542812411,
	54.70442008073992,54.67920122047586,54.654088042314406,54.62907974979829,54.604175554915095,
	54.579374677984056,54.5546763475444,54.530079800245595,54.50558428073927,54.4811890415731,
	54.45689334308594,54.43269645330497,54.40859764784428,54.3845962098053,54.36069142967835,
	54.336882605246196,54.31316904148881,54.289550050489716,54.266024951343844,54.24259307006675,
	54.21925373950515,54.19600629924916,54.17285009554539,54.14978448121191,54.126808815554014,
	54.10392246428176,54.08112479942838,54.05841519927008,54.03579304824714,54.013257736886096,
	53.990808661723094,53.96844522522849,53.94616683573251,53.92397290735208,53.901862859918666,
	53.879836118907306,53.85789211536667,53.83603028585001,53.81425007234742,53.79255092221886,
	53.77093228812819,53.749393627978364,53.72793440484739,53.70655408692525,53.685252147451905,
	53.6640280646559,53.642881321694226,53.62181140659281,53.60081781218786,53.57990003606829,
	53.55905758051871,53.53828995246337,53.51759666341091,53.496977229399874,53.47643117094503,
	53.455958012984354,53.43555728482702,53.41522852010177,53.39497125670633,53.374785036757395,
	53.35466940654134,53.334623916465596,53.31464812101082,53.29474157868359,53.274903851969846,
	53.25513450728897,53.23543311494854,53.21579924909961,53.19623248769268,53.17673241243428,
	53.157298608744235,53.13793066571317,53.11862817606118,53.099390736096474,53.080217945674974,
	53.06110940816034,53.042064730384524,53.0230835226088,53.00416539848555,52.98530997502026,
	52.96651687253429,52.94778571462803,52.92911612814444,52.91050774313336,52.89196019281608,
	52.87347311355035,52.85504614479602,52.83667892908115,52.81837111194776,52.80012234200225,
	52.781932270755654,52.763800552677566,52.74572684514236,52.72771080839791,52.709752105534484,
	52.6918504024544,52.67400536784161,52.656216673132114,52.63848399248443,52.62080700275076,
	52.603185383448206,52.58561881673047,52.568106987360146,52.55064958268104,52.53324629259097,
	52.515896809514935,52.49860082837873,52.48135804658257,52.46416816397546,52.44703088282955,
	52.429945907815,52.412912945975144,52.39593170670191,52.37900190171155,52.362123245020726,
	52.345295452922834,52.32851824396479,52.31179133892379,52.295114460784596,52.278487334717155,
	52.26190968805423,52.24538125026961,52.22890175295633,52.212470929805356,52.19608851658435,
	52.179754251116876,52.163467873261844,52.14722912489294,52.13103774987859,52.114893494062244,
	52.09879610524247,52.0827453331537,52.06674092944707,52.05078264767146,52.034870243254716,
	52.019003473485284,52.003182097493884,51.98740587623542,51.971674572471294,51.955987950751584,
	51.94034577739781,51.92474782048562,51.90919384982789,51.89368363695783,51.878216955112386,
	51.86279357921591,51.84741328586391,51.83207585330696,51.81678106143496,51.801528691761405,
	51.786318527407985,51.7711503530892,51.75602395509734,51.74093912128753,51.72589564106285,
	51.710893305359875,51.69593190663417,51.68101123884608,51.66613109744655,51.651291279363235,
	51.63649158298672,51.62173180815692,51.607011756149454,51.59233122966257,51.5776900328038,
	51.56308797107698,51.5485248513694,51.53400048193908,51.519514672402174,51.50506723372047,
	51.490657978189205,51.476286719424785,51.4619532723528,51.44765745319612,51.43339907946315,
	51.41917796993613,51.40499394465973,51.39084682492949,51.376736433280826,51.36266259347762,
	51.3486251305014,51.33462387054041,51.32065864097872,51.30672927038577,51.29283558850569,
	51.278977426246854,51.265154615671726,51.2513669899865,51.23761438353104,51.22389663176905,
	51.210213571277905,51.19656503973924,51.182950875928974,51.1693709197079,51.15582501201227,
	51.14231299484429,51.12883471126298,51.115390005375005,51.10197872232555,51.08860070828937,
	51.075255810462004,51.06194387705082,51.04866475726655,51.03541830131449,51.022204360386134,
	51.009022786650675,50.99587343324671,50.98275615427399,50.96967080478528,50.956617240778286,
	50.94359531918756,50.93060489787681,50.917645835630864,50.90471799214806,50.8918212280325,
	50.8789554047865,50.866120384803104,50.85331603135859,50.84054220860518,50.82779878156369,
	50.815085616116434,50.802402578999946,50.789749537798045,50.777126360934716,50.76453291766737,
	50.751969078079796,50.73943471307551,50.726929694370995,50.7144538944891,50.70200718675237,
	50.68958944527661,50.67720054496442,50.664840361498804,50.652508771336834,50.640205651703376,
	50.62793088058503,50.615684336723746,50.603465899611,50.59127544948164,50.57911286730787,
	50.56697803479361,50.55487083436827,50.542791149181404,50.53073886309664,50.5187138606861,
	50.5067160272249,50.49474524868548,50.48280141173208,50.47088440371538,50.45899411266702,
	50.44713042729427,50.435293236974736,50.42348243175113,50.41169790232603,50.399939540056806,
	50.388207236950464,50.37650088565856,50.36482037947227,50.35316561231744,50.341536478749646,
	50.329932873949346,50.318354693716984,50.30680183446841,50.295274193229986,50.283771667633985,
	50.27229415591387,50.260841556899834,50.249413770014144,50.238010695266766,50.226632233250655,
	50.21527828513756,50.20394875267363,50.19264353817488,50.1813625445231,50.17010567516151,
	50.158872834090516,50.14766392586357,50.136478855582986,50.12531752889586,50.11417985199003,
	50.10306573158992,50.09197507495275,50.08090778986438,50.0698637846355,50.05884296809772,
	50.04784524959967,50.03687053900328,50.02591874667991,50.01498978350665,50.0040835608626,
	49.99319999062512,49.98233898516638,49.971500457349435,49.960684320525,49.949890488527515,
	49.939118875672015,49.92836939675037,49.917641967027905,49.90693650224001,49.896252918588736,
	49.885591132739364,49.87495106181719,49.86433262340408,49.8537357355353,49.843160316696235,
	49.83260628581918,49.82207356228009,49.81156206589548,49.801071716919296,49.79060243603977,
	49.78015414437635,49.76972676347667,49.759320215313444,49.748934422281565,49.73856930719512,
	49.72822479328438,49.71790080419282,49.70759726397448,49.697314097090754,49.68705122840779,
	49.676808583193534,49.666586087115014,49.6563836662355,49.64620124701176,49.63603875629136,
	49.62589612131,49.615773269688674,49.60567012943114,49.595586628921296,49.58552269692048,
	49.57547826256495,49.56545325536323,49.555447605193685,49.545461242301826,49.53549409729795,
	49.52554610115461,49.5156171852041,49.50570728113611,49.495816320995154,49.48594423717831,
	49.47609096243276,49.46625642985346,49.456440572880766,49.44664332529813,49.436864621229795,
	49.427104395138436,49.417362581823085,49.407639116416604,49.397933934383694,49.38824697151859,
	49.37857816394283,49.368927448103086,49.35929476076915,49.34968003903154,49.34008322029961,
	49.33050424229933,49.32094304305226,49.31139956094994,49.301873734636075,49.29236550308246,
	49.28287480556713,49.27340158167263,49.263945771283765,49.2545073145857,49.24508615206209,
	49.235682224493075,49.2262954729533,49.21692583881008,49.20757326372144,49.198237689634375,
	49.188919058782744,49.17961731368567,49.17033239714553,49.16106425224614,49.15181282235114,
	49.14257805110194,49.133359882416094,49.124158260485466,49.114973129774576,49.10580443501874,
	49.09665212122246,49.0875161336576,49.078396417861754,49.069292919636595,49.0602055850461,
	49.051134360415006,49.04207919232711,49.033040027623606,49.02401681340149,49.01500949701204,
	49.00601802605906,48.9970423483974,48.98808241213141,48.97913816561328,48.97020955744159,
	48.96129653645972,48.95239905175437,48.94351705265395,48.93465048872727,48.925799309781844,
	48.91696346586256,48.908142907250095,48.89933758445962,48.890547448239204,48.88177244956843,
	48.873012539657005,48.86426766994335,48.855537792093145,48.846822857997985,48.838122819774,
	48.829437629760456,48.820767240518414,48.812111604829404,48.803470675694065,48.79484440633083,
	48.78623275017453,48.777635660875234,48.769053092296794,48.76048499851569,48.7519313338197,
	48.74339205270649,48.73486710988269,48.72635646026227,48.71786005896553,48.70937786131776,
	48.700909822848125,48.692455899288355,48.68401604657149,48.67559022083087,48.66717837839881,
	48.65878047580537,48.65039646977735,48.64202631723698,48.63366997530087,48.62532740127879,
	48.61699855267252,48.60868338717482,48.60038186266824,48.59209393722399,48.5838195691009,
	48.57555871674427,48.56731133878474,48.55907739403737,48.550856841500355,48.54264964035415,
	48.534455749960266,48.52627512986031,48.518107739774926,48.509953539602705,48.50181248941926,
	48.49368454947605,48.48556968019959,48.477467842190165,48.469378996221096,48.461303103237576,
	48.45324012435573,48.44519002086173,48.437152754210615,48.42912828602554,48.42111657809673,
	48.41311759238048,48.40513129099828,48.397157636235875,48.389196590542305,48.38124811652899,
	48.3733121769688,48.36538873479518,48.357477753101215,48.349579195138695,48.34169302431732,
	48.33381920420376,48.325957698520675,48.31810847114607,48.310271486112185,48.30244670760479,
	48.29463409996229,48.28683362767483,48.27904525538348,48.271268947879435,48.2635046701031,
	48.25575238714336,48.24801206423666,48.24028366676625,48.232567160261354,48.22486251039637,
	48.21716968299007,48.20948864400485,48.2018193595458,48.194161795860104,48.186515919336095,
	48.178881696502636,48.17125909402823,48.16364807872035,48.15604861752457,48.14846067752391,
	48.14088422593806,48.13331923012262,48.12576565756842,48.118223475900685,48.110692652878406,
	48.10317315639354,48.095664954470365,48.08816801526472,48.08068230706329,48.07320779828296,
	48.06574445747002,48.05829225329958,48.050851154574794,48.04342113022621,48.0360021493111,
	48.02859418101277,48.02119719463983,48.0138111596257,48.006436045527735,47.99907182202667,
	47.99171845892603,47.9843759261513,47.9770441937495,47.969723231888345,47.962413010855734,
	47.95511350105907,47.94782467302459,47.94054649739688,47.93327894493808,47.92602198652739,
	47.91877559316038,47.91153973594844,47.904314386118166,47.89709951501066,47.88989509408111,
	47.88270109489807,47.8755174891429,47.86834424860912,47.86118134520201,47.85402875093783,
	47.846886437943326,47.83975437845518,47.832632544819425,47.82552090949085,47.8184194450325,
	47.81132812411503,47.804246919516274,47.797175804120634,47.79011475091844,47.783063733005605,
	47.7760227235829,47.76899169595548,47.761970623532456,47.75495947982621,47.74795823845196,
	47.74096687312718,47.733985357671145,47.72701366600436,47.72005177214812,47.71309965022385,
	47.706157274452835,47.69922461915544,47.69230165875085,47.68538836775644,47.67848472078731,
	47.67159069255579,47.66470625787098,47.657831391638254,47.650966068858736,47.6441102646289,
	47.637263954139975,47.63042711267761,47.62359971562135,47.616781738444104,47.60997315671174,
	47.6031739460827,47.59638408230736,47.58960354122773,47.582832298776914,47.57607033097871,
	47.56931761394715,47.56257412388602,47.55583983708849,47.54911472993659,47.54239877890082,
	47.53569196053974,47.52899425149946,47.522305628513315,47.51562606840134,47.508955548069885,
	47.50229404451125,47.49564153480317,47.48899799610844,47.48236340567456,47.47573774083318,
	47.469120978999854,47.46251309767352,47.45591407443619,47.44932388695239,47.44274251296896,
	47.436169930314584,47.429606116899244,47.423051050714065,47.416504709830804,47.40996707240148,
	47.403438116657924,47.39691782091156,47.39040616355287,47.38390312305104,47.377408677953646,
	47.37092280688625,47.364445488552064,47.35797670173145,47.351516425281716,47.34506463813667,
	47.33862131930627,47.33218644787621,47.32576000300769,47.31934196393694,47.312932309974904,
	47.3065310205069,47.30013807499228,47.293753452964005,47.287377134028425,47.28100909786481,
	47.274649324225095,47.26829779293351,47.2619544838862,47.25561937705099,47.24929245246692,
	47.242973690244064,47.23666307056303,47.230360573674766,47.224066179900184,47.217779869629815,
	47.211501623323535,47.20523142151018,47.198969244787286,47.192715073820736,47.18646888934452,
	47.180230672160185,47.174000403136944,47.16777806321088,47.16156363338504,47.155357094728856,
	47.149158428378016,47.14296761553406,47.13678463746408,47.130609475500506,47.12444211104073,
	47.118282525546775,47.11213070054517,47.10598661762642,47.099850258444924,47.093721604718546,
	47.087600638228395,47.081487340818505,47.0753816943956,47.06928368092875,47.063193282449156,
	47.05711048104972,47.051035258884994,47.04496759817074,47.03890748118369,47.03285489026129,
	47.02680980780139,47.020772216262046,47.01474209816117,47.00871943607631,47.002704212644346,
	46.9966964105613,46.990696012581964,46.98470300151971,46.97871736024626,46.972739071691294,
	46.96676811884234,46.96080448474448,46.95484815249994,46.94889910526812,46.942957326265116,
	46.93702279876356,46.931095506092284,46.925175431636234,46.9192625588361,46.913356871188064,
	46.90745835224361,46.90156698560926,46.895682754946336,46.88980564397077,46.88393563645268,
	46.878072716216394,46.872216867140025,46.86636807315529,46.86052631824733,46.854691586454386,
	46.848863861867585,46.843043128630825,46.83722937094034,46.83142257304469,46.82562271924441,
	46.819829793891735,46.814043781390566,46.80826466619603,46.80249243281442,46.796727065802855,
	46.790968549769204,46.785216869371716,46.77947200931889,46.77373395436923,46.76800268933105,
	46.762278199062244,46.75656046847008,46.75084948251099,46.745145226190395,46.739447684562386,
	46.733756842729626,46.72807268584313,46.72239519910201,46.71672436775327,46.7110601770917,
	46.70540261245952,46.699751659246346,46.694107302888824,46.688469528870556,46.68283832272184,
	46.67721367001952,46.6715955563867,46.66598396749267,46.66037888905261,46.654780306827455,
	46.649188206623684,46.6436025742931,46.63802339573272,46.632450656864656,46.62688434371596,
	46.62132444229748,46.615770938684996,46.61022381899849,46.60468306940199,46.599148676103404,
	46.59362062535424,46.58809890344962,46.5825834967279,46.577074391570555,46.57157157440208,
	46.56607503168971,46.560584749943274,46.55510071571505,46.54962291559958,46.5441513362334,
	46.53868596429506,46.533226786504734,46.52777378962426,46.52232696045677,46.516886285846674,
	46.51145175267942,46.50602334788128,46.500601058419335,46.495184871301106,46.48977477357462,
	46.484370752328,46.4789727946895,46.47358088782722,46.46819501894903,46.46281517530232,
	46.457441344173915,46.45207351288989,46.446711668815354,46.44135579935442,46.4360058919499,
	46.43066193408328,46.4253239132745,46.41999181708171,46.414665633101336,46.40934534896772,
	46.40403095235308,46.398722430967304,46.39341977255782,46.38812296490948,46.3828319958443,
	46.37754685322146,46.372267524937044,46.36699399892394,46.36172626315168,46.35646430562629,
	46.35120811439019,46.34595767752192,46.3407129831362,46.3354740193836,46.33024077445044,
	46.32501323655881,46.31979139396616,46.31457523496535,46.30936474788448,46.30415992108671,
	46.29896074297014,46.29376720196763,46.28857928654678,46.28339698520967,46.2782202864928,
	46.2730491789669,46.267883651236815,46.262723691941446,46.25756928975348,46.25242043337931,
	46.247277111559036,46.24213931306612,46.23700702670736,46.23188024132279,46.2267589457855,
	46.22164312900152,46.21653277990968,46.211427887481534,46.206328440721144,46.20123442866508,
	46.196145840382144,46.19106266497336,46.1859848915718,46.18091250934246,46.17584550748219,
	46.17078387521946,46.16572760181436,46.16067667655843,46.155631088774506,46.15059082781661,
	46.145555883069896,46.14052624395046,46.13550189990524,46.13048284041191,46.12546905497874,
	46.120460533144524,46.1154572644784,46.11045923857978,46.10546644507823,46.100478873633335,
	46.09549651393459,46.09051935570135,46.08554738868258,46.080580602656845,46.075618987432215,
	46.070662532846086,46.06571122876511,46.06076506508501,46.05582403173064,46.050888118655664,
	46.04595731584258,46.04103161330265,46.036111001075625,46.03119546922981,46.02628500786181,
	46.02137960709659,46.01647925708717,46.011583948014696,46.00669367008826,46.00180841354476,
	45.99692816864887
	}}
};
table1d_imp<2001> tubetable2_KT88[2] __rt_data = {
	{ // Ri = 68k
	-5,5,200,2001, {
	1667344.0169328852,1664730.353013284,1662108.081674914,1659477.210966028,1656837.7493810894,
	1654189.7058635552,1651533.089804229,1648867.9110486086,1646194.1798961349,1643511.9071044882,
	1640821.1038909003,1638121.781935585,1635413.9533826432,1632697.6308442384,1629972.827400293,
	1627239.5566037472,1624497.8324806849,1621747.6695329088,1618989.0827401704,1616222.0875627561,
	1613446.699943579,1610662.9363080328,1607870.8135688824,1605070.3491268146,1602261.5608718225,
	1599444.4671860798,1596619.0869451303,1593785.4395195672,1590943.5447768548,1588093.4230834374,
	1585235.0953054633,1582368.5828105223,1579493.907470415,1576611.0916600854,1573720.1582617576,
	1570821.1306639172,1567914.0327646562,1564998.8889711425,1562075.724202093,1559144.5638881554,
	1556205.433973227,1553258.3609152727,1550303.371687893,1547340.4937805838,1544369.7551990915,
	1541391.1844683771,1538404.8106309737,1535410.6632479753,1532408.7724014272,1529399.168693034,
	1526381.8832453107,1523356.9477019734,1520324.3942282652,1517284.2555112792,1514236.5647604214,
	1511181.3557069942,1508118.6626054405,1505048.5202314307,1501970.9638841497,1498886.029384035,
	1495793.75307465,1492694.1718208566,1489587.323009198,1486473.2445480605,1483351.9748659236,
	1480223.5529118967,1477088.0181549632,1473945.410582977,1470795.7707026298,1467639.1395380665,
	1464475.5586301885,1461305.0700357798,1458127.716326568,1454943.540588328,1451752.586419304,
	1448554.8979294205,1445350.519738508,1442139.4969758627,1438921.8752774526,1435697.7007858702,
	1432467.0201478894,1429229.8805130848,1425986.3295317697,1422736.4153538563,1419480.1866263854,
	1416217.6924918473,1412948.9825862965,1409674.1070371636,1406393.1164607266,1403106.061960473,
	1399812.9951240858,1396513.9680220096,1393209.0332041648,1389898.243697768,1386581.6530042957,
	1383259.315097859,1379931.2844209583,1376597.6158828684,1373258.3648562126,1369913.587173688,
	1366563.33912614,1363207.6774577573,1359846.6593643236,1356480.342489216,1353108.7849200715,
	1349732.0451855874,1346350.1822523042,1342963.2555198672,1339571.3248188917,1336174.4504060133,
	1332772.6929611904,1329366.1135827142,1325954.7737840354,1322538.7354897808,1319118.0610311765,
	1315692.8131424894,1312263.0549561505,1308828.8499990301,1305390.2621882334,1301947.3558259315,
	1298500.195595522,1295048.8465569261,1291593.374141871,1288133.8441493523,1284670.3227407269,
	1281202.8764349995,1277731.5721041153,1274256.4769675124,1270777.6585880222,1267295.184865783,
	1263809.1240337885,1260319.5446527228,1256826.5156050476,1253330.1060907298,1249830.385621161,
	1246327.424013662,1242821.2913867962,1239312.0581540228,1235799.795018518,1232284.5729674916,
	1228766.4632664593,1225245.5374536188,1221721.867334087,1218195.5249736002,1214666.5826934953,
	1211135.1130641538,1207601.1888986581,1204064.8832481604,1200526.2693941162,1196985.4208436292,
	1193442.4113221457,1189897.3147683227,1186350.2053266854,1182801.1573423808,1179250.2453538724,
	1175697.5440880172,1172143.1284517958,1168587.0735271552,1165029.4545648182,1161470.3469764728,
	1157909.8263297095,1154347.9683403035,1150784.8488662434,1147220.5439012686,1143655.1295676245,
	1140088.6821099054,1136521.2778883441,1132952.993371628,1129383.9051308325,1125814.0898323455,
	1122243.6242310633,1118672.5851633935,1115101.0495411125,1111529.0943439566,1107956.7966130306,
	1104384.2334436686,1100811.4819792565,1097238.6194036768,1093665.7229344647,1090092.8698165347,
	1086520.137314584,1082947.602706719,1079375.343277222,1075803.4363095432,1072231.9590801108,
	1068660.988850605,1065090.6028612235,1061520.878324245,1057951.8924167063,1054383.7222735286,
	1050816.4449809068,1047250.1375689142,1043684.8770053781,1040120.7401883496,1036557.8039395094,
	1032996.1449975105,1029435.8400109122,1025876.9655312402,1022319.5980067011,1018763.8137751158,
	1015209.6890570065,1011657.2999490601,1008106.7224173932,1004558.0322911664,1001011.3052551737,
	997466.6168438719,993924.0424347795,990383.6572412676,986845.5363068094,983309.7544978069,
	979776.3864975509,976245.5067994711,972717.189700957,969191.5092966155,965668.5394725571,
	962148.3538993024,958631.0260259897,955116.6290741778,951605.2360313166,948096.9196450844,
	944591.7524165738,941089.8065949787,937591.1541711229,934095.8668715956,930604.0161528863,
	927115.6731954523,923630.9088976556,920149.7938706172,916672.3984318615,913198.7925999351,
	909729.046088642,906263.2283016313,902801.4083267832,899343.6549307962,895890.0365537443,
	892440.6213037544,888995.4769516948,885554.6709259897,882118.2703074837,878686.3418241066,
	875258.9518462223,871836.1663813144,868418.0510691722,865004.6711770615,861596.0915949194,
	858192.3768304877,854793.5910050425,851399.7978482431,848011.0606940504,844627.4424760343,
	841249.0057230863,837875.8125550245,834507.9246784362,831145.4033822288,827788.3095338668,
	824436.7035751023,821090.6455181063,817750.1949414406,814415.4109861923,811086.3523525349,
	807763.0772956547,804445.6436223603,801134.1086873756,797828.5293900816,794528.9621709273,
	791235.4630082704,787948.0874148598,784666.89043514,781391.9266414973,778123.2501319132,
	774860.9145265438,771604.9729650064,768355.4781035968,765112.482112602,761876.036673543,
	758646.1929766372,755423.0017184302,752206.5130991477,748996.7768206195,745793.8420837456,
	742597.7575865629,739408.5715218871,736226.3315754475,733051.084923872,729882.8782327813,
	726721.7576549442,723567.7688287069,720420.9568760294,717281.3664013282,714149.0414894077,
	711024.0257046139,707906.3620890338,704796.0931614508,701693.2609159993,698597.9068210574,
	695510.0718183052,692429.7963214795,689357.1202157217,686292.0828565753,683234.7230692127,
	680185.0791478668,677143.1888549854,674109.0894208928,671082.8175431613,668064.4093862181,
	665053.9005810263,662051.3262248535,659056.720880946,656070.1185784218,653091.5528123482,
	650121.0565435515,647158.6621987005,644204.4016705855,641258.3063181627,638320.4069668832,
	635390.7339090649,632469.316904147,629556.1851793263,626651.3674299782,623754.8918201645,
	620866.7859834671,617987.0770236213,615115.7915151597,612252.9555044053,609398.5945103632,
	606552.7335255594,603715.3970171051,600886.6089277752,598066.3926771415,595254.7711627375,
	592451.7667612792,589657.4013300006,586871.6962079562,584094.67221748,581326.3496656186,
	578566.7483455323,575815.8875383089,573073.7860143087,570340.4620349432,567615.9333544858,
	564900.2172216033,562193.3303813876,559495.2890770909,556806.1090520421,554125.8055516864,
	551454.3933254294,548791.8866287983,546138.2992255348,543493.6443895998,540857.934907515,
	538231.183080392,535613.4007263611,533004.5991827482,530404.7893084699,527813.9814863479,
	525232.1856255698,522659.4111641392,520095.66707131965,517540.9618501906,514995.30354018084,
	512458.69971966697,509931.15750858135,507412.6835711129,504903.2841183284,502402.9649109427,
	499911.7312620536,497429.5880398794,494956.53967064316,492492.5901413547,490037.743002664,
	487592.00137180655,485155.3679354912,482727.84495276684,480309.43425814115,477900.13726443506,
	475499.95496587054,473108.88794103765,470726.93635604053,468354.09996752086,465990.37812570564,
	463635.76977767475,461290.27347029286,458953.88735355303,456626.60918362316,454308.4363260974,
	451999.36575914174,449699.394076793,447408.51749214175,445126.7318405487,442854.03258298076,
	440590.4148092384,438335.8732412145,436090.40223629,433853.995790519,431626.6475420398,
	429408.35077435605,427199.0984196877,424998.88306228095,422807.6969418283,420625.53195678565,
	418452.37966770184,416288.23130065424,414133.07775062724,411986.9095848001,409849.7170460233,
	407721.49005618726,405602.21821958927,403491.89082634513,401390.4968557741,399298.02497981035,
	397214.46356638754,395139.8006828174,393074.0240992225,391017.12129194033,388969.07944682846,
	386929.8854627927,384899.52595507575,382877.9872586582,380865.25543170224,378861.3162588321,
	376866.1552546289,374879.7576669051,372902.1084800896,370933.1924186334,368972.99395034136,
	367021.4972896849,365078.68640118535,363144.54500271555,361219.05656888365,359302.2043342477,
	357393.97129674396,355494.3402209179,353603.2936411796,351720.81386518665,349846.88297704764,
	347981.4828405744,346124.5951025743,344276.20119606255,342436.2823434798,340604.81955993036,
	338781.79365638754,336967.1852428542,335160.9747315782,333363.1423401882,331573.66809485946,
	329792.5318334392,328019.71320860763,326255.19169092545,324498.94657198223,322750.95696747286,
	321011.2018202141,319279.6599032571,317556.30982289376,315841.1300216661,314134.09878138243,
	312435.19422611146,310744.3943251407,309061.6768959231,307387.0196070346,305720.39998109505,
	304061.7953976347,302411.18309601705,300768.54017830454,299133.8436120941,297507.0702333278,
	295888.1967491825,294277.19974076515,292674.05566597724,291078.7408622219,289491.2315491574,
	287911.5038314192,286339.53370132967,284775.29704156664,283218.76962784363,281669.9271315388,
	280128.7451223135,278595.1990707568,277069.26435092324,275550.9162429307,274040.1299354887,
	272536.8805284313,271041.14303523814,269552.89238548424,268072.10342733347,266598.75092999823,
	265132.809586108,263674.2540141824,262223.0587609658,260779.1983038258,259342.6470530508,
	257913.37935423787,256491.3694905397,255076.59168497156,253669.02010266637,252268.6288531148,
	250875.39199240008,249489.28352536086,248110.27740781277,246738.3475486854,245373.46781214568,
	244015.61201974365,242664.75395248082,241320.86735290574,239983.9259271581,238653.90334700965,
	237330.773251863,236014.50925075045,234705.0849243218,233402.4738267641,232106.64948776373,
	230817.58541438807,229535.25509299463,228259.6319911001,226990.68955921277,225728.4012326701,
	224472.74043345393,223223.68057196925,221981.19504880605,220745.25725649882,219515.84058124648,
	218292.91840461938,217076.46410525366,215866.45106050087,214662.85264809366,213465.6422477642,
	212274.79324285136,211090.27902189223,209912.0729801872,208740.14852134534,207574.47905883045,
	206415.03801744067,205261.79883483815,204114.73496297622,202973.81986959578,201839.0270396305,
	200710.32997662065,199587.70220412756,198471.11726709627,197360.54873321817,196255.97019426303,
	195157.35526742451,194064.67759658568,192977.91085363552,191897.02873971805,190822.0049864883,
	189752.81335734332,188689.42764862234,187631.82169082572,186579.9693497665,185533.84452774408,
	184493.42116468985,183458.67323927788,182429.5747700446,181406.09981647888,180388.22248008565,
	179375.9169054606,178369.15728130884,177367.91784148695,176372.17286600015,175381.89668199193,
	174397.06366472642,173417.64823853777,172443.6248777819,171474.96810774936,170511.65250558683,
	169553.65270118875,168600.94337807645,167653.4992742603,166711.29518308697,165774.30595407792,
	164842.50649374435,163915.87176638813,162994.37679489257,162077.99666149207,161166.70650854337,
	160260.48153925253,159359.29701841503,158463.12827313674,157571.95069351888,156685.73973336598,
	155804.47091084212,154928.1198091449,154056.66207714094,153190.07343000986,152328.32964985745,
	151471.4065863177,150619.2801571591,149771.9263488551,148929.3212171508,148091.4408876275,
	147258.26155623922,146429.75948983335,145605.9110266868,144786.69257699774,143972.08062337912,
	143162.0517213469,142356.5824997836,141555.64966139512,140759.22998316333,139967.30031676922,
	139179.83758902774,138396.818802286,137618.2210348423,136844.0214413143,136074.19725303294,
	135308.72577840555,134547.5844032704,133790.75059124385,133038.20188406447,132289.91590190292,
	131545.87034369368,130806.04298743287,130070.41169046768,129338.95438980432,128611.64910235333,
	127888.47392521892,127169.40703594877,126454.42669278078,125743.51123487923,125036.63908257007,
	124333.78873755665,123634.93878313553,122940.0678843882,122249.1547883869,121562.1783243761,
	120879.11740394706,120199.95102120747,119524.65825294112,118853.21825875975,118185.6102812519,
	117521.81364610976,116861.80776226705,116205.57212201426,115553.08630110952,114904.32995889352,
	114259.2828383773,113617.92476634057,112980.2356534118,112346.19549414681,111715.78436709807,
	111088.98243488009,110465.76994421818,109846.12722601024,109230.0346953599,108617.47285161736,
	108008.42227841052,107402.86364366938,106800.77769964239,106202.14528290968,105606.9473143922,
	105015.16479934723,104426.77882736948,103841.77057237312,103260.12129258542,102681.8123305136,
	102106.82511292944,101535.1411508297,100966.7420394023,100401.60945798575,99839.72517001767,
	99281.07102298668,98725.62894837922,98173.38096160973,97624.30916196453,97078.39573252888,
	96535.62294011001,95995.97313516343,95459.42875170842,94925.97230724362,94395.58640265661,
	93868.25372212521,93343.9570330284,92822.67918584001,92304.40311402566,91789.11183393281,
	91276.7884446816,90767.41612805147,90260.97814836091,89757.45785234857,89256.8386690491,
	88759.10410966953,88264.23776745627,87772.22331756423,87283.04451692945,86796.68520412334,
	86313.12929922156,85832.36080365785,85354.36380008567,84879.12245223112,84406.62100474408,
	83936.84378305708,83469.77519322539,83005.39972178357,82543.70193558735,82084.66648166456,
	81628.27808705074,81174.52155864376,80723.38178303327,80274.84372635589,79828.89243412358,
	79385.51303107046,78944.6907209898,78506.41078657597,78070.65858925783,77637.41956904205,
	77206.67924434664,76778.4232118461,76352.63714630375,75929.30680041174,75508.41800463527,
	75089.95666704481,74673.9087731645,74260.26038580554,73848.99764491699,73440.1067674218,
	73033.57404706685,72629.38585426493,72227.52863594644,71827.98891540465,71430.75329215103,
	71035.80844176405,70643.14111574806,70252.73814138808,69864.58642161253,69478.67293485352,
	69094.98473491399,68713.50895083371,68334.23278676465,67957.1435218423,67582.22851006844,
	67209.47518018633,66838.87103557447,66470.40365413083,66104.06068817031,65739.82986432336,
	65377.69898343822,65017.6559204917,64659.68862449978,64303.78511844046,63949.933499173785,
	63598.1219373766,63248.33867747744,62900.57203759818,62554.81040950636,62211.042258566486,
	61869.25612370999,61529.440617400796,61191.58442561572,60855.67630782897,60521.705097010556,
	60189.65969962554,59859.52909564649,59531.30233857543,59204.96855547509,58880.516947005235,
	58557.93678747786,58237.21742491453,57918.348281118815,57601.31885175826,57286.118706461726,
	56972.737488919665,56661.16491700767,56351.39078291616,56043.40495329135,55737.197369397196,
	55432.758047284304,55130.07707797499,54829.1446276651,54529.950937939524,54232.486326002436,
	53936.74118492426,53642.705983906584,53350.37126856211,53059.72766121228,52770.76586120556,
	52483.476645248586,52197.85086776183,51913.87946125288,51631.553436707996,51350.86388400497,
	51071.80197234898,50794.35895072778,50518.52614838741,50244.294975335804,49971.6569228628,
	49700.603564088626,49431.12655453513,49163.217632719345,48896.868620776426,48632.07142510156,
	48368.81803702676,48107.10053351848,47846.91107790077,47588.24192061064,47331.08539997862,
	47075.43394303821,46821.28006636319,46568.61637693529,46317.43557304052,46067.73044519546,
	45819.49387710127,45572.718846632095,45327.398426849955,45083.52578705009,44841.09419383968,
	44600.09701224283,44360.52770683826,44122.37984292561,43885.6470877228,43650.323211589704,
	43416.40208928464,43183.877701242694,42952.74413488865,42722.99558596986,42494.626359917755,
	42267.6308732316,42042.00365488571,41817.73934775552,41594.83271006671,41373.278616855554,
	41153.072061448904,40934.20815695257,40716.68213775089,40500.489361010805,40285.625308189046,
	40072.08558653972,39859.86593061096,39648.9622037387,39439.370399520725,39231.0866432703,
	39024.107193445285,38818.428443047145,38614.04692097446,38410.95929333666,38209.16236470988,
	38008.65307933207,37809.42852222812,37611.485920251784,37414.82264304038,37219.436203867335,
	37025.32426038378,36832.48461523606,36640.91521654874,36450.61415825965,36261.579680291936,
	36073.81016855325,35887.304154742844,35702.0603159574,35518.07747407512,35335.35459490571,
	35153.89078708932,34973.685300729616,34794.73752574225,34617.04698990469,34440.613356589274,
	34265.43642216692,34091.5161130585,33918.85248242691,33747.44570648787,33577.2960804289,
	33408.40401392188,33240.770026215156,33074.39474079756,32909.2788796196,32745.423256867303,
	32582.828772279565,32421.496404003832,32261.427200991875,32102.622274927082,31945.08279169327,
	31788.8099623854,31633.805033869197,31480.069278903902,31327.60398583672,31176.410447889175,
	31026.489952053536,30877.843767623406,30730.47313438453,30584.379250494778,30439.563260089508,
	30296.02624064516,30153.769190142175,30012.79301407176,29873.098512326138,29734.686366028633,
	29597.557124345643,29461.711191337505,29327.148812901367,29193.870063858667,29061.874835250554,
	28931.162821886843,28801.73351021672,28673.586166570127,28546.71982582885,28421.13328058183,
	28296.825070814826,28173.79347418866,28052.036496950313,27931.55186552676,27812.337018837112,
	27694.389101364937,27577.70495702383,27462.281123844772,27348.11382950867,27235.198987748532,
	27123.532195628108,27013.108731716722,26903.92355515599,26795.971305622767,26689.24630418037,
	26583.742555011377,26479.453748009797,26376.373262219822,26274.494170092068,26173.809242530275,
	26074.310954694993,25975.991492533038,25878.842759985688,25782.856386842555,25688.0237371907,
	25594.335918417208,25501.78379071509,25410.357977046267,25320.048873509662,25230.84666006779,
	25142.741311577105,25055.72260908124,24969.780151308045,24884.90336632965,24801.081523336998,
	24718.30374448375,24636.55901675612,24555.8362038258,24476.12405784968,24397.411231176866,
	24319.68628792758,24242.93771541333,24167.153935367453,24092.323314956677,24018.43417755359,
	23945.474813240595,23873.433489031246,23802.298458787023,23732.057972818227,23662.700287150477,
	23594.21367245371,23526.586422616296,23459.80686296288,23393.863358111335,23328.7443194623,
	23264.438212323996,23200.933562668273,23138.218963522257,23076.283080999754,23015.114659970583,
	22954.70252938167,22895.035607226757,22836.102905179083,22777.893532891925,22720.396701973583,
	22663.601729649443,22607.498042116706,22552.075177607283,22497.3227891591,22443.2306471192,
	22389.788641378054,22336.986783350414,22284.815207714488,22233.264173917993,22182.324067461865,
	22131.98540097318,22082.238815077446,22033.075079080703,21984.485091470175,21936.459880245373,
	21888.990603088485,21842.068547382296,21795.685130086746,21749.8318974831,21704.50052478988,
	21659.682815667245,21615.37070160604,21571.55624122578,21528.23161946917,21485.389146713787,
	21443.02125780949,21401.12051103381,21359.67958698278,21318.691287409085,21278.148533992182,
	21238.04436706435,21198.371944293634,21159.124539320157,21120.295540362302,21081.87844878794,
	21043.86687765909,21006.254550251426,20969.035298556646,20932.20306176217,20895.751884723937,
	20859.675916421587,20823.96940841028,20788.626713265137,20753.64228301998,20719.010667611405,
	20684.72651331514,20650.78456118529,20617.17964553675,20583.9066923431,20550.96071774235,
	20518.33682649306,20486.03021046214,20454.03614711432,20422.349998022597,20390.96720738465,
	20359.88330056316,20329.093882629586,20298.594636934977,20268.381323690683,20238.44977856889,
	20208.79591132031,20179.41570441,20150.305211669995,20121.460556974576,20092.877932932395,
	20064.553599594547,20036.483883188408,20008.66517486861,19981.09392948423,19953.766664369876,
	19926.67995815629,19899.830449598743,19873.214836427152,19846.829874210747,19820.67237525467,
	19794.73920749904,19769.027293452596,19743.533609135775,19718.255183050198,19693.18909515792,
	19668.332475890344,19643.68250516738,19619.236411439524,19594.991470743596,19570.94500578315,
	19547.0943850207,19523.437021789916,19499.970373424585,19476.691940404962,19453.599265520752,
	19430.689933050216,19407.961567957027,19385.41183509887,19363.03843845838,19340.839120385008,
	19318.81166085013,19296.953876725653,19275.263621067283,19253.738782417713,19232.377284124428,
	19211.177083669947,19190.1361720123,19169.25257294872,19148.524342480177,19127.94956819859,
	19107.526368681196,19087.252892900895,19067.12731964541,19047.147856949498,19027.31274154255,
	19007.620238301213,18988.068639717538,18968.656265377598,18949.381461451114,18930.24260018786,
	18911.238079433042,18892.36632214011,18873.625775908047,18855.014912514904,18836.53222747076,
	18818.176239577737,18799.94549048835,18781.838544295882,18763.853987107443,18745.990426646382,
	18728.24649184919,18710.62083247781,18693.112118739024,18675.719040907934,18658.440308966216,
	18641.27465223911,18624.22081904731,18607.277576362092,18590.443709466712,18573.718021629546,
	18557.099333778704,18540.58648418469,18524.178328154583,18507.87373771877,18491.671601344427,
	18475.57082362739,18459.570325044777,18443.66904161846,18427.86592468058,18412.15994059262,
	18396.550070483077,18381.035309991406,18365.614669008544,18350.28717143594,18335.05185494087,
	18319.907770712765,18304.85398323922,18289.889570068666,18275.01362159176,18260.22524081831,
	18245.523543162697,18230.907656233536,18216.37671962669,18201.92988471905,18187.56631447539,
	18173.285183248114,18159.085676587016,18144.966991053156,18130.92833403623,18116.968923567994,
	18103.087988153704,18089.284766589928,18075.558507803857,18061.90847067775,18048.333923891514,
	18034.834145759356,18021.408424071873,18008.056055942532,17994.77634765545,17981.56861452099,
	17968.43218072339,17955.366379180712,17942.370551404925,17929.444047364304,17916.586225347783,
	17903.79645183073,17891.074101349055,17878.418556366785,17865.829207153212,17853.305451659104,
	17840.846695398242,17828.45235132508,17816.12183972031,17803.85458807794,17791.65003099195,
	17779.507610045148,17767.42677370361,17755.406977208026,17743.447682471797,17731.548357978016,
	17719.708478678174,17707.927525895204,17696.204987224766,17684.540356442187,17672.9331334058,
	17661.38282397081,17649.88893989489,17638.450998748835,17627.06852383189,17615.74104408905,
	17604.468094020925,17593.249213605308,17582.083948217412,17570.971848545098,17559.912470516578,
	17548.90537522145,17537.950128834294,17527.04630253753,17516.193472459774,17505.39121958962,
	17494.639129716947,17483.936793355984,17473.283805683986,17462.679766467812,17452.124280001175,
	17441.616955044767,17431.157404753263,17420.74524662063,17410.380102416668,17400.061598122622,
	17389.789363880715,17379.563033927257,17369.38224654019,17359.246643978862,17349.155872434512,
	17339.109581969115,17329.10742646617,17319.14906357913,17309.234154671805,17299.362364776884,
	17289.533362541057,17279.746820172448,17270.002413403876,17260.299821428016,17250.638726862944,
	17241.018815704338,17231.439777275064,17221.90130418725,17212.40309228882,17202.9448406317,
	17193.52625142017,17184.147029970816,17174.806884675705,17165.50552695601,17156.242671226097,
	17147.018034852925,17137.83133811553,17128.682304168444,17119.570659005483,17110.496131420517,
	17101.458452972885,17092.45735794971,17083.492583331124,17074.56386875009,17065.670956488848,
	17056.813591396036,17047.991520883144,17039.204494890375,17030.452265850414,17021.73458865818,
	17013.051220639885,17004.40192151735,16995.786453388824,16987.204580684986,16978.656070154357,
	16970.140690821627,16961.658213969626,16953.208413102893,16944.79106392396,16936.40594430894,
	16928.05283427555,16919.731515959957,16911.44177358673,16903.183393453244,16894.956163891584,
	16886.75987524873,16878.594319871074,16870.459292063686,16862.35458808105,16854.28000609144,
	16846.235346169957,16838.220410255046,16830.235002144393,16822.278927463187,16814.351993642704,
	16806.4540099044,16798.584787233398,16790.74413835709,16782.931877730298,16775.14782150981,
	16767.391787536744,16759.663595314152,16751.96306599236,16744.290022345776,16736.644288755408,
	16729.025691190185,16721.434057187344,16713.869215839768,16706.33099776848,16698.819235113067,
	16691.333761513644,16683.87441208847,16676.441023422634,16669.033433548935,16661.65148192923,
	16654.29500944635,16646.963858376108,16639.6578723816,16632.376896496407,16625.12077710115,
	16617.88936191611,16610.682499987062,16603.5000416681,16596.341838599477,16589.20774371099,
	16582.097611188452,16575.011296476056,16567.948656250876,16560.909548414944,16553.893832081325,
	16546.901367557755,16539.932016342704,16532.985641097817,16526.062105648543,16519.161274963208,
	16512.283015146233,16505.427193422405,16498.593678128163,16491.782338693323,16484.993045636555,
	16478.225670550568,16471.480086090804,16464.75616596054,16458.05378490969,16451.372818712727,
	16444.713144166122,16438.07463906917,16431.457182224138,16424.86065341575,16418.284933408064,
	16411.72990393037,16405.19544766554,16398.681448246625,16392.187790241613,16385.71435914485,
	16379.261041369375,16372.827724233612,16366.4142959548,16360.020645643457,16353.646663284291,
	16347.292239736027,16340.957266721485,16334.641636813272,16328.345243433143,16322.067980833994,
	16315.809744102786,16309.570429142595,16303.349932664107,16297.148152188274,16290.964986029325,
	16284.800333283883,16278.654093835159,16272.52616833348,16266.416458195414,16260.324865589748,
	16254.251293438452,16248.195645405249,16242.157825885974,16236.137740004559,16230.135293604804,
	16224.150393244057,16218.182946184175,16212.232860387667,16206.300044507241,16200.384407885604,
	16194.485860540985,16188.604313153342,16182.739677101465,16176.891864390911,16171.060787692039,
	16165.246360322173,16159.4484962414,16153.667110038332,16147.902116937752,16142.153432784778,
	16136.420974038023,16130.70465776976,16125.00440166055,16119.32012398275,16113.651743611266,
	16107.999180001803,16102.362353199847,16096.741183824866,16091.135593066761,16085.545502684115,
	16079.970834998128,16074.411512883768,16068.867459769841,16063.338599628767,16057.824856974714,
	16052.32615685914,16046.842424862958,16041.373587094991,16035.919570185066,16030.48030127947,
	16025.055708034164,16019.64571861905,16014.250261700085,16008.869266444764,16003.502662514848,
	15998.150380059798,15992.812349713766,15987.488502594297,15982.178770290384,15976.883084868983,
	15971.601378861349,15966.333585263294,15961.079637529645,15955.839469570858,15950.613015748842,
	15945.400210875112,15940.20099020076,15935.015289418792,15929.843044660922,15924.68419248369,
	15919.53866988035,15914.406414259898,15909.287363459862,15904.18145572895,15899.088629736374,
	15894.008824552067,15888.941979660873,15883.888034945314,15878.846930685522,15873.818607567502,
	15868.803006658898,15863.80006942351,15858.809737708467,15853.831953742461,15848.86666013571,
	15843.91379987121,15838.973316308795,15834.045153180561,15829.129254577801,15824.225564957376,
	15819.334029140826,15814.454592305181,15809.58719998114,15804.7317980505,15799.888332747403,
	15795.05675064639,15790.236998666383,15785.429024069032,15780.632774452002,15775.848197744885,
	15771.075242213175,15766.313856447121,15761.563989363436,15756.825590198127,15752.098608530026,
	15747.382994234958,15742.678697503123,15737.985668848753,15733.303859085949,15728.633219348023,
	15723.973701066745,15719.325255978682,15714.687836121268,15710.061393831616,15705.445881735892,
	15700.841252764229,15696.247460127297,15691.664457332008,15687.092198159018,15682.53063671378,
	15677.979727320706,15673.439424625798,15668.909683546506,15664.390459265582,15659.881707252265,
	15655.383383228775,15650.895443207368,15646.417843451327,15641.950540491252,15637.493491124107,
	15633.046652405294,15628.609981648993,15624.183436424399,15619.766974556826,15615.36055411789,
	15610.964133447143,15606.577671108245,15602.201125929014,15597.834457067554,15593.477623556686,
	15589.130585225166,15584.793301768734,15580.465733214174,15576.147839823969,15571.839582096656,
	15567.540920756743,15563.251816764088,15558.972231304604,15554.702125791604,15550.441461862401,
	15546.190201377638,15541.94830642069,15537.715739292178,15533.49246251368,15529.278438823585,
	15525.073631169293,15520.878002720074,15516.691516853245,15512.514137155324,15508.345827420666,
	15504.186551651443,15500.036274059164,15495.89495904979,15491.762571245847,15487.639075457444,
	15483.524436704045,15479.418620194136,15475.321591340064,15471.23331574715,15467.153759213646,
	15463.082887728211,15459.020667473374,15454.967064821003,15450.922046330912,15446.885578747986,
	15442.857629019074,15438.838164234887,15434.827151703896,15430.82455890594,15426.830353499841,
	15422.844503325867,15418.866976400543,15414.897740915709,15410.936765235196,15406.984017905286,
	15403.039467638073,15399.103083318041,15395.17483399914,15391.254688905497,15387.342617430308,
	15383.438589130617,15379.542573728604,15375.654541112523,15371.774461332518,15367.902304602347,
	15364.038041291647,15360.181641935776,15356.3330772241,15352.492318003402,15348.659335283563,
	15344.83410021818,15341.016584122286,15337.20675846569,15333.404594864207,15329.61006508959,
	15325.823141059236,15322.043794840789,15318.27199865285,15314.507724859344,15310.750945966318,
	15307.00163462484,15303.259763637414,15299.525305941816,15295.798234618887,15292.078522893073,
	15288.366144126465,15284.66107181951,15280.963279613707,15277.272741282046,15273.589430743014,
	15269.913322042861,15266.244389360994,15262.582607016257,15258.927949455425,15255.280391260478,
	15251.63990713968,15248.00647193419,15244.380060616822,15240.760648281244,15237.148210156738,
	15233.542721591597,15229.944158064036,15226.352495178597,15222.767708656998,15219.189774349232,
	15215.618668230512,15212.054366387436,15208.496845043015,15204.94608052143,15201.4020492809,
	15197.864727890299,15194.334093040852,15190.810121533365,15187.29279029647,15183.782076360938,
	15180.277956881884,15176.780409124849,15173.289410466596,15169.804938397054,15166.326970521155,
	15162.855484550138,15159.390458309497,15155.931869728889,15152.479696854603,15149.033917835475,
	15145.594510924228,15142.161454491265,15138.73472700138,15135.314307032595,15131.900173261807,
	15128.49230447784,15125.090679566543,15121.695277514662,15118.30607741868,15114.923058469612,
	15111.546199962433,15108.175481290004,15104.810881948586,15101.452381530702,15098.099959726456,
	15094.753596324219,15091.413271209507,15088.078964365151,15084.750655870888,15081.428325885427,
	15078.111954699312,15074.801522663656,15071.497010234749,15068.19839795751,15064.90566647783,
	15061.618796524004,15058.337768921187,15055.062564579917,15051.793164508857,15048.529549797107,
	15045.271701630943,15042.01960127896,15038.773230100322,15035.532569542196,15032.297601133405,
	15029.068306501602,15025.844667341631,15022.626665449405,15019.414282699709,15016.207501046869,
	15013.006302540552,15009.810669301127,15006.620583539272,15003.436027545258,15000.256983690235,
	14997.083434428963,14993.915362295917,14990.752749906678,14987.595579953055,14984.443835208816,
	14981.297498526748,14978.15655283979,14975.020981150943,14971.890766551169,14968.76589220306,
	14965.646341340936,14962.532097287138,14959.423143423686,14956.319463225724,14953.221040228325,
	14950.127858048198,14947.039900376942,14943.957150970566,14940.879593668045,14937.807212374732,
	14934.73999107289,14931.677913813137,14928.620964719308,14925.569127983243,14922.522387867422,
	14919.480728710112,14916.444134908916,14913.412590944054,14910.386081352708,14907.364590743602,
	14904.34810379692,14901.336605260569,14898.330079944986,14895.328512729984,14892.331888558541,
	14889.340192450749,14886.353409479074,14883.371524787437,14880.394523589022,14877.422391148943,
	14874.45511281091,14871.492673973307,14868.535060101258,14865.58225672491,14862.634249430781,
	14859.691023872747,14856.752565766657,14853.818860891466,14850.889895080805,14847.96565423527,
	14845.046124321072,14842.131291349631,14839.221141406568,14836.31566062723,14833.414835215941,
	14830.518651428805,14827.627095582962,14824.74015405387,14821.857813274588,14818.980059733356,
	14816.106879986757,14813.23826063317,14810.374188335325,14807.514649815083,14804.659631847288,
	14801.809121259434,14798.963104940978,14796.121569832536,14793.28450292852,14790.451891281342,
	14787.623721998772,14784.799982235096,14781.980659206356,14779.165740178854,14776.355212471995,
	14773.549063461212,14770.747280561756,14767.949851262674,14765.156763086123,14762.368003616364,
	14759.583560482635,14756.803421370223,14754.027574016407,14751.256006197618,14748.488705760654,
	14745.725660579279,14742.966858599324,14740.212287797487,14737.461936211488,14734.715791923976,
	14731.973843066002,14729.236077818096,14726.50248440627,14723.773051112352,14721.047766254556,
	14718.3266182067,14715.609595387057,14712.896686262882,14710.187879345825,14707.48316319294,
	14704.782526408562,14702.085957648102,14699.393445604961,14696.704979019643,14694.020546682244,
	14691.340137426281,14688.663740128097,14685.991343705891,14683.32293712665,14680.658509407189,
	14677.99804959165,14675.341546782518,14672.688990122482,14670.040368790867,14667.395672020082,
	14664.75488907623,14662.118009272954,14659.485021962608,14656.855916543564,14654.230682452548,
	14651.609309175405,14648.99178622644,14646.378103170542,14643.768249611758,14641.16221519768,
	14638.559989607473,14635.961562568078,14633.366923849277,14630.776063251093,14628.188970621739,
	14625.605635844086,14623.026048846601,14620.45019958427,14617.878078068881,14615.309674332644,
	14612.744978462504,14610.183980569192,14607.626670813353,14605.073039391566,14602.523076529907,
	14599.976772501714,14597.434117607068,14594.895102200206,14592.359716650564,14589.827951385909,
	14587.299796856261,14584.77524355271,14582.254281999929,14579.736902769448,14577.223096453097,
	14574.712853688176,14572.2061651446,14569.703021529425,14567.203413585428,14564.707332087004,
	14562.214767843958,14559.725711703355,14557.24015454871,14554.758087286873,14552.279500876033,
	14549.804386292702,14547.332734558058,14544.864536721223,14542.399783865718,14539.938467108437,
	14537.48057760046,14535.026106524616,14532.57504510071,14530.127384576308,14527.683116232945,
	14525.242231384977,14522.80472137565,14520.3705775913,14517.939791434594,14515.512354341869,
	14513.088257807409,14510.667493325382,14508.250052431082,14505.835926694625,14503.425107712439,
	14501.017587119182,14498.613356570677,14496.212407758872,14493.814732404544,14491.420322267028,
	14489.0291691162,14486.641264774818,14484.256601077112,14481.875169897996,14479.49696313713,
	14477.121972726578,14474.750190624558,14472.381608819665,14470.01621933296,14467.654014208983,
	14465.294985523582,14462.939125379095,14460.58642590878,14458.236879275251,14455.890477666766,
	14453.547213304206,14451.20707842865,14448.870065310623,14446.536166256594,14444.205373588513,
	14441.877679669555,14439.553076875975,14437.231557622255,14434.913114340645,14432.597739501683,
	14430.285425592701,14427.976165127318,14425.669950656411,14423.366774744427,14421.066629994288,
	14418.769509018102,14416.475404479157,14414.18430904338,14411.896215413073,14409.6111163155,
	14407.329004496953,14405.049872741642,14402.77371385084,14400.500520649182,14398.230285998017,
	14395.963002767472,14393.698663860978,14391.43726220713,14389.178790759986,14386.923242493069,
	14384.67061041229,14382.42088753817,14380.174066923653,14377.930141642877,14375.689104790692,
	14373.450949494383,14371.215668891606,14368.983256158801,14366.75370448303,14364.527007086115,
	14362.303157204315,14360.082148099053,14357.863973058855,14355.648625391257,14353.436098431435,
	14351.226385526765,14349.019480061748,14346.815375434306,14344.614065061747,14342.41554239643,
	14340.219800907455,14338.026834072449,14335.836635415882,14333.649198462324,14331.464516771415,
	14329.282583921688,14327.103393509184,14324.926939154931,14322.753214506709,14320.582213219986,
	14318.413928985194,14316.248355507936,14314.085486515432,14311.92531575462,14309.76783699526,
	14307.613044033262,14305.460930672303,14303.311490746244,14301.164718113727,14299.020606638735,
	14296.87915022343,14294.74034277626,14292.604178231706,14290.47065054441,14288.339753690947,
	14286.21148166268,14284.085828474734,14281.962788164448,14279.842354781124,14277.724522398852,
	14275.609285116885,14273.4966370369,14271.38657230097,14269.279085050784,14267.174169468752,
	14265.07181973027,14262.972030057083,14260.874794669618,14258.780107816252,14256.68796376102,
	14254.598356790728,14252.511281207155,14250.426731329851,14248.344701497781,14246.265186073515,
	14244.188179432858,14242.113675964856,14240.041670091441,14237.972156235679,14235.90512885238,
	14233.840582406889,14231.778511383522,14229.71891028637,14227.661773633981,14225.607095967305,
	14223.554871841105,14221.505095824661,14219.457762518063,14217.412866523524,14215.370402460945,
	14213.330364981082,14211.292748741926,14209.25754842101,14207.224758711774,14205.194374324155,
	14203.16638998143,14201.140800436482,14199.117600443818,14197.096784784759,14195.078348252582,
	14193.062285657821,14191.04859182623,14189.037261607995,14187.028289856778,14185.021671447497,
	14183.017401278612,14181.015474253858,14179.015885301027,14177.018629357695,14175.023701380109,
	14173.031096348182,14171.040809237771,14169.052835063065,14167.067168839023,14165.083805595264,
	14163.102740392244,14161.12396829288,14159.147484374966,14157.17328373482,14155.201361490424,
	14153.231712762083,14151.264332699686,14149.29921645358,14147.336359199622,14145.375756124258,
	14143.417402430203,14141.461293333277,14139.50742406517,14137.555789877368,14135.60638602691,
	14133.659207788169,14131.71425045193,14129.771509327635,14127.830979728129,14125.892656994096,
	14123.956536467851,14122.022613516772,14120.090883509863,14118.161341845598,14116.233983923497,
	14114.308805165743,14112.385800997323,14110.464966875405,14108.546298252939,14106.629790607067,
	14104.715439426922,14102.803240211288,14100.893188479877,14098.985279752802,14097.079509579744,
	14095.175873515895,14093.274367126962,14091.374986002716,14089.477725731083,14087.582581928093,
	14085.689550210163,14083.79862621627,14081.909805593168,14080.023084004994,14078.138457124376,
	14076.25592064304
	}},
	{ // Ri = 250k
	-5,5,200,2001, {
	1667344.0169328852,1664730.353013284,1662108.081674813,1659477.2109658278,1656837.7493810894,
	1654189.7058634043,1651533.0898041055,1648867.9110486086,1646194.1798962306,1643511.9071044882,
	1640821.1038909003,1638121.781935585,1635413.9533828276,1632697.6308441865,1629972.827400293,
	1627239.5566037472,1624497.8324806218,1621747.6695329088,1618989.0827402319,1616222.0875628775,
	1613446.699943579,1610662.9363080328,1607870.8135688824,1605070.3491268468,1602261.5608718225,
	1599444.467186049,1596619.0869453172,1593785.4395196221,1590943.5447768548,1588093.4230834374,
	1585235.0953054382,1582368.5828105223,1579493.907470415,1576611.0916601354,1573720.1582618325,
	1570821.1306638182,1567914.0327647047,1564998.8889711658,1562075.724202093,1559144.5638881554,
	1556205.433973227,1553258.3609153428,1550303.371687893,1547340.4937804956,1544369.7551990238,
	1541391.1844684202,1538404.810630907,1535410.6632480172,1532408.7724014032,1529399.1686931225,
	1526381.883245159,1523356.9477019734,1520324.3942282652,1517284.2555111551,1514236.5647603837,
	1511181.3557072985,1508118.6626053331,1505048.5202316456,1501970.9638840673,1498886.0293839532,
	1495793.75307465,1492694.171820776,1489587.3230092546,1486473.2445480044,1483351.9748659006,
	1480223.5529118648,1477088.0181549632,1473945.4105828693,1470795.770702759,1467639.1395380213,
	1464475.5586302704,1461305.0700357573,1458127.7163265743,1454943.540588356,1451752.5864192815,
	1448554.8979293657,1445350.51973853,1442139.4969757877,1438921.8752773525,1435697.700785892,
	1432467.0201480775,1429229.880512992,1425986.3295316775,1422736.4153538563,1419480.186626362,
	1416217.692491849,1412948.982586231,1409674.1070372295,1406393.1164607494,1403106.0619604087,
	1399812.9951240013,1396513.9680219674,1393209.0332043094,1389898.243697829,1386581.6530043557,
	1383259.315097797,1379931.284420917,1376597.61588279,1373258.3648562494,1369913.5871737238,
	1366563.339126082,1363207.6774578495,1359846.6593642293,1356480.3424891224,1353108.7849200314,
	1349732.0451857431,1346350.1822523158,1342963.2555198078,1339571.3248188177,1336174.4504060233,
	1332772.6929611803,1329366.1135826083,1325954.7737839497,1322538.7354897559,1319118.0610311707,
	1315692.8131424834,1312263.0549561125,1308828.8499990362,1305390.2621882202,1301947.35582593,
	1298500.195595599,1295048.8465569604,1291593.3741420936,1288133.8441493555,1284670.322740751,
	1281202.8764350882,1277731.5721040992,1274256.4769675059,1270777.658588097,1267295.1848658395,
	1263809.1240338888,1260319.5446526695,1256826.515605109,1253330.1060907287,1249830.3856211074,
	1246327.4240137269,1242821.2913868513,1239312.0581540188,1235799.795018551,1232284.5729675984,
	1228766.4632665159,1225245.5374537623,1221721.8673340057,1218195.524973572,1214666.5826936502,
	1211135.1130641238,1207601.188898735,1204064.8832480845,1200526.2693941335,1196985.4208435963,
	1193442.4113222132,1189897.3147683507,1186350.2053267069,1182801.157342332,1179250.2453540673,
	1175697.5440879301,1172143.1284517434,1168587.073527224,1165029.4545648105,1161470.3469765054,
	1157909.8263297088,1154347.9683402395,1150784.8488662755,1147220.543901271,1143655.1295676604,
	1140088.6821099499,1136521.2778883092,1132952.993371671,1129383.905130904,1125814.089832454,
	1122243.6242310689,1118672.585163429,1115101.0495412503,1111529.0943440874,1107956.7966130318,
	1104384.2334437624,1100811.481979384,1097238.6194036768,1093665.7229345527,1090092.8698165596,
	1086520.1373146358,1082947.602706739,1079375.3432772395,1075803.4363096128,1072231.9590802616,
	1068660.988850692,1065090.6028613888,1061520.8783243764,1057951.892416831,1054383.722273619,
	1050816.4449809897,1047250.1375690408,1043684.87700547,1040120.7401883815,1036557.8039395823,
	1032996.1449976214,1029435.8400109877,1025876.9655314228,1022319.5980068928,1018763.8137752444,
	1015209.6890571206,1011657.2999491802,1008106.7224176539,1004558.0322912742,1001011.30525535,
	997466.6168440889,993924.0424349341,990383.6572414804,986845.5363070413,983309.7544980305,
	979776.386497739,976245.5067996971,972717.1897011466,969191.5092969099,965668.5394728306,
	962148.3538995207,958631.0260262649,955116.6290744648,951605.2360316493,948096.919645386,
	944591.7524169495,941089.8065952783,937591.1541715098,934095.866871995,930604.016153235,
	927115.673195774,923630.9088980709,920149.7938710263,916672.3984322983,913198.7926003648,
	909729.04608909,906263.2283021034,902801.4083272686,899343.6549313285,895890.0365542944,
	892440.6213043159,888995.4769522417,885554.6709265701,882118.2703080254,878686.3418247417,
	875258.951846868,871836.1663820359,868418.0510699125,865004.6711778098,861596.0915956522,
	858192.3768313421,854793.591005874,851399.7978490959,848011.060694952,844627.4424769363,
	841249.0057240652,837875.8125560572,834507.9246794687,831145.4033832654,827788.3095349662,
	824436.7035762861,821090.6455193361,817750.1949426638,814415.4109875025,811086.352353909,
	807763.0772970687,804445.6436237773,801134.1086888558,797828.5293916526,794528.9621725766,
	791235.4630099374,787948.0874166095,784666.8904369335,781391.9266433703,778123.2501338903,
	774860.9145285389,771604.972967073,768355.47810577,765112.482114883,761876.0366758814,
	758646.192979075,755423.0017209401,752206.5131017753,748996.7768233093,745793.8420865933,
	742597.7575894933,739408.5715249196,736226.3315786056,733051.0849271399,729882.8782361279,
	726721.7576584708,723567.7688323036,720420.9568798153,717281.3664052038,714149.0414934433,
	711024.0257088111,707906.3620934059,704796.0931659953,701693.2609206919,698597.9068259468,
	695510.0718233407,692429.7963266972,689357.1202211173,686292.0828621874,683234.7230750268,
	680185.0791539035,677143.1888612533,674109.0894273984,671082.817549882,668064.4093931832,
	665053.9005882454,662051.3262323423,659056.7208886984,656070.1185864792,653091.55282071,
	650121.0565521955,647158.6622076764,644204.4016798848,641258.3063277772,638320.406976853,
	635390.7339193927,632469.3169148837,629556.1851904657,626651.3674414821,623754.8918321263,
	620866.7859958538,617987.077036441,615115.7915284418,612252.9555181884,609398.5945246511,
	606552.7335403728,603715.3970324313,600886.6089436878,598066.3926936024,595254.7711798036,
	592451.7667789629,589657.4013483044,586871.6962269332,584094.6722371601,581326.3496859962,
	578566.7483666483,575815.887560189,573073.7860369543,570340.4620584479,567615.9333787935,
	564900.2172468081,562193.3304074978,559495.2891041317,556806.1090800718,554125.8055807113,
	551454.3933554926,548791.8866599547,546138.2992578121,543493.6444230343,540857.9349421277,
	538231.1831162673,535613.4007635203,533004.5992212453,530404.7893483393,527813.9815276376,
	525232.185668328,522659.41120843426,520095.66711721197,517540.9618976969,514995.30358940404,
	512458.699770633,509931.1575613729,507412.68362579367,504903.2841749509,502402.96496958,
	499911.7313227644,497429.5881027663,494956.5397357508,492492.59020879155,490037.7430724994,
	487592.0014441338,485155.36801037024,482727.84503030946,480309.4343384327,477900.137347563,
	475499.95505195006,473108.8880301649,470726.93644832616,468354.10006306286,465990.37822463555,
	463635.76988009154,461290.2735763358,458953.88746333524,456626.60929727886,454308.4364437606,
	451999.36588097195,449699.3942029172,447408.517622711,445126.73197572515,442854.0327229168,
	440590.41495408164,438335.8733911674,436090.40239151916,433853.9959511952,431626.6477083775,
	429408.35094652657,427199.09859789425,424998.883246753,422807.69713277416,420625.532154425,
	418452.37987227633,416288.23151239904,414133.0779697924,411986.90981163364,409849.71728079906,
	407721.4902991681,405602.21847107675,403491.8910866153,401390.49712515104,399298.02525858924,
	397214.4638548974,395139.80098139506,393074.0244082168,391017.1216117075,388969.0797777528,
	386929.8858052559,384899.52630946407,382877.9876253836,380865.2558111904,378861.3166515347,
	376866.15566098335,374879.7580873835,372902.10891518823,370933.1928688516,368972.99441619625,
	367021.4977717198,365078.6868999363,363144.54551878653,361219.0571028343,359302.2048867201,
	357393.9718683626,355494.340812326,353603.29425307934,351720.8144982716,349846.88363203895,
	347981.48351822456,346124.59580365877,344276.20192138257,342436.2830938653,340604.82033624017,
	338781.7944595024,336967.18607370293,335160.975591092,333363.1432293556,331573.66901469085,
	329792.5327849833,328019.71419294405,326255.1927091717,324498.94762530853,322750.95805705304,
	321011.20294730074,319279.66106912744,317556.31102886173,315841.13126909593,314134.100071695,
	312435.1955607655,310744.3957056397,309061.6783238335,307387.02108396246,305720.40150870854,
	304061.79697765637,302411.1847302379,300768.5418685593,299133.8453602797,297507.07204142393,
	295888.1986192176,294277.2016748441,292674.0576662695,291078.7429309673,289491.23368869076,
	287911.5060441377,286339.5359897115,284775.2994081822,283218.77207533596,281669.92966264725,
	280128.7477398773,278595.20177770377,277069.26715027675,275550.91913781746,274040.132929139,
	272536.8836241932,271041.14623655914,269552.8956959315,268072.10685061,266598.7544698998,
	265132.81324658147,263674.2577993046,262223.06267494767,260779.20235100854,259342.65123794365,
	257913.38368148304,256491.3739649425,255076.59631149453,253669.0248864439,252268.63379945376,
	250875.39710677657,249489.2888134414,248110.28287545405,246738.35320193222,245373.4736572586,
	244015.61806317678,242664.76020091548,241320.87381324946,239983.93260654347,238653.91025280856,
	237330.78039168834,236014.51663248197,234705.09255609647,233402.48171699193,232106.65764513044,
	230817.59384787976,229535.26381189268,228259.6410049906,226990.69887801248,225728.4108666181,
	224472.75039314447,223223.6908683334,221981.2056931506,220745.26826050275,219515.85195698822,
	218292.93016456903,217076.47626230534,215866.46362797747,214662.86563976,213465.65567784628,
	212274.80712605026,211090.29337339906,209912.08781570158,208740.16385709398,207574.49491156742,
	206415.05440449482,205261.81577410377,204114.7524729524,202973.8379693977,201839.04574900132,
	200710.3493159724,199587.72219454983,198471.13793037966,197360.57009188156,196255.99227157937,
	195157.37808742782,194064.7011841269,192977.93523438077,191897.05394019425,190822.0310341105,
	189752.84028042742,188689.45547644043,187631.85045361388,186579.99907876988,185533.8752552538,
	184493.4529240644,183458.70606498956,182429.60869771405,181406.134882904,180388.25872330464,
	179375.95436476206,178369.19599729637,177367.95785611137,176372.21422260642,175381.93942537438,
	174397.1078411594,173417.69389584224,172443.67206536408,171475.01687665939,170511.70290857603,
	169553.7047927555,168600.9972145365,167653.55491379814,166711.352685824,165774.36538213506,
	164842.56791130095,163915.93523975989,162994.44239259747,162078.06445433275,161166.77656966526,
	160260.55394423325,159359.37184534853,158463.20560270533,157572.03060909183,156685.82232107336,
	155804.55625968403,154928.20801107117,154056.7532271596,153190.16762628272,152328.4269938028,
	151471.50718273042,150619.38411430805,149772.033778601,148929.4322350791,148091.5556131543,
	147258.3801127445,146429.88200480127,145606.03763182752,144786.82340839112,143972.21582163151,
	143162.1914317266,142356.72687238178,141555.79885129008,140759.3841505724,139967.45962723513,
	139180.00221358298,138396.98891764422,137618.39682357843,136844.20309206523,136074.38496069322,
	135308.91974434105,134547.7848355263,133790.9577047747,133038.41590095035,132290.13705160044,
	131546.09886326993,130806.27912182077,130070.65569273476,129339.20652140566,128611.90963342336,
	127888.74313485861,127169.68521251455,126454.71413419498,125743.80824895753,125036.94598733306,
	124334.10586158045,123635.26646589492,122940.40647662185,122249.50465247194,121562.5398347119,
	120879.49094735006,120200.33699732932,119525.05707469356,118853.6303527528,118186.03608824694,
	117522.2536214914,116862.26237652794,116206.04186125251,115553.57166755316,114904.83147142982,
	114259.80103310672,113618.46019715045,112980.78889256374,112346.76713288385,111716.37501628196,
	111089.59272563012,110466.40052859753,109846.7787777104,109230.70791041972,108618.16844917052,
	108009.14100144447,107403.60625981847,106801.54500201024,106202.93809090665,105607.76647461308,
	105016.01118647416,104427.6533450977,103842.67415438319,103261.05490352595,102682.77696703924,
	102107.82180475644,101536.17096183679,100967.80606876075,100402.70884133254,99840.86108066386,
	99282.2446731709,98726.84159055402,98174.6338897783,97625.60371306098,97079.73328783669,
	96537.00492674299,95997.40102757805,95460.90407327683,94927.49663187764,94397.16135648241,
	93869.88098521954,93345.63834120387,92824.41633249458,92306.19795205619,91790.96627770629,
	91278.70447207532,90769.39578255879,90263.02354126771,89759.57116498258,89259.02215510306,
	88761.3600975986,88266.56866296125,87774.63160615467,87285.53276656276,86799.25606794498,
	86315.78551838816,85835.10521025519,85357.19932014207,84882.05210883361,84409.64792125528,
	83939.97118643577,83473.00641746775,83008.73821146227,82547.15124951965,82088.23029669431,
	81631.96020196466,81178.32589820462,80727.3124021577,80278.90481441973,79833.08831941789,
	79389.84818540132,78949.16976442676,78511.03849235977,78075.43988887085,77642.35955744119,
	77211.78318537759,76783.69654382013,76358.08548777601,75934.93595613423,75514.23397171538,
	75095.96564130016,74680.11715568654,74266.67478974405,73855.62490247856,73446.95393710404,
	73040.64842112496,72636.69496642497,72235.08026936791,71835.79111090714,71438.81435670354,
	71044.13695725649,70651.74594804214,70261.62844966991,69873.77166804262,69488.16289453335,
	69104.78950617326,68723.63896585544,68344.69882254642,67967.95671152047,67593.40035459524,
	67221.01756040093,66850.79622464359,66482.72433040389,66116.78994843709,65752.98123750153,
	65391.28644469583,65031.693905821,64674.19204575762,64318.76937886253,63965.41450938469,
	63614.11613190523,63264.863031794404,62917.64408568993,62572.44826200336,62229.264621438524,
	61888.08231754653,61548.890597292564,61211.67880165687,60876.436366252885,60543.15282197949,
	60211.817795691175,59882.421010902464,59554.95228851628,59229.40154758113,58905.75880607756,
	58584.01418173513,58264.157892877396,57946.18025929833,57630.07170317191,57315.82274999111,
	57003.42402953856,56692.86627689234,56384.14033346563,56077.237148072665,55772.1477780411,
	55468.86339034624,55167.37526278902,54867.67478520185,54569.753460695276,54273.602906935244,
	53979.2148574579,53686.58116302022,53395.693792979044,53106.544836715875,52819.12650508585,
	52533.43113190239,52249.451175461116,51967.179220088736,51686.60797772571,51407.730289538726,
	51130.53912756621,50855.027596384694,50581.188934804006,50309.016517589254,50038.50385720063,
	49769.64460554496,49502.4325557668,49236.86164402767,48972.92595130841,48710.61970521651,
	48449.9372817914,48190.8732073139,47933.42216010227,47677.57897229969,47423.33863164234,
	47170.69628320422,46919.647231106246,46670.18694019293,46422.31103765815,46176.015314618235,
	45931.29572761935,45688.14840007286,45446.56962360569,45206.55585931649,44968.10373892558,
	44731.210065805484,44495.8718158793,44262.086138377046,44029.85035642848,43799.16196748331,
	43570.01864354186,43342.41823118005,43116.35875134763,42891.83839893154,42668.85554205664,
	42447.40872111302,42227.496647483546,42009.11820196429,41792.27243284468,41576.95855363848,
	41363.17594044208,41150.92412890014,40940.20281076387,40731.011830016854,40523.3511785572,
	40317.220991412934,40112.62154148052,39909.55323376422,39708.016599108945,39508.01228740905,
	39309.54106028897,39112.603783237995,38917.20141720174,38723.33500962248,38531.00568492601,
	38340.21463445827,38150.96310587784,37963.25239200738,37777.083819163025,37592.458734968335,
	37409.37849567781,37227.8444530304,37047.85794065944,36869.420260087456,36692.53266634819,
	36517.19635325993,36343.41243841031,36171.18194788351,36000.505800786705,35831.38479362911,
	35663.819584607874,35497.810677859336,35333.35840773954,35170.462923196515,35009.124172299256,
	34849.341886992974,34691.115568142595,34534.44447093849,34379.32759073104,34225.76364935328,
	34073.75108201053,33923.28802478842,33774.37230284645,33627.00141935844,33481.17254524226,
	33336.88250974873,33194.12779193639,33052.90451309144,32913.20843011543,32775.03492991871,
	32638.3790248497,32503.23534916752,32369.59815658055,32237.461318856876,32106.81832550775,
	31977.662284533817,31849.985924233755,31723.781596049,31599.04127842546,31475.756581670415,
	31353.918753758473,31233.518687066728,31114.54692598153,30996.993675340174,30880.84880965787,
	30766.101883087507,30652.742140052527,30540.75852650867,30430.139701762695,30320.874050801245,
	30212.949697059663,30106.35451558212,30001.07614650378,29897.1020088,29794.419314249495,
	29693.01508154516,29592.876150507527,29493.989196341274,29396.340743888413,29299.917181829154,
	29204.70477678248,29110.68968726636,29017.857977478106,28926.19563085397,28835.68856337823,
	28746.32263661035,28658.083670399028,28570.957455256477,28484.929764384582,28399.986365310928,
	28316.113031141052,28233.295551393414,28151.519742424498,28070.77145741685,27991.036595939786,
	27912.301113065456,27834.551028048074,27757.772432557493,27681.951498479375,27607.074485266814,
	27533.12774687282,27460.097738245408,27387.971021408837,27316.734271129644,27246.3742801833,
	27176.87796422713,27108.232366286255,27040.42466087992,26973.442157775567,26907.272305405953,
	26841.902693944456,26777.32105806444,26713.51527938419,26650.473388620423,26588.18356745138,
	26526.634150117647,26465.813624760285,26405.710634513223,26346.313978365062,26287.612611801473,
	26229.595647235008,26172.25235424367,26115.572159614243,26059.544647229064,26004.15955777121,
	25949.406788285418,25895.276391597567,25841.758575595177,25788.84370239048,25736.522287363405,
	25684.784998102645,25633.622653245122,25583.026221228454,25532.986818958285,25483.495710404273,
	25434.544305124036,25386.124156722944,25338.22696126718,25290.844555634754,25243.968915835056,
	25197.592155274662,25151.706522991757,25106.304401909274,25061.378306943716,25016.920883224702,
	24972.92490422061,24929.383269874117,24886.289004721337,24843.635256006062,24801.415291788988,
	24759.622499054545,24718.2503818209,24677.29255925013,24636.74276376516,24596.59483917449,
	24556.842738807074,24517.480523653285,24478.5023605248,24439.902520225398,24401.675375736857,
	24363.815400418818,24326.31716623247,24289.175341975857,24252.384691544594,24215.940072206347,
	24179.83643290344,24144.06881256733,24108.632338465475,24073.522224563618,24038.733769911687,
	24004.26235705563,23970.103450470982,23936.252595016864,23902.70541442125,23869.45760978259,
	23836.504958098434,23803.843310821478,23771.46859243134,23739.37679903965,23707.563997011144,
	23676.026321615984,23644.759975698653,23613.761228374344,23583.02641374995,23552.55192966515,
	23522.33423645834,23492.369855753637,23462.655369274922,23433.1874176757,23403.96269939726,
	23374.97796954471,23346.23003878506,23317.715772269232,23289.432088572008,23261.375958653156,
	23233.544404841366,23205.93449983536,23178.54336572671,23151.368173040573,23124.406139796443,
	23097.654530588658,23071.110655681867,23044.771870134642,23018.63557292099,22992.6992060946,
	22966.960253950176,22941.416242213294,22916.064737241057,22890.903345240127,22865.92971150551,
	22841.141519667355,22816.53649095705,22792.112383493368,22767.86699157055,22743.79814497745,
	22719.90370831414,22696.181580337947,22672.629693310326,22649.246012366722,22626.028534891273,
	22602.975289912858,22580.084337506334,22557.353768213365,22534.781702466877,22512.366290031292,
	22490.105709460408,22467.998167555215,22446.041898841846,22424.235165055685,22402.57625463853,
	22381.06348224564,22359.695188257345,22338.469738314016,22317.385522846205,22296.440956625913,
	22275.634478314747,22254.964550036777,22234.42965694633,22214.02830681146,22193.759029604927,
	22173.62037710514,22153.610922501568,22133.72926000747,22113.974004490785,22094.343791096548,
	22074.83727489258,22055.453130507816,22036.190051791247,22017.046751470618,21998.021960815866,
	21979.114429306883,21960.32292435119,21941.64623091122,21923.083151235984,21904.632504553865,
	21886.29312677079,21868.0638701884,21849.94360321611,21831.93121009458,21814.02559062665,
	21796.225659902848,21778.530348047792,21760.93859995939,21743.4493750607,21726.061647050316,
	21708.774403660726,21691.586646426545,21674.497390445653,21657.50566415572,21640.61050911244,
	21623.81097976428,21607.10614324549,21590.495079159024,21573.976879375005,21557.550647825075,
	21541.215500306607,21524.97056428614,21508.81497870775,21492.74789380781,21476.76847092951,
	21460.875882344862,21445.069311072024,21429.347950711064,21413.711005264566,21398.15768897711,
	21382.687226166752,21367.29885106535,21351.991807668426,21336.765349565037,21321.618739797595,
	21306.551250711535,21291.56216380252,21276.650769580934,21261.816367424435,21247.058265441665,
	21232.375780338647,21217.768237281718,21203.234969767156,21188.775319498945,21174.388636250496,
	21160.07427774887,21145.831609556968,21131.660004938454,21117.558844761734,21103.527517366074,
	21089.5654184574,21075.671950997606,21061.846525090084,21048.088557878335,21034.39747343567,
	21020.77270266825,21007.21368320223,20993.71985929951,20980.29068174256,20966.925607752397,
	20953.624100885845,20940.385630945813,20927.209673886577,20914.095711727285,20901.043232462885,
	20888.051729975654,20875.120703953246,20862.249659800873,20849.438108564926,20836.685566839857,
	20823.991556705412,20811.355605634206,20798.77724642611,20786.25601712121,20773.791460932785,
	20761.383126175802,20749.030566187645,20736.733339267965,20724.491008596324,20712.303142173045,
	20700.169312754995,20688.089097775937,20676.062079297353,20664.087843933034,20652.165982790662,
	20640.296091413027,20628.477769710953,20616.710621908285,20604.994256480313,20593.328286100903,
	20581.71232757352,20570.146001794823,20558.62893367782,20547.16075211653,20535.741089918716,
	20524.369583763888,20513.045874141248,20501.769605309735,20490.54042523959,20479.35798556752,
	20468.221941549134,20457.131952006424,20446.087679285487,20435.088789207362,20424.134951026444,
	20413.225837379592,20402.361124252344,20391.54049091994,20380.76361992057,20370.030197004864,
	20359.339911095518,20348.692454249667,20338.087521612943,20327.524811384505,20317.0040247804,
	20306.524865989417,20296.087042136078,20285.69026324963,20275.334242221386,20265.01869477111,
	20254.743339411936,20244.50789741229,20234.312092766966,20224.155652159436,20214.038304926267,
	20203.95978303014,20193.919821025025,20183.91815602299,20173.954527661495,20164.028678079852,
	20154.140351875576,20144.289296090134,20134.47526016516,20124.697995924227,20114.95725753633,
	20105.252801490133,20095.584386568695,20085.95177381655,20076.354726520007,20066.793010172605,
	20057.26639245258,20047.774643196168,20038.317534378373,20028.894840072728,20019.5063364413,
	20010.151801701442,20000.831016105574,19991.54376191791,19982.289823385603,19973.06898672593,
	19963.88104008757,19954.725773544335,19945.60297906468,19936.51245048923,19927.45398351578,
	19918.427375662955,19909.432426272062,19900.468936467267,19891.536709140728,19882.635548938502,
	19873.765262229335,19864.92565710045,19856.11654332062,19847.337732321645,19838.58903722367,
	19829.870272743094,19821.181255225565,19812.521802614334,19803.89173442967,19795.29087175995,
	19786.719037230254,19778.17605499853,19769.661750735864,19761.175951601224,19752.71848623393,
	19744.289184738573,19735.887878661677,19727.51440098063,19719.168586084947,19710.850269770268,
	19702.559289205772,19694.29548293865,19686.05869086266,19677.84875421778,19669.66551556796,
	19661.508818782688,19653.378509035203,19645.27443277774,19637.196437731236,19629.14437288123,
	19621.118088442614,19613.117435869754,19605.142267830823,19597.192438199803,19589.267802037568,
	19581.36821558469,19573.493536254453,19565.643622606694,19557.81833434712,19550.01753231373,
	19542.24107845626,19534.488835840297,19526.76066862377,19519.056442045345,19511.376022423916,
	19503.71927713476,19496.08607461049,19488.47628431834,19480.889776761665,19473.326423459333,
	19465.78609694076,19458.268670735444,19450.774019367946,19443.30201832635,19435.852544083154,
	19428.42547406546,19421.02068664918,19413.63806115315,19406.277477824955,19398.93881783808,
	19391.621963274632,19384.32679712349,19377.053203269355,19369.801066478783,19362.57027240078,
	19355.360707550342,19348.172259300936,19341.004815884455,19333.858266371604,19326.7325006677,
	19319.62740950878,19312.542884451406,19305.478817855175,19298.435102892694,19291.41163353056,
	19284.40830451914,19277.425011392897,19270.46165046127,19263.51811879495,19256.59431422863,
	19249.690135342436,19242.80548146495,19235.940252662225,19229.094349727322,19222.267674181014,
	19215.46012825889,19208.671614903335,19201.90203776259,19195.151301182534,19188.419310201145,
	19181.705970533876,19175.011188577246,19168.334871400246,19161.676926733388,19155.0372629701,
	19148.41578915184,19141.812414972832,19135.22705076047,19128.65960748323,19122.109996737043,
	19115.578130740512,19109.06392233071,19102.56728495297,19096.088132670004,19089.626380131536,
	19083.181942591727,19076.754735895658,19070.34467646486,19063.95168131197,19057.57566801812,
	19051.216554732935,19044.8742601718,19038.548703611123,19032.239804878274,19025.947484353626,
	19019.671662957386,19013.412262155485,19007.16920394643,19000.94241085354,18994.731805936404,
	18988.537312768152,18982.358855438186,18976.196358551355,18970.049747218884,18963.918947054408,
	18957.803884169487,18951.704485174745,18945.620677161794,18939.552387718537,18933.49954490803,
	18927.462077273663,18921.43991383024,18915.43298406239,18909.4412179237,18903.464545822266,
	18897.502898633535,18891.556207675258,18885.624404722912,18879.707421997024,18873.805192155178,
	18867.91764829907,18862.0447239658,18856.18635311661,18850.34247014991,18844.513009876147,
	18838.697907537284,18832.897098788173,18827.11051969586,18821.338106735144,18815.57979679349,
	18809.835527158317,18804.105235516578,18798.38885995193,18792.686338938624,18786.99761135132,
	18781.322616440677,18775.66129384335,18770.013583578067,18764.379426040527,18758.758762005065,
	18753.15153260969,18747.55767936549,18741.97714414665,18736.409869193194,18730.85579710271,
	18725.314870828613,18719.787033674755,18714.272229305578,18708.770401725295,18703.281495287352,
	18697.80545468036,18692.34222494461,18686.891751450232,18681.453979900776,18676.028856336405,
	18670.616327120755,18665.216338948725,18659.828838837308,18654.453774124595,18649.091092467,
	18643.740741842554,18638.402670535193,18633.076827144432,18627.763160578696,18622.46162005344,
	18617.172155085293,18611.894715498544,18606.62925141324,18601.375713245725,18596.134051707268,
	18590.904217807773,18585.686162838603,18580.479838381212,18575.285196313613,18570.102188784025,
	18564.93076822744,18559.770887357878,18554.622499171735,18549.48555692837,18544.36001417723,
	18539.245824723053,18534.1429426484,18529.05132229944,18523.970918291114,18518.90168549558,
	18513.843579049477,18508.796554353376,18503.76056705166,18498.735573054924,18493.72152852691,
	18488.718389876856,18483.726113766068,18478.744657107152,18473.773977050303,18468.814031001544,
	18463.86477659552,18458.926171718198,18453.998174489265,18449.08074326519,18444.173836639602,
	18439.277413440348,18434.39143271809,18429.515853771572,18424.650636108032,18419.795739472487,
	18414.95112383619,18410.116749386074,18405.29257653655,18400.47856592205,18395.674678395644,
	18390.880875025443,18386.097117090176,18381.323366099194,18376.559583752798,18371.805731980898,
	18367.061772910125,18362.327668880156,18357.60338243253,18352.888876323657,18348.184113504652,
	18343.4890571319,18338.803670560133,18334.127917344606,18329.461761240673,18324.80516619708,
	18320.158096358617,18315.52051606091,18310.892389836765,18306.273682406747,18301.66435868597,
	18297.064383768997,18292.473722944356,18287.892341679293,18283.32020563732,18278.757280650687,
	18274.203532744577,18269.65892811935,18265.123433159515,18260.59701441952,18256.079638636118,
	18251.571272722278,18247.071883763954,18242.58143901913,18238.09990592091,18233.627252072456,
	18229.163445241076,18224.708453368516,18220.262244566202,18215.824787105226,18211.39604942645,
	18206.976000134266,18202.564607981356,18198.161841918158,18193.76767102333,18189.382064547233,
	18185.004991893093,18180.636422627893,18176.27632647247,18171.924673302638,18167.58143315111,
	18163.246576198882,18158.92007278439,18154.601893398856,18150.29200867657,18145.990389403378,
	18141.697006518672,18137.41183110735,18133.13483439464,18128.86598775878,18124.60526272049,
	18120.35263093791,18116.108064220734,18111.8715345171,18107.643013909805,18103.422474632927,
	18099.209889050686,18095.005229667546,18090.80846912629,18086.619580204155,18082.438535817528,
	18078.26530900927,18074.09987296129,18069.94220099585,18065.792266549495,18061.650043205234,
	18057.515504667677,18053.38862477517,18049.269377490375,18045.15773690804,18041.053677249784,
	18036.95717285434,18032.86819820253,18028.78672788131,18024.712736616395,18020.646199248058,
	18016.58709073989,18012.53538617542,18008.49106076805,18004.454089836185,18000.424448829537,
	17996.402113308715,17992.387058957087,17988.3792615741,17984.378697068354,17980.38534147559,
	17976.399170934055,17972.420161708298,17968.448290166172,17964.483532792343,17960.5258661811,
	17956.575267042987,17952.63171219028,17948.695178554666,17944.765643170616,17940.843083182426,
	17936.9274758476,17933.018798520297,17929.11702866774,17925.22214386405,17921.33412178453,
	17917.45294020775,17913.578577030465,17909.71101023178,17905.850217904706,17901.996178243484,
	17898.14886954246,17894.308270200992,17890.474358709736,17886.647113666804,17882.826513766056,
	17879.01253780193,17875.205164661165,17871.404373334255,17867.61014290307,17863.82245255185,
	17860.04128155086,17856.26660927718,17852.498415188762,17848.736678849495,17844.981379912617,
	17841.232498117613,17837.49001330407,17833.753905399626,17830.024154419163,17826.30074047993,
	17822.583643777394,17818.872844601763,17815.168323327933,17811.470060430373,17807.778036448846,
	17804.09223203699,17800.412627923582,17796.739204913134,17793.071943913477,17789.410825906376,
	17785.755831969513,17782.1069432458,17778.464140984466,17774.827406504002,17771.196721205746,
	17767.57206658368,17763.95342420057,17760.340775709607,17756.734102840022,17753.133387410842,
	17749.538611303844,17745.9497564997,17742.36680504652,17738.789739069165,17735.218540778395,
	17731.653192462687,17728.093676480887,17724.53997527286,17720.99207135477,17717.44994732028,
	17713.913585838447,17710.382969646773,17706.85808156698,17703.33890448864,17699.82542137961,
	17696.317615279928,17692.815469298865,17689.318966623752,17685.828090511193,17682.342824292173,
	17678.863151361053,17675.38905519627,17671.92051933811,17668.4575273952,17665.00006305501,
	17661.54811007029,17658.10165225492,17654.660673506434,17651.225157775836,17647.79508909428,
	17644.370451554285,17640.95122931569,17637.537406603755,17634.128967716893,17630.72589701382,
	17627.3281789207,17623.93579792345,17620.548738587582,17617.166985524625,17613.790523425858,
	17610.419337041305,17607.053411178684,17603.69273071764,17600.337280594238,17596.98704581565,
	17593.642011438107,17590.30216259647,17586.967484469063,17583.637962307897,17580.31358142535,
	17576.994327185595,17573.680185023582,17570.37114042911,17567.067178949237,17563.768286193575,
	17560.47444783495,17557.185649592484,17553.901877259013,17550.62311666918,17547.349353732156,
	17544.08057440103,17540.816764696916,17537.557910684285,17534.303998496882,17531.055014316356,
	17527.81094438546,17524.571774998367,17521.337492511804,17518.108083328192,17514.883533909844,
	17511.663830773352,17508.448960492904,17505.23890968671,17502.033665034145,17498.833213264254,
	17495.637541163946,17492.446635571523,17489.260483370337,17486.079071509277,17482.90238697574,
	17479.73041681719,17476.563148131558,17473.400568065397,17470.24266381444,17467.089422632307,
	17463.940831816857,17460.79687871515,17457.657550732696,17454.522835313714,17451.39271995805,
	17448.267192211933,17445.14623967473,17442.029849990697,17438.918010848174,17435.810709996276,
	17432.707935216775,17429.609674349867,17426.515915282216,17423.426645940162,17420.34185430646,
	17417.261528399646,17414.18565629761,17411.114226111848,17408.047226011353,17404.98464419713,
	17401.92646893311,17398.872688509582,17395.82329128104,17392.778265626734,17389.737599986514,
	17386.701282839866,17383.66930270422,17380.64164814928,17377.618307785444,17374.59927026248,
	17371.58452428054,17368.574058578422,17365.56786193946,17362.56592319072,17359.56823118997,
	17356.57477485922,17353.58554314435,17350.60052503795,17347.619709573806,17344.64308583773,
	17341.670642936526,17338.702370030576,17335.738256324174,17332.778291051203,17329.822463497054,
	17326.870762977313,17323.92317885097,17320.979700525044,17318.040317436247,17315.105019059247,
	17312.173794915765,17309.24663456273,17306.323527596585,17303.404463648392,17300.48943239862,
	17297.578423548715,17294.67142685252,17291.768432099783,17288.869429111037,17285.97440774924,
	17283.083357912004,17280.196269540535,17277.313132607254,17274.433937122787,17271.55867313448,
	17268.68733072145,17265.81990000966,17262.95637115252,17260.09673433923,17257.240979798597,
	17254.389097800526,17251.54107863337,17248.69691263562,17245.856590179268,17243.020101661077,
	17240.187437524903,17237.358588242292,17234.533544321184,17231.712296300528,17228.89483475918,
	17226.081150307255,17223.271233590753,17220.465075279306,17217.662666088258,17214.86399675867,
	17212.06905807276,17209.27784083566,17206.490335895785,17203.70653412247,17200.9264264246,
	17198.150003745424,17195.377257057717,17192.6081773652,17189.842755705653,17187.080983144166,
	17184.322850786313,17181.568349755333,17178.817471227947,17176.070206382934,17173.326546454544,
	17170.586482692735,17167.850006389435,17165.117108865445,17162.38778146041,17159.66201555597,
	17156.939802561898,17154.221133915544,17151.506001084625,17148.794395572782,17146.086308898655,
	17143.381732629954,17140.680658341636,17137.98307765881,17135.28898222683,17132.598363714864,
	17129.91121383041,17127.22752430275,17124.547286891968,17121.87049338983,17119.197135608603,
	17116.527205400023,17113.86069463341,17111.197595210862,17108.537899062358,17105.881598146425,
	17103.228684443846,17100.57914996805,17097.93298675545,17095.29018688416,17092.65074243307,
	17090.014645533935,17087.381888329994,17084.752462990855,17082.12636172429,17079.503576756382,
	17076.884100339998,17074.267924751326,17071.655042303082,17069.045445322252,17066.439126172114,
	17063.836077227395,17061.236290910307,17058.6397596514,17056.04647589755,17053.456432154453,
	17050.869620925132,17048.286034744437,17045.70566617248,17043.128507805002,17040.55455224047,
	17037.983792119583,17035.416220103994,17032.851828878687,17030.290611155673,17027.73255965859,
	17025.177667152908,17022.625926417382,17020.07733025629,17017.531871503787,17014.989543007825,
	17012.450337648905,17009.914248324603,17007.38126796251,17004.85138950171,17002.3246059225,
	16999.800910208305,16997.280295386496,16994.762754484862,16992.248280573396,16989.736866734376,
	16987.22850607732,16984.72319173111,16982.2209168445,16979.72167458852,16977.225458176865,
	16974.73226081853,16972.24207575647,16969.754896251572,16967.27071559449,16964.789527087996,
	16962.311324056092,16959.836099855158,16957.36384786374,16954.894561459438,16952.428234072475,
	16949.964859125823,16947.50443007888,16945.046940415556,16942.592383630537,16940.140753244847,
	16937.692042799437,16935.246245855313,16932.803355989774,16930.3633668114,16927.926271942197,
	16925.492065025806,16923.060739723718,16920.632289718902,16918.206708715203,16915.78399043888,
	16913.36412863531,16910.94711706598,16908.532949509958,16906.121619778085,16903.71312168269,
	16901.30744907996,16898.904595824897,16896.504555793985,16894.107322893928,16891.712891038627,
	16889.32125417681,16886.93240625452,16884.546341258916,16882.163053178254,16879.782536028997,
	16877.404783846567,16875.029790677992,16872.657550598044,16870.288057693037,16867.921306077264,
	16865.557289865934,16863.19600320678,16860.83744026805,16858.481595225443,16856.128462273795,
	16853.778035636187,16851.43030954295,16849.08527824974,16846.742936025854,16844.403277150963,
	16842.066295943674,16839.731986717903,16837.40034381639,16835.071361596543,16832.745034436553,
	16830.421356722334,16828.100322868882,16825.781927302367,16823.466164465823,16821.15302881983,
	16818.842514841574,16816.53461702832,16814.22932989248,16811.926647954428,16809.626565764353,
	16807.329077884624,16805.034178893296,16802.74186338428,16800.45212596662,16798.164961267707,
	16795.880363928874,16793.598328619268,16791.31885000229,16789.041922780292,16786.76754165675,
	16784.495701353288,16782.226396616028,16779.959622191476,16777.695372860362,16775.43364340022,
	16773.174428622515,16770.91772334022,16768.663522391056,16766.41182061468,16764.162612890002,
	16761.915894084676,16759.67165910615,16757.42990285262,16755.190620259276,16752.953806254263,
	16750.719455812403,16748.48756388889,16746.258125470627,16744.03113556285,16741.806589183492,
	16739.58448135533,16737.364807128135,16735.14756155868,16732.932739724594,16730.72033670731,
	16728.51034761892,16726.302767571287,16724.097591700654,16721.894815143518,16719.694433066652,
	16717.49644064491,16715.30083306978,16713.107605535846,16710.916753267902,16708.72827149193,
	16706.54215545512,16704.358400410685,16702.17700164006,16699.997954422284,16697.82125405507,
	16695.64689586185
	}}
};
