/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "field.h"

using namespace Form;

Field::Field( const QString &name, QWidget *parent )
  : QWidget( parent ), mName( name )
{
  mLayout = new QGridLayout( this );
  mLayout->setMargin( 0 );
  mLayout->setSpacing( 0 );
}

QString Field::name() const
{
  return mName;
}

QGridLayout* Field::fieldLayout() const
{
  return mLayout;
}

void Field::loadEntry( const Entry& )
{
}

void Field::saveEntry( Entry& ) const
{
}

bool Field::isValid( QString&, PagePolicy::State ) const
{
  return false;
}

void Field::setEditable( bool )
{
}

void Field::setDefaultValue( const QString &value )
{
  mDefaultValue = value;
}

QString Field::defaultValue() const
{
  return mDefaultValue;
}
