/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <QtGui/QButtonGroup>
#include <QtGui/QLabel>
#include <QtGui/QRadioButton>

#include "mailfilterfield.h"

using namespace Form;

MailFilterField::MailFilterField( const QString &name, QWidget *parent )
  : Field( name, parent )
{
  mForgedHeader = new QRadioButton( this );
  mNonForgedHeader = new QRadioButton( this );

  QButtonGroup *group = new QButtonGroup( this );
  group->addButton( mForgedHeader );
  group->addButton( mNonForgedHeader );

  fieldLayout()->addWidget( mForgedHeader, 0, 0 );
  QLabel *label = new QLabel( tr( "Reject the message with the except if it originates from the outside but has a From header that matches the Kolab server's domain. In that case rewrite the From header so the recipient can see the potential forgery." ), this );
  label->setWordWrap( true );
  fieldLayout()->addWidget( label, 0, 1 );

  fieldLayout()->addWidget( mNonForgedHeader, 1, 0 );
  label = new QLabel( tr( "Always reject the message. Note that enabling this setting will make the server reject any mail with non-matching sender and From header if the sender is an account on this server. This is known to cause trouble for example with mailinglists." ), this );
  label->setWordWrap( true );
  fieldLayout()->addWidget( label, 1, 1 );
}

void MailFilterField::loadEntry( const Entry &entry )
{
  if ( entry.value( "kolabfilter-reject-forged-from-header" ) == "TRUE" )
    mForgedHeader->setChecked( true );
  else
    mNonForgedHeader->setChecked( true );
}

void MailFilterField::saveEntry( Entry &entry ) const
{
  entry.setValue( "kolabfilter-reject-forged-from-header", mForgedHeader->isChecked() ? "TRUE" : "FALSE" );
}

bool MailFilterField::isValid( QString&, PagePolicy::State ) const
{
  return true;
}

void MailFilterField::setEditable( bool editable )
{
  mForgedHeader->setEnabled( editable );
  mNonForgedHeader->setEnabled( editable );
}

