package latexDraw.ui.components;

import java.awt.event.ItemEvent;

import javax.swing.JComboBox;
import javax.swing.JLabel;

import latexDraw.ui.dialog.ExceptionFrameDialog;



/** 
 * This class change only on function of the mother class ComboBox : the method
 * setSelectedItem ; by default this method selected a given object in the list. but
 * in our case, we want the selected the object whose name is the string given in parameter
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE.  See the GNU General Public License for more details.<br>
 *<br>
 * 01/20/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class LaTeXDrawComboBox extends JComboBox
{
	private static final long serialVersionUID = 1L;

	
	@Override
	public void setSelectedItem(Object anObject)
	{
		try
		{
			int i, size = getItemCount();
			boolean found = false;
			Object o=null;
			
			if(anObject instanceof JLabel)
				o = anObject;
			else
			{
				if(!(anObject instanceof String))
					throw new ClassCastException();
					
				if(size==0) return ;
				
				for(i=0; i<size && !found; i++)
				{
					o = getItemAt(i);
					if(o instanceof JLabel)
					{
						if(((JLabel)o).getText().compareTo((String)anObject)==0)
							found=true;
					}
					else
					if(o instanceof String)
						if(((String)o).compareTo((String)anObject)==0)
							found=true;
				}
			}
			
		    dataModel.setSelectedItem(o);
			
		}catch(Exception e)
		{
			e.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(e);
		}
	}
	
	
	
    @Override
	protected void selectedItemChanged() 
    {
    	selectedItemReminder = dataModel.getSelectedItem();

    	if(selectedItemReminder != null) 
    		fireItemStateChanged(new ItemEvent(this, ItemEvent.ITEM_STATE_CHANGED, selectedItemReminder, ItemEvent.SELECTED));
    }
}
